/*
  File: wff2targa.c
  Authors: Gemini Lasswell,
           Jamie Painter,
           K.R. Sloan
  Last Modified: 5 February 1992
  Purpose: Convert .wff image files to ``targa'' format.
           This version passes the file, rather than hogging memory

           An obsolete version (wff2targa.c.obsolete) tried to center
           the image on an ATT Targa board.  

           This version doesn't do that...

           This version produces a 24 bit per pixel RGB image.

           This version produces OLD STYLE Targa images. 

 */
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <wff.h>

int VERBOSE = 0;
static char *RoutineName;

static void FatalError(s)
 {
  fprintf(stderr,"%s: FatalError(%s)\n",RoutineName,s);
  exit(-1);
 } 

static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s\n",
           RoutineName);
 }

/* Targa format routines */

/*
   Header and footer are set to primitive, simple values
   If you want to support the full (latest) Targa format - feel free...
 */

unsigned char Header[18] =
 {                    /* Header for targa file                            */
  0,                  /* [0] Number of Characters in ID field             */
  0,                  /* [1] Color Map Type  0 means NONE                 */
  2,                  /* [2] Image Type      2 means RGB                  */
  0, 0, 0, 0, 0,      /* [3,4,5,6,7] color map specs - we don't have one  */
  0, 0,               /* [ 8, 9] xorigin                                  */
  0, 0,               /* [10,11] yorigin                                  */
  0, 0,               /* [12,13] width                                    */
  0, 0,               /* [14,15] height                                   */ 
  24,                 /* [16] bits per pixel - we always write 8+8+8 RGB  */
  0                   /* [17] bits 3-0: number of attribute bits per pixel 
                                     4: 0/1 = origin at (left/right)
                                     5: 0/1 = origin at (bottom/top)
                                   7-6: interleaving (0 means no interleave)
                                        (in the new documentation, this
                                         is:
                             "must be zero to insure future compatibility"
                       */

 };

/*
  We don't use any of the new extensions, but we write the footer, just
  to be nice.
 */

unsigned char Footer[26] =
 {                    /* Header for targa file                            */
  0, 0, 0, 0,         /* [0-3]  Extension Area Offset (none)              */
  0, 0, 0, 0,         /* [4-7]  Developer Directory Offset (none)         */
  'T','R','U','E',    /* [8-23] Signature                                 */ 
  'V','I','S','I',
  'O','N','-','X',
  'F','I','L','E',   
  '.',                /* [24] .                                           */
  0                   /* [25] terminator                                  */
 };

static void WriteTargaHeader(targaFile, xsize, ysize, xoffset, yoffset)
 FILE *targaFile;
 int xsize, ysize;
 int xoffset, yoffset;
 {

  Header[ 8] = (unsigned char) (xoffset & 0xff);
  Header[ 9] = (unsigned char) (xoffset >> 8);
  Header[10] = (unsigned char) (yoffset & 0xff);
  Header[11] = (unsigned char) (yoffset >> 8);
  Header[12] = (unsigned char) (xsize   & 0xff); 
  Header[13] = (unsigned char) (xsize   >> 8);
  Header[14] = (unsigned char) (ysize   & 0xff);
  Header[15] = (unsigned char) (ysize   >> 8);

  if (18 != fwrite(Header, 1, 18, targaFile))
   FatalError("writing targa header");
 }

static void WriteTargaFooter(targaFile)
 FILE *targaFile;
 {
  if (26 != fwrite(Footer, 1, 26, targaFile))
   FatalError("writing targa footer");
 }

static void WriteTargaScanline(targaFile, Scanline, CharsPerScanline)
 FILE *targaFile;
 unsigned char *Scanline;
 int CharsPerScanline;
 {
  if (CharsPerScanline != fwrite(Scanline, 1, CharsPerScanline, targaFile))
   FatalError("writing targa image Scanline");
 }

static void
Pass(fdIn, fdOut)
 FILE *fdIn, *fdOut;
 {
  FrameBufferType *FBin;
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength];
  char WhatBands[ValueLength];
  int  BitsPerBand, BandsPerPixel;
  int x,y,b;
  unsigned short *Pixel;
  unsigned short Red, Green, Blue;
  unsigned char *TargaScanline;
  unsigned char *pout;
  unsigned short *pin;
  int TargaBandsPerPixel;
  int xsize, ysize, xoffset, yoffset, i;

  /* Start reading the .wff image */
  FBin = (FrameBufferType *)0;
  if (FAILURE == OpenFB(&FBin))           FatalError("Open FB failed");
  if (FAILURE == PassImageIn(fdIn, FBin)) FatalError("PassImageIn failed");

  /* make sure we know how to handle it */
  GetColorSystem( FBin, WhatBands, &BitsPerBand );
  if (   (0 != strcmp(WhatBands,"RGBA"))
      && (0 != strcmp(WhatBands,"RGB" ))
      && (0 != strcmp(WhatBands,"I"   )))
   {
    fprintf(stderr,
            "%s: can't deal with %s images\n", RoutineName, WhatBands);
    FatalError("BadColorSystem");
   }
  BandsPerPixel = FBin->BandsPerPixel;

  TargaBandsPerPixel = 3;  /* RGB only */

  /* find out how big it is */
  if (FAILURE == GetBounds(FBin, &Bottom, &Left, &Top, &Right)) 
   FatalError("GetBounds failed");

  xsize = Right - Left + 1;
  ysize = Top - Bottom + 1;

  xoffset = 0; yoffset = 0;
  WriteTargaHeader(fdOut, xsize, ysize, xoffset, yoffset);

  Pixel = (unsigned short *)
    malloc( (unsigned) (sizeof(unsigned short)*xsize*BandsPerPixel));
  if ((unsigned short *)0 == Pixel)
   FatalError("No memory for WFF scan line buffer");

  TargaScanline = (unsigned char *)
    malloc( (unsigned) (sizeof(unsigned char *)*xsize*TargaBandsPerPixel));
  if ((unsigned char *)0 == TargaScanline)
   FatalError("No memory for Targa scan line buffer");

  /* Two cases - duplicate the code rather than decide for each pixel */
  if (   (0 == strcmp(WhatBands,"RGB" ))
      || (0 == strcmp(WhatBands,"RGBA")) )
   {
    for (y=0;y<ysize;y++) 
     {
      pout = TargaScanline;

      /* Read the scan line from the WFF file */
      if (FAILURE == NextNPixelsIn( FBin, xsize, Pixel ) )
       FatalError("NextNPixelsIn failed");

      pin = Pixel;
      for (x=0;x<xsize;x++, pin += BandsPerPixel) 
       {
        Red   = (pin[0] << (16-BitsPerBand)) >> 8;
        Green = (pin[1] << (16-BitsPerBand)) >> 8;
        Blue  = (pin[2] << (16-BitsPerBand)) >> 8;
        for(b=BitsPerBand;b<8;b+=BitsPerBand)
         {
          Red   |= (Red   >> BitsPerBand); 
          Green |= (Green >> BitsPerBand);
          Blue  |= (Blue  >> BitsPerBand);
	 }
        *pout++ = Blue;
        *pout++ = Green;
        *pout++ = Red;
       }
      WriteTargaScanline(fdOut, TargaScanline, xsize*TargaBandsPerPixel);
     }
   }
  else if (0 == strcmp(WhatBands,"I"))
   {
    for (y=0;y<ysize;y++) 
     {
      pout = TargaScanline;
      if (FAILURE == NextNPixelsIn ( FBin, xsize, Pixel ) )
       FatalError("NextNPixelsIn failed");
      pin = Pixel;

      for (x=0;x<xsize;x++, pin += BandsPerPixel) 
       {
        Red   = (pin[0] << (16-BitsPerBand)) >> 8;
        for(b=BitsPerBand;b<8;b+=BitsPerBand)
         Red |= (Red >> BitsPerBand);
        Green = Red;
        Blue  = Red;
        *pout++ = Blue;
        *pout++ = Green;
        *pout++ = Red;
       }
      WriteTargaScanline(fdOut, TargaScanline, xsize*3);
     }
   }
  WriteTargaFooter(fdOut);
  (void)CloseFB(&FBin);
 }

int main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  int xsize, ysize;
 
  RoutineName = argv[ArgsParsed++];
  for (; ArgsParsed <argc; ArgsParsed++)
   {
    if ('-' == argv[ArgsParsed][0])
     {
      switch (argv[ArgsParsed++][1])
       {
        case 'v': VERBOSE = -1; break;
        case 'h':
        default: 
         usage(); exit(-1);  
       }         
     }
    else { usage(); exit(-1); }
   }
  if (ArgsParsed < argc)  { usage(); exit (-1); }	

  Pass(stdin,stdout);
  exit(0);
 }



