/*
  File: Grid.c
  Author: K.R. Sloan,
  Last Modified: 19 April 1988
  Purpose: create a standard grid testpattern
 */
#include <stdio.h>
#include <strings.h>
#include "wff.h"
int atoi();
double atof();

static char *RoutineName;
static void 
usage()
 {
  fprintf(stderr,"Usage is:\n\t%s top left width foreground background\n",RoutineName);
 }

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
  int width = 1;
  double foreground = 1.0;
  double background = 0.5;
  FILE *FileDescriptor;
  FrameBufferType *FrameBuffer = NULL;
  int Left=0, Bottom=0, Top=511, Right=511, BitsPerBand;
  char WhatBands[10], Name[NameLength], Value[ValueLength];
  int x,y;
  unsigned short WhiteScanLine[1024];
  unsigned short GrayScanLine[1024];
  unsigned short White, Gray;

  RoutineName = argv[ArgsParsed++];
  if (ArgsParsed < argc) Top = atoi(argv[ArgsParsed++]);
  if (ArgsParsed < argc) Left = atoi(argv[ArgsParsed++]);
  if (ArgsParsed < argc) width = atoi(argv[ArgsParsed++]);
  if (ArgsParsed < argc) foreground = atof(argv[ArgsParsed++]);
  if (ArgsParsed < argc) background = atof(argv[ArgsParsed++]);
  if (ArgsParsed < argc) { usage(); exit(-1); }

  if ((width < 1) || (15 < width)) { usage(); exit(-1); }
  if ((foreground < 0.0) || (1.0 < foreground)) { usage(); exit(-1); }
  if ((background < 0.0) || (1.0 < background)) { usage(); exit(-1); }

  OpenFB(&FrameBuffer);
  SetBounds(FrameBuffer, Bottom, Left, Top, Right);
  strcpy(WhatBands,"I"); BitsPerBand = 8;
  SetColorSystem(FrameBuffer, WhatBands,  BitsPerBand);

  strcpy(Name,"Title");
  strcpy(Value,"Standard Grid");
  SetDescriptor(FrameBuffer, Name, Value);

  strcpy(Name,"X-CreatedBy");
  strcpy(Value,RoutineName);
  SetDescriptor(FrameBuffer, Name, Value);

  White = foreground * (double)((1 << BitsPerBand) -1);
  Gray =  background * (double)((1 << BitsPerBand) -1);
  GrayScanLine[Left] = White;
  WhiteScanLine[Left] = White;
  for(x=Left+1; x<Right; x++)
   {
    if (width < ((x % 16) + 1)) GrayScanLine[x] = Gray;
    else                        GrayScanLine[x] = White;
    WhiteScanLine[x] = White;
   }
  GrayScanLine[Right] = White;
  WhiteScanLine[Right] = White;
  (void)PutBlock(FrameBuffer,Bottom, Left, Bottom, Right, WhiteScanLine);
  for(y=Bottom+1; y<Top;y++)
   {
    if (width < ((y % 16) + 1))
     (void)PutBlock(FrameBuffer,y, Left, y, Right, GrayScanLine);
    else
     (void)PutBlock(FrameBuffer,y, Left, y, Right, WhiteScanLine);
   }
  (void)PutBlock(FrameBuffer,Top, Left, Top, Right, WhiteScanLine);
  WriteImage(stdout, FrameBuffer);
  CloseFB(&FrameBuffer);

  exit(0);
 }
