/*
  File: ConvHV.c 
  Authors: K.R. Sloan
  Last Modified: 14 April 1989
  Purpose: Convolve with an arbitrary nx1 kernel (plus DC),
             followed by an arbitrary 1xn kernel (plus DC)

           symmetric filters can be specified once, rather than twice 
 */

#include <stdio.h>
#include "wff.h"

#define SwitchChar '+'

double atof();

static char *RoutineName;
static void usage()
 {
  fprintf(stderr, "Usage is\n\t%s [-h][-H hdc h1 h2 ... hn][-V vdc v1 v2 ... vm][-S sdc s1 s2 ... sn]\n",
              RoutineName);
 }

int main(argc, argv)
 int argc;
 char *argv[]; 
 {
  int ArgsParsed = 0;
  int hn = 0;
  int vn = 0; 
  int h[100], v[100];

  RoutineName = argv[ArgsParsed++];

  while (argc > ArgsParsed)
   {
    if (SwitchChar == argv[ArgsParsed][0])
     switch (argv[ArgsParsed++][1])
      {
       case 'V':
                 vn = 0;
                 while((argc>ArgsParsed) && (SwitchChar != argv[ArgsParsed][0]))
                  {
                   v[vn++] = (int)(2048.0*atof(argv[ArgsParsed++]));
		  }
                 break;
       case 'H':
                 hn = 0;
                 while((argc>ArgsParsed) && (SwitchChar != argv[ArgsParsed][0]))
                  {
                   h[hn++] = (int)(2048.0*atof(argv[ArgsParsed++]));
		  }
                 break;
       case 'S':
                 hn = 0; vn = 0;
                 while((argc>ArgsParsed) && (SwitchChar != argv[ArgsParsed][0]))
                  {
                   h[hn] = (int)(2048.0*atof(argv[ArgsParsed++]));
                   v[vn++] = h[hn++];
		  }
                 break;
       case 'h':
       default:
                 usage(); exit(-1);  
      }
    else  { usage(); exit (-1); }	
   }

  if (0 == hn) { hn = 2; h[0] = 0; h[1] = 2048;}
  if (0 == vn) { vn = 2; v[0] = 0; v[1] = 2048;}

  (void)wffConvHV(stdin,stdout,hn,vn,h,v);

  exit (0);
 }
