/*
  File: devCircle.c
  Authors: K.R. Sloan
  Last Modified: 13 October 1988
  Purpose: draw a circle, or a (filled) disc
  Reference: F&vD p. 445
 */

#include <stdio.h>
#include "DEVICE.h"

static void Point(x, y)
 int x, y;
 {
  (void) devRect(x, y, x, y);
 }

static void Line(y, xL, xR)
 int y, xL, xR;
 {
  (void) devRect(xL, y, xR, y);
 }

static void CirclePoints(x, y, xc, yc)
 int x, y, xc, yc;
 {
  Point(xc+x, yc+y);
  Point(xc+y, yc+x);
  Point(xc+x, yc-y);
  Point(xc+y, yc-x);
  Point(xc-x, yc-y);
  Point(xc-y, yc-x);
  Point(xc-x, yc+y);
  Point(xc-y, yc+x);
 }

static void DiscLines(x, y, xc, yc)
 int x, y, xc, yc;
 {
  Line(yc+y, xc-x, xc+x);
  Line(yc-y, xc-x, xc+x);
  Line(yc+x, xc-y, xc+y);
  Line(yc-x, xc-y, xc+y);
 }

int devCircle(xc, yc, radius)
 int xc, yc, radius;
 {
  int x, y, d;

  d = 3 - (2*radius);
  for (x = 0, y = radius; x < y; x++)
   {
    CirclePoints(x, y, xc, yc);
    if (d < 0)
     d = d + (x<<2) + 6;
    else
     {
      d = d + ((x-y)<<2) + 10;
      y--;
     }
   }
  if (x == y) CirclePoints(x, y, xc, yc);
  return 0;
 }

int devDisc(xc, yc, radius)
 int xc, yc, radius;
 {
  int x, y, d;

  d = 3 - (2*radius);
  for (x = 0, y = radius; x < y; x++)
   {
    DiscLines(x, y, xc, yc);
    if (d < 0)
     d = d + (x<<2) + 6;
    else
     {
      d = d + ((x-y)<<2) + 10;
      y--;
     }
   }
  if (x == y) DiscLines(x, y, xc, yc);
  return 0;
 }
