/*
  File: devProprinter/DEVICE.c
  Author: K.R. Sloan
  Last Modified: 10 February 1991
  Purpose: definitions for the generic graphics device used by SGP
           this version keeps a private binary framebuffer of moderate
           size.  devClose prints a file suitable for printing on an
           IBM Proprinter.

           It's crude - but Mikey likes it

  See also: devLine.c, devTriangle.c, devCircle.c, devClip.c.
           Some of the functions promised in DEVICE.h are implemented there.

           devPick always fails...
 */
#include <stdio.h>
#include "DEVICE.h"
extern devClipLine();
extern devClipRectangle();

/*  Device state  - made global for convenience ... */
int devLeft, devBottom, devRight, devTop;
int devClipL, devClipB, devClipR, devClipT;
int devCurrentColor;
FILE *devOutputStream = stdout;
double devAspectRatio = 1.2;

/* 
   MARGIN controls the number of spaces in the left margin
   Printing resolution is 60 dpi horizontally and 72 dpi vertically
   Call it close enough to square, and let users of this device worry
   about it.  Eventually, this needs to be fixed across the board - but 
   not today
   Today, we use devAspectRatio, above....  Advanced applications can
   read it, and use it
 */

#define MARGIN 10
#define XSIZE 384
#define YSIZE 384

/* private framebuffer */
static unsigned char FrameBuffer[XSIZE][YSIZE];


/*
   devInit initializes the display, loading color maps if necessary
   There are two modes: color and mono.  Here, we assume a full-color
   display, and the two modes are identical

   devInit may also need to fill in the "physical" size of the display
   here, we output the "physical" limits to help your interpreter 
 */
int devInit(color, OutputStream)
 int color;
 FILE *OutputStream;
 {
  devOutputStream = OutputStream;
  devAspectRatio = 1.2;
  devLeft = 0;  devBottom = 0; devRight = XSIZE - 1; devTop = YSIZE - 1;
  devSetClipWin(devLeft,devBottom,devRight,devTop);
  devCurrentColor = devColorCode(1.0, 1.0, 1.0);
  return(0); /* success */ 
 }

/*
  devClose insures that all operations are complete and closes up
 */
int devClose()
 {
  int x,y,z,i;
  int n1, n2;
  char BEL=0x07;
  char LF =0x0a;
  char FF =0x0c;
  char CR =0x0d;
  char DC1=0x11;
  char ESC=0x1b; 

  /*
     NO Form Feed
   */
  /* fputc(FF,devOutputStream); */

  /* 
    Instead, leave some space and guarantee that we are at the left edge
   */
  fputc(CR,devOutputStream);
  fputc(LF, devOutputStream);
  fputc(LF, devOutputStream);

  /*
     Write out the image
   */
  n1 = (devRight-devLeft+1) & 0x000000ff;
  n2 = (devRight-devLeft+1) >> 8;
  for(y=devTop;y>=devBottom;y -= 8)
   {
    for(i=0;i<MARGIN; i++) fputc(' ',devOutputStream);
    fputc(ESC,devOutputStream);
    fputc('K',devOutputStream);
    fputc(n1,devOutputStream);
    fputc(n2,devOutputStream);
    for(x=devLeft;x<=devRight;x++)
     {
      register int column;

      for (column=0,z=0;z<8;z++)
       column = (column << 1) + FrameBuffer[x][y-z];

      fputc(255-column,devOutputStream);  /* reverse intensity */
     }
    /* carriage return */
    fputc(CR,devOutputStream);
    /* advance paper by 24/216 inch */
    fputc(ESC,devOutputStream);
    fputc('J',devOutputStream);
    fputc(24,devOutputStream);
   }  

  /*
    leave some space below
   */
  fputc(LF, devOutputStream);
  fputc(LF, devOutputStream);

  /*
     NO Form Feed & beep
   */
  /* fputc(FF,devOutputStream);  */
  /* fputc(BEL,devOutputStream); */


  fflush(devOutputStream);
  return(0); /* success */ 
 }

/*
  devSetClipWin establishes a clipping window
  restrictions such as (L<R) must be enforced here!
 */
int devSetClipWin(L, B, R, T)
 int L, B, R, T;
 {
  if (L<R) { devClipL=L; devClipR=R; } else { devClipL=R; devClipR=L;} 
  if (B<T) { devClipB=B; devClipT=T; } else { devClipB=T; devClipT=B;} 
  if (devLeft < devRight)
   {
    if (devClipL < devLeft)   devClipL = devLeft;
    if (devClipR > devRight)  devClipR = devRight;
   }
  else
   {
    if (devClipL < devRight)  devClipL = devRight;
    if (devClipR > devLeft)   devClipR = devLeft;
   }

  if (devBottom < devTop)
   {
    if (devClipB < devBottom) devClipB = devBottom;
    if (devClipT > devTop)    devClipT = devTop;
   }
  else 
   {
    if (devClipB < devTop)    devClipB = devTop;
    if (devClipT > devBottom) devClipT = devBottom;
   }

  return(0); /* success */
 }

/*
 devClearScreen fills the entire screen with a particular color
 */
int devClearScreen(color)
 int color;
 {
  int SavedColorCode;
  int SavedClipL, SavedClipB, SavedClipR, SavedClipT; 

  SavedColorCode = devCurrentColor;
  SavedClipL = devClipL;  SavedClipB = devClipB;
  SavedClipR = devClipR;  SavedClipT = devClipT;
  devSetClipWin(devLeft,devBottom,devRight,devTop);

  devCurrentColor = color;
  devRect(devLeft, devBottom, devRight, devTop);

  devCurrentColor = SavedColorCode;
  devSetClipWin(SavedClipL,SavedClipB,SavedClipR,SavedClipT);

  return(0); /* success */
 }

/*
   the following routines draw primitive shapes on the physical device
   All of them clip against the device's clipping window.
   All of them paint in the device's current color
 */

/*
  devLine draws a line - see devLine.c
 */

/*
 devRect fills a rectangle - we assume this is a primitive
 */
int devRect(L, B, R, T)
 int L, B, R, T;
 {
  int x,y;

  if (devClipRectangle(&L, &B, &R, &T)) return(0); /* success */
  
  for(y=B; y<=T; y++)
   for(x=L; x<=R; x++)
    FrameBuffer[x][y] = devCurrentColor;

  return(0); /* success */
 }

/*
 devDisc fills a disc - see devCircle.c
 */

/*
 devCircle draws a circle - see devCircle.c
 */

/*
 devSolidTriangle fills a triangle - see devTriangle.c
 */

/*
 devShadeTriangle shades a triangle
   with color codes specified at each vertex - see devTriangle.c
 */

/*
 devSetColor establishes the current color
 */
int devSetColor(color)
 int color;
 {
  devCurrentColor = color;
  return(0); /* success */
 }

/*
   devColorCode returns a framebuffer value - here we assume a 
   binary.
 */ 
int devColorCode(R, G, B)
 double R,G,B; 
 {
  double devI;

  devI = 0.3*R + 0.59*G + 0.11*B;

  return ( (devI > 0.5) ? 1 : 0 );
 }
/*
  devColorDecode generates r,g,b values in [0.0, 1.0] 
 */
int devColorDecode(code, R, G, B)
 int code;
 double *R, *G, *B;
 {
  *R = (double)code;
  *G = (double)code;
  *B = (double)code;
  return (0);
 }

int devPick(x,y,button)
 int *x,*y,*button;
 {
  *x = 0; *y = 0; *button = 0; return(-1); /* failure */
 }

/*       -30-         */
