/*
  File: Cube.c
  Author: K.R. Sloan
  Last Modified: 8 November 1988
  Purpose: Test 3D graphics
 */

#include <stdio.h>
#include <3D.h>

double atof();

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [-e x y z][-o x y z][-u x y z][-f f]\n",
                 RoutineName);
 }

int main(argc, argv)
 int argc; 
 char *argv[];
 {
  int ArgsParsed = 0;
  static sgpRectangleType Window   = {-0.0018, -0.0012, 0.0018, 0.0012};
  static sgpRectangleType Viewport = {-0.25 ,   0.00,   1.25,   1.00};  
  static sgpColorType White =    {1.00, 1.00, 1.00};
  static sgpColorType Gray18 =   {0.50, 0.50, 0.50};
  static sgpColorType Black =    {0.00, 0.00, 0.00};
  static sgpColorType Pink =     {1.00, 0.50, 0.50};
  static sgpColorType DarkPink = {0.75, 0.24, 0.24};
  static sgpColorType Red =      {1.00, 0.00, 0.00};
  static sgpColorType Green =    {0.00, 1.00, 0.00};
  static sgpColorType Blue =     {0.00, 0.00, 1.00};
  static PointType3D Vertex[8] 
                        = {
                           { 2.0, 2.0, 2.0 },
                           { 2.0, 2.0,-2.0 },
                           { 2.0,-2.0,-2.0 },
                           { 2.0,-2.0, 2.0 },
                           {-2.0, 2.0, 2.0 },
                           {-2.0, 2.0,-2.0 },
                           {-2.0,-2.0,-2.0 },
                           {-2.0,-2.0, 2.0 }                           
                          };
  typedef struct TriStruct { int v[3]; sgpColorType rgb[3]; } TriType;
  static TriType Triangles[12]
    = {
       {{0,2,1}, {{1.0 ,1.0 ,1.0 }, {0.5 ,0.0 ,0.5 }, {1.0 ,0.0 ,0.0 }}},  
       {{0,3,2}, {{1.0 ,1.0 ,1.0 }, {0.0 ,0.0 ,1.0 }, {0.5 ,0.0 ,0.5 }}},
       {{0,1,5}, {{1.0 ,1.0 ,1.0 }, {1.0 ,0.0 ,0.0 }, {0.5 ,0.5 ,0.0 }}}, 
       {{0,5,4}, {{1.0 ,1.0 ,1.0 }, {0.5 ,0.5 ,0.0 }, {0.0 ,1.0 ,0.0 }}}, 
       {{0,4,7}, {{1.0 ,1.0 ,1.0 }, {0.0 ,1.0 ,0.0 }, {0.0 ,0.5 ,0.5 }}}, 
       {{0,7,3}, {{1.0 ,1.0 ,1.0 }, {0.0 ,0.5 ,0.5 }, {0.0 ,0.0 ,1.0 }}}, 
       {{6,7,4}, {{0.0 ,0.0 ,0.0 }, {0.0 ,0.5 ,0.5 }, {0.0 ,1.0 ,0.0 }}},  
       {{6,4,5}, {{0.0 ,0.0 ,0.0 }, {0.0 ,1.0 ,0.0 }, {0.5 ,0.5 ,0.0 }}},  
       {{6,5,1}, {{0.0 ,0.0 ,0.0 }, {0.5 ,0.5 ,0.0 }, {1.0 ,0.0 ,0.0 }}},  
       {{6,1,2}, {{0.0 ,0.0 ,0.0 }, {1.0 ,0.0 ,0.0 }, {0.5 ,0.0 ,0.5 }}},  
       {{6,2,3}, {{0.0 ,0.0 ,0.0 }, {0.5 ,0.0 ,0.5 }, {0.0 ,0.0 ,1.0 }}},  
       {{6,3,7}, {{0.0 ,0.0 ,0.0 }, {0.0 ,0.0 ,1.0 }, {0.0 ,0.5 ,0.5 }}}  
      };

  static PointType3D EyePoint =     {-4.0, -5.0, -6.0};
  static VectorType3D OpticalAxis = { 4.0,  5.0,  6.0};
  static VectorType3D Up = {0.0, 1.0, 0.0};
  static double FocalLength = 0.0015;
  static PointType3D Origin = {0.0, 0.0, 0.0};
  static PointType3D X = {1.0, 0.0, 0.0};
  static PointType3D Y = {0.0, 1.0, 0.0};
  static PointType3D Z = {0.0, 0.0, 1.0};
  int u, v, t;

  RoutineName = argv[ArgsParsed++];

  while (ArgsParsed < argc)
   {
    if ('-' == argv[ArgsParsed][0])
     {
      switch (argv[ArgsParsed++][1])
       {
        case 'e':
         if ((argc-ArgsParsed)<3) { usage(); exit (-1); }
         EyePoint.x = atof(argv[ArgsParsed++]);
         EyePoint.y = atof(argv[ArgsParsed++]);
         EyePoint.z = atof(argv[ArgsParsed++]);
         break;
        case 'o':
         if ((argc-ArgsParsed)<3) { usage(); exit (-1); }
         OpticalAxis.dx = atof(argv[ArgsParsed++]);
         OpticalAxis.dy = atof(argv[ArgsParsed++]);
         OpticalAxis.dz = atof(argv[ArgsParsed++]);
         break;
        case 'u':
         if ((argc-ArgsParsed)<3) { usage(); exit (-1); }
         Up.dx = atof(argv[ArgsParsed++]);
         Up.dy = atof(argv[ArgsParsed++]);
         Up.dz = atof(argv[ArgsParsed++]);
         break;
        case 'f':
         if ((argc-ArgsParsed)<1) { usage(); exit (-1); }
         FocalLength = atof(argv[ArgsParsed++]);
         break;
        case 'h': 
        default:
         usage(); exit(-1);
       }
     }
    else { usage(); exit (-1); }
   }   

  while (ArgsParsed < argc) { usage(); exit (-1); }
  
  sgpInit(ColorDisplay);
  sgpSetWindow(Window);
  sgpSetViewport(Viewport);
  sgpColor(Gray18); sgpClearScreen();

  Camera3D(EyePoint, OpticalAxis, Up);
  Lens3D(FocalLength); SetHither(FocalLength);

  sgpColor(White);
  for (v = 0; v < 8; v++)
   Point3D(Vertex[v]);  

  sgpColor(Red); Line3D(Origin, X);
  sgpColor(Green); Line3D(Origin, Y);
  sgpColor(Blue); Line3D(Origin, Z);

  sgpColor(DarkPink);
  for (u = 0; u < 8; u++)
   for (v = u+1; v < 8; v++) 
    Line3D(Vertex[u], Vertex[v]);

  for (t = 0; t < 12; t++)
   { /* paint BACK facing triangles */
    PointType3D V[3];
    VectorType3D Normal, A, B;
    
    V[0] = Vertex[Triangles[t].v[0]];
    V[1] = Vertex[Triangles[t].v[1]];
    V[2] = Vertex[Triangles[t].v[2]];


    A.dx = V[1].x - V[0].x;
    A.dy = V[1].y - V[0].y;
    A.dz = V[1].z - V[0].z;

    B.dx = V[2].x - V[0].x;
    B.dy = V[2].y - V[0].y;
    B.dz = V[2].z - V[0].z;

    Normal = Cross3D(A, B);

    if (Dot3D(Normal, OpticalAxis) > 0.0)
     ShadeTriangle3D(V, Triangles[t].rgb);
   }

  for (t = 0; t < 12; t++)
   { /* paint FRONT facing triangles */
    PointType3D V[3];
    VectorType3D Normal, A, B;

    V[0] = Vertex[Triangles[t].v[0]];
    V[1] = Vertex[Triangles[t].v[1]];
    V[2] = Vertex[Triangles[t].v[2]];

    A.dx = V[1].x - V[0].x;
    A.dy = V[1].y - V[0].y;
    A.dz = V[1].z - V[0].z;

    B.dx = V[2].x - V[0].x;
    B.dy = V[2].y - V[0].y;
    B.dz = V[2].z - V[0].z;

    Normal = Cross3D(A, B);

    if (Dot3D(Normal, OpticalAxis) < 0.0)
     ShadeTriangle3D(V, Triangles[t].rgb);
   }

  sgpQuit();
  exit(0);
 }


