/*
  File: Lighting.h
  Authors: Jinling Lee (Bill)
           K.R. Sloan
  Last Modified: 10 November 1988
  Purpose: lighting model for SGP
       
     I = Ambient*(Diffuse+Specular)
        + Sum Intensity_source * Diffuse * cos(theta)
         sources
                                               n
        + Sum Intensity_source * Specular * cos (alpha)
         sources
 */

/*
  void ClearLightSources()
  
  removes ALL light sources (but leaves Ambient as is)
 */
extern void ClearLightSources();

/*
 void SetExposure(exposure)
      double exposure;

  multiplies all light sources by an exposure factor - a good starting
  point is probably 1/NumberOfLightSources
 */
extern void SetExposure();

/*
 void SetAmbient(color)
       sgpColorType color;
  
   sets the ambient illumination of the scene
 */
extern void SetAmbient();

/*
 void AddLightSource(location, color)
       PointType3D location; 
       sgpColorType color;
 */
extern void AddLightSource();

/*
 void SetSurfaceReflectance(diffuse, specular, specularity)
       sgpColorType diffuse, specular;
       int specularity;

     sets the current surface diffuse, specular and specularity.
 */
extern void SetSurfaceReflectance();

/* 
 sgpColorType ColorAtPoint(location, normal)
               PointType3D location;
               VectorType3D normal;
  
   returns the color of a point on a surface at the location
   "location" and with normal "normal".
 */
extern sgpColorType ColorAtPoint();
