/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.Iterator;
import java.util.List;
import jde.debugger.Etc;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Rep;
import jde.debugger.command.DebugProcessCommand;

public class GetArray
extends DebugProcessCommand {
    private static final int MAX_DISPLAY_ELEMENTS = 30;

    public void doCommand() throws JDEException {
        if (this.m_args.size() < 1) {
            throw new JDEException("Insufficient arguments");
        }
        Long uniqueID = Etc.safeGetLong(this.m_args.remove(0), "object ID");
        ObjectReference oRef = this.m_debugger.getStore().get(uniqueID);
        if (oRef == null) {
            throw new JDEException("No such object exists");
        }
        if (!(oRef instanceof ArrayReference)) {
            throw new JDEException("Object is not an array");
        }
        this.m_debugger.getStore().put(oRef);
        if (this.m_args.size() == 0) {
            this.m_debugger.signalCommandResult(this.m_cmdID, Rep.getArrayRep((ArrayReference)oRef, ""), true, false);
        } else if (this.m_args.size() == 2) {
            StringBuffer elements = new StringBuffer();
            int index = Etc.safeGetint(this.m_args.remove(0), "index");
            int length = Etc.safeGetint(this.m_args.remove(0), "length");
            List<Value> elementList = ((ArrayReference)oRef).getValues(index, length);
            Iterator<Value> it = elementList.iterator();
            int numElements = 0;
            while (it.hasNext() && numElements < 30) {
                ++numElements;
                Value value = it.next();
                if (value instanceof ObjectReference) {
                    this.m_debugger.getStore().put((ObjectReference)value);
                }
                elements.append(" ");
                elements.append(Rep.getValueRep(value));
            }
            if (it.hasNext()) {
                JDE.debug(4, "did not list all elements");
            }
            this.m_debugger.signalCommandResult(this.m_cmdID, Rep.getArrayRep((ArrayReference)oRef, elements.toString()), true, false);
        } else {
            throw new JDEException("Syntax error: Wrong number of arguments");
        }
    }

    public Object clone() {
        return new GetArray();
    }
}

