;;; DO NOT MODIFY THIS FILE
(if (featurep 'calendar-autoloads) (error "Feature calendar-autoloads already loaded"))

(package-provide 'calendar :version 1.31 :author-version "No-Upstream-Ver" :type 'regular)

;;;### (autoloads (appt-activate appt-make-list appt-delete appt-add appt-display-diary appt-display-duration appt-display-mode-line appt-display-format appt-msg-window appt-visible appt-audible appt-message-warning-time appt-issue-message) "appt" "calendar/appt.el")

(defvar appt-issue-message t "\
*Non-nil means check for appointments in the diary buffer.
To be detected, the diary entry must have the format described in the
documentation of the function `appt-check'.")

(defvar appt-message-warning-time 12 "\
*Time in minutes before an appointment that the warning begins.")

(defvar appt-audible t "\
*Non-nil means beep to indicate appointment.")

(defvar appt-visible t "\
*Non-nil means display appointment message in echo area.
This variable is only relevant if `appt-msg-window' is nil.")

(defvar appt-msg-window t "\
*Non-nil means display appointment message in another window.
If non-nil, this variable overrides `appt-visible'.")

(defvar appt-display-format 'ignore "\
How appointment reminders should be displayed.
The options are:
   window - use a separate window
   echo   - use the echo area
   nil    - no visible reminder.
See also `appt-audible' and `appt-display-mode-line'.

The default value is 'ignore, which means to fall back on the value
of the (obsolete) variables `appt-msg-window' and `appt-visible'.")

(defvar appt-display-mode-line t "\
*Non-nil means display minutes to appointment and time on the mode line.
This is in addition to any other display of appointment messages.")

(defvar appt-display-duration 10 "\
*The number of seconds an appointment message is displayed.
Only relevant if reminders are to be displayed in their own window.")

(defvar appt-display-diary t "\
*Non-nil displays the diary when the appointment list is first initialized.
This will occur at midnight when the appointment list is updated.")

(autoload 'appt-add "appt" "\
Add an appointment for today at NEW-APPT-TIME with message NEW-APPT-MSG.
The time should be in either 24 hour format or am/pm format." t nil)

(autoload 'appt-delete "appt" "\
Delete an appointment from the list of appointments." t nil)

(autoload 'appt-make-list "appt" "\
Update the appointments list from today's diary buffer.
The time must be at the beginning of a line for it to be
put in the appointments list (see examples in documentation of
the function `appt-check').  We assume that the variables DATE and
NUMBER hold the arguments that `diary-list-entries' received.
They specify the range of dates that the diary is being processed for.

Any appointments made with `appt-add' are not affected by this
function.

For backwards compatibility, this function activates the
appointment package (if it is not already active)." nil nil)

(autoload 'appt-activate "appt" "\
Toggle checking of appointments.
With optional numeric argument ARG, turn appointment checking on if
ARG is positive, otherwise off." t nil)

;;;***

;;;### (autoloads (cal-make-mode-line-mouse-map cal-tp-ml-conv cal-remove-extents insert-button make-button) "cal-compat" "calendar/cal-compat.el")

(eval-and-compile (unless (fboundp 'line-beginning-position) (defalias 'line-beginning-position 'point-at-bol)) (unless (fboundp 'line-end-position) (defalias 'line-end-position 'point-at-eol)))

(autoload 'make-button "cal-compat" "\
Make a button from BEG to END in the current buffer.
The remaining arguments form a sequence of PROPERTY VALUE pairs,

This function is included with calendar for compatability with Emacs." nil nil)

(autoload 'insert-button "cal-compat" "\
Insert a button with the label LABEL.
The remaining arguments form a sequence of PROPERTY VALUE pairs.

This function is included with calendar for compatability with Emacs." nil nil)

(unless (fboundp 'match-string-no-properties) (defun match-string-no-properties (num &optional string) "Return string of text matched by last search, without text properties.\nNUM specifies which parenthesized expression in the last regexp.\n Value is nil if NUMth pair didn't match, or there were less than NUM pairs.\nZero means the entire text matched by the whole regexp or whole string.\nSTRING should be given if the last search was by `string-match' on STRING." (if (match-beginning num) (if string (let ((result (substring string (match-beginning num) (match-end num)))) (set-text-properties 0 (length result) nil result) result) (buffer-substring-no-properties (match-beginning num) (match-end num))))))

(unless (fboundp 'add-to-invisibility-spec) (defun add-to-invisibility-spec (arg) "Add elements to `buffer-invisibility-spec'.\nSee documentation for `buffer-invisibility-spec' for the kind of elements\nthat can be added." (if (eq buffer-invisibility-spec t) (setq buffer-invisibility-spec (list t))) (setq buffer-invisibility-spec (cons arg buffer-invisibility-spec))))

(if (fboundp 'assoc-string) (defalias 'cal-assoc-string 'assoc-string) (defun cal-assoc-string (key list case-fold) (if case-fold (assoc-ignore-case key list) (assoc key list))))

(unless (fboundp 'display-multi-frame-p) (defun display-multi-frame-p nil (not (null (memq (device-type) '(x mswindows gtk))))))

(unless (fboundp 'display-color-p) (defun display-color-p nil (eq 'color (device-class))))

(unless (fboundp 'propertize) (defun propertize (string &rest properties) "Return a copy of STRING with text properties added.\nFirst argument is the string to copy.\nRemaining arguments form a sequence of PROPERTY VALUE pairs for text\nproperties to add to the result." (let ((str (copy-sequence string))) (add-text-properties 0 (length str) properties str) str)))

(unless (fboundp 'fit-window-to-buffer) (defun cal-fit-window-to-buffer (&optional owin) "Make window the right size to display its contents exactly." (interactive) (if owin (delete-other-windows)) (when (> (length (window-list nil 'nomini)) 1) (let* ((window (selected-window)) (buf (window-buffer window)) (height (window-displayed-height (selected-window))) (new-height (with-current-buffer buf (count-lines (point-min) (point-max)))) (diff (- new-height height))) (unless (zerop diff) (enlarge-window diff)) (let ((end (with-current-buffer buf (point-max)))) (while (and (> (length (window-list nil 'nomini)) 1) (not (pos-visible-in-window-p end))) (enlarge-window 1)))))))

(autoload 'cal-remove-extents "cal-compat" "\
Clear BEG and END of overlays whose property NAME has value VAL.
Extents might be moved and or split. " t nil)

(autoload 'cal-tp-ml-conv "cal-compat" "\
Used to convert a propertized calendar modeline string to the XEmacs modeline format. 
If there are any text properties present in the string, it will be split on the text-property 
boundaries and extents added to the substrings with text properties." nil nil)

(autoload 'cal-make-mode-line-mouse-map "cal-compat" "\
Return a keymap with single entry for mouse key MOUSE on the mode line.
MOUSE is defined to run function FUNCTION with no args in the buffer
corresponding to the mode line clicked." nil nil)

;;;***

;;;### (autoloads (list-yahrzeit-dates) "cal-hebrew" "calendar/cal-hebrew.el")

(autoload 'list-yahrzeit-dates "cal-hebrew" "\
List Yahrzeit dates for *Gregorian* DEATH-DATE from START-YEAR to END-YEAR.
When called interactively from the calendar window, the date of death is taken
from the cursor position." t nil)

;;;***

;;;### (autoloads (calendar-week-start-day calendar calendar-setup solar-holidays bahai-holidays islamic-holidays christian-holidays hebrew-holidays other-holidays local-holidays oriental-holidays general-holidays holidays-in-diary-buffer diary-list-include-blanks nongregorian-diary-marking-hook mark-diary-entries-hook nongregorian-diary-listing-hook diary-display-hook diary-hook list-diary-entries-hook print-diary-entries-hook american-calendar-display-form european-calendar-display-form european-date-diary-pattern american-date-diary-pattern european-calendar-style abbreviated-calendar-year sexp-diary-entry-symbol diary-include-string bahai-diary-entry-symbol islamic-diary-entry-symbol hebrew-diary-entry-symbol diary-nonmarking-symbol diary-file calendar-move-hook today-invisible-calendar-hook today-visible-calendar-hook initial-calendar-window-hook calendar-load-hook all-bahai-calendar-holidays all-islamic-calendar-holidays all-christian-calendar-holidays all-hebrew-calendar-holidays mark-holidays-in-calendar view-calendar-holidays-initially calendar-remove-frame-by-deleting mark-diary-entries-in-calendar view-diary-entries-initially calendar-offset) "calendar" "calendar/calendar.el")

(defconst calendar-buffer "*Calendar*" "\
Name of the buffer used for the calendar.")

(defvar calendar-offset 0 "\
The offset of the principal month from the center of the calendar window.
0 means the principal month is in the center (default), -1 means on the left,
+1 means on the right.  Larger (or smaller) values push the principal month off
the screen.")

(defvar view-diary-entries-initially nil "\
Non-nil means display current date's diary entries on entry to calendar.
The diary is displayed in another window when the calendar is first displayed,
if the current date is visible.  The number of days of diary entries displayed
is governed by the variable `number-of-diary-entries'.  This variable can
be overridden by the value of `calendar-setup'.")

(defvar mark-diary-entries-in-calendar nil "\
Non-nil means mark dates with diary entries, in the calendar window.
The marking symbol is specified by the variable `diary-entry-marker'.")

(defvar calendar-remove-frame-by-deleting nil "\
Determine how the calendar mode removes a frame no longer needed.
If nil, make an icon of the frame.  If non-nil, delete the frame.")

(defvar view-calendar-holidays-initially nil "\
Non-nil means display holidays for current three month period on entry.
The holidays are displayed in another window when the calendar is first
displayed.")

(defvar mark-holidays-in-calendar nil "\
Non-nil means mark dates of holidays in the calendar window.
The marking symbol is specified by the variable `calendar-holiday-marker'.")

(defvar all-hebrew-calendar-holidays nil "\
If nil, show only major holidays from the Hebrew calendar.
This means only those Jewish holidays that appear on secular calendars.

If t, show all the holidays that would appear in a complete Hebrew calendar.")

(defvar all-christian-calendar-holidays nil "\
If nil, show only major holidays from the Christian calendar.
This means only those Christian holidays that appear on secular calendars.

If t, show all the holidays that would appear in a complete Christian
calendar.")

(defvar all-islamic-calendar-holidays nil "\
If nil, show only major holidays from the Islamic calendar.
This means only those Islamic holidays that appear on secular calendars.

If t, show all the holidays that would appear in a complete Islamic
calendar.")

(defvar all-bahai-calendar-holidays nil "\
If nil, show only major holidays from the Baha'i calendar.
These are the days on which work and school must be suspended.

If t, show all the holidays that would appear in a complete Baha'i
calendar.")

(defvar calendar-load-hook nil "\
List of functions to be called after the calendar is first loaded.
This is the place to add key bindings to `calendar-mode-map'.")

(defvar initial-calendar-window-hook nil "\
List of functions to be called when the calendar window is first opened.
The functions invoked are called after the calendar window is opened, but
once opened is never called again.  Leaving the calendar with the `q' command
and reentering it will cause these functions to be called again.")

(defvar today-visible-calendar-hook nil "\
List of functions called whenever the current date is visible.
This can be used, for example, to replace today's date with asterisks; a
function `calendar-star-date' is included for this purpose:
    (setq today-visible-calendar-hook 'calendar-star-date)
It can also be used to mark the current date with `calendar-today-marker';
a function is also provided for this:
    (setq today-visible-calendar-hook 'calendar-mark-today)

The corresponding variable `today-invisible-calendar-hook' is the list of
functions called when the calendar function was called when the current
date is not visible in the window.

Other than the use of the provided functions, the changing of any
characters in the calendar buffer by the hooks may cause the failure of the
functions that move by days and weeks.")

(defvar today-invisible-calendar-hook nil "\
List of functions called whenever the current date is not visible.

The corresponding variable `today-visible-calendar-hook' is the list of
functions called when the calendar function was called when the current
date is visible in the window.

Other than the use of the provided functions, the changing of any
characters in the calendar buffer by the hooks may cause the failure of the
functions that move by days and weeks.")

(defvar calendar-move-hook nil "\
List of functions called whenever the cursor moves in the calendar.

For example,

  (add-hook 'calendar-move-hook (lambda () (diary-view-entries 1)))

redisplays the diary for whatever date the cursor is moved to.")

(defvar diary-file "~/diary" "\
Name of the file in which one's personal diary of dates is kept.

The file's entries are lines beginning with any of the forms
specified by the variable `american-date-diary-pattern', by default:

            MONTH/DAY
            MONTH/DAY/YEAR
            MONTHNAME DAY
            MONTHNAME DAY, YEAR
            DAYNAME

with the remainder of the line being the diary entry string for
that date.  MONTH and DAY are one or two digit numbers, YEAR is a
number and may be written in full or abbreviated to the final two
digits (if `abbreviated-calendar-year' is non-nil).  MONTHNAME
and DAYNAME can be spelled in full (as specified by the variables
`calendar-month-name-array' and `calendar-day-name-array'),
abbreviated (as specified by `calendar-month-abbrev-array' and
`calendar-day-abbrev-array') with or without a period,
capitalized or not.  Any of DAY, MONTH, or MONTHNAME, YEAR can be
`*' which matches any day, month, or year, respectively. If the
date does not contain a year, it is generic and applies to any
year.  A DAYNAME entry applies to the appropriate day of the week
in every week.

The European style (in which the day precedes the month) can be
used instead, if you execute `european-calendar' when in the
calendar, or set `european-calendar-style' to t in your .emacs
file.  The European forms (see `european-date-diary-pattern') are

            DAY/MONTH
            DAY/MONTH/YEAR
            DAY MONTHNAME
            DAY MONTHNAME YEAR
            DAYNAME

To revert to the default American style from the European style, execute
`american-calendar' in the calendar.

A diary entry can be preceded by the character
`diary-nonmarking-symbol' (ordinarily `&') to make that entry
nonmarking--that is, it will not be marked on dates in the calendar
window but will appear in a diary window.

Multiline diary entries are made by indenting lines after the first with
either a TAB or one or more spaces.

Lines not in one the above formats are ignored.  Here are some sample diary
entries (in the default American style):

     12/22/1988 Twentieth wedding anniversary!!
     &1/1. Happy New Year!
     10/22 Ruth's birthday.
     21: Payday
     Tuesday--weekly meeting with grad students at 10am
              Supowit, Shen, Bitner, and Kapoor to attend.
     1/13/89 Friday the thirteenth!!
     &thu 4pm squash game with Lloyd.
     mar 16 Dad's birthday
     April 15, 1989 Income tax due.
     &* 15 time cards due.

If the first line of a diary entry consists only of the date or day name with
no trailing blanks or punctuation, then that line is not displayed in the
diary window; only the continuation lines is shown.  For example, the
single diary entry

     02/11/1989
      Bill Blattner visits Princeton today
      2pm Cognitive Studies Committee meeting
      2:30-5:30 Lizzie at Lawrenceville for `Group Initiative'
      4:00pm Jamie Tappenden
      7:30pm Dinner at George and Ed's for Alan Ryan
      7:30-10:00pm dance at Stewart Country Day School

will appear in the diary window without the date line at the beginning.  This
facility allows the diary window to look neater, but can cause confusion if
used with more than one day's entries displayed.

Diary entries can be based on Lisp sexps.  For example, the diary entry

      %%(diary-block 11 1 1990 11 10 1990) Vacation

causes the diary entry \"Vacation\" to appear from November 1 through
November 10, 1990.  Other functions available are `diary-float',
`diary-anniversary', `diary-cyclic', `diary-day-of-year',
`diary-iso-date', `diary-french-date', `diary-hebrew-date',
`diary-islamic-date', `diary-bahai-date', `diary-mayan-date',
`diary-chinese-date', `diary-coptic-date', `diary-ethiopic-date',
`diary-persian-date', `diary-yahrzeit', `diary-sunrise-sunset',
`diary-phases-of-moon', `diary-parasha', `diary-omer',
`diary-rosh-hodesh', and `diary-sabbath-candles'.  See the
documentation for the function `list-sexp-diary-entries' for more
details.

Diary entries based on the Hebrew, the Islamic and/or the Baha'i
calendar are also possible, but because these are somewhat slow, they
are ignored unless you set the `nongregorian-diary-listing-hook' and
the `nongregorian-diary-marking-hook' appropriately.  See the
documentation for these functions for details.

Diary files can contain directives to include the contents of other files; for
details, see the documentation for the variable `list-diary-entries-hook'.")

(defvar diary-nonmarking-symbol "&" "\
Symbol indicating that a diary entry is not to be marked in the calendar.")

(defvar hebrew-diary-entry-symbol "H" "\
Symbol indicating a diary entry according to the Hebrew calendar.")

(defvar islamic-diary-entry-symbol "I" "\
Symbol indicating a diary entry according to the Islamic calendar.")

(defvar bahai-diary-entry-symbol "B" "\
Symbol indicating a diary entry according to the Baha'i calendar.")

(defvar diary-include-string "#include" "\
The string indicating inclusion of another file of diary entries.
See the documentation for the function `include-other-diary-files'.")

(defvar sexp-diary-entry-symbol "%%" "\
The string used to indicate a sexp diary entry in `diary-file'.
See the documentation for the function `list-sexp-diary-entries'.")

(defvar abbreviated-calendar-year t "\
Interpret a two-digit year DD in a diary entry as either 19DD or 20DD.
For the Gregorian calendar; similarly for the Hebrew, Islamic and
Baha'i calendars.  If this variable is nil, years must be written in
full.")

(defvar european-calendar-style nil "\
Use the European style of dates in the diary and in any displays.
If this variable is t, a date 1/2/1990 would be interpreted as February 1,
1990.  The default European date styles (see `european-date-diary-pattern')
are

            DAY/MONTH
            DAY/MONTH/YEAR
            DAY MONTHNAME
            DAY MONTHNAME YEAR
            DAYNAME

Names can be capitalized or not, written in full (as specified by the
variable `calendar-day-name-array'), or abbreviated (as specified by
`calendar-day-abbrev-array') with or without a period.

Setting this variable directly does not take effect (if the
calendar package is already loaded).  Rather, use either
\\[customize] or the functions `european-calendar' and
`american-calendar'.")

(defvar american-date-diary-pattern '((month "/" day "[^/0-9]") (month "/" day "/" year "[^0-9]") (monthname " *" day "[^,0-9]") (monthname " *" day ", *" year "[^0-9]") (dayname "\\W")) "\
List of pseudo-patterns describing the American patterns of date used.
See the documentation of `diary-date-forms' for an explanation.")

(defvar european-date-diary-pattern '((day "/" month "[^/0-9]") (day "/" month "/" year "[^0-9]") (backup day " *" monthname "\\W+\\<\\([^*0-9]\\|\\([0-9]+[:aApP]\\)\\)") (day " *" monthname " *" year "[^0-9]") (dayname "\\W")) "\
List of pseudo-patterns describing the European patterns of date used.
See the documentation of `diary-date-forms' for an explanation.")

(defvar european-calendar-display-form '((if dayname (concat dayname ", ")) day " " monthname " " year) "\
Pseudo-pattern governing the way a date appears in the European style.
See the documentation of `calendar-date-display-form' for an explanation.")

(defvar american-calendar-display-form '((if dayname (concat dayname ", ")) monthname " " day ", " year) "\
Pseudo-pattern governing the way a date appears in the American style.
See the documentation of `calendar-date-display-form' for an explanation.")

(defvar print-diary-entries-hook 'lpr-buffer "\
List of functions called after a temporary diary buffer is prepared.
The buffer shows only the diary entries currently visible in the diary
buffer.  The default just does the printing.  Other uses might include, for
example, rearranging the lines into order by day and time, saving the buffer
instead of deleting it, or changing the function used to do the printing.")

(defvar list-diary-entries-hook nil "\
List of functions called after diary file is culled for relevant entries.
It is to be used for diary entries that are not found in the diary file.

A function `include-other-diary-files' is provided for use as the value of
this hook.  This function enables you to use shared diary files together
with your own.  The files included are specified in the diary file by lines
of the form

        #include \"filename\"

This is recursive; that is, #include directives in files thus included are
obeyed.  You can change the \"#include\" to some other string by changing
the variable `diary-include-string'.  When you use `include-other-diary-files'
as part of the list-diary-entries-hook, you will probably also want to use the
function `mark-included-diary-files' as part of `mark-diary-entries-hook'.

For example, you could use

     (setq list-diary-entries-hook
       '(include-other-diary-files sort-diary-entries))
     (setq diary-display-hook 'fancy-diary-display)

in your `.emacs' file to cause the fancy diary buffer to be displayed with
diary entries from various included files, each day's entries sorted into
lexicographic order.")

(defvar diary-hook nil "\
List of functions called after the display of the diary.
Can be used for appointment notification.")

(defvar diary-display-hook nil "\
List of functions that handle the display of the diary.
If nil (the default), `simple-diary-display' is used.  Use `ignore' for no
diary display.

Ordinarily, this just displays the diary buffer (with holidays indicated in
the mode line), if there are any relevant entries.  At the time these
functions are called, the variable `diary-entries-list' is a list, in order
by date, of all relevant diary entries in the form of ((MONTH DAY YEAR)
STRING), where string is the diary entry for the given date.  This can be
used, for example, a different buffer for display (perhaps combined with
holidays), or produce hard copy output.

A function `fancy-diary-display' is provided as an alternative
choice for this hook; this function prepares a special noneditable diary
buffer with the relevant diary entries that has neat day-by-day arrangement
with headings.  The fancy diary buffer will show the holidays unless the
variable `holidays-in-diary-buffer' is set to nil.  Ordinarily, the fancy
diary buffer will not show days for which there are no diary entries, even
if that day is a holiday; if you want such days to be shown in the fancy
diary buffer, set the variable `diary-list-include-blanks' to t.")

(defvar nongregorian-diary-listing-hook nil "\
List of functions called for listing diary file and included files.
As the files are processed for diary entries, these functions are used
to cull relevant entries.  You can use either or both of
`list-hebrew-diary-entries', `list-islamic-diary-entries' and
`list-bahai-diary-entries'.  The documentation for these functions
describes the style of such diary entries.")

(defvar mark-diary-entries-hook nil "\
List of functions called after marking diary entries in the calendar.

A function `mark-included-diary-files' is also provided for use as the
`mark-diary-entries-hook'; it enables you to use shared diary files together
with your own.  The files included are specified in the diary file by lines
of the form
        #include \"filename\"
This is recursive; that is, #include directives in files thus included are
obeyed.  You can change the \"#include\" to some other string by changing the
variable `diary-include-string'.  When you use `mark-included-diary-files' as
part of the mark-diary-entries-hook, you will probably also want to use the
function `include-other-diary-files' as part of `list-diary-entries-hook'.")

(defvar nongregorian-diary-marking-hook nil "\
List of functions called for marking diary file and included files.
As the files are processed for diary entries, these functions are used
to cull relevant entries.  You can use either or both of
`mark-hebrew-diary-entries', `mark-islamic-diary-entries' and
`mark-bahai-diary-entries'.  The documentation for these functions
describes the style of such diary entries.")

(defvar diary-list-include-blanks nil "\
If nil, do not include days with no diary entry in the list of diary entries.
Such days will then not be shown in the fancy diary buffer, even if they
are holidays.")

(defvar holidays-in-diary-buffer t "\
Non-nil means include holidays in the diary display.
The holidays appear in the mode line of the diary buffer, or in the
fancy diary buffer next to the date.  This slows down the diary functions
somewhat; setting it to nil makes the diary display faster.")

(put 'general-holidays 'risky-local-variable t)

(defvar general-holidays '((holiday-fixed 1 1 "New Year's Day") (holiday-float 1 1 3 "Martin Luther King Day") (holiday-fixed 2 2 "Groundhog Day") (holiday-fixed 2 14 "Valentine's Day") (holiday-float 2 1 3 "President's Day") (holiday-fixed 3 17 "St. Patrick's Day") (holiday-fixed 4 1 "April Fools' Day") (holiday-float 5 0 2 "Mother's Day") (holiday-float 5 1 -1 "Memorial Day") (holiday-fixed 6 14 "Flag Day") (holiday-float 6 0 3 "Father's Day") (holiday-fixed 7 4 "Independence Day") (holiday-float 9 1 1 "Labor Day") (holiday-float 10 1 2 "Columbus Day") (holiday-fixed 10 31 "Halloween") (holiday-fixed 11 11 "Veteran's Day") (holiday-float 11 4 4 "Thanksgiving")) "\
General holidays.  Default value is for the United States.
See the documentation for `calendar-holidays' for details.")

(put 'oriental-holidays 'risky-local-variable t)

(defvar oriental-holidays '((if (fboundp 'atan) (holiday-chinese-new-year))) "\
Oriental holidays.
See the documentation for `calendar-holidays' for details.")

(put 'local-holidays 'risky-local-variable t)

(defvar local-holidays nil "\
Local holidays.
See the documentation for `calendar-holidays' for details.")

(put 'other-holidays 'risky-local-variable t)

(defvar other-holidays nil "\
User defined holidays.
See the documentation for `calendar-holidays' for details.")

(put 'hebrew-holidays-1 'risky-local-variable t)

(defvar hebrew-holidays-1 '((holiday-rosh-hashanah-etc) (if all-hebrew-calendar-holidays (holiday-julian 11 (let* ((m displayed-month) (y displayed-year) (year)) (increment-calendar-month m y -1) (let ((year (extract-calendar-year (calendar-julian-from-absolute (calendar-absolute-from-gregorian (list m 1 y)))))) (if (zerop (% (1+ year) 4)) 22 21))) "\"Tal Umatar\" (evening)"))))

(put 'hebrew-holidays-2 'risky-local-variable t)

(defvar hebrew-holidays-2 '((if all-hebrew-calendar-holidays (holiday-hanukkah) (holiday-hebrew 9 25 "Hanukkah")) (if all-hebrew-calendar-holidays (holiday-hebrew 10 (let ((h-year (extract-calendar-year (calendar-hebrew-from-absolute (calendar-absolute-from-gregorian (list displayed-month 28 displayed-year)))))) (if (= (% (calendar-absolute-from-hebrew (list 10 10 h-year)) 7) 6) 11 10)) "Tzom Teveth")) (if all-hebrew-calendar-holidays (holiday-hebrew 11 15 "Tu B'Shevat"))))

(put 'hebrew-holidays-3 'risky-local-variable t)

(defvar hebrew-holidays-3 '((if all-hebrew-calendar-holidays (holiday-hebrew 11 (let ((m displayed-month) (y displayed-year)) (increment-calendar-month m y 1) (let* ((h-year (extract-calendar-year (calendar-hebrew-from-absolute (calendar-absolute-from-gregorian (list m (calendar-last-day-of-month m y) y))))) (s-s (calendar-hebrew-from-absolute (if (= (% (calendar-absolute-from-hebrew (list 7 1 h-year)) 7) 6) (calendar-dayname-on-or-before 6 (calendar-absolute-from-hebrew (list 11 17 h-year))) (calendar-dayname-on-or-before 6 (calendar-absolute-from-hebrew (list 11 16 h-year)))))) (day (extract-calendar-day s-s))) day)) "Shabbat Shirah"))))

(put 'hebrew-holidays-4 'risky-local-variable t)

(defvar hebrew-holidays-4 '((holiday-passover-etc) (if (and all-hebrew-calendar-holidays (let* ((m displayed-month) (y displayed-year) (year)) (increment-calendar-month m y -1) (let ((year (extract-calendar-year (calendar-julian-from-absolute (calendar-absolute-from-gregorian (list m 1 y)))))) (= 21 (% year 28))))) (holiday-julian 3 26 "Kiddush HaHamah")) (if all-hebrew-calendar-holidays (holiday-tisha-b-av-etc))))

(put 'hebrew-holidays 'risky-local-variable t)

(defvar hebrew-holidays (append hebrew-holidays-1 hebrew-holidays-2 hebrew-holidays-3 hebrew-holidays-4) "\
Jewish holidays.
See the documentation for `calendar-holidays' for details.")

(put 'christian-holidays 'risky-local-variable t)

(defvar christian-holidays '((if all-christian-calendar-holidays (holiday-fixed 1 6 "Epiphany")) (holiday-easter-etc 0 "Easter Sunday") (holiday-easter-etc -2 "Good Friday") (holiday-easter-etc -46 "Ash Wednesday") (if all-christian-calendar-holidays (holiday-easter-etc -63 "Septuagesima Sunday")) (if all-christian-calendar-holidays (holiday-easter-etc -56 "Sexagesima Sunday")) (if all-christian-calendar-holidays (holiday-easter-etc -49 "Shrove Sunday")) (if all-christian-calendar-holidays (holiday-easter-etc -48 "Shrove Monday")) (if all-christian-calendar-holidays (holiday-easter-etc -47 "Shrove Tuesday")) (if all-christian-calendar-holidays (holiday-easter-etc -14 "Passion Sunday")) (if all-christian-calendar-holidays (holiday-easter-etc -7 "Palm Sunday")) (if all-christian-calendar-holidays (holiday-easter-etc -3 "Maundy Thursday")) (if all-christian-calendar-holidays (holiday-easter-etc 35 "Rogation Sunday")) (if all-christian-calendar-holidays (holiday-easter-etc 39 "Ascension Day")) (if all-christian-calendar-holidays (holiday-easter-etc 49 "Pentecost (Whitsunday)")) (if all-christian-calendar-holidays (holiday-easter-etc 50 "Whitmonday")) (if all-christian-calendar-holidays (holiday-easter-etc 56 "Trinity Sunday")) (if all-christian-calendar-holidays (holiday-easter-etc 60 "Corpus Christi")) (if all-christian-calendar-holidays (holiday-greek-orthodox-easter)) (if all-christian-calendar-holidays (holiday-fixed 8 15 "Assumption")) (if all-christian-calendar-holidays (holiday-advent 0 "Advent")) (holiday-fixed 12 25 "Christmas") (if all-christian-calendar-holidays (holiday-julian 12 25 "Eastern Orthodox Christmas"))) "\
Christian holidays.
See the documentation for `calendar-holidays' for details.")

(put 'islamic-holidays 'risky-local-variable t)

(defvar islamic-holidays '((holiday-islamic 1 1 (format "Islamic New Year %d" (let ((m displayed-month) (y displayed-year)) (increment-calendar-month m y 1) (extract-calendar-year (calendar-islamic-from-absolute (calendar-absolute-from-gregorian (list m (calendar-last-day-of-month m y) y))))))) (if all-islamic-calendar-holidays (holiday-islamic 1 10 "Ashura")) (if all-islamic-calendar-holidays (holiday-islamic 3 12 "Mulad-al-Nabi")) (if all-islamic-calendar-holidays (holiday-islamic 7 26 "Shab-e-Mi'raj")) (if all-islamic-calendar-holidays (holiday-islamic 8 15 "Shab-e-Bara't")) (holiday-islamic 9 1 "Ramadan Begins") (if all-islamic-calendar-holidays (holiday-islamic 9 27 "Shab-e Qadr")) (if all-islamic-calendar-holidays (holiday-islamic 10 1 "Id-al-Fitr")) (if all-islamic-calendar-holidays (holiday-islamic 12 10 "Id-al-Adha"))) "\
Islamic holidays.
See the documentation for `calendar-holidays' for details.")

(put 'bahai-holidays 'risky-local-variable t)

(defvar bahai-holidays '((holiday-fixed 3 21 (format "Baha'i New Year (Naw-Ruz) %d" (- displayed-year (1- 1844)))) (holiday-fixed 4 21 "First Day of Ridvan") (if all-bahai-calendar-holidays (holiday-fixed 4 22 "Second Day of Ridvan")) (if all-bahai-calendar-holidays (holiday-fixed 4 23 "Third Day of Ridvan")) (if all-bahai-calendar-holidays (holiday-fixed 4 24 "Fourth Day of Ridvan")) (if all-bahai-calendar-holidays (holiday-fixed 4 25 "Fifth Day of Ridvan")) (if all-bahai-calendar-holidays (holiday-fixed 4 26 "Sixth Day of Ridvan")) (if all-bahai-calendar-holidays (holiday-fixed 4 27 "Seventh Day of Ridvan")) (if all-bahai-calendar-holidays (holiday-fixed 4 28 "Eighth Day of Ridvan")) (holiday-fixed 4 29 "Ninth Day of Ridvan") (if all-bahai-calendar-holidays (holiday-fixed 4 30 "Tenth Day of Ridvan")) (if all-bahai-calendar-holidays (holiday-fixed 5 1 "Eleventh Day of Ridvan")) (holiday-fixed 5 2 "Twelfth Day of Ridvan") (holiday-fixed 5 23 "Declaration of the Bab") (holiday-fixed 5 29 "Ascension of Baha'u'llah") (holiday-fixed 7 9 "Martyrdom of the Bab") (holiday-fixed 10 20 "Birth of the Bab") (holiday-fixed 11 12 "Birth of Baha'u'llah") (if all-bahai-calendar-holidays (holiday-fixed 11 26 "Day of the Covenant")) (if all-bahai-calendar-holidays (holiday-fixed 11 28 "Ascension of `Abdu'l-Baha"))) "\
Baha'i holidays.
See the documentation for `calendar-holidays' for details.")

(put 'solar-holidays 'risky-local-variable t)

(defvar solar-holidays '((if (fboundp 'atan) (solar-equinoxes-solstices)) (if (progn (require 'cal-dst) t) (funcall 'holiday-sexp calendar-daylight-savings-starts '(format "Daylight Savings Time Begins %s" (if (fboundp 'atan) (solar-time-string (/ calendar-daylight-savings-starts-time (float 60)) calendar-standard-time-zone-name) "")))) (funcall 'holiday-sexp calendar-daylight-savings-ends '(format "Daylight Savings Time Ends %s" (if (fboundp 'atan) (solar-time-string (/ calendar-daylight-savings-ends-time (float 60)) calendar-daylight-time-zone-name) "")))) "\
Sun-related holidays.
See the documentation for `calendar-holidays' for details.")

(put 'calendar-holidays 'risky-local-variable t)

(defvar calendar-setup nil "\
The frame setup of the calendar.
The choices are: `one-frame' (calendar and diary together in one separate,
dedicated frame); `two-frames' (calendar and diary in separate, dedicated
frames); `calendar-only' (calendar in a separate, dedicated frame); with
any other value the current frame is used.  Using any of the first
three options overrides the value of `view-diary-entries-initially'.")

(autoload 'calendar "calendar" "\
Choose between the one frame, two frame, or basic calendar displays.
If called with an optional prefix argument, prompts for month and year.

The original function `calendar' has been renamed `calendar-basic-setup'.
See the documentation of that function for more information." t nil)

(defvar calendar-week-start-day 0 "\
The day of the week on which a week in the calendar begins.
0 means Sunday (default), 1 means Monday, and so on.

If you change this variable directly (without using customize)
after starting `calendar', you should call `redraw-calendar' to
update the calendar display to reflect the change, otherwise
movement commands will not work correctly.")

;;;***

;;;### (autoloads (diary-mode diary-mail-entries diary) "diary-lib" "calendar/diary-lib.el")

(autoload 'diary "diary-lib" "\
Generate the diary window for ARG days starting with the current date.
If no argument is provided, the number of days of diary entries is governed
by the variable `number-of-diary-entries'.  A value of ARG less than 1
does nothing.  This function is suitable for execution in a `.emacs' file." t nil)

(autoload 'diary-mail-entries "diary-lib" "\
Send a mail message showing diary entries for next NDAYS days.
If no prefix argument is given, NDAYS is set to `diary-mail-days'.
Mail is sent to the address specified by `diary-mail-addr'.

You can call `diary-mail-entries' every night using an at/cron job.
For example, this script will run the program at 2am daily.  Since
`emacs -batch' does not load your `.emacs' file, you must ensure that
all relevant variables are set, as done here.

#!/bin/sh
# diary-rem.sh -- repeatedly run the Emacs diary-reminder
emacs -batch \\
-eval \"(setq diary-mail-days 3 \\
             diary-file \\\"/path/to/diary.file\\\" \\
             european-calendar-style t \\
             diary-mail-addr \\\"user@host.name\\\" )\" \\
-l diary-lib -f diary-mail-entries
at -f diary-rem.sh 0200 tomorrow

You may have to tweak the syntax of the `at' command to suit your
system.  Alternatively, you can specify a cron entry:
0 1 * * * diary-rem.sh
to run it every morning at 1am." t nil)

(autoload 'diary-mode "diary-lib" "\
Major mode for editing the diary file." t nil)

;;;***

;;;### (autoloads (check-calendar-holidays list-holidays holidays) "holidays" "calendar/holidays.el")

(autoload 'holidays "holidays" "\
Display the holidays for last month, this month, and next month.
If called with an optional prefix argument, prompts for month and year.

This function is suitable for execution in a .emacs file." t nil)

(autoload 'list-holidays "holidays" "\
Display holidays for years Y1 to Y2 (inclusive).

The optional list of holidays L defaults to `calendar-holidays'.
If you want to control what holidays are displayed, use a
different list.  For example,

  (list-holidays 2006 2006
    (append general-holidays local-holidays other-holidays))

will display holidays for the year 2006 defined in the 3
mentioned lists, and nothing else.

When called interactively, this command offers a choice of
holidays, based on the variables `solar-holidays' etc.  See the
documentation of `calendar-holidays' for a list of the variables
that control the choices, as well as a description of the format
of a holiday list.

The optional LABEL is used to label the buffer created." t nil)

(autoload 'check-calendar-holidays "holidays" "\
Check the list of holidays for any that occur on DATE.
The value returned is a list of strings of relevant holiday descriptions.
The holidays are those in the list calendar-holidays." nil nil)

;;;***

;;;### (autoloads (icalendar-import-buffer icalendar-import-file icalendar-export-region icalendar-export-file) "icalendar" "calendar/icalendar.el")

(autoload 'icalendar-export-file "icalendar" "\
Export diary file to iCalendar format.
All diary entries in the file DIARY-FILENAME are converted to iCalendar
format.  The result is appended to the file ICAL-FILENAME." t nil)

(autoload 'icalendar-export-region "icalendar" "\
Export region in diary file to iCalendar format.
All diary entries in the region from MIN to MAX in the current buffer are
converted to iCalendar format.  The result is appended to the file
ICAL-FILENAME.
This function attempts to return t if something goes wrong.  In this
case an error string which describes all the errors and problems is
written into the buffer `*icalendar-errors*'." t nil)

(autoload 'icalendar-import-file "icalendar" "\
Import an iCalendar file and append to a diary file.
Argument ICAL-FILENAME output iCalendar file.
Argument DIARY-FILENAME input `diary-file'.
Optional argument NON-MARKING determines whether events are created as
non-marking or not." t nil)

(autoload 'icalendar-import-buffer "icalendar" "\
Extract iCalendar events from current buffer.

This function searches the current buffer for the first iCalendar
object, reads it and adds all VEVENT elements to the diary
DIARY-FILE.

It will ask for each appointment whether to add it to the diary
when DO-NOT-ASK is non-nil.  When called interactively,
DO-NOT-ASK is set to t, so that you are asked fore each event.

NON-MARKING determines whether diary events are created as
non-marking.

Return code t means that importing worked well, return code nil
means that an error has occurred.  Error messages will be in the
buffer `*icalendar-errors*'." t nil)

;;;***

;;;### (autoloads (phases-of-moon) "lunar" "calendar/lunar.el")

(autoload 'phases-of-moon "lunar" "\
Display the quarters of the moon for last month, this month, and next month.
If called with an optional prefix argument, prompts for month and year.

This function is suitable for execution in a .emacs file." t nil)

;;;***

;;;### (autoloads (solar-equinoxes-solstices sunrise-sunset calendar-location-name calendar-longitude calendar-latitude calendar-time-display-form) "solar" "calendar/solar.el")

(defvar calendar-time-display-form '(12-hours ":" minutes am-pm (if time-zone " (") time-zone (if time-zone ")")) "\
*The pseudo-pattern that governs the way a time of day is formatted.

A pseudo-pattern is a list of expressions that can involve the keywords
`12-hours', `24-hours', and `minutes', all numbers in string form,
and `am-pm' and `time-zone', both alphabetic strings.

For example, the form

  '(24-hours \":\" minutes
    (if time-zone \" (\") time-zone (if time-zone \")\"))

would give military-style times like `21:07 (UTC)'.")

(defvar calendar-latitude nil "\
*Latitude of `calendar-location-name' in degrees.

The value can be either a decimal fraction (one place of accuracy is
sufficient), + north, - south, such as 40.7 for New York City, or the value
can be a vector [degrees minutes north/south] such as [40 50 north] for New
York City.

This variable should be set in `site-start'.el.")

(defvar calendar-longitude nil "\
*Longitude of `calendar-location-name' in degrees.

The value can be either a decimal fraction (one place of accuracy is
sufficient), + east, - west, such as -73.9 for New York City, or the value
can be a vector [degrees minutes east/west] such as [73 55 west] for New
York City.

This variable should be set in `site-start'.el.")

(defvar calendar-location-name '(let ((float-output-format "%.1f")) (format "%s%s, %s%s" (if (numberp calendar-latitude) (abs calendar-latitude) (+ (aref calendar-latitude 0) (/ (aref calendar-latitude 1) 60.0))) (if (numberp calendar-latitude) (if (> calendar-latitude 0) "N" "S") (if (equal (aref calendar-latitude 2) 'north) "N" "S")) (if (numberp calendar-longitude) (abs calendar-longitude) (+ (aref calendar-longitude 0) (/ (aref calendar-longitude 1) 60.0))) (if (numberp calendar-longitude) (if (> calendar-longitude 0) "E" "W") (if (equal (aref calendar-longitude 2) 'east) "E" "W")))) "\
*Expression evaluating to name of `calendar-longitude', `calendar-latitude'.
For example, \"New York City\".  Default value is just the latitude, longitude
pair.

This variable should be set in `site-start'.el.")

(autoload 'sunrise-sunset "solar" "\
Local time of sunrise and sunset for today.  Accurate to a few seconds.
If called with an optional prefix argument, prompt for date.

If called with an optional double prefix argument, prompt for longitude,
latitude, time zone, and date, and always use standard time.

This function is suitable for execution in a .emacs file." t nil)

(autoload 'solar-equinoxes-solstices "solar" "\
*local* date and time of equinoxes and solstices, if visible in the calendar window.
Requires floating point." nil nil)

;;;***

;;;### (autoloads (timeclock-when-to-leave-string timeclock-workday-elapsed-string timeclock-workday-remaining-string timeclock-reread-log timeclock-query-out timeclock-change timeclock-status-string timeclock-out timeclock-in timeclock-modeline-display) "timeclock" "calendar/timeclock.el")

(autoload 'timeclock-modeline-display "timeclock" "\
Toggle display of the amount of time left today in the modeline.
If `timeclock-use-display-time' is non-nil (the default), then
the function `display-time-mode' must be active, and the modeline
will be updated whenever the time display is updated.  Otherwise,
the timeclock will use its own sixty second timer to do its
updating.  With prefix ARG, turn modeline display on if and only
if ARG is positive.  Returns the new status of timeclock modeline
display (non-nil means on)." t nil)

(autoload 'timeclock-in "timeclock" "\
Clock in, recording the current time moment in the timelog.
With a numeric prefix ARG, record the fact that today has only that
many hours in it to be worked.  If arg is a non-numeric prefix arg
\(non-nil, but not a number), 0 is assumed (working on a holiday or
weekend).  *If not called interactively, ARG should be the number of
_seconds_ worked today*.  This feature only has effect the first time
this function is called within a day.

PROJECT is the project being clocked into.  If PROJECT is nil, and
FIND-PROJECT is non-nil -- or the user calls `timeclock-in'
interactively -- call the function `timeclock-get-project-function' to
discover the name of the project." t nil)

(autoload 'timeclock-out "timeclock" "\
Clock out, recording the current time moment in the timelog.
If a prefix ARG is given, the user has completed the project that was
begun during the last time segment.

REASON is the user's reason for clocking out.  If REASON is nil, and
FIND-REASON is non-nil -- or the user calls `timeclock-out'
interactively -- call the function `timeclock-get-reason-function' to
discover the reason." t nil)

(autoload 'timeclock-status-string "timeclock" "\
Report the overall timeclock status at the present moment.
If SHOW-SECONDS is non-nil, display second resolution.
If TODAY-ONLY is non-nil, the display will be relative only to time
worked today, ignoring the time worked on previous days." t nil)

(autoload 'timeclock-change "timeclock" "\
Change to working on a different project.
This clocks out of the current project, then clocks in on a new one.
With a prefix ARG, consider the previous project as finished at the
time of changeover.  PROJECT is the name of the last project you were
working on." t nil)

(autoload 'timeclock-query-out "timeclock" "\
Ask the user whether to clock out.
This is a useful function for adding to `kill-emacs-query-functions'." nil nil)

(autoload 'timeclock-reread-log "timeclock" "\
Re-read the timeclock, to account for external changes.
Returns the new value of `timeclock-discrepancy'." t nil)

(autoload 'timeclock-workday-remaining-string "timeclock" "\
Return a string representing the amount of time left today.
Display second resolution if SHOW-SECONDS is non-nil.  If TODAY-ONLY
is non-nil, the display will be relative only to time worked today.
See `timeclock-relative' for more information about the meaning of
\"relative to today\"." t nil)

(autoload 'timeclock-workday-elapsed-string "timeclock" "\
Return a string representing the amount of time worked today.
Display seconds resolution if SHOW-SECONDS is non-nil.  If RELATIVE is
non-nil, the amount returned will be relative to past time worked." t nil)

(autoload 'timeclock-when-to-leave-string "timeclock" "\
Return a string representing the end of today's workday.
This string is relative to the value of `timeclock-workday'.  If
SHOW-SECONDS is non-nil, the value printed/returned will include
seconds.  If TODAY-ONLY is non-nil, the value returned will be
relative only to the time worked today, and not to past time." t nil)

;;;***

;;;### (autoloads (todo-show todo-cp todo-mode todo-print todo-top-priorities todo-insert-item todo-add-item-non-interactively todo-add-category) "todo-mode" "calendar/todo-mode.el")

(autoload 'todo-add-category "todo-mode" "\
Add new category CAT to the TODO list." t nil)

(autoload 'todo-add-item-non-interactively "todo-mode" "\
Insert NEW-ITEM in TODO list as a new entry in CATEGORY." nil nil)

(autoload 'todo-insert-item "todo-mode" "\
Insert new TODO list entry.
With a prefix argument solicit the category, otherwise use the current
category." t nil)

(autoload 'todo-top-priorities "todo-mode" "\
List top priorities for each category.

Number of entries for each category is given by NOF-PRIORITIES which
defaults to 'todo-show-priorities'.

If CATEGORY-PR-PAGE is non-nil, a page separator '^L' is inserted
between each category." t nil)

(autoload 'todo-print "todo-mode" "\
Print todo summary using `todo-print-function'.
If CATEGORY-PR-PAGE is non-nil, a page separator `^L' is inserted
between each category.

Number of entries for each category is given by `todo-print-priorities'." t nil)

(autoload 'todo-mode "todo-mode" "\
Major mode for editing TODO lists.

\\{todo-mode-map}" t nil)

(autoload 'todo-cp "todo-mode" "\
Make a diary entry appear only in the current date's diary." nil nil)

(autoload 'todo-show "todo-mode" "\
Show TODO list." t nil)

;;;***

(put 'calendar-daylight-savings-starts 'risky-local-variable t)

(put 'calendar-daylight-savings-ends 'risky-local-variable t)

(provide 'calendar-autoloads)
