/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { format } from "date-fns";
import { Fragment, h, VNode } from "preact";
import { Part } from "../../components/Part.js";
import { Button } from "../../mui/Button.js";
import { TextField } from "../../mui/TextField.js";
import {
  getAmountWithFee,
  TransferCreationDetails,
} from "../../wallet/Transaction.js";
import { State } from "./index.js";
import { AmountField } from "../../components/AmountField.js";

export function ReadyView({
  subject,
  amount,
  expiration,
  toBeReceived,
  debitAmount,
  create,
}: State.Ready): VNode {
  const { i18n } = useTranslationContext();

  async function oneDayExpiration() {
    if (expiration.onInput) {
      expiration.onInput(
        format(new Date().getTime() + 1000 * 60 * 60 * 24, "dd/MM/yyyy"),
      );
    }
  }

  async function oneWeekExpiration() {
    if (expiration.onInput) {
      expiration.onInput(
        format(new Date().getTime() + 1000 * 60 * 60 * 24 * 7, "dd/MM/yyyy"),
      );
    }
  }
  async function _30DaysExpiration() {
    if (expiration.onInput) {
      expiration.onInput(
        format(new Date().getTime() + 1000 * 60 * 60 * 24 * 30, "dd/MM/yyyy"),
      );
    }
  }
  return (
    <Fragment>
      <section style={{ textAlign: "left" }}>
        <p>
          <AmountField 
            label={i18n.str`Amount`}
            handler={amount}
            required
          />
        </p>
        <p>
          <TextField
            label="Subject"
            variant="filled"
            helperText={i18n.str`Short description of the transfer`}
            error={subject.error}
            required
            fullWidth
            value={subject.value}
            onChange={subject.onInput}
          />
        </p>
        <p>
          <TextField
            label="Expiration"
            variant="filled"
            error={expiration.error}
            required
            fullWidth
            value={expiration.value}
            onChange={expiration.onInput}
          />
          <p>
            <Button
              variant="outlined"
              disabled={!expiration.onInput}
              onClick={oneDayExpiration}
            >
              1 day
            </Button>
            <Button
              variant="outlined"
              disabled={!expiration.onInput}
              onClick={oneWeekExpiration}
            >
              1 week
            </Button>
            <Button
              variant="outlined"
              disabled={!expiration.onInput}
              onClick={_30DaysExpiration}
            >
              30 days
            </Button>
          </p>
        </p>
        <Part
          title={i18n.str`Details`}
          text={
            <TransferCreationDetails
              amount={getAmountWithFee(debitAmount, toBeReceived, "debit")}
            />
          }
        />
      </section>
      <section>
        <Button onClick={create.onClick} variant="contained" color="success">
          <i18n.Translate>Create</i18n.Translate>
        </Button>
      </section>
    </Fragment>
  );
}
