/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import {
  BankingChoiceSpec
} from "@gnu-taler/taler-util";
import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { styled } from "@linaria/react";
import { Fragment, h, VNode } from "preact";
import { ButtonHandler } from "../mui/handlers.js";
import { Modal } from "./Modal.js";

const BanksTable = styled.table`
  width: 100%;
  border-spacing: 0px;
  & > tr > td {
    padding: 5px;
  }
  & > tr > td:nth-child(2n) {
    text-align: right;
    overflow-wrap: anywhere;
  }
  & > tr:nth-child(2n) {
    background: #ebebeb;
  }
`;

interface Props { banks: BankingChoiceSpec[], onClose: ButtonHandler };

export function ShowBanksForPaytoPopup({ banks, onClose }: Props): VNode {
  const { i18n } = useTranslationContext();

  return (
    <Modal title="Supported banks" onClose={onClose}>
      <div style={{ overflowY: "auto", height: "95%", padding: 5 }}>
        <BanksTable>
          {banks.map((b, idx) => {

            return <tr key={idx}>
              <td>
                <a href={b.uri}>{b.label}</a>
              </td>
            </tr>
          })}
        </BanksTable>
      </div>
    </Modal>
  );
}
