;; GNU Shepherd --- Test the service module.
;; Copyright © 2025 Tomas Volf <~@wolfsden.cz>
;;
;; This file is part of the GNU Shepherd.
;;
;; The GNU Shepherd is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3 of the License, or (at
;; your option) any later version.
;;
;; The GNU Shepherd is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with the GNU Shepherd.  If not, see <https://www.gnu.org/licenses/>.

(define-module (test-service)
  #:use-module (shepherd service)
  #:use-module (srfi srfi-64))


(test-begin "service")

(let* ((environment-variables '("USER=foo"
                                "HOME=/foo"
                                "USER=bar"
                                "HOME=/bar"))

       (passwd (getpwuid (getuid)))
       (user (passwd:name passwd))

       (expected (list (string-append "HOME=" (passwd:dir passwd))
                       (string-append "USER=" user))))
  (test-equal "name sets variables"
    expected
    (user-environment-variables user environment-variables))
  (test-equal "id sets variables"
    expected
    (user-environment-variables (getuid) environment-variables)))

(test-end)
