.\" Copyright (c) 2000 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution
.TH pr-edit 8 "January 2000" "GNATS @VERSION@" "GNATS Admininstration Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
pr\-edit \- creates, edits or deletes PRs
.SH SYNOPSIS
.hy 0
.na
.TP
.B pr\-edit
[\fB\-\-lock\fR\ \fIusername\fR\ |\ \fB\-l\fR\ \fIusername\fR]
[\fB\-\-unlock\fR\ |\ \fB\-u\fR]
[\fB\-\-lockdb\fR\ |\ \fB\-L\fR]
[\fB\-\-unlockdb\fR\ |\ \fB\-U\fR]
[\fB\-\-check\fR\ |\ \fB\-c\fR]
[\fB\-\-check\-initial\fR\ |\ \fB\-C\fR]
[\fB\-\-submit\fR\ |\ \fB\-s\fR]
[\fB\-\-append\fR\ \fIfield\fR\ |\ \fB\-a\fR\ \fIfield\fR]
[\fB\-\-replace\fR\ \fIfield\fR\ |\ \fB\-r\fR\ \fIfield\fR]
[\fB\-\-delete\-pr\fR]
[\fB\-\-process\fR\ \fIprocess\-id\fR\ |\ \fB\-p\fR\ \fIprocess\-id\fR]
[\fB\-\-database\fR\ \fIdatabase\fR\ |\ \fB\-d\fR\ \fIdatabase\fR]
[\fB\-\-filename\fR\ \fIfilename\fR\ |\ \fB\-f\fR\ \fIfilename\fR]
[\fB\-\-version\fR\ |\ \fB\-V\fR]
[\fB\-\-help\fR\ |\ \fB\-h\fR]
[\fB\-\-user\fR\ \fInetid\fR\ |\ \fB\-v\fR\ \fInetid\fR]
[\fB\-\-passwd\fR\ \fIpassword\fR\ |\ \fB\-w\fR\ \fIpassword\fR]
[\fB\-\-host\fR\ \fIhost\fR\ |\ \fB\-H\fR\ \fIhost\fR]
[\fB\-\-port\fR\ \fIport\fR\ |\ \fB\-P\fR\ \fIport\fR]
[\fB\-\-debug\fR\ |\ \fB\-D\fR]
[\fBPR number\fR]
.ad b
.hy 1
.SH DESCRIPTION
\fBpr\-edit\fR can be used to exit an existing \fIPR\fR by either
replacing or appending to particular fields within the \fIPR\fR, or
providing a new \fIPR\fR to replace the existing one. \fBpr\-edit\fR
can also be used to create new \fIPR\fRs from scratch, or delete
existing ones.
.P
\fBpr\-edit\fR also provides miscellaneous services for locking and
unlocking \fIPR\fRs,  locking or unlocking an entire database, or
verifying that proposed \fIPR\fR contents are valid and correct.
.SH OPTIONS
.TP 0.5i
\fB\-\-lockdb\fR,\ \fB\-L\fR
Locks the specified database.  No PRs may be edited, created or deleted
while the database is locked.
.LP
.RS 0.5i
This option is generally used when editing the index file.
.RE
.TP 0.5i
\fB\-\-unlockdb\fR,\ \fB\-U\fR
Unlocks the database.  No check is made that the invoking user actually had
locked the database in the first place; hence, it is possible for anyone
to steal a database lock.
.TP
\fB\-\-check\fR,\ \fB\-c\fR
.TP
\fB\-\-check\-initial\fR,\ \fB\-C\fR
The \fB\-\-check\fR options are used to verify that a proposed
\fIPR\fR's field contents are valid.  The \fIPR\fR is read in (either
from stdin or a file specified with \fB\-\-filename\fR), and its
fields are compared against the rules specified by the database
configuration of the selected database.  Warnings are given for
enumerated fields whose contents do not contain one of the required
values or fields that do not match required regexps.
.P
.RS 0.5i
\fB\-\-check\-initial\fR is used to verify initial \fIPR\fRs, rather
than proposed edits of existing \fIPRs\fR.
.RE
.TP 0.5i
\fB\-\-submit\fR,\ \fB\-s\fR
Used to submit a new \fIPR\fR to the database.  The \fIPR\fR is read
in and verified for content; if the \fIPR\fR is valid as an initial
\fIPR\fR, it is then added to the database.
.P
.RS 0.5i
A zero exit code is
returned if the submission was successful.  Otherwise, the reason(s)
for the \fIPR\fR being rejected are printed to stdout, and a non-zero
exit code is returned.
.RE
.P
The following options require a \fIPR number\fR to be given.
.TP 0.5i
\fB\-\-delete\-pr\fR
Deletes the specified \fIPR\fR from the database.  The \fIPR\fR must be
in a closed state, and not locked.
.LP
.RS 0.5i
Only the user \fB@GNATS_USER@\fR is permitted to delete \fIPR\fRs.
.RE
.TP 0.5i
\fB\-\-lock\fR\ \fIusername\fR,\ \fB\-l\fR\ \fIusername\fR
Locks the \fIPR\fR.  \fIusername\fR is associated with the lock, so
the system administrator can determine who actually placed the lock on
the \fIPR\fR.  However, anyone is permitted to remove locks on a
\fIPR\fR.
.P
.RS 0.5i
If the optional \fB\-\-process\-id\fR option is also given, that
\fIprocess\-id\fR is associated with the lock.
.RE
.TP 0.5i
\fB\-\-unlock\fR,\ \fB\-u\fR
Unlocks the \fIPR\fR.
.TP
\fB\-\-append\fR\ \fIfield\fR,\ \fB\-a\fR\ \fIfield\fR
.TP
\fB\-\-replace\fR\ \fIfield\fR,\ \fB\-r\fR\ \fIfield\fR
\fB\-\-append\fR and \fB\-\-replace\fR are used to append or replace
content of a specific field within a \fIPR\fR.  The new field content
is read in from stdin (or from the file specified with the
\fB\-\-filename\fR option), and either appended or replaced to the
specified field.  The field contents are verified for correctness
before the \fIPR\fR is rewritten.
.P
.RS 0.5i
If the edit is successful, a zero exit status is returned.  If the edit
failed, a non-zero exit status is returned, and the reasons for the failure
are printed to stdout.
.RE
.TP 0.5i
\fB[PR number]\fR
If only a \fIPR number\fR is specified with no other options, a
replacement \fIPR\fR is read in (either from stdin or the file
specified with \fB\-\-filename\fR).  If the \fIPR\fR contents are
valid and correct, the existing \fIPR\fR is replaced with the new
\fIPR\fR contents.
.P
.RS 0.5i
If the edit is successful, a zero exit status is returned.  If the edit
failed, a non-zero exit status is returned, and the reasons for the failure
are printed to stdout.
.RE
.TP 0.5i
\fB\-\-database\fR\ \fIdatabase\fR,\ \fB\-d\fR\ \fIdatabase\fR
Specifies the database which is to be manipulated.  If no database is
specified, the database named \fIdefault\fR is assumed.  This option
overrides the database specified in the \fBGNATSDB\fR environment
variable.
.TP 0.5i
\fB\-\-filename\fR\ \fIfilename\fR,\ \fB\-f\fR\ \fIfilename\fR
For actions that require reading in a \fIPR\fR or field content, this
specifies the name of a file to read.  If \fB\-\-filename\fR is not
specified, the \fIPR\fR or field content is read in from stdin.
.TP 0.5i
\fB\-\-version\fR,\ \fB\-V\fR
Displays the version number of the program.
.TP 0.5i
\fB\-\-help\fR,\ \fB\-h\fR
Prints a brief usage message.
.TP 0.5i
\fB\-\-host\fR\ \fIhost\fR,\ \fB\-H\fR\ \fIhost\fR
Hostname of the GNATS server.
.TP 0.5i
\fB\-\-port\fR\ \fIport\fR,\ \fB\-P\fR\ \fIport\fR
The port that the GNATS server runs on.
.TP 0.5i
\fB\-\-user\fR\ \fInetid\fR,\ \fB\-v\fR\ \fInetid\fR
Username used when logging into the GNATS server.
.TP 0.5i
\fB\-\-passwd\fR\ \fIpassword\fR,\ \fB\-w\fR\ \fIpassword\fR
Password used when logging into the GNATS server.
.TP 0.5i
\fB\-\-debug\fR,\ \fB\-D\fR
Used to debug network connections.
.SH ENVIRONMENT VARIABLES
The \fBGNATSDB\fR environment variable is used to determine which database to
use.  For a local database, it contains the name of the database to access.
.P
For network access via \fIgnatsd\fR, it contains a colon-separated list
of strings that describe the remote database, in the form
.TP
\fIserver\fR:\fIport\fR:\fIdatabasename\fR:\fIusername\fR:\fIpassword\fR
.P
Any of the fields may be omitted, but at least one colon must appear;
otherwise, the value is assumed to be the name of a local database.
.P
If \fBGNATSDB\fR is not set and the --database option is not supplied,
it is assumed that the database is local and that its name is
\fIdefault\fR.
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
and
.I Reporting Problems Using send-pr
(also installed as the GNU Info file
.BR send-pr.info ).
.LP
.BR gnats (7),
.BR send-pr (1),
.BR edit-pr (1),
.BR query-pr (1),
.BR file-pr (8),
.BR queue-pr (8),
.BR rmcat (8),
.BR gen-index (8),
.BR mkcat (8).
.SH COPYING
Copyright (c) 2000 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
