/* Test ufromfpx (pre-C23 compat version).
   Copyright (C) 1997-2026 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#include <shlib-compat.h>
#include <first-versions.h>
#include "libm-test-driver.c"

#define CONCATX(x, y) x ## y
#define CONCAT(x, y) CONCATX (x, y)
#define COMPAT_VER CONCAT (FIRST_VERSION_libm_, FUNC_TEST (ufromfpx))

#if TEST_COMPAT (libm, COMPAT_VER, GLIBC_2_43)

uintmax_t FUNC_TEST (compat_ufromfpx) (FLOAT, int, unsigned int);
compat_symbol_reference (libm,
			 FUNC_TEST (compat_ufromfpx),
			 FUNC_TEST (ufromfpx),
			 COMPAT_VER);

static const struct test_fiu_U_data compat_ufromfpx_test_data[] =
  {
    /* Infinity, NaN and values that are definitely out of range
       (large values of width count as the width of the return
       type).  */
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_infty, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_infty, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, qnan_value, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -qnan_value, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, snan_value, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -snan_value, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, max_value, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -max_value, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1p64, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p64, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (fromfpx, -0x1.000002p63, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#if MANT_DIG >= 53
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p63, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
#if MANT_DIG >= 64
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x8000000000000001p0, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif

    /* Zero (OK unless the width specified is zero).  */
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_UPWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_UPWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_UPWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, plus_zero, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_UPWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_UPWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_UPWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, minus_zero, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    /* For unsigned results, -1 and below are always invalid.  */
    TEST_fiu_U (ufromfpx, -1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -1.1, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -2.5, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -123.456, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_TOWARDZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_TOWARDZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1p32, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),

    /* Tests below here are generated with gen-fromfp-tests.py.  */

    /* Integer inputs within range of uintmax_t.  */
    TEST_fiu_U (ufromfpx, 1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_DOWNWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_DOWNWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_DOWNWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_DOWNWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TOWARDZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TOWARDZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TOWARDZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TOWARDZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TOWARDZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TONEARESTFROMZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TONEAREST, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_UPWARD, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_UPWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_UPWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_UPWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_DOWNWARD, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_DOWNWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_DOWNWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_DOWNWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TOWARDZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TOWARDZERO, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TOWARDZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TOWARDZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TOWARDZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TONEARESTFROMZERO, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TONEARESTFROMZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TONEARESTFROMZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TONEAREST, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TONEAREST, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TONEAREST, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5, FP_INT_TONEAREST, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_UPWARD, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_UPWARD, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_UPWARD, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_UPWARD, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_DOWNWARD, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_DOWNWARD, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_DOWNWARD, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_DOWNWARD, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TOWARDZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TOWARDZERO, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TOWARDZERO, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TOWARDZERO, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TOWARDZERO, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TONEARESTFROMZERO, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TONEARESTFROMZERO, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TONEARESTFROMZERO, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TONEARESTFROMZERO, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TONEAREST, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TONEAREST, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TONEAREST, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 6, FP_INT_TONEAREST, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_UPWARD, 3, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_UPWARD, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_UPWARD, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_UPWARD, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_DOWNWARD, 3, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_DOWNWARD, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_DOWNWARD, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_DOWNWARD, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TOWARDZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TOWARDZERO, 3, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TOWARDZERO, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TOWARDZERO, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TOWARDZERO, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TONEARESTFROMZERO, 3, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TONEARESTFROMZERO, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TONEARESTFROMZERO, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TONEARESTFROMZERO, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TONEAREST, 3, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TONEAREST, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TONEAREST, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 7, FP_INT_TONEAREST, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_UPWARD, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_UPWARD, 4, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_UPWARD, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_UPWARD, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_UPWARD, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_DOWNWARD, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_DOWNWARD, 4, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_DOWNWARD, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_DOWNWARD, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_DOWNWARD, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TOWARDZERO, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TOWARDZERO, 4, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TOWARDZERO, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TOWARDZERO, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TOWARDZERO, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TONEARESTFROMZERO, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TONEARESTFROMZERO, 4, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TONEARESTFROMZERO, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TONEARESTFROMZERO, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TONEARESTFROMZERO, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TONEAREST, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TONEAREST, 4, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TONEAREST, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TONEAREST, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 8, FP_INT_TONEAREST, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_UPWARD, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_UPWARD, 4, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_UPWARD, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_UPWARD, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_UPWARD, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_DOWNWARD, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_DOWNWARD, 4, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_DOWNWARD, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_DOWNWARD, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_DOWNWARD, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TOWARDZERO, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TOWARDZERO, 4, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TOWARDZERO, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TOWARDZERO, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TOWARDZERO, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TONEARESTFROMZERO, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TONEARESTFROMZERO, 4, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TONEARESTFROMZERO, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TONEARESTFROMZERO, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TONEARESTFROMZERO, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TONEAREST, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TONEAREST, 4, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TONEAREST, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TONEAREST, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 9, FP_INT_TONEAREST, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_UPWARD, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_UPWARD, 4, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_UPWARD, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_UPWARD, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_UPWARD, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_DOWNWARD, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_DOWNWARD, 4, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_DOWNWARD, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_DOWNWARD, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_DOWNWARD, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TOWARDZERO, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TOWARDZERO, 4, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TOWARDZERO, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TOWARDZERO, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TOWARDZERO, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TONEARESTFROMZERO, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TONEARESTFROMZERO, 4, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TONEARESTFROMZERO, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TONEARESTFROMZERO, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TONEARESTFROMZERO, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TONEAREST, 3, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TONEAREST, 4, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TONEAREST, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TONEAREST, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 15, FP_INT_TONEAREST, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_UPWARD, 4, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_UPWARD, 5, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_UPWARD, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_UPWARD, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_UPWARD, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_DOWNWARD, 4, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_DOWNWARD, 5, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_DOWNWARD, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_DOWNWARD, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_DOWNWARD, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TOWARDZERO, 4, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TOWARDZERO, 5, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TOWARDZERO, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TOWARDZERO, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TOWARDZERO, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TONEARESTFROMZERO, 4, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TONEARESTFROMZERO, 5, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TONEARESTFROMZERO, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TONEARESTFROMZERO, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TONEARESTFROMZERO, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TONEAREST, 4, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TONEAREST, 5, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TONEAREST, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TONEAREST, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 16, FP_INT_TONEAREST, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_UPWARD, 4, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_UPWARD, 5, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_UPWARD, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_UPWARD, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_UPWARD, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_DOWNWARD, 4, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_DOWNWARD, 5, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_DOWNWARD, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_DOWNWARD, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_DOWNWARD, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TOWARDZERO, 4, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TOWARDZERO, 5, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TOWARDZERO, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TOWARDZERO, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TOWARDZERO, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TONEARESTFROMZERO, 4, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TONEARESTFROMZERO, 5, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TONEARESTFROMZERO, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TONEARESTFROMZERO, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TONEARESTFROMZERO, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TONEAREST, 4, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TONEAREST, 5, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TONEAREST, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TONEAREST, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 17, FP_INT_TONEAREST, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_UPWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_UPWARD, 22, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_UPWARD, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_UPWARD, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_UPWARD, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_DOWNWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_DOWNWARD, 22, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_DOWNWARD, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_DOWNWARD, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_DOWNWARD, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TOWARDZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TOWARDZERO, 22, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TOWARDZERO, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TOWARDZERO, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TOWARDZERO, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TONEARESTFROMZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TONEARESTFROMZERO, 22, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TONEARESTFROMZERO, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TONEARESTFROMZERO, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TONEAREST, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TONEAREST, 22, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TONEAREST, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TONEAREST, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff, FP_INT_TONEAREST, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_UPWARD, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_UPWARD, 23, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_UPWARD, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_UPWARD, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_UPWARD, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_DOWNWARD, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_DOWNWARD, 23, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_DOWNWARD, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_DOWNWARD, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_DOWNWARD, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TOWARDZERO, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TOWARDZERO, 23, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TOWARDZERO, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TOWARDZERO, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TOWARDZERO, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TONEARESTFROMZERO, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TONEARESTFROMZERO, 23, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TONEARESTFROMZERO, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TONEARESTFROMZERO, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TONEAREST, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TONEAREST, 23, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TONEAREST, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TONEAREST, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400000, FP_INT_TONEAREST, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_UPWARD, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_UPWARD, 23, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_UPWARD, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_UPWARD, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_UPWARD, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_DOWNWARD, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_DOWNWARD, 23, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_DOWNWARD, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_DOWNWARD, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_DOWNWARD, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TOWARDZERO, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TOWARDZERO, 23, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TOWARDZERO, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TOWARDZERO, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TOWARDZERO, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TONEARESTFROMZERO, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TONEARESTFROMZERO, 23, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TONEARESTFROMZERO, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TONEARESTFROMZERO, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TONEAREST, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TONEAREST, 23, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TONEAREST, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TONEAREST, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x400001, FP_INT_TONEAREST, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_UPWARD, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_UPWARD, 23, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_UPWARD, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_UPWARD, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_UPWARD, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_DOWNWARD, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_DOWNWARD, 23, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_DOWNWARD, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_DOWNWARD, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_DOWNWARD, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TOWARDZERO, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TOWARDZERO, 23, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TOWARDZERO, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TOWARDZERO, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TONEARESTFROMZERO, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TONEARESTFROMZERO, 23, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TONEARESTFROMZERO, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TONEARESTFROMZERO, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TONEAREST, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TONEAREST, 23, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TONEAREST, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TONEAREST, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff, FP_INT_TONEAREST, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_UPWARD, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_UPWARD, 24, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_UPWARD, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_UPWARD, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_UPWARD, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_DOWNWARD, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_DOWNWARD, 24, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_DOWNWARD, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_DOWNWARD, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_DOWNWARD, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TOWARDZERO, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TOWARDZERO, 24, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TOWARDZERO, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TOWARDZERO, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TOWARDZERO, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TONEARESTFROMZERO, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TONEARESTFROMZERO, 24, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TONEARESTFROMZERO, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TONEARESTFROMZERO, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TONEAREST, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TONEAREST, 24, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TONEAREST, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TONEAREST, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800000, FP_INT_TONEAREST, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_UPWARD, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_UPWARD, 24, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_UPWARD, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_UPWARD, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_UPWARD, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_DOWNWARD, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_DOWNWARD, 24, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_DOWNWARD, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_DOWNWARD, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_DOWNWARD, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TOWARDZERO, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TOWARDZERO, 24, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TOWARDZERO, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TOWARDZERO, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TOWARDZERO, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TONEARESTFROMZERO, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TONEARESTFROMZERO, 24, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TONEARESTFROMZERO, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TONEARESTFROMZERO, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TONEAREST, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TONEAREST, 24, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TONEAREST, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TONEAREST, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x800001, FP_INT_TONEAREST, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_UPWARD, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_UPWARD, 24, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_UPWARD, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_UPWARD, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_UPWARD, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_DOWNWARD, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_DOWNWARD, 24, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_DOWNWARD, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_DOWNWARD, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_DOWNWARD, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TOWARDZERO, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TOWARDZERO, 24, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TOWARDZERO, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TOWARDZERO, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TOWARDZERO, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TONEARESTFROMZERO, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TONEARESTFROMZERO, 24, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TONEARESTFROMZERO, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TONEARESTFROMZERO, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TONEAREST, 23, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TONEAREST, 24, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TONEAREST, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TONEAREST, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff, FP_INT_TONEAREST, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_UPWARD, 24, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_UPWARD, 25, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_UPWARD, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_UPWARD, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_UPWARD, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_DOWNWARD, 24, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_DOWNWARD, 25, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_DOWNWARD, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_DOWNWARD, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_DOWNWARD, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TOWARDZERO, 24, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TOWARDZERO, 25, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TOWARDZERO, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TOWARDZERO, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TOWARDZERO, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TONEARESTFROMZERO, 24, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TONEARESTFROMZERO, 25, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TONEARESTFROMZERO, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TONEARESTFROMZERO, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TONEAREST, 24, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TONEAREST, 25, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TONEAREST, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TONEAREST, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000000, FP_INT_TONEAREST, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_UPWARD, 24, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_UPWARD, 25, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_UPWARD, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_UPWARD, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_UPWARD, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_DOWNWARD, 24, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_DOWNWARD, 25, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_DOWNWARD, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_DOWNWARD, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_DOWNWARD, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TOWARDZERO, 24, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TOWARDZERO, 25, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TOWARDZERO, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TOWARDZERO, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TOWARDZERO, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TONEARESTFROMZERO, 24, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TONEARESTFROMZERO, 25, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TONEARESTFROMZERO, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TONEARESTFROMZERO, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TONEAREST, 24, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TONEAREST, 25, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TONEAREST, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TONEAREST, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1000001, FP_INT_TONEAREST, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_UPWARD, 50, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_UPWARD, 51, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_UPWARD, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_UPWARD, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 50, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 51, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 50, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 51, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 50, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 51, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TONEAREST, 50, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TONEAREST, 51, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TONEAREST, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TONEAREST, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_UPWARD, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_UPWARD, 52, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_UPWARD, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_UPWARD, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_UPWARD, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_DOWNWARD, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_DOWNWARD, 52, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_DOWNWARD, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_DOWNWARD, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TOWARDZERO, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TOWARDZERO, 52, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TOWARDZERO, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TOWARDZERO, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 52, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TONEAREST, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TONEAREST, 52, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TONEAREST, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TONEAREST, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_UPWARD, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_UPWARD, 52, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_UPWARD, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_UPWARD, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_UPWARD, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_DOWNWARD, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_DOWNWARD, 52, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_DOWNWARD, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_DOWNWARD, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TOWARDZERO, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TOWARDZERO, 52, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TOWARDZERO, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TOWARDZERO, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 52, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TONEAREST, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TONEAREST, 52, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TONEAREST, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TONEAREST, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000001LL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_UPWARD, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_UPWARD, 52, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_UPWARD, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_UPWARD, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_DOWNWARD, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_DOWNWARD, 52, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_DOWNWARD, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_DOWNWARD, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 52, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 52, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TONEAREST, 51, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TONEAREST, 52, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TONEAREST, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TONEAREST, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_UPWARD, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_UPWARD, 53, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_UPWARD, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_UPWARD, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_UPWARD, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_DOWNWARD, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_DOWNWARD, 53, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_DOWNWARD, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_DOWNWARD, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TOWARDZERO, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TOWARDZERO, 53, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TOWARDZERO, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TOWARDZERO, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 53, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TONEAREST, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TONEAREST, 53, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TONEAREST, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TONEAREST, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_UPWARD, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_UPWARD, 53, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_UPWARD, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_UPWARD, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_UPWARD, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_DOWNWARD, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_DOWNWARD, 53, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_DOWNWARD, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_DOWNWARD, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_DOWNWARD, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TOWARDZERO, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TOWARDZERO, 53, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TOWARDZERO, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TOWARDZERO, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 53, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TONEAREST, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TONEAREST, 53, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TONEAREST, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TONEAREST, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x10000000000001LL, FP_INT_TONEAREST, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_UPWARD, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_UPWARD, 53, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_UPWARD, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_UPWARD, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 53, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 53, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 53, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TONEAREST, 52, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TONEAREST, 53, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TONEAREST, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TONEAREST, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_UPWARD, 53, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_UPWARD, 54, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_UPWARD, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_UPWARD, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_UPWARD, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_DOWNWARD, 53, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_DOWNWARD, 54, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_DOWNWARD, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_DOWNWARD, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TOWARDZERO, 53, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TOWARDZERO, 54, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TOWARDZERO, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TOWARDZERO, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 53, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 54, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TONEAREST, 53, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TONEAREST, 54, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TONEAREST, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TONEAREST, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 64
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_UPWARD, 53, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_UPWARD, 54, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_UPWARD, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_UPWARD, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_UPWARD, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_DOWNWARD, 53, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_DOWNWARD, 54, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_DOWNWARD, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_DOWNWARD, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_DOWNWARD, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TOWARDZERO, 53, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TOWARDZERO, 54, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TOWARDZERO, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TOWARDZERO, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 53, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 54, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TONEAREST, 53, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TONEAREST, 54, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TONEAREST, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TONEAREST, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x20000000000001LL, FP_INT_TONEAREST, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_UPWARD, 61, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_UPWARD, 62, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_UPWARD, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_UPWARD, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 61, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 62, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 61, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 62, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 61, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 62, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 61, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 62, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_UPWARD, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_UPWARD, 63, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_UPWARD, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_UPWARD, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_DOWNWARD, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_DOWNWARD, 63, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_DOWNWARD, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TOWARDZERO, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TOWARDZERO, 63, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TOWARDZERO, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 63, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TONEAREST, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TONEAREST, 63, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TONEAREST, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 64
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_UPWARD, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_UPWARD, 63, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_UPWARD, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_UPWARD, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_DOWNWARD, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_DOWNWARD, 63, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_DOWNWARD, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_DOWNWARD, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TOWARDZERO, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TOWARDZERO, 63, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TOWARDZERO, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 63, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TONEAREST, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TONEAREST, 63, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TONEAREST, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4000000000000001LL, FP_INT_TONEAREST, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_UPWARD, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_UPWARD, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_UPWARD, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_UPWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_UPWARD, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_UPWARD, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_DOWNWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_DOWNWARD, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TOWARDZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TOWARDZERO, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TONEAREST, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TONEAREST, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000000ULL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 64
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_UPWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_UPWARD, 64, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_UPWARD, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_DOWNWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_DOWNWARD, 64, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TOWARDZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TOWARDZERO, 64, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TONEAREST, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TONEAREST, 64, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000001ULL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_UPWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_UPWARD, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_UPWARD, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_DOWNWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_DOWNWARD, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_DOWNWARD, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TONEAREST, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TONEAREST, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffffULL, FP_INT_TONEAREST, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_UPWARD, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_UPWARD, 63, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_UPWARD, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_UPWARD, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 63, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 63, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 63, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TONEAREST, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TONEAREST, 63, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TONEAREST, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffff8000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_UPWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_UPWARD, 64, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_UPWARD, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_DOWNWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_DOWNWARD, 64, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_DOWNWARD, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TOWARDZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TOWARDZERO, 64, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, 64, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TONEAREST, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TONEAREST, 64, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000010000000000ULL, FP_INT_TONEAREST, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_UPWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_UPWARD, 64, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_UPWARD, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_DOWNWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_DOWNWARD, 64, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_DOWNWARD, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, 64, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, 64, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TONEAREST, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TONEAREST, 64, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffff0000000000ULL, FP_INT_TONEAREST, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 63, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_UPWARD, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 63, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 63, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 63, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 63, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_UPWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_UPWARD, 64, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_UPWARD, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_DOWNWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_DOWNWARD, 64, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TOWARDZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TOWARDZERO, 64, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TONEAREST, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TONEAREST, 64, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x8000000000000800ULL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_UPWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_UPWARD, 64, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_UPWARD, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, 64, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, 64, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, 64, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TONEAREST, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TONEAREST, 64, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffffffffffff800ULL, FP_INT_TONEAREST, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif

    /* Inputs with absolute value between 0 and 1.  */
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_subnorm_value, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_subnorm_value, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, min_value, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -min_value, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.1, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.1, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.25, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.25, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.499, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.499, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp-1, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp-1, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.5, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TONEAREST, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TONEAREST, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TONEAREST, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.5, FP_INT_TONEAREST, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p-1, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000002p-1, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#if MANT_DIG >= 53
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p-1, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000001p-1, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
#if MANT_DIG >= 64
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
#if MANT_DIG >= 106
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
#if MANT_DIG >= 113
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.501, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.501, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.75, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.75, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0.9, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0.9, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp0, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffp0, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#if MANT_DIG >= 53
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
#if MANT_DIG >= 64
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
#if MANT_DIG >= 106
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
#if MANT_DIG >= 113
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 1, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 2, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 64, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif

    /* Various non-integer inputs.  */
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.25, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.5, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 1.75, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.25, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.5, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 2.75, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.25, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TONEARESTFROMZERO, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TONEARESTFROMZERO, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TONEARESTFROMZERO, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TONEAREST, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TONEAREST, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TONEAREST, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.5, FP_INT_TONEAREST, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TONEARESTFROMZERO, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TONEARESTFROMZERO, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TONEARESTFROMZERO, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TONEAREST, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TONEAREST, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TONEAREST, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 3.75, FP_INT_TONEAREST, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_UPWARD, 3, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_UPWARD, 4, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_UPWARD, 64, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_UPWARD, UINT_MAX, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_DOWNWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_DOWNWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_DOWNWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_DOWNWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TOWARDZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TOWARDZERO, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TOWARDZERO, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TOWARDZERO, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TOWARDZERO, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TONEARESTFROMZERO, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TONEARESTFROMZERO, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TONEARESTFROMZERO, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TONEAREST, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TONEAREST, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TONEAREST, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.25, FP_INT_TONEAREST, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_UPWARD, 3, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_UPWARD, 4, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_UPWARD, 64, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_UPWARD, UINT_MAX, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_DOWNWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_DOWNWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_DOWNWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_DOWNWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TOWARDZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TOWARDZERO, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TOWARDZERO, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TOWARDZERO, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TOWARDZERO, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TONEARESTFROMZERO, 3, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TONEARESTFROMZERO, 4, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TONEARESTFROMZERO, 64, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TONEAREST, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TONEAREST, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TONEAREST, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.5, FP_INT_TONEAREST, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_UPWARD, 3, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_UPWARD, 4, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_UPWARD, 64, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_UPWARD, UINT_MAX, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_DOWNWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_DOWNWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_DOWNWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_DOWNWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TOWARDZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TOWARDZERO, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TOWARDZERO, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TOWARDZERO, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TOWARDZERO, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TONEARESTFROMZERO, 3, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TONEARESTFROMZERO, 4, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TONEARESTFROMZERO, 64, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TONEAREST, 3, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TONEAREST, 4, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TONEAREST, 64, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 4.75, FP_INT_TONEAREST, UINT_MAX, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_UPWARD, 3, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_UPWARD, 4, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_UPWARD, 64, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_UPWARD, UINT_MAX, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_DOWNWARD, 3, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_DOWNWARD, 4, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_DOWNWARD, 64, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_DOWNWARD, UINT_MAX, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TOWARDZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TOWARDZERO, 3, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TOWARDZERO, 4, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TOWARDZERO, 64, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TOWARDZERO, UINT_MAX, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TONEARESTFROMZERO, 3, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TONEARESTFROMZERO, 4, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TONEARESTFROMZERO, 64, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TONEAREST, 3, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TONEAREST, 4, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TONEAREST, 64, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.25, FP_INT_TONEAREST, UINT_MAX, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_UPWARD, 3, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_UPWARD, 4, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_UPWARD, 64, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_UPWARD, UINT_MAX, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_DOWNWARD, 3, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_DOWNWARD, 4, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_DOWNWARD, 64, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_DOWNWARD, UINT_MAX, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TOWARDZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TOWARDZERO, 3, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TOWARDZERO, 4, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TOWARDZERO, 64, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TOWARDZERO, UINT_MAX, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TONEARESTFROMZERO, 3, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TONEARESTFROMZERO, 4, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TONEARESTFROMZERO, 64, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TONEAREST, 3, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TONEAREST, 4, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TONEAREST, 64, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.5, FP_INT_TONEAREST, UINT_MAX, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_UPWARD, 3, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_UPWARD, 4, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_UPWARD, 64, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_UPWARD, UINT_MAX, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_DOWNWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_DOWNWARD, 3, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_DOWNWARD, 4, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_DOWNWARD, 64, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_DOWNWARD, UINT_MAX, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TOWARDZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TOWARDZERO, 3, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TOWARDZERO, 4, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TOWARDZERO, 64, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TOWARDZERO, UINT_MAX, 5, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TONEARESTFROMZERO, 3, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TONEARESTFROMZERO, 4, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TONEARESTFROMZERO, 64, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TONEAREST, 3, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TONEAREST, 4, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TONEAREST, 64, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 5.75, FP_INT_TONEAREST, UINT_MAX, 6, INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    /* 1, 1.5, 2, 2.5, 3, 3.5 +/- 1ulp.  */
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p0, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp-1, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p-1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffp1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000002p1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffff8p-1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.000008p-1, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffcp0, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.000004p0, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffff8p-1, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TONEAREST, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TONEAREST, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TONEAREST, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.000008p-1, FP_INT_TONEAREST, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p0, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000001p1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000004p-1, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffep0, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000002p0, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TONEAREST, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TONEAREST, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TONEAREST, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000004p-1, FP_INT_TONEAREST, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p0, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p-1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000002p1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000008p-1, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000004p0, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000008p-1, FP_INT_TONEAREST, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 1, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 2, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 64, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, UINT_MAX, 1, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x5.0000000000000000000000000004p-1, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_UPWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_UPWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_UPWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_UPWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_DOWNWARD, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_DOWNWARD, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_DOWNWARD, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_DOWNWARD, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TOWARDZERO, 2, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TOWARDZERO, 3, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TOWARDZERO, 64, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 2, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3.0000000000000000000000000002p0, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_UPWARD, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_UPWARD, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_UPWARD, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_UPWARD, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_UPWARD, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 2, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 3, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 64, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TONEAREST, 2, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TONEAREST, 3, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TONEAREST, 4, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TONEAREST, 64, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7.0000000000000000000000000004p-1, FP_INT_TONEAREST, UINT_MAX, 4, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif

    /* 31, 32, 33 fractional bits.  */
#if MANT_DIG >= 53
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_UPWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_UPWARD, 22, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_UPWARD, 23, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_UPWARD, 64, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_UPWARD, UINT_MAX, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_DOWNWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_DOWNWARD, 22, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_DOWNWARD, 23, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_DOWNWARD, 64, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_DOWNWARD, UINT_MAX, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TOWARDZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TOWARDZERO, 22, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TOWARDZERO, 23, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TOWARDZERO, 64, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 22, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 23, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 64, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TONEAREST, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TONEAREST, 22, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TONEAREST, 23, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TONEAREST, 64, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.7ffffffep0, FP_INT_TONEAREST, UINT_MAX, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_UPWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_UPWARD, 22, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_UPWARD, 23, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_UPWARD, 64, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_UPWARD, UINT_MAX, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_DOWNWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_DOWNWARD, 22, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_DOWNWARD, 23, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_DOWNWARD, 64, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TOWARDZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TOWARDZERO, 22, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TOWARDZERO, 23, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TOWARDZERO, 64, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TONEARESTFROMZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TONEARESTFROMZERO, 22, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TONEARESTFROMZERO, 23, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TONEAREST, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TONEAREST, 22, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TONEAREST, 23, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TONEAREST, 64, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.8p0, FP_INT_TONEAREST, UINT_MAX, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_UPWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_UPWARD, 22, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_UPWARD, 23, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_UPWARD, 64, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_UPWARD, UINT_MAX, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_DOWNWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_DOWNWARD, 22, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_DOWNWARD, 23, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_DOWNWARD, 64, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_DOWNWARD, UINT_MAX, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TOWARDZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TOWARDZERO, 22, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TOWARDZERO, 23, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TOWARDZERO, 64, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TOWARDZERO, UINT_MAX, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TONEARESTFROMZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TONEARESTFROMZERO, 22, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TONEARESTFROMZERO, 23, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TONEARESTFROMZERO, 64, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TONEAREST, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TONEAREST, 22, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TONEAREST, 23, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TONEAREST, 64, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200000.80000002p0, FP_INT_TONEAREST, UINT_MAX, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_UPWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_UPWARD, 22, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_UPWARD, 23, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_UPWARD, 64, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_UPWARD, UINT_MAX, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_DOWNWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_DOWNWARD, 22, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_DOWNWARD, 23, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_DOWNWARD, 64, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_DOWNWARD, UINT_MAX, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TOWARDZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TOWARDZERO, 22, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TOWARDZERO, 23, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TOWARDZERO, 64, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 22, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 23, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 64, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TONEAREST, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TONEAREST, 22, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TONEAREST, 23, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TONEAREST, 64, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.7ffffffep0, FP_INT_TONEAREST, UINT_MAX, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_UPWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_UPWARD, 22, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_UPWARD, 23, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_UPWARD, 64, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_UPWARD, UINT_MAX, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_DOWNWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_DOWNWARD, 22, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_DOWNWARD, 23, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_DOWNWARD, 64, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TOWARDZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TOWARDZERO, 22, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TOWARDZERO, 23, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TOWARDZERO, 64, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TONEARESTFROMZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TONEARESTFROMZERO, 22, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TONEARESTFROMZERO, 23, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TONEAREST, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TONEAREST, 22, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TONEAREST, 23, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TONEAREST, 64, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.8p0, FP_INT_TONEAREST, UINT_MAX, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_UPWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_UPWARD, 22, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_UPWARD, 23, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_UPWARD, 64, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_UPWARD, UINT_MAX, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_DOWNWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_DOWNWARD, 22, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_DOWNWARD, 23, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_DOWNWARD, 64, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_DOWNWARD, UINT_MAX, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TOWARDZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TOWARDZERO, 22, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TOWARDZERO, 23, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TOWARDZERO, 64, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TOWARDZERO, UINT_MAX, 0x200001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TONEARESTFROMZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TONEARESTFROMZERO, 22, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TONEARESTFROMZERO, 23, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TONEARESTFROMZERO, 64, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TONEAREST, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TONEAREST, 22, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TONEAREST, 23, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TONEAREST, 64, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x200001.80000002p0, FP_INT_TONEAREST, UINT_MAX, 0x200002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_UPWARD, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_UPWARD, 23, 0x400000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_UPWARD, 24, 0x400000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_UPWARD, 64, 0x400000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_UPWARD, UINT_MAX, 0x400000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_DOWNWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_DOWNWARD, 22, 0x3fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_DOWNWARD, 23, 0x3fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_DOWNWARD, 64, 0x3fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_DOWNWARD, UINT_MAX, 0x3fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TOWARDZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TOWARDZERO, 22, 0x3fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TOWARDZERO, 23, 0x3fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TOWARDZERO, 64, 0x3fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 0x3fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 23, 0x400000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 24, 0x400000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 64, 0x400000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x400000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TONEAREST, 22, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TONEAREST, 23, 0x400000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TONEAREST, 24, 0x400000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TONEAREST, 64, 0x400000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x3fffff.fffffffep0, FP_INT_TONEAREST, UINT_MAX, 0x400000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_UPWARD, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_UPWARD, 21, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_UPWARD, 22, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_UPWARD, 64, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_UPWARD, UINT_MAX, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_DOWNWARD, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_DOWNWARD, 21, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_DOWNWARD, 22, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_DOWNWARD, 64, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TOWARDZERO, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TOWARDZERO, 21, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TOWARDZERO, 22, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TOWARDZERO, 64, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 21, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 22, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 64, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TONEAREST, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TONEAREST, 21, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TONEAREST, 22, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TONEAREST, 64, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.7fffffffp0, FP_INT_TONEAREST, UINT_MAX, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_UPWARD, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_UPWARD, 21, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_UPWARD, 22, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_UPWARD, 64, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_UPWARD, UINT_MAX, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_DOWNWARD, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_DOWNWARD, 21, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_DOWNWARD, 22, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_DOWNWARD, 64, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TOWARDZERO, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TOWARDZERO, 21, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TOWARDZERO, 22, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TOWARDZERO, 64, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TONEARESTFROMZERO, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TONEARESTFROMZERO, 21, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TONEARESTFROMZERO, 22, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TONEAREST, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TONEAREST, 21, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TONEAREST, 22, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TONEAREST, 64, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.8p0, FP_INT_TONEAREST, UINT_MAX, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_UPWARD, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_UPWARD, 21, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_UPWARD, 22, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_UPWARD, 64, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_UPWARD, UINT_MAX, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_DOWNWARD, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_DOWNWARD, 21, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_DOWNWARD, 22, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_DOWNWARD, 64, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_DOWNWARD, UINT_MAX, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TOWARDZERO, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TOWARDZERO, 21, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TOWARDZERO, 22, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TOWARDZERO, 64, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TONEARESTFROMZERO, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TONEARESTFROMZERO, 21, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TONEARESTFROMZERO, 22, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TONEARESTFROMZERO, 64, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TONEAREST, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TONEAREST, 21, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TONEAREST, 22, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TONEAREST, 64, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000.80000001p0, FP_INT_TONEAREST, UINT_MAX, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_UPWARD, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_UPWARD, 21, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_UPWARD, 22, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_UPWARD, 64, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_UPWARD, UINT_MAX, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_DOWNWARD, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_DOWNWARD, 21, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_DOWNWARD, 22, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_DOWNWARD, 64, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TOWARDZERO, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TOWARDZERO, 21, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TOWARDZERO, 22, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TOWARDZERO, 64, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 21, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 22, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 64, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TONEAREST, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TONEAREST, 21, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TONEAREST, 22, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TONEAREST, 64, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.7fffffffp0, FP_INT_TONEAREST, UINT_MAX, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_UPWARD, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_UPWARD, 21, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_UPWARD, 22, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_UPWARD, 64, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_UPWARD, UINT_MAX, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_DOWNWARD, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_DOWNWARD, 21, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_DOWNWARD, 22, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_DOWNWARD, 64, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TOWARDZERO, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TOWARDZERO, 21, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TOWARDZERO, 22, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TOWARDZERO, 64, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TONEARESTFROMZERO, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TONEARESTFROMZERO, 21, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TONEARESTFROMZERO, 22, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TONEAREST, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TONEAREST, 21, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TONEAREST, 22, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TONEAREST, 64, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.8p0, FP_INT_TONEAREST, UINT_MAX, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_UPWARD, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_UPWARD, 21, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_UPWARD, 22, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_UPWARD, 64, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_UPWARD, UINT_MAX, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_DOWNWARD, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_DOWNWARD, 21, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_DOWNWARD, 22, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_DOWNWARD, 64, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_DOWNWARD, UINT_MAX, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TOWARDZERO, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TOWARDZERO, 21, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TOWARDZERO, 22, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TOWARDZERO, 64, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TONEARESTFROMZERO, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TONEARESTFROMZERO, 21, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TONEARESTFROMZERO, 22, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TONEARESTFROMZERO, 64, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TONEAREST, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TONEAREST, 21, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TONEAREST, 22, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TONEAREST, 64, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100001.80000001p0, FP_INT_TONEAREST, UINT_MAX, 0x100002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_UPWARD, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_UPWARD, 22, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_UPWARD, 23, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_UPWARD, 64, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_UPWARD, UINT_MAX, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_DOWNWARD, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_DOWNWARD, 21, 0x1fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_DOWNWARD, 22, 0x1fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_DOWNWARD, 64, 0x1fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0x1fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TOWARDZERO, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TOWARDZERO, 21, 0x1fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TOWARDZERO, 22, 0x1fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TOWARDZERO, 64, 0x1fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0x1fffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 22, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 23, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 64, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TONEAREST, 21, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TONEAREST, 22, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TONEAREST, 23, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TONEAREST, 64, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1fffff.ffffffffp0, FP_INT_TONEAREST, UINT_MAX, 0x200000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_UPWARD, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_UPWARD, 20, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_UPWARD, 21, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_UPWARD, 64, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_UPWARD, UINT_MAX, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_DOWNWARD, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_DOWNWARD, 20, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_DOWNWARD, 21, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_DOWNWARD, 64, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TOWARDZERO, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TOWARDZERO, 20, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TOWARDZERO, 21, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TOWARDZERO, 64, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 20, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 21, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TONEAREST, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TONEAREST, 20, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TONEAREST, 21, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TONEAREST, 64, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.7fffffff8p0, FP_INT_TONEAREST, UINT_MAX, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_UPWARD, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_UPWARD, 20, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_UPWARD, 21, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_UPWARD, 64, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_UPWARD, UINT_MAX, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_DOWNWARD, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_DOWNWARD, 20, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_DOWNWARD, 21, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_DOWNWARD, 64, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TOWARDZERO, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TOWARDZERO, 20, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TOWARDZERO, 21, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TOWARDZERO, 64, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TONEARESTFROMZERO, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TONEARESTFROMZERO, 20, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TONEARESTFROMZERO, 21, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TONEAREST, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TONEAREST, 20, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TONEAREST, 21, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TONEAREST, 64, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.8p0, FP_INT_TONEAREST, UINT_MAX, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_UPWARD, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_UPWARD, 20, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_UPWARD, 21, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_UPWARD, 64, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_UPWARD, UINT_MAX, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_DOWNWARD, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_DOWNWARD, 20, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_DOWNWARD, 21, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_DOWNWARD, 64, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_DOWNWARD, UINT_MAX, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TOWARDZERO, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TOWARDZERO, 20, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TOWARDZERO, 21, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TOWARDZERO, 64, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TONEARESTFROMZERO, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TONEARESTFROMZERO, 20, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TONEARESTFROMZERO, 21, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TONEARESTFROMZERO, 64, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TONEAREST, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TONEAREST, 20, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TONEAREST, 21, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TONEAREST, 64, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000.800000008p0, FP_INT_TONEAREST, UINT_MAX, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_UPWARD, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_UPWARD, 20, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_UPWARD, 21, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_UPWARD, 64, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_UPWARD, UINT_MAX, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_DOWNWARD, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_DOWNWARD, 20, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_DOWNWARD, 21, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_DOWNWARD, 64, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TOWARDZERO, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TOWARDZERO, 20, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TOWARDZERO, 21, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TOWARDZERO, 64, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 20, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 21, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TONEAREST, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TONEAREST, 20, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TONEAREST, 21, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TONEAREST, 64, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.7fffffff8p0, FP_INT_TONEAREST, UINT_MAX, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_UPWARD, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_UPWARD, 20, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_UPWARD, 21, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_UPWARD, 64, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_UPWARD, UINT_MAX, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_DOWNWARD, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_DOWNWARD, 20, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_DOWNWARD, 21, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_DOWNWARD, 64, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TOWARDZERO, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TOWARDZERO, 20, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TOWARDZERO, 21, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TOWARDZERO, 64, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TONEARESTFROMZERO, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TONEARESTFROMZERO, 20, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TONEARESTFROMZERO, 21, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TONEAREST, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TONEAREST, 20, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TONEAREST, 21, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TONEAREST, 64, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.8p0, FP_INT_TONEAREST, UINT_MAX, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_UPWARD, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_UPWARD, 20, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_UPWARD, 21, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_UPWARD, 64, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_UPWARD, UINT_MAX, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_DOWNWARD, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_DOWNWARD, 20, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_DOWNWARD, 21, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_DOWNWARD, 64, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_DOWNWARD, UINT_MAX, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TOWARDZERO, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TOWARDZERO, 20, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TOWARDZERO, 21, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TOWARDZERO, 64, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80001, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TONEARESTFROMZERO, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TONEARESTFROMZERO, 20, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TONEARESTFROMZERO, 21, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TONEARESTFROMZERO, 64, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TONEAREST, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TONEAREST, 20, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TONEAREST, 21, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TONEAREST, 64, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80001.800000008p0, FP_INT_TONEAREST, UINT_MAX, 0x80002, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_UPWARD, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_UPWARD, 21, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_UPWARD, 22, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_UPWARD, 64, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_UPWARD, UINT_MAX, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_DOWNWARD, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_DOWNWARD, 20, 0xfffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_DOWNWARD, 21, 0xfffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_DOWNWARD, 64, 0xfffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0xfffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TOWARDZERO, 19, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TOWARDZERO, 20, 0xfffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TOWARDZERO, 21, 0xfffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TOWARDZERO, 64, 0xfffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0xfffff, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 21, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 22, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TONEAREST, 20, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TONEAREST, 21, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TONEAREST, 22, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TONEAREST, 64, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xfffff.ffffffff8p0, FP_INT_TONEAREST, UINT_MAX, 0x100000, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_UPWARD, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_UPWARD, 33, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_UPWARD, 34, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_UPWARD, 64, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_UPWARD, UINT_MAX, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_DOWNWARD, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_DOWNWARD, 33, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_DOWNWARD, 34, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_DOWNWARD, 64, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_DOWNWARD, UINT_MAX, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TOWARDZERO, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TOWARDZERO, 33, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TOWARDZERO, 34, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TOWARDZERO, 64, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 33, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 34, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 64, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TONEAREST, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TONEAREST, 33, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TONEAREST, 34, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TONEAREST, 64, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.7ffffffep0, FP_INT_TONEAREST, UINT_MAX, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_UPWARD, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_UPWARD, 33, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_UPWARD, 34, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_UPWARD, 64, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_UPWARD, UINT_MAX, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_DOWNWARD, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_DOWNWARD, 33, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_DOWNWARD, 34, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_DOWNWARD, 64, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TOWARDZERO, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TOWARDZERO, 33, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TOWARDZERO, 34, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TOWARDZERO, 64, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TONEARESTFROMZERO, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TONEARESTFROMZERO, 33, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TONEARESTFROMZERO, 34, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TONEAREST, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TONEAREST, 33, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TONEAREST, 34, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TONEAREST, 64, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.8p0, FP_INT_TONEAREST, UINT_MAX, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_UPWARD, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_UPWARD, 33, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_UPWARD, 34, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_UPWARD, 64, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_UPWARD, UINT_MAX, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_DOWNWARD, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_DOWNWARD, 33, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_DOWNWARD, 34, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_DOWNWARD, 64, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_DOWNWARD, UINT_MAX, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TOWARDZERO, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TOWARDZERO, 33, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TOWARDZERO, 34, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TOWARDZERO, 64, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TONEARESTFROMZERO, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TONEARESTFROMZERO, 33, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TONEARESTFROMZERO, 34, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TONEARESTFROMZERO, 64, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TONEAREST, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TONEAREST, 33, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TONEAREST, 34, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TONEAREST, 64, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000000.80000002p0, FP_INT_TONEAREST, UINT_MAX, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_UPWARD, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_UPWARD, 33, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_UPWARD, 34, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_UPWARD, 64, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_UPWARD, UINT_MAX, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_DOWNWARD, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_DOWNWARD, 33, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_DOWNWARD, 34, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_DOWNWARD, 64, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_DOWNWARD, UINT_MAX, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TOWARDZERO, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TOWARDZERO, 33, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TOWARDZERO, 34, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TOWARDZERO, 64, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 33, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 34, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 64, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TONEAREST, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TONEAREST, 33, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TONEAREST, 34, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TONEAREST, 64, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.7ffffffep0, FP_INT_TONEAREST, UINT_MAX, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_UPWARD, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_UPWARD, 33, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_UPWARD, 34, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_UPWARD, 64, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_UPWARD, UINT_MAX, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_DOWNWARD, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_DOWNWARD, 33, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_DOWNWARD, 34, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_DOWNWARD, 64, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TOWARDZERO, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TOWARDZERO, 33, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TOWARDZERO, 34, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TOWARDZERO, 64, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TONEARESTFROMZERO, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TONEARESTFROMZERO, 33, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TONEARESTFROMZERO, 34, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TONEAREST, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TONEAREST, 33, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TONEAREST, 34, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TONEAREST, 64, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.8p0, FP_INT_TONEAREST, UINT_MAX, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_UPWARD, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_UPWARD, 33, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_UPWARD, 34, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_UPWARD, 64, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_UPWARD, UINT_MAX, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_DOWNWARD, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_DOWNWARD, 33, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_DOWNWARD, 34, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_DOWNWARD, 64, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_DOWNWARD, UINT_MAX, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TOWARDZERO, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TOWARDZERO, 33, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TOWARDZERO, 34, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TOWARDZERO, 64, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TONEARESTFROMZERO, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TONEARESTFROMZERO, 33, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TONEARESTFROMZERO, 34, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TONEARESTFROMZERO, 64, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TONEAREST, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TONEAREST, 33, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TONEAREST, 34, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TONEAREST, 64, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x100000001.80000002p0, FP_INT_TONEAREST, UINT_MAX, 0x100000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_UPWARD, 33, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_UPWARD, 34, 0x200000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_UPWARD, 35, 0x200000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_UPWARD, 64, 0x200000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_UPWARD, UINT_MAX, 0x200000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_DOWNWARD, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_DOWNWARD, 33, 0x1ffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_DOWNWARD, 34, 0x1ffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_DOWNWARD, 64, 0x1ffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_DOWNWARD, UINT_MAX, 0x1ffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TOWARDZERO, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TOWARDZERO, 33, 0x1ffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TOWARDZERO, 34, 0x1ffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TOWARDZERO, 64, 0x1ffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 0x1ffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 33, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 34, 0x200000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 35, 0x200000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 64, 0x200000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TONEAREST, 33, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TONEAREST, 34, 0x200000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TONEAREST, 35, 0x200000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TONEAREST, 64, 0x200000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x1ffffffff.fffffffep0, FP_INT_TONEAREST, UINT_MAX, 0x200000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_UPWARD, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_UPWARD, 32, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_UPWARD, 33, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_UPWARD, 64, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_UPWARD, UINT_MAX, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_DOWNWARD, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_DOWNWARD, 32, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_DOWNWARD, 33, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_DOWNWARD, 64, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TOWARDZERO, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TOWARDZERO, 32, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TOWARDZERO, 33, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TOWARDZERO, 64, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 32, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 33, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 64, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TONEAREST, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TONEAREST, 32, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TONEAREST, 33, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TONEAREST, 64, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.7fffffffp0, FP_INT_TONEAREST, UINT_MAX, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_UPWARD, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_UPWARD, 32, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_UPWARD, 33, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_UPWARD, 64, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_UPWARD, UINT_MAX, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_DOWNWARD, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_DOWNWARD, 32, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_DOWNWARD, 33, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_DOWNWARD, 64, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TOWARDZERO, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TOWARDZERO, 32, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TOWARDZERO, 33, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TOWARDZERO, 64, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TONEARESTFROMZERO, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TONEARESTFROMZERO, 32, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TONEARESTFROMZERO, 33, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TONEAREST, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TONEAREST, 32, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TONEAREST, 33, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TONEAREST, 64, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.8p0, FP_INT_TONEAREST, UINT_MAX, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_UPWARD, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_UPWARD, 32, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_UPWARD, 33, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_UPWARD, 64, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_UPWARD, UINT_MAX, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_DOWNWARD, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_DOWNWARD, 32, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_DOWNWARD, 33, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_DOWNWARD, 64, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_DOWNWARD, UINT_MAX, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TOWARDZERO, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TOWARDZERO, 32, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TOWARDZERO, 33, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TOWARDZERO, 64, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TONEARESTFROMZERO, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TONEARESTFROMZERO, 32, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TONEARESTFROMZERO, 33, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TONEARESTFROMZERO, 64, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TONEAREST, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TONEAREST, 32, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TONEAREST, 33, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TONEAREST, 64, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000000.80000001p0, FP_INT_TONEAREST, UINT_MAX, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_UPWARD, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_UPWARD, 32, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_UPWARD, 33, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_UPWARD, 64, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_UPWARD, UINT_MAX, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_DOWNWARD, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_DOWNWARD, 32, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_DOWNWARD, 33, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_DOWNWARD, 64, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TOWARDZERO, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TOWARDZERO, 32, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TOWARDZERO, 33, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TOWARDZERO, 64, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 32, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 33, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 64, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TONEAREST, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TONEAREST, 32, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TONEAREST, 33, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TONEAREST, 64, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.7fffffffp0, FP_INT_TONEAREST, UINT_MAX, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_UPWARD, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_UPWARD, 32, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_UPWARD, 33, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_UPWARD, 64, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_UPWARD, UINT_MAX, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_DOWNWARD, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_DOWNWARD, 32, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_DOWNWARD, 33, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_DOWNWARD, 64, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TOWARDZERO, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TOWARDZERO, 32, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TOWARDZERO, 33, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TOWARDZERO, 64, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TONEARESTFROMZERO, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TONEARESTFROMZERO, 32, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TONEARESTFROMZERO, 33, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TONEAREST, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TONEAREST, 32, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TONEAREST, 33, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TONEAREST, 64, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.8p0, FP_INT_TONEAREST, UINT_MAX, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_UPWARD, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_UPWARD, 32, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_UPWARD, 33, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_UPWARD, 64, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_UPWARD, UINT_MAX, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_DOWNWARD, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_DOWNWARD, 32, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_DOWNWARD, 33, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_DOWNWARD, 64, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_DOWNWARD, UINT_MAX, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TOWARDZERO, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TOWARDZERO, 32, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TOWARDZERO, 33, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TOWARDZERO, 64, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TONEARESTFROMZERO, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TONEARESTFROMZERO, 32, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TONEARESTFROMZERO, 33, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TONEARESTFROMZERO, 64, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TONEAREST, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TONEAREST, 32, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TONEAREST, 33, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TONEAREST, 64, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x80000001.80000001p0, FP_INT_TONEAREST, UINT_MAX, 0x80000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_UPWARD, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_UPWARD, 33, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_UPWARD, 34, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_UPWARD, 64, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_UPWARD, UINT_MAX, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_DOWNWARD, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_DOWNWARD, 32, 0xffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_DOWNWARD, 33, 0xffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_DOWNWARD, 64, 0xffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0xffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TOWARDZERO, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TOWARDZERO, 32, 0xffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TOWARDZERO, 33, 0xffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TOWARDZERO, 64, 0xffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0xffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 33, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 34, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 64, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TONEAREST, 32, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TONEAREST, 33, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TONEAREST, 34, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TONEAREST, 64, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffff.ffffffffp0, FP_INT_TONEAREST, UINT_MAX, 0x100000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_UPWARD, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_UPWARD, 31, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_UPWARD, 32, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_UPWARD, 64, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_UPWARD, UINT_MAX, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_DOWNWARD, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_DOWNWARD, 31, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_DOWNWARD, 32, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_DOWNWARD, 64, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TOWARDZERO, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TOWARDZERO, 31, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TOWARDZERO, 32, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TOWARDZERO, 64, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 31, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 32, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TONEAREST, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TONEAREST, 31, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TONEAREST, 32, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TONEAREST, 64, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.7fffffff8p0, FP_INT_TONEAREST, UINT_MAX, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_UPWARD, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_UPWARD, 31, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_UPWARD, 32, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_UPWARD, 64, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_UPWARD, UINT_MAX, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_DOWNWARD, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_DOWNWARD, 31, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_DOWNWARD, 32, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_DOWNWARD, 64, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TOWARDZERO, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TOWARDZERO, 31, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TOWARDZERO, 32, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TOWARDZERO, 64, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TONEARESTFROMZERO, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TONEARESTFROMZERO, 31, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TONEARESTFROMZERO, 32, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TONEAREST, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TONEAREST, 31, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TONEAREST, 32, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TONEAREST, 64, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.8p0, FP_INT_TONEAREST, UINT_MAX, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_UPWARD, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_UPWARD, 31, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_UPWARD, 32, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_UPWARD, 64, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_UPWARD, UINT_MAX, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_DOWNWARD, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_DOWNWARD, 31, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_DOWNWARD, 32, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_DOWNWARD, 64, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_DOWNWARD, UINT_MAX, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TOWARDZERO, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TOWARDZERO, 31, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TOWARDZERO, 32, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TOWARDZERO, 64, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TOWARDZERO, UINT_MAX, 0x40000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TONEARESTFROMZERO, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TONEARESTFROMZERO, 31, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TONEARESTFROMZERO, 32, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TONEARESTFROMZERO, 64, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TONEAREST, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TONEAREST, 31, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TONEAREST, 32, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TONEAREST, 64, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000000.800000008p0, FP_INT_TONEAREST, UINT_MAX, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_UPWARD, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_UPWARD, 31, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_UPWARD, 32, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_UPWARD, 64, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_UPWARD, UINT_MAX, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_DOWNWARD, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_DOWNWARD, 31, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_DOWNWARD, 32, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_DOWNWARD, 64, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TOWARDZERO, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TOWARDZERO, 31, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TOWARDZERO, 32, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TOWARDZERO, 64, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 31, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 32, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TONEAREST, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TONEAREST, 31, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TONEAREST, 32, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TONEAREST, 64, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.7fffffff8p0, FP_INT_TONEAREST, UINT_MAX, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_UPWARD, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_UPWARD, 31, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_UPWARD, 32, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_UPWARD, 64, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_UPWARD, UINT_MAX, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_DOWNWARD, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_DOWNWARD, 31, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_DOWNWARD, 32, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_DOWNWARD, 64, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TOWARDZERO, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TOWARDZERO, 31, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TOWARDZERO, 32, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TOWARDZERO, 64, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TONEARESTFROMZERO, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TONEARESTFROMZERO, 31, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TONEARESTFROMZERO, 32, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TONEAREST, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TONEAREST, 31, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TONEAREST, 32, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TONEAREST, 64, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.8p0, FP_INT_TONEAREST, UINT_MAX, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_UPWARD, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_UPWARD, 31, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_UPWARD, 32, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_UPWARD, 64, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_UPWARD, UINT_MAX, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_DOWNWARD, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_DOWNWARD, 31, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_DOWNWARD, 32, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_DOWNWARD, 64, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_DOWNWARD, UINT_MAX, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TOWARDZERO, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TOWARDZERO, 31, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TOWARDZERO, 32, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TOWARDZERO, 64, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TOWARDZERO, UINT_MAX, 0x40000001LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TONEARESTFROMZERO, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TONEARESTFROMZERO, 31, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TONEARESTFROMZERO, 32, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TONEARESTFROMZERO, 64, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TONEAREST, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TONEAREST, 31, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TONEAREST, 32, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TONEAREST, 64, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x40000001.800000008p0, FP_INT_TONEAREST, UINT_MAX, 0x40000002LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_UPWARD, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_UPWARD, 32, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_UPWARD, 33, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_UPWARD, 64, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_UPWARD, UINT_MAX, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_DOWNWARD, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_DOWNWARD, 31, 0x7fffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_DOWNWARD, 32, 0x7fffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_DOWNWARD, 64, 0x7fffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0x7fffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TOWARDZERO, 30, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TOWARDZERO, 31, 0x7fffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TOWARDZERO, 32, 0x7fffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TOWARDZERO, 64, 0x7fffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 32, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 33, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TONEAREST, 31, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TONEAREST, 32, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TONEAREST, 33, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TONEAREST, 64, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffff.ffffffff8p0, FP_INT_TONEAREST, UINT_MAX, 0x80000000LL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif

    /* Tests where overflow depends on the rounding mode.  */
#if MANT_DIG >= 64
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_UPWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_UPWARD, 64, 0x8000000000000000ULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_UPWARD, UINT_MAX, 0x8000000000000000ULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_DOWNWARD, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_DOWNWARD, 63, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_DOWNWARD, 64, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TOWARDZERO, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TOWARDZERO, 63, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TOWARDZERO, 64, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000000000ULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000000ULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TONEAREST, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TONEAREST, 64, 0x8000000000000000ULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.8p0, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000000ULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 72
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_UPWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_UPWARD, 64, 0x8000000000000000ULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_UPWARD, UINT_MAX, 0x8000000000000000ULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_DOWNWARD, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_DOWNWARD, 63, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_DOWNWARD, 64, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_DOWNWARD, UINT_MAX, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TOWARDZERO, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TOWARDZERO, 63, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TOWARDZERO, 64, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 63, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 64, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TONEAREST, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TONEAREST, 63, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TONEAREST, 64, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.7fp0, FP_INT_TONEAREST, UINT_MAX, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_UPWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_UPWARD, 64, 0x8000000000000000ULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_UPWARD, UINT_MAX, 0x8000000000000000ULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_DOWNWARD, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_DOWNWARD, 63, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_DOWNWARD, 64, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_DOWNWARD, UINT_MAX, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TOWARDZERO, 62, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TOWARDZERO, 63, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TOWARDZERO, 64, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffffffffffffffLL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000000000ULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000000ULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TONEAREST, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TONEAREST, 64, 0x8000000000000000ULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0x7fffffffffffffff.81p0, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000000ULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_DOWNWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_DOWNWARD, 64, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_DOWNWARD, UINT_MAX, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 64, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TOWARDZERO, UINT_MAX, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 64, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TONEAREST, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TONEAREST, 64, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.7fp0, FP_INT_TONEAREST, UINT_MAX, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_DOWNWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_DOWNWARD, 64, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_DOWNWARD, UINT_MAX, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_TOWARDZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_TOWARDZERO, 64, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.8p0, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_UPWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_UPWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_UPWARD, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_UPWARD, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_DOWNWARD, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_DOWNWARD, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_DOWNWARD, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_DOWNWARD, 64, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_DOWNWARD, UINT_MAX, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_TOWARDZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_TOWARDZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_TOWARDZERO, 63, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_TOWARDZERO, 64, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_TOWARDZERO, UINT_MAX, 0xffffffffffffffffULL, INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_TONEAREST, 0, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_TONEAREST, 1, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_TONEAREST, 64, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_U (ufromfpx, 0xffffffffffffffff.81p0, FP_INT_TONEAREST, UINT_MAX, IGNORE, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
  };

static void
compat_ufromfpx_test (void)
{
  ALL_RM_TEST (compat_ufromfpx, 1, compat_ufromfpx_test_data, RUN_TEST_LOOP_fiu_U, END);
}

#endif

static void
do_test (void)
{
#if TEST_COMPAT (libm, COMPAT_VER, GLIBC_2_43)
  compat_ufromfpx_test ();
#endif
}

/*
 * Local Variables:
 * mode:c
 * End:
 */
