/* gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 1991, 1993, 1994, 1999, 2000, 2001 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the GNU MP Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */

#define BITS_PER_MP_LIMB 64
#define BYTES_PER_MP_LIMB 8

/* These values were measured on a PA8000 using the system compiler version
   A.10.32.30.  Presumably the PA8200 and PA8500 have the same timing
   characteristic, but GCC might give somewhat different results.  */

/* Generated by tuneup.c, 2001-11-26, system compiler */

#define KARATSUBA_MUL_THRESHOLD       16
#define TOOM3_MUL_THRESHOLD          105

#define BASECASE_SQR_THRESHOLD         5
#define KARATSUBA_SQR_THRESHOLD       30
#define TOOM3_SQR_THRESHOLD          114

#define SB_PREINV_THRESHOLD            0
#define DC_THRESHOLD                  56
#define POWM_THRESHOLD               110

#define GCD_ACCEL_THRESHOLD            3
#define GCDEXT_THRESHOLD               0

#define DIVREM_1_NORM_THRESHOLD        0
#define DIVREM_1_UNNORM_THRESHOLD      0
#define MOD_1_NORM_THRESHOLD           0
#define MOD_1_UNNORM_THRESHOLD         0
#define USE_PREINV_MOD_1               1
#define DIVREM_2_THRESHOLD             0
#define DIVEXACT_1_THRESHOLD           0
#define MODEXACT_1_ODD_THRESHOLD       0

#define FFT_MUL_TABLE  { 464, 928, 2112, 3840, 9216, 28672, 0 }
#define FFT_MODF_MUL_THRESHOLD       328
#define FFT_MUL_THRESHOLD           2432

#define FFT_SQR_TABLE  { 464, 992, 2240, 4352, 9216, 28672, 0 }
#define FFT_MODF_SQR_THRESHOLD       344
#define FFT_SQR_THRESHOLD           2432
