/* buffer.c generated by valac 0.52.3, the Vala compiler
 * generated from buffer.vala, do not modify */

/* Buffer-oriented functions

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <estr.h>
#include <unistd.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _buffer_unref0(var) ((var == NULL) ? NULL : (var = (buffer_unref (var), NULL)))
#define _marker_unref0(var) ((var == NULL) ? NULL : (var = (marker_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _immutable_estr_unref0(var) ((var == NULL) ? NULL : (var = (immutable_estr_unref (var), NULL)))
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())

#define TYPE_REGION (region_get_type ())
#define REGION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGION, Region))
#define REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGION, RegionClass))
#define IS_REGION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGION))
#define IS_REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGION))
#define REGION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGION, RegionClass))

typedef struct _Region Region;
typedef struct _RegionClass RegionClass;
typedef struct _VarEntryPrivate VarEntryPrivate;
#define _var_entry_unref0(var) ((var == NULL) ? NULL : (var = (var_entry_unref (var), NULL)))

#define TYPE_WINDOW (window_get_type ())
#define WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW, Window))
#define WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW, WindowClass))
#define IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW))
#define IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW))
#define WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW, WindowClass))

typedef struct _Window Window;
typedef struct _WindowClass WindowClass;
typedef struct _WindowPrivate WindowPrivate;
#define _window_unref0(var) ((var == NULL) ? NULL : (var = (window_unref (var), NULL)))

#define TYPE_COMPLETION (completion_get_type ())
#define COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION, Completion))
#define COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION, CompletionClass))
#define IS_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION))
#define IS_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION))
#define COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION, CompletionClass))

typedef struct _Completion Completion;
typedef struct _CompletionClass CompletionClass;
typedef struct _CompletionPrivate CompletionPrivate;
typedef enum  {
	COMPLETION_FLAGS_POPPEDUP = 1 << 0,
	COMPLETION_FLAGS_CLOSE = 1 << 1,
	COMPLETION_FLAGS_FILENAME = 1 << 2
} CompletionFlags;

#define COMPLETION_TYPE_FLAGS (completion_flags_get_type ())
typedef gsize (*BufferBufferMoveLine) (gsize o, gpointer user_data);
typedef struct _ParamSpecBuffer ParamSpecBuffer;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

struct _BufferPrivate {
	gsize _pt;
	Estr* text;
	gsize gap;
};

struct _VarEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VarEntryPrivate * priv;
	gchar* name;
	gchar* defval;
	gchar* val;
	gboolean local;
	gchar* doc;
};

struct _VarEntryClass {
	GTypeClass parent_class;
	void (*finalize) (VarEntry *self);
};

struct _Window {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WindowPrivate * priv;
	Window* next;
	Buffer* bp;
	gsize topdelta;
	gsize start_column;
	Marker* saved_pt;
	gsize fwidth;
	gsize fheight;
	gsize ewidth;
	gsize eheight;
	gboolean all_displayed;
	gsize lastpointn;
};

struct _WindowClass {
	GTypeClass parent_class;
	void (*finalize) (Window *self);
};

struct _Completion {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CompletionPrivate * priv;
	gchar* match;
	Buffer* old_bp;
	GeeSortedSet* completions;
	GeeSortedSet* matches;
	glong matchsize;
	CompletionFlags flags;
	gchar* path;
};

struct _CompletionClass {
	GTypeClass parent_class;
	void (*finalize) (Completion *self);
};

struct _ParamSpecBuffer {
	GParamSpec parent_instance;
};

static gint Buffer_private_offset;
static gpointer buffer_parent_class = NULL;
extern Buffer* head_bp;
extern Flags thisflag;
extern Window* cur_wp;
extern Buffer* cur_bp;
extern Window* head_wp;

gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
gpointer marker_ref (gpointer instance);
void marker_unref (gpointer instance);
GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_marker (GValue* value,
                       gpointer v_object);
void value_take_marker (GValue* value,
                        gpointer v_object);
gpointer value_get_marker (const GValue* value);
GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
gpointer undo_ref (gpointer instance);
void undo_unref (gpointer instance);
GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_undo (GValue* value,
                     gpointer v_object);
void value_take_undo (GValue* value,
                      gpointer v_object);
gpointer value_get_undo (const GValue* value);
GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
gpointer var_entry_ref (gpointer instance);
void var_entry_unref (gpointer instance);
GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_var_entry (GValue* value,
                          gpointer v_object);
void value_take_var_entry (GValue* value,
                           gpointer v_object);
gpointer value_get_var_entry (const GValue* value);
GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
gsize buffer_get_length (Buffer* self);
const gchar* buffer_get_eol (Buffer* self);
void marker_unchain (Marker* self);
#define BUFFER_MIN_GAP 1024
#define BUFFER_MAX_GAP 4096
Buffer* buffer_new (Estr* es);
Buffer* buffer_construct (GType object_type,
                          Estr* es);
void buffer_init (Buffer* self);
ImmutableEstr* buffer_pre_point (Buffer* self);
gsize buffer_get_pt (Buffer* self);
ImmutableEstr* buffer_post_point (Buffer* self);
gsize buffer_realo_to_o (Buffer* self,
                         gsize o);
gsize buffer_o_to_realo (Buffer* self,
                         gsize o);
gsize buffer_line_len (Buffer* self,
                       gsize o);
gchar buffer_get_char (Buffer* self,
                       gsize o);
gsize buffer_prev_line (Buffer* self,
                        gsize o);
gsize buffer_next_line (Buffer* self,
                        gsize o);
gsize buffer_start_of_line (Buffer* self,
                            gsize o);
gsize buffer_end_of_line (Buffer* self,
                          gsize o);
gsize buffer_line_o (Buffer* self);
gboolean buffer_replace_estr (Buffer* self,
                              gsize del,
                              ImmutableEstr* es);
gboolean buffer_warn_if_readonly (Buffer* self);
void undo_save_block (gsize o,
                      gsize osize,
                      gsize size);
gsize buffer_calculate_goalc (Buffer* self,
                              gsize o);
Marker* marker_get_next (Marker* self);
gsize marker_get_o (Marker* self);
void marker_set_o (Marker* self,
                   gsize value);
GType flags_get_type (void) G_GNUC_CONST ;
gpointer region_ref (gpointer instance);
void region_unref (gpointer instance);
GParamSpec* param_spec_region (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_region (GValue* value,
                       gpointer v_object);
void value_take_region (GValue* value,
                        gpointer v_object);
gpointer value_get_region (const GValue* value);
GType region_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Region, region_unref)
ImmutableEstr* buffer_get_region (Buffer* self,
                                  Region* r);
gsize region_get_start (Region* self);
gsize region_get_end (Region* self);
gboolean buffer_insert_estr (Buffer* self,
                             ImmutableEstr* es);
gboolean buffer_is_empty_line (Buffer* self);
gboolean buffer_is_blank_line (Buffer* self);
gchar buffer_following_char (Buffer* self);
gboolean buffer_eobp (Buffer* self);
gboolean buffer_eolp (Buffer* self);
gchar buffer_preceding_char (Buffer* self);
gboolean buffer_bobp (Buffer* self);
gboolean buffer_bolp (Buffer* self);
gboolean buffer_insert_char (Buffer* self,
                             gchar c);
gboolean buffer_delete_char (Buffer* self);
void minibuf_error (const gchar* fmt,
                    ...);
gboolean buffer_backward_delete_char (Buffer* self);
gboolean buffer_move_char (Buffer* self,
                           glong offset);
static void buffer_insert_half_buffer (Buffer* self,
                                Buffer* bp,
                                ImmutableEstr* es);
void buffer_insert_buffer (Buffer* self,
                           Buffer* bp);
gboolean get_variable_bool (const gchar* name);
gchar* buffer_get_filename_or_name (Buffer* self);
void buffer_set_names (Buffer* self,
                       const gchar* new_filename);
Buffer* buffer_find (const gchar* name);
const gchar* buffer_get_variable (Buffer* self,
                                  const gchar* name);
VarEntry* get_variable_entry (Buffer* bp,
                              const gchar* name);
static void buffer_move_to_head (Buffer* bp);
void buffer_switch_to (Buffer* self);
gpointer window_ref (gpointer instance);
void window_unref (gpointer instance);
GParamSpec* param_spec_window (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_window (GValue* value,
                       gpointer v_object);
void value_take_window (GValue* value,
                        gpointer v_object);
gpointer value_get_window (const GValue* value);
GType window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Window, window_unref)
gboolean buffer_warn_if_no_mark (Buffer* self);
void buffer_set_temporary (Buffer* self);
gsize buffer_tab_width (Buffer* self);
glong* parse_number (const gchar* s);
static glong* _long_dup (glong* self);
void buffer_kill (Buffer* self);
Buffer* create_scratch_buffer (void);
void window_resync (Window* self);
gpointer completion_ref (gpointer instance);
void completion_unref (gpointer instance);
GParamSpec* param_spec_completion (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_completion (GValue* value,
                           gpointer v_object);
void value_take_completion (GValue* value,
                            gpointer v_object);
gpointer value_get_completion (const GValue* value);
GType completion_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Completion, completion_unref)
Completion* buffer_make_buffer_completion (void);
Completion* completion_new (gboolean fileflag);
Completion* completion_construct (GType object_type,
                                  gboolean fileflag);
GType completion_flags_get_type (void) G_GNUC_CONST ;
gboolean buffer_check_modified (Buffer* self);
gboolean* minibuf_read_yesno (const gchar* fmt,
                              ...);
gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
static gboolean _bool_equal (const gboolean * s1,
                      const gboolean * s2);
static void buffer_set_pt (Buffer* self,
                    gsize value);
void buffer_goto_goalc (Buffer* self);
gboolean buffer_move_line (Buffer* self,
                           glong n);
static gsize _buffer_next_line_buffer_buffer_move_line (gsize o,
                                                 gpointer self);
static gsize _buffer_prev_line_buffer_buffer_move_line (gsize o,
                                                 gpointer self);
gboolean buffer_move_word (Buffer* self,
                           glong dir);
gboolean iswordchar (gchar c);
gboolean buffer_move_sexp (Buffer* self,
                           glong dir);
gboolean isopenbracketchar (gchar c,
                            gboolean single_quote,
                            gboolean double_quote);
gboolean isclosebracketchar (gchar c,
                             gboolean single_quote,
                             gboolean double_quote);
gsize buffer_offset_to_line (Buffer* self,
                             gsize offset);
void buffer_goto_offset (Buffer* self,
                         gsize o);
static void buffer_finalize (Buffer * obj);
static GType buffer_get_type_once (void);
Buffer* create_auto_buffer (const gchar* name);
void buffer_init_lisp (void);
static gboolean __lambda32_ (glong uniarg,
                      GeeQueue* args);
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_history (GValue* value,
                        gpointer v_object);
void value_take_history (GValue* value,
                         gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (History, history_unref)
gchar* minibuf_read_completion (const gchar* fmt,
                                const gchar* val,
                                Completion* cp,
                                History* hp,
                                ...);
static gboolean ___lambda32__function (glong uniarg,
                                GeeQueue* args);
LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
gpointer lisp_func_ref (gpointer instance);
void lisp_func_unref (gpointer instance);
GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_lisp_func (GValue* value,
                          gpointer v_object);
void value_take_lisp_func (GValue* value,
                           gpointer v_object);
gpointer value_get_lisp_func (const GValue* value);
GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)

static inline gpointer
buffer_get_instance_private (Buffer* self)
{
	return G_STRUCT_MEMBER_P (self, Buffer_private_offset);
}

static gpointer
_immutable_estr_ref0 (gpointer self)
{
#line 65 "src/buffer.vala"
	return self ? immutable_estr_ref (self) : NULL;
#line 550 "buffer.c"
}

static gpointer
_buffer_ref0 (gpointer self)
{
#line 69 "src/buffer.vala"
	return self ? buffer_ref (self) : NULL;
#line 558 "buffer.c"
}

Buffer*
buffer_construct (GType object_type,
                  Estr* es)
{
	Buffer* self = NULL;
	Estr* _tmp0_;
	gchar* _tmp1_;
	Buffer* _tmp2_;
	Buffer* _tmp3_;
	Buffer* _tmp4_;
#line 64 "src/buffer.vala"
	g_return_val_if_fail (es != NULL, NULL);
#line 64 "src/buffer.vala"
	self = (Buffer*) g_type_create_instance (object_type);
#line 65 "src/buffer.vala"
	_tmp0_ = _immutable_estr_ref0 (es);
#line 65 "src/buffer.vala"
	_immutable_estr_unref0 (self->priv->text);
#line 65 "src/buffer.vala"
	self->priv->text = _tmp0_;
#line 66 "src/buffer.vala"
	_tmp1_ = g_get_current_dir ();
#line 66 "src/buffer.vala"
	_g_free0 (self->dir);
#line 66 "src/buffer.vala"
	self->dir = _tmp1_;
#line 69 "src/buffer.vala"
	_tmp2_ = head_bp;
#line 69 "src/buffer.vala"
	_tmp3_ = _buffer_ref0 (_tmp2_);
#line 69 "src/buffer.vala"
	_buffer_unref0 (self->next);
#line 69 "src/buffer.vala"
	self->next = _tmp3_;
#line 70 "src/buffer.vala"
	_tmp4_ = _buffer_ref0 (self);
#line 70 "src/buffer.vala"
	_buffer_unref0 (head_bp);
#line 70 "src/buffer.vala"
	head_bp = _tmp4_;
#line 72 "src/buffer.vala"
	buffer_init (self);
#line 64 "src/buffer.vala"
	return self;
#line 605 "buffer.c"
}

Buffer*
buffer_new (Estr* es)
{
#line 64 "src/buffer.vala"
	return buffer_construct (TYPE_BUFFER, es);
#line 613 "buffer.c"
}

ImmutableEstr*
buffer_pre_point (Buffer* self)
{
	Estr* _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	ImmutableEstr* _tmp3_;
	ImmutableEstr* result = NULL;
#line 78 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 79 "src/buffer.vala"
	_tmp0_ = self->priv->text;
#line 79 "src/buffer.vala"
	_tmp1_ = buffer_get_pt (self);
#line 79 "src/buffer.vala"
	_tmp2_ = _tmp1_;
#line 79 "src/buffer.vala"
	_tmp3_ = immutable_estr_substring ((ImmutableEstr*) _tmp0_, (gsize) 0, _tmp2_);
#line 79 "src/buffer.vala"
	result = _tmp3_;
#line 79 "src/buffer.vala"
	return result;
#line 638 "buffer.c"
}

ImmutableEstr*
buffer_post_point (Buffer* self)
{
	gsize post_gap = 0UL;
	gsize _tmp0_;
	gsize _tmp1_;
	Estr* _tmp2_;
	Estr* _tmp3_;
	gsize _tmp4_;
	gsize _tmp5_;
	ImmutableEstr* _tmp6_;
	ImmutableEstr* result = NULL;
#line 82 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 83 "src/buffer.vala"
	_tmp0_ = buffer_get_pt (self);
#line 83 "src/buffer.vala"
	_tmp1_ = _tmp0_;
#line 83 "src/buffer.vala"
	post_gap = _tmp1_ + self->priv->gap;
#line 84 "src/buffer.vala"
	_tmp2_ = self->priv->text;
#line 84 "src/buffer.vala"
	_tmp3_ = self->priv->text;
#line 84 "src/buffer.vala"
	_tmp4_ = immutable_estr_get_length ((ImmutableEstr*) _tmp3_);
#line 84 "src/buffer.vala"
	_tmp5_ = _tmp4_;
#line 84 "src/buffer.vala"
	_tmp6_ = immutable_estr_substring ((ImmutableEstr*) _tmp2_, post_gap, _tmp5_ - post_gap);
#line 84 "src/buffer.vala"
	result = _tmp6_;
#line 84 "src/buffer.vala"
	return result;
#line 675 "buffer.c"
}

gsize
buffer_realo_to_o (Buffer* self,
                   gsize o)
{
	gsize result = 0UL;
#line 87 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 88 "src/buffer.vala"
	if (o == ((gsize) G_MAXSIZE)) {
#line 89 "src/buffer.vala"
		result = o;
#line 89 "src/buffer.vala"
		return result;
#line 691 "buffer.c"
	} else {
		gsize _tmp0_;
		gsize _tmp1_;
#line 90 "src/buffer.vala"
		_tmp0_ = buffer_get_pt (self);
#line 90 "src/buffer.vala"
		_tmp1_ = _tmp0_;
#line 90 "src/buffer.vala"
		if (o < (_tmp1_ + self->priv->gap)) {
#line 701 "buffer.c"
			gsize _tmp2_;
			gsize _tmp3_;
#line 91 "src/buffer.vala"
			_tmp2_ = buffer_get_pt (self);
#line 91 "src/buffer.vala"
			_tmp3_ = _tmp2_;
#line 91 "src/buffer.vala"
			result = MIN (o, _tmp3_);
#line 91 "src/buffer.vala"
			return result;
#line 712 "buffer.c"
		} else {
#line 93 "src/buffer.vala"
			result = o - self->priv->gap;
#line 93 "src/buffer.vala"
			return result;
#line 718 "buffer.c"
		}
	}
}

gsize
buffer_o_to_realo (Buffer* self,
                   gsize o)
{
	gsize _tmp0_ = 0UL;
	gsize _tmp1_;
	gsize _tmp2_;
	gsize result = 0UL;
#line 96 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 97 "src/buffer.vala"
	_tmp1_ = buffer_get_pt (self);
#line 97 "src/buffer.vala"
	_tmp2_ = _tmp1_;
#line 97 "src/buffer.vala"
	if (o < _tmp2_) {
#line 97 "src/buffer.vala"
		_tmp0_ = o;
#line 741 "buffer.c"
	} else {
#line 97 "src/buffer.vala"
		_tmp0_ = o + self->priv->gap;
#line 745 "buffer.c"
	}
#line 97 "src/buffer.vala"
	result = _tmp0_;
#line 97 "src/buffer.vala"
	return result;
#line 751 "buffer.c"
}

gsize
buffer_line_len (Buffer* self,
                 gsize o)
{
	Estr* _tmp0_;
	Estr* _tmp1_;
	gsize result = 0UL;
#line 104 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 105 "src/buffer.vala"
	_tmp0_ = self->priv->text;
#line 105 "src/buffer.vala"
	_tmp1_ = self->priv->text;
#line 105 "src/buffer.vala"
	result = buffer_realo_to_o (self, immutable_estr_end_of_line ((ImmutableEstr*) _tmp0_, buffer_o_to_realo (self, o))) - buffer_realo_to_o (self, immutable_estr_start_of_line ((ImmutableEstr*) _tmp1_, buffer_o_to_realo (self, o)));
#line 105 "src/buffer.vala"
	return result;
#line 771 "buffer.c"
}

gchar
buffer_get_char (Buffer* self,
                 gsize o)
{
	Estr* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar _tmp3_;
	gchar result = '\0';
#line 109 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 110 "src/buffer.vala"
	_tmp0_ = self->priv->text;
#line 110 "src/buffer.vala"
	_tmp1_ = immutable_estr_get_text ((ImmutableEstr*) _tmp0_);
#line 110 "src/buffer.vala"
	_tmp2_ = _tmp1_;
#line 110 "src/buffer.vala"
	_tmp3_ = _tmp2_[buffer_o_to_realo (self, o)];
#line 110 "src/buffer.vala"
	result = _tmp3_;
#line 110 "src/buffer.vala"
	return result;
#line 797 "buffer.c"
}

gsize
buffer_prev_line (Buffer* self,
                  gsize o)
{
	Estr* _tmp0_;
	gsize result = 0UL;
#line 113 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 114 "src/buffer.vala"
	_tmp0_ = self->priv->text;
#line 114 "src/buffer.vala"
	result = buffer_realo_to_o (self, immutable_estr_prev_line ((ImmutableEstr*) _tmp0_, buffer_o_to_realo (self, o)));
#line 114 "src/buffer.vala"
	return result;
#line 814 "buffer.c"
}

gsize
buffer_next_line (Buffer* self,
                  gsize o)
{
	Estr* _tmp0_;
	gsize result = 0UL;
#line 117 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 118 "src/buffer.vala"
	_tmp0_ = self->priv->text;
#line 118 "src/buffer.vala"
	result = buffer_realo_to_o (self, immutable_estr_next_line ((ImmutableEstr*) _tmp0_, buffer_o_to_realo (self, o)));
#line 118 "src/buffer.vala"
	return result;
#line 831 "buffer.c"
}

gsize
buffer_start_of_line (Buffer* self,
                      gsize o)
{
	Estr* _tmp0_;
	gsize result = 0UL;
#line 121 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 122 "src/buffer.vala"
	_tmp0_ = self->priv->text;
#line 122 "src/buffer.vala"
	result = buffer_realo_to_o (self, immutable_estr_start_of_line ((ImmutableEstr*) _tmp0_, buffer_o_to_realo (self, o)));
#line 122 "src/buffer.vala"
	return result;
#line 848 "buffer.c"
}

gsize
buffer_end_of_line (Buffer* self,
                    gsize o)
{
	Estr* _tmp0_;
	gsize result = 0UL;
#line 125 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 126 "src/buffer.vala"
	_tmp0_ = self->priv->text;
#line 126 "src/buffer.vala"
	result = buffer_realo_to_o (self, immutable_estr_end_of_line ((ImmutableEstr*) _tmp0_, buffer_o_to_realo (self, o)));
#line 126 "src/buffer.vala"
	return result;
#line 865 "buffer.c"
}

gsize
buffer_line_o (Buffer* self)
{
	Estr* _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	gsize result = 0UL;
#line 129 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 130 "src/buffer.vala"
	_tmp0_ = self->priv->text;
#line 130 "src/buffer.vala"
	_tmp1_ = buffer_get_pt (self);
#line 130 "src/buffer.vala"
	_tmp2_ = _tmp1_;
#line 130 "src/buffer.vala"
	result = buffer_realo_to_o (self, immutable_estr_start_of_line ((ImmutableEstr*) _tmp0_, buffer_o_to_realo (self, _tmp2_)));
#line 130 "src/buffer.vala"
	return result;
#line 887 "buffer.c"
}

static gpointer
_marker_ref0 (gpointer self)
{
#line 171 "src/buffer.vala"
	return self ? marker_ref (self) : NULL;
#line 895 "buffer.c"
}

gboolean
buffer_replace_estr (Buffer* self,
                     gsize del,
                     ImmutableEstr* es)
{
	gsize newlen = 0UL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	gsize oldgap = 0UL;
	gint _tmp4_ = 0;
	gsize added_gap = 0UL;
	Estr* _tmp14_;
	gsize _tmp15_;
	gsize _tmp16_;
	gboolean result = FALSE;
#line 138 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 138 "src/buffer.vala"
	g_return_val_if_fail (es != NULL, FALSE);
#line 139 "src/buffer.vala"
	if (buffer_warn_if_readonly (self)) {
#line 140 "src/buffer.vala"
		result = FALSE;
#line 140 "src/buffer.vala"
		return result;
#line 925 "buffer.c"
	}
#line 142 "src/buffer.vala"
	_tmp0_ = buffer_get_eol (self);
#line 142 "src/buffer.vala"
	_tmp1_ = _tmp0_;
#line 142 "src/buffer.vala"
	newlen = immutable_estr_len_with_eol (es, _tmp1_);
#line 143 "src/buffer.vala"
	_tmp2_ = buffer_get_pt (self);
#line 143 "src/buffer.vala"
	_tmp3_ = _tmp2_;
#line 143 "src/buffer.vala"
	undo_save_block (_tmp3_, del, newlen);
#line 146 "src/buffer.vala"
	oldgap = self->priv->gap;
#line 147 "src/buffer.vala"
	if ((oldgap + del) < newlen) {
#line 147 "src/buffer.vala"
		_tmp4_ = BUFFER_MIN_GAP;
#line 945 "buffer.c"
	} else {
#line 147 "src/buffer.vala"
		_tmp4_ = 0;
#line 949 "buffer.c"
	}
#line 147 "src/buffer.vala"
	added_gap = (gsize) _tmp4_;
#line 148 "src/buffer.vala"
	if (added_gap > ((gsize) 0)) {
#line 955 "buffer.c"
		Estr* _tmp5_;
		gsize _tmp6_;
		gsize _tmp7_;
#line 150 "src/buffer.vala"
		_tmp5_ = self->priv->text;
#line 150 "src/buffer.vala"
		_tmp6_ = buffer_get_pt (self);
#line 150 "src/buffer.vala"
		_tmp7_ = _tmp6_;
#line 150 "src/buffer.vala"
		estr_insert (_tmp5_, _tmp7_, (newlen + BUFFER_MIN_GAP) - (oldgap + del));
#line 151 "src/buffer.vala"
		self->priv->gap = (gsize) BUFFER_MIN_GAP;
#line 969 "buffer.c"
	} else {
#line 152 "src/buffer.vala"
		if ((oldgap + del) > (BUFFER_MAX_GAP + newlen)) {
#line 973 "buffer.c"
			Estr* _tmp8_;
			gsize _tmp9_;
			gsize _tmp10_;
#line 154 "src/buffer.vala"
			_tmp8_ = self->priv->text;
#line 154 "src/buffer.vala"
			_tmp9_ = buffer_get_pt (self);
#line 154 "src/buffer.vala"
			_tmp10_ = _tmp9_;
#line 154 "src/buffer.vala"
			estr_remove (_tmp8_, (_tmp10_ + newlen) + BUFFER_MAX_GAP, (oldgap + del) - (BUFFER_MAX_GAP + newlen));
#line 155 "src/buffer.vala"
			self->priv->gap = (gsize) BUFFER_MAX_GAP;
#line 987 "buffer.c"
		} else {
#line 157 "src/buffer.vala"
			self->priv->gap = (oldgap + del) - newlen;
#line 991 "buffer.c"
		}
	}
#line 160 "src/buffer.vala"
	if ((MAX (oldgap, newlen) + added_gap) < (self->priv->gap + newlen)) {
#line 996 "buffer.c"
		Estr* _tmp11_;
		gsize _tmp12_;
		gsize _tmp13_;
#line 161 "src/buffer.vala"
		_tmp11_ = self->priv->text;
#line 161 "src/buffer.vala"
		_tmp12_ = buffer_get_pt (self);
#line 161 "src/buffer.vala"
		_tmp13_ = _tmp12_;
#line 161 "src/buffer.vala"
		estr_set (_tmp11_, (_tmp13_ + MAX (oldgap, newlen)) + added_gap, (gint) '\0', ((newlen + self->priv->gap) - MAX (oldgap, newlen)) - added_gap);
#line 1008 "buffer.c"
	}
#line 166 "src/buffer.vala"
	_tmp14_ = self->priv->text;
#line 166 "src/buffer.vala"
	_tmp15_ = buffer_get_pt (self);
#line 166 "src/buffer.vala"
	_tmp16_ = _tmp15_;
#line 166 "src/buffer.vala"
	estr_replace (_tmp14_, _tmp16_, es);
#line 167 "src/buffer.vala"
	self->priv->_pt = self->priv->_pt + newlen;
#line 168 "src/buffer.vala"
	self->goalc = buffer_calculate_goalc (self, self->priv->_pt);
#line 1022 "buffer.c"
	{
		Marker* m = NULL;
		Marker* _tmp17_;
		Marker* _tmp18_;
#line 171 "src/buffer.vala"
		_tmp17_ = self->markers;
#line 171 "src/buffer.vala"
		_tmp18_ = _marker_ref0 (_tmp17_);
#line 171 "src/buffer.vala"
		m = _tmp18_;
#line 1033 "buffer.c"
		{
			gboolean _tmp19_ = FALSE;
#line 171 "src/buffer.vala"
			_tmp19_ = TRUE;
#line 171 "src/buffer.vala"
			while (TRUE) {
#line 1040 "buffer.c"
				Marker* _tmp24_;
				Marker* _tmp25_;
				gsize _tmp26_;
				gsize _tmp27_;
				gsize _tmp28_;
				gsize _tmp29_;
#line 171 "src/buffer.vala"
				if (!_tmp19_) {
#line 1049 "buffer.c"
					Marker* _tmp20_;
					Marker* _tmp21_;
					Marker* _tmp22_;
					Marker* _tmp23_;
#line 171 "src/buffer.vala"
					_tmp20_ = m;
#line 171 "src/buffer.vala"
					_tmp21_ = marker_get_next (_tmp20_);
#line 171 "src/buffer.vala"
					_tmp22_ = _tmp21_;
#line 171 "src/buffer.vala"
					_tmp23_ = _marker_ref0 (_tmp22_);
#line 171 "src/buffer.vala"
					_marker_unref0 (m);
#line 171 "src/buffer.vala"
					m = _tmp23_;
#line 1066 "buffer.c"
				}
#line 171 "src/buffer.vala"
				_tmp19_ = FALSE;
#line 171 "src/buffer.vala"
				_tmp24_ = m;
#line 171 "src/buffer.vala"
				if (!(_tmp24_ != NULL)) {
#line 171 "src/buffer.vala"
					break;
#line 1076 "buffer.c"
				}
#line 172 "src/buffer.vala"
				_tmp25_ = m;
#line 172 "src/buffer.vala"
				_tmp26_ = marker_get_o (_tmp25_);
#line 172 "src/buffer.vala"
				_tmp27_ = _tmp26_;
#line 172 "src/buffer.vala"
				_tmp28_ = buffer_get_pt (self);
#line 172 "src/buffer.vala"
				_tmp29_ = _tmp28_;
#line 172 "src/buffer.vala"
				if (_tmp27_ > (_tmp29_ - newlen)) {
#line 1090 "buffer.c"
					Marker* _tmp30_;
					gsize _tmp31_;
					gsize _tmp32_;
					Marker* _tmp33_;
					gsize _tmp34_;
					gsize _tmp35_;
#line 173 "src/buffer.vala"
					_tmp30_ = m;
#line 173 "src/buffer.vala"
					_tmp31_ = buffer_get_pt (self);
#line 173 "src/buffer.vala"
					_tmp32_ = _tmp31_;
#line 173 "src/buffer.vala"
					_tmp33_ = m;
#line 173 "src/buffer.vala"
					_tmp34_ = marker_get_o (_tmp33_);
#line 173 "src/buffer.vala"
					_tmp35_ = _tmp34_;
#line 173 "src/buffer.vala"
					marker_set_o (_tmp30_, MAX (_tmp32_ - newlen, (_tmp35_ + newlen) - del));
#line 1111 "buffer.c"
				}
			}
		}
#line 171 "src/buffer.vala"
		_marker_unref0 (m);
#line 1117 "buffer.c"
	}
#line 175 "src/buffer.vala"
	self->modified = TRUE;
#line 176 "src/buffer.vala"
	if (immutable_estr_next_line (es, (gsize) 0) != ((gsize) G_MAXSIZE)) {
#line 1123 "buffer.c"
		Flags _tmp36_;
#line 177 "src/buffer.vala"
		_tmp36_ = thisflag;
#line 177 "src/buffer.vala"
		thisflag = _tmp36_ | FLAGS_NEED_RESYNC;
#line 1129 "buffer.c"
	}
#line 178 "src/buffer.vala"
	result = TRUE;
#line 178 "src/buffer.vala"
	return result;
#line 1135 "buffer.c"
}

ImmutableEstr*
buffer_get_region (Buffer* self,
                   Region* r)
{
	Estr* es = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	Estr* _tmp2_;
	gsize _tmp3_;
	gsize _tmp4_;
	gsize _tmp5_;
	gsize _tmp6_;
	gsize _tmp19_;
	gsize _tmp20_;
	gsize _tmp21_;
	gsize _tmp22_;
	ImmutableEstr* result = NULL;
#line 181 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 181 "src/buffer.vala"
	g_return_val_if_fail (r != NULL, NULL);
#line 182 "src/buffer.vala"
	_tmp0_ = buffer_get_eol (self);
#line 182 "src/buffer.vala"
	_tmp1_ = _tmp0_;
#line 182 "src/buffer.vala"
	_tmp2_ = estr_of_empty (_tmp1_);
#line 182 "src/buffer.vala"
	es = _tmp2_;
#line 183 "src/buffer.vala"
	_tmp3_ = region_get_start (r);
#line 183 "src/buffer.vala"
	_tmp4_ = _tmp3_;
#line 183 "src/buffer.vala"
	_tmp5_ = buffer_get_pt (self);
#line 183 "src/buffer.vala"
	_tmp6_ = _tmp5_;
#line 183 "src/buffer.vala"
	if (_tmp4_ < _tmp6_) {
#line 1177 "buffer.c"
		Estr* _tmp7_;
		Estr* _tmp8_;
		gsize _tmp9_;
		gsize _tmp10_;
		gsize _tmp11_;
		gsize _tmp12_;
		gsize _tmp13_;
		gsize _tmp14_;
		gsize _tmp15_;
		gsize _tmp16_;
		ImmutableEstr* _tmp17_;
		ImmutableEstr* _tmp18_;
#line 184 "src/buffer.vala"
		_tmp7_ = es;
#line 184 "src/buffer.vala"
		_tmp8_ = self->priv->text;
#line 184 "src/buffer.vala"
		_tmp9_ = region_get_start (r);
#line 184 "src/buffer.vala"
		_tmp10_ = _tmp9_;
#line 184 "src/buffer.vala"
		_tmp11_ = region_get_end (r);
#line 184 "src/buffer.vala"
		_tmp12_ = _tmp11_;
#line 184 "src/buffer.vala"
		_tmp13_ = buffer_get_pt (self);
#line 184 "src/buffer.vala"
		_tmp14_ = _tmp13_;
#line 184 "src/buffer.vala"
		_tmp15_ = region_get_start (r);
#line 184 "src/buffer.vala"
		_tmp16_ = _tmp15_;
#line 184 "src/buffer.vala"
		_tmp17_ = immutable_estr_substring ((ImmutableEstr*) _tmp8_, _tmp10_, MIN (_tmp12_, _tmp14_) - _tmp16_);
#line 184 "src/buffer.vala"
		_tmp18_ = _tmp17_;
#line 184 "src/buffer.vala"
		estr_cat (_tmp7_, _tmp18_);
#line 184 "src/buffer.vala"
		_immutable_estr_unref0 (_tmp18_);
#line 1218 "buffer.c"
	}
#line 185 "src/buffer.vala"
	_tmp19_ = region_get_end (r);
#line 185 "src/buffer.vala"
	_tmp20_ = _tmp19_;
#line 185 "src/buffer.vala"
	_tmp21_ = buffer_get_pt (self);
#line 185 "src/buffer.vala"
	_tmp22_ = _tmp21_;
#line 185 "src/buffer.vala"
	if (_tmp20_ > _tmp22_) {
#line 1230 "buffer.c"
		gsize from = 0UL;
		gsize _tmp23_;
		gsize _tmp24_;
		gsize _tmp25_;
		gsize _tmp26_;
		Estr* _tmp27_;
		Estr* _tmp28_;
		gsize _tmp29_;
		gsize _tmp30_;
		ImmutableEstr* _tmp31_;
		ImmutableEstr* _tmp32_;
#line 186 "src/buffer.vala"
		_tmp23_ = region_get_start (r);
#line 186 "src/buffer.vala"
		_tmp24_ = _tmp23_;
#line 186 "src/buffer.vala"
		_tmp25_ = buffer_get_pt (self);
#line 186 "src/buffer.vala"
		_tmp26_ = _tmp25_;
#line 186 "src/buffer.vala"
		from = MAX (_tmp24_, _tmp26_);
#line 187 "src/buffer.vala"
		_tmp27_ = es;
#line 187 "src/buffer.vala"
		_tmp28_ = self->priv->text;
#line 187 "src/buffer.vala"
		_tmp29_ = region_get_end (r);
#line 187 "src/buffer.vala"
		_tmp30_ = _tmp29_;
#line 187 "src/buffer.vala"
		_tmp31_ = immutable_estr_substring ((ImmutableEstr*) _tmp28_, self->priv->gap + from, _tmp30_ - from);
#line 187 "src/buffer.vala"
		_tmp32_ = _tmp31_;
#line 187 "src/buffer.vala"
		estr_cat (_tmp27_, _tmp32_);
#line 187 "src/buffer.vala"
		_immutable_estr_unref0 (_tmp32_);
#line 1268 "buffer.c"
	}
#line 189 "src/buffer.vala"
	result = (ImmutableEstr*) es;
#line 189 "src/buffer.vala"
	return result;
#line 1274 "buffer.c"
}

gboolean
buffer_insert_estr (Buffer* self,
                    ImmutableEstr* es)
{
	gboolean result = FALSE;
#line 199 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 199 "src/buffer.vala"
	g_return_val_if_fail (es != NULL, FALSE);
#line 200 "src/buffer.vala"
	result = buffer_replace_estr (self, (gsize) 0, es);
#line 200 "src/buffer.vala"
	return result;
#line 1290 "buffer.c"
}

gboolean
buffer_is_empty_line (Buffer* self)
{
	gsize _tmp0_;
	gsize _tmp1_;
	gboolean result = FALSE;
#line 203 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 204 "src/buffer.vala"
	_tmp0_ = buffer_get_pt (self);
#line 204 "src/buffer.vala"
	_tmp1_ = _tmp0_;
#line 204 "src/buffer.vala"
	result = buffer_line_len (self, _tmp1_) == ((gsize) 0);
#line 204 "src/buffer.vala"
	return result;
#line 1309 "buffer.c"
}

gboolean
buffer_is_blank_line (Buffer* self)
{
	gboolean result = FALSE;
#line 207 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1318 "buffer.c"
	{
		gsize i = 0UL;
#line 208 "src/buffer.vala"
		i = (gsize) 0;
#line 1323 "buffer.c"
		{
			gboolean _tmp0_ = FALSE;
#line 208 "src/buffer.vala"
			_tmp0_ = TRUE;
#line 208 "src/buffer.vala"
			while (TRUE) {
#line 1330 "buffer.c"
				gsize _tmp2_;
				gsize _tmp3_;
				gchar c = '\0';
				gboolean _tmp4_ = FALSE;
#line 208 "src/buffer.vala"
				if (!_tmp0_) {
#line 1337 "buffer.c"
					gsize _tmp1_;
#line 208 "src/buffer.vala"
					_tmp1_ = i;
#line 208 "src/buffer.vala"
					i = _tmp1_ + 1;
#line 1343 "buffer.c"
				}
#line 208 "src/buffer.vala"
				_tmp0_ = FALSE;
#line 208 "src/buffer.vala"
				_tmp2_ = buffer_get_pt (self);
#line 208 "src/buffer.vala"
				_tmp3_ = _tmp2_;
#line 208 "src/buffer.vala"
				if (!(i < buffer_line_len (self, _tmp3_))) {
#line 208 "src/buffer.vala"
					break;
#line 1355 "buffer.c"
				}
#line 210 "src/buffer.vala"
				c = buffer_get_char (self, buffer_line_o (self) + i);
#line 211 "src/buffer.vala"
				if (c != ' ') {
#line 211 "src/buffer.vala"
					_tmp4_ = c != '\t';
#line 1363 "buffer.c"
				} else {
#line 211 "src/buffer.vala"
					_tmp4_ = FALSE;
#line 1367 "buffer.c"
				}
#line 211 "src/buffer.vala"
				if (_tmp4_) {
#line 212 "src/buffer.vala"
					result = FALSE;
#line 212 "src/buffer.vala"
					return result;
#line 1375 "buffer.c"
				}
			}
		}
	}
#line 214 "src/buffer.vala"
	result = TRUE;
#line 214 "src/buffer.vala"
	return result;
#line 1384 "buffer.c"
}

gchar
buffer_following_char (Buffer* self)
{
	gchar result = '\0';
#line 218 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 219 "src/buffer.vala"
	if (buffer_eobp (self)) {
#line 220 "src/buffer.vala"
		result = (gchar) 0;
#line 220 "src/buffer.vala"
		return result;
#line 1399 "buffer.c"
	} else {
#line 221 "src/buffer.vala"
		if (buffer_eolp (self)) {
#line 222 "src/buffer.vala"
			result = '\n';
#line 222 "src/buffer.vala"
			return result;
#line 1407 "buffer.c"
		} else {
			gsize _tmp0_;
			gsize _tmp1_;
#line 224 "src/buffer.vala"
			_tmp0_ = buffer_get_pt (self);
#line 224 "src/buffer.vala"
			_tmp1_ = _tmp0_;
#line 224 "src/buffer.vala"
			result = buffer_get_char (self, _tmp1_);
#line 224 "src/buffer.vala"
			return result;
#line 1419 "buffer.c"
		}
	}
}

gchar
buffer_preceding_char (Buffer* self)
{
	gchar result = '\0';
#line 228 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 229 "src/buffer.vala"
	if (buffer_bobp (self)) {
#line 230 "src/buffer.vala"
		result = (gchar) 0;
#line 230 "src/buffer.vala"
		return result;
#line 1436 "buffer.c"
	} else {
#line 231 "src/buffer.vala"
		if (buffer_bolp (self)) {
#line 232 "src/buffer.vala"
			result = '\n';
#line 232 "src/buffer.vala"
			return result;
#line 1444 "buffer.c"
		} else {
			gsize _tmp0_;
			gsize _tmp1_;
#line 234 "src/buffer.vala"
			_tmp0_ = buffer_get_pt (self);
#line 234 "src/buffer.vala"
			_tmp1_ = _tmp0_;
#line 234 "src/buffer.vala"
			result = buffer_get_char (self, _tmp1_ - 1);
#line 234 "src/buffer.vala"
			return result;
#line 1456 "buffer.c"
		}
	}
}

gboolean
buffer_bobp (Buffer* self)
{
	gsize _tmp0_;
	gsize _tmp1_;
	gboolean result = FALSE;
#line 238 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 239 "src/buffer.vala"
	_tmp0_ = buffer_get_pt (self);
#line 239 "src/buffer.vala"
	_tmp1_ = _tmp0_;
#line 239 "src/buffer.vala"
	result = _tmp1_ == ((gsize) 0);
#line 239 "src/buffer.vala"
	return result;
#line 1477 "buffer.c"
}

gboolean
buffer_eobp (Buffer* self)
{
	gsize _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	gboolean result = FALSE;
#line 243 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 244 "src/buffer.vala"
	_tmp0_ = buffer_get_pt (self);
#line 244 "src/buffer.vala"
	_tmp1_ = _tmp0_;
#line 244 "src/buffer.vala"
	_tmp2_ = buffer_get_length (self);
#line 244 "src/buffer.vala"
	_tmp3_ = _tmp2_;
#line 244 "src/buffer.vala"
	result = _tmp1_ == _tmp3_;
#line 244 "src/buffer.vala"
	return result;
#line 1502 "buffer.c"
}

gboolean
buffer_bolp (Buffer* self)
{
	gsize _tmp0_;
	gsize _tmp1_;
	gboolean result = FALSE;
#line 248 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 249 "src/buffer.vala"
	_tmp0_ = buffer_get_pt (self);
#line 249 "src/buffer.vala"
	_tmp1_ = _tmp0_;
#line 249 "src/buffer.vala"
	result = _tmp1_ == buffer_line_o (self);
#line 249 "src/buffer.vala"
	return result;
#line 1521 "buffer.c"
}

gboolean
buffer_eolp (Buffer* self)
{
	gsize _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	gboolean result = FALSE;
#line 253 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 254 "src/buffer.vala"
	_tmp0_ = buffer_get_pt (self);
#line 254 "src/buffer.vala"
	_tmp1_ = _tmp0_;
#line 254 "src/buffer.vala"
	_tmp2_ = buffer_get_pt (self);
#line 254 "src/buffer.vala"
	_tmp3_ = _tmp2_;
#line 254 "src/buffer.vala"
	result = (_tmp1_ - buffer_line_o (self)) == buffer_line_len (self, _tmp3_);
#line 254 "src/buffer.vala"
	return result;
#line 1546 "buffer.c"
}

gboolean
buffer_insert_char (Buffer* self,
                    gchar c)
{
	ImmutableEstr* _tmp0_;
	ImmutableEstr* _tmp1_;
	gboolean _tmp2_;
	gboolean result = FALSE;
#line 260 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 261 "src/buffer.vala"
	_tmp0_ = immutable_estr_of ((const gchar*) (&c), (gsize) 1, IMMUTABLE_ESTR_eol_lf);
#line 261 "src/buffer.vala"
	_tmp1_ = _tmp0_;
#line 261 "src/buffer.vala"
	_tmp2_ = buffer_insert_estr (self, _tmp1_);
#line 261 "src/buffer.vala"
	_immutable_estr_unref0 (_tmp1_);
#line 261 "src/buffer.vala"
	result = _tmp2_;
#line 261 "src/buffer.vala"
	return result;
#line 1571 "buffer.c"
}

gboolean
buffer_delete_char (Buffer* self)
{
	gboolean result = FALSE;
#line 264 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 265 "src/buffer.vala"
	self->mark_active = FALSE;
#line 267 "src/buffer.vala"
	if (buffer_eobp (self)) {
#line 268 "src/buffer.vala"
		minibuf_error ("End of buffer", NULL);
#line 269 "src/buffer.vala"
		result = FALSE;
#line 269 "src/buffer.vala"
		return result;
#line 1590 "buffer.c"
	}
#line 272 "src/buffer.vala"
	if (buffer_warn_if_readonly (self)) {
#line 273 "src/buffer.vala"
		result = FALSE;
#line 273 "src/buffer.vala"
		return result;
#line 1598 "buffer.c"
	}
#line 275 "src/buffer.vala"
	if (buffer_eolp (self)) {
#line 1602 "buffer.c"
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		ImmutableEstr* _tmp4_;
		Flags _tmp5_;
#line 276 "src/buffer.vala"
		_tmp0_ = buffer_get_eol (self);
#line 276 "src/buffer.vala"
		_tmp1_ = _tmp0_;
#line 276 "src/buffer.vala"
		_tmp2_ = strlen (_tmp1_);
#line 276 "src/buffer.vala"
		_tmp3_ = _tmp2_;
#line 276 "src/buffer.vala"
		_tmp4_ = immutable_estr_empty;
#line 276 "src/buffer.vala"
		buffer_replace_estr (self, (gsize) _tmp3_, _tmp4_);
#line 277 "src/buffer.vala"
		_tmp5_ = thisflag;
#line 277 "src/buffer.vala"
		thisflag = _tmp5_ | FLAGS_NEED_RESYNC;
#line 1625 "buffer.c"
	} else {
		ImmutableEstr* _tmp6_;
#line 279 "src/buffer.vala"
		_tmp6_ = immutable_estr_empty;
#line 279 "src/buffer.vala"
		buffer_replace_estr (self, (gsize) 1, _tmp6_);
#line 1632 "buffer.c"
	}
#line 280 "src/buffer.vala"
	self->modified = TRUE;
#line 282 "src/buffer.vala"
	result = TRUE;
#line 282 "src/buffer.vala"
	return result;
#line 1640 "buffer.c"
}

gboolean
buffer_backward_delete_char (Buffer* self)
{
	gboolean result = FALSE;
#line 285 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 286 "src/buffer.vala"
	self->mark_active = FALSE;
#line 288 "src/buffer.vala"
	if (!buffer_move_char (self, (glong) -1)) {
#line 289 "src/buffer.vala"
		minibuf_error ("Beginning of buffer", NULL);
#line 290 "src/buffer.vala"
		result = FALSE;
#line 290 "src/buffer.vala"
		return result;
#line 1659 "buffer.c"
	}
#line 293 "src/buffer.vala"
	buffer_delete_char (self);
#line 294 "src/buffer.vala"
	result = TRUE;
#line 294 "src/buffer.vala"
	return result;
#line 1667 "buffer.c"
}

static void
buffer_insert_half_buffer (Buffer* self,
                           Buffer* bp,
                           ImmutableEstr* es)
{
#line 297 "src/buffer.vala"
	g_return_if_fail (self != NULL);
#line 297 "src/buffer.vala"
	g_return_if_fail (bp != NULL);
#line 297 "src/buffer.vala"
	g_return_if_fail (es != NULL);
#line 299 "src/buffer.vala"
	if (bp != self) {
#line 300 "src/buffer.vala"
		buffer_insert_estr (self, es);
#line 1685 "buffer.c"
	} else {
		Estr* _tmp0_;
		Estr* _tmp1_;
#line 302 "src/buffer.vala"
		_tmp0_ = estr_copy (es);
#line 302 "src/buffer.vala"
		_tmp1_ = _tmp0_;
#line 302 "src/buffer.vala"
		buffer_insert_estr (self, (ImmutableEstr*) _tmp1_);
#line 302 "src/buffer.vala"
		_immutable_estr_unref0 (_tmp1_);
#line 1697 "buffer.c"
	}
}

void
buffer_insert_buffer (Buffer* self,
                      Buffer* bp)
{
	ImmutableEstr* _tmp0_;
	ImmutableEstr* _tmp1_;
	ImmutableEstr* _tmp2_;
	ImmutableEstr* _tmp3_;
#line 305 "src/buffer.vala"
	g_return_if_fail (self != NULL);
#line 305 "src/buffer.vala"
	g_return_if_fail (bp != NULL);
#line 306 "src/buffer.vala"
	_tmp0_ = buffer_pre_point (bp);
#line 306 "src/buffer.vala"
	_tmp1_ = _tmp0_;
#line 306 "src/buffer.vala"
	buffer_insert_half_buffer (self, bp, _tmp1_);
#line 306 "src/buffer.vala"
	_immutable_estr_unref0 (_tmp1_);
#line 307 "src/buffer.vala"
	_tmp2_ = buffer_post_point (bp);
#line 307 "src/buffer.vala"
	_tmp3_ = _tmp2_;
#line 307 "src/buffer.vala"
	buffer_insert_half_buffer (self, bp, _tmp3_);
#line 307 "src/buffer.vala"
	_immutable_estr_unref0 (_tmp3_);
#line 1729 "buffer.c"
}

void
buffer_init (Buffer* self)
{
#line 321 "src/buffer.vala"
	g_return_if_fail (self != NULL);
#line 322 "src/buffer.vala"
	if (get_variable_bool ("auto-fill-mode")) {
#line 323 "src/buffer.vala"
		self->autofill = TRUE;
#line 1741 "buffer.c"
	}
}

gchar*
buffer_get_filename_or_name (Buffer* self)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 329 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 330 "src/buffer.vala"
	_tmp1_ = self->filename;
#line 330 "src/buffer.vala"
	_tmp0_ = _tmp1_;
#line 330 "src/buffer.vala"
	if (_tmp0_ == NULL) {
#line 1760 "buffer.c"
		const gchar* _tmp2_;
#line 330 "src/buffer.vala"
		_tmp2_ = self->name;
#line 330 "src/buffer.vala"
		_tmp0_ = _tmp2_;
#line 1766 "buffer.c"
	}
#line 330 "src/buffer.vala"
	_tmp3_ = g_strdup (_tmp0_);
#line 330 "src/buffer.vala"
	result = _tmp3_;
#line 330 "src/buffer.vala"
	return result;
#line 1774 "buffer.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1232 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1233 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1233 "glib-2.0.vapi"
	result = _tmp0_;
#line 1233 "glib-2.0.vapi"
	return result;
#line 1791 "buffer.c"
}

void
buffer_set_names (Buffer* self,
                  const gchar* new_filename)
{
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* new_name = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
#line 336 "src/buffer.vala"
	g_return_if_fail (self != NULL);
#line 336 "src/buffer.vala"
	g_return_if_fail (new_filename != NULL);
#line 337 "src/buffer.vala"
	_tmp0_ = g_strdup (new_filename);
#line 337 "src/buffer.vala"
	_g_free0 (self->filename);
#line 337 "src/buffer.vala"
	self->filename = _tmp0_;
#line 338 "src/buffer.vala"
	_tmp1_ = self->filename;
#line 338 "src/buffer.vala"
	if (string_get (_tmp1_, (glong) 0) != '/') {
#line 1819 "buffer.c"
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 339 "src/buffer.vala"
		_tmp2_ = g_get_current_dir ();
#line 339 "src/buffer.vala"
		_tmp3_ = _tmp2_;
#line 339 "src/buffer.vala"
		_tmp4_ = self->filename;
#line 339 "src/buffer.vala"
		_tmp5_ = g_build_filename (_tmp3_, _tmp4_, NULL);
#line 339 "src/buffer.vala"
		_g_free0 (self->filename);
#line 339 "src/buffer.vala"
		self->filename = _tmp5_;
#line 339 "src/buffer.vala"
		_g_free0 (_tmp3_);
#line 1838 "buffer.c"
	}
#line 341 "src/buffer.vala"
	_tmp6_ = self->filename;
#line 341 "src/buffer.vala"
	_tmp7_ = g_path_get_basename (_tmp6_);
#line 341 "src/buffer.vala"
	new_name = _tmp7_;
#line 1846 "buffer.c"
	{
		gsize i = 0UL;
#line 343 "src/buffer.vala"
		i = (gsize) 2;
#line 1851 "buffer.c"
		{
			gboolean _tmp8_ = FALSE;
#line 343 "src/buffer.vala"
			_tmp8_ = TRUE;
#line 343 "src/buffer.vala"
			while (TRUE) {
#line 1858 "buffer.c"
				const gchar* _tmp10_;
				Buffer* _tmp11_;
				Buffer* _tmp12_;
				gboolean _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
#line 343 "src/buffer.vala"
				if (!_tmp8_) {
#line 1871 "buffer.c"
					gsize _tmp9_;
#line 343 "src/buffer.vala"
					_tmp9_ = i;
#line 343 "src/buffer.vala"
					i = _tmp9_ + 1;
#line 1877 "buffer.c"
				}
#line 343 "src/buffer.vala"
				_tmp8_ = FALSE;
#line 343 "src/buffer.vala"
				_tmp10_ = new_name;
#line 343 "src/buffer.vala"
				_tmp11_ = buffer_find (_tmp10_);
#line 343 "src/buffer.vala"
				_tmp12_ = _tmp11_;
#line 343 "src/buffer.vala"
				_tmp13_ = !(_tmp12_ != NULL);
#line 343 "src/buffer.vala"
				_buffer_unref0 (_tmp12_);
#line 343 "src/buffer.vala"
				if (_tmp13_) {
#line 343 "src/buffer.vala"
					break;
#line 1895 "buffer.c"
				}
#line 344 "src/buffer.vala"
				_tmp14_ = new_name;
#line 344 "src/buffer.vala"
				_tmp15_ = g_strdup_printf ("%" G_GSIZE_FORMAT, i);
#line 344 "src/buffer.vala"
				_tmp16_ = _tmp15_;
#line 344 "src/buffer.vala"
				_tmp17_ = g_strconcat ("<", _tmp16_, ">", NULL);
#line 344 "src/buffer.vala"
				_tmp18_ = _tmp17_;
#line 344 "src/buffer.vala"
				_tmp19_ = g_strconcat (_tmp14_, _tmp18_, NULL);
#line 344 "src/buffer.vala"
				_g_free0 (new_name);
#line 344 "src/buffer.vala"
				new_name = _tmp19_;
#line 344 "src/buffer.vala"
				_g_free0 (_tmp18_);
#line 344 "src/buffer.vala"
				_g_free0 (_tmp16_);
#line 1917 "buffer.c"
			}
		}
	}
#line 345 "src/buffer.vala"
	_tmp20_ = new_name;
#line 345 "src/buffer.vala"
	_tmp21_ = g_strdup (_tmp20_);
#line 345 "src/buffer.vala"
	_g_free0 (self->name);
#line 345 "src/buffer.vala"
	self->name = _tmp21_;
#line 336 "src/buffer.vala"
	_g_free0 (new_name);
#line 1931 "buffer.c"
}

const gchar*
buffer_get_variable (Buffer* self,
                     const gchar* name)
{
	VarEntry* v = NULL;
	VarEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	VarEntry* _tmp2_;
	const gchar* result = NULL;
#line 348 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 348 "src/buffer.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 349 "src/buffer.vala"
	_tmp0_ = get_variable_entry (self, name);
#line 349 "src/buffer.vala"
	v = _tmp0_;
#line 350 "src/buffer.vala"
	_tmp2_ = v;
#line 350 "src/buffer.vala"
	if (_tmp2_ != NULL) {
#line 1955 "buffer.c"
		VarEntry* _tmp3_;
		const gchar* _tmp4_;
#line 350 "src/buffer.vala"
		_tmp3_ = v;
#line 350 "src/buffer.vala"
		_tmp4_ = _tmp3_->val;
#line 350 "src/buffer.vala"
		_tmp1_ = _tmp4_;
#line 1964 "buffer.c"
	} else {
#line 350 "src/buffer.vala"
		_tmp1_ = NULL;
#line 1968 "buffer.c"
	}
#line 350 "src/buffer.vala"
	result = _tmp1_;
#line 350 "src/buffer.vala"
	_var_entry_unref0 (v);
#line 350 "src/buffer.vala"
	return result;
#line 1976 "buffer.c"
}

Buffer*
buffer_find (const gchar* name)
{
	Buffer* result = NULL;
#line 356 "src/buffer.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 1985 "buffer.c"
	{
		Buffer* bp = NULL;
		Buffer* _tmp0_;
		Buffer* _tmp1_;
#line 357 "src/buffer.vala"
		_tmp0_ = head_bp;
#line 357 "src/buffer.vala"
		_tmp1_ = _buffer_ref0 (_tmp0_);
#line 357 "src/buffer.vala"
		bp = _tmp1_;
#line 1996 "buffer.c"
		{
			gboolean _tmp2_ = FALSE;
#line 357 "src/buffer.vala"
			_tmp2_ = TRUE;
#line 357 "src/buffer.vala"
			while (TRUE) {
#line 2003 "buffer.c"
				Buffer* _tmp6_;
				gchar* bname = NULL;
				Buffer* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				const gchar* _tmp11_;
#line 357 "src/buffer.vala"
				if (!_tmp2_) {
#line 2013 "buffer.c"
					Buffer* _tmp3_;
					Buffer* _tmp4_;
					Buffer* _tmp5_;
#line 357 "src/buffer.vala"
					_tmp3_ = bp;
#line 357 "src/buffer.vala"
					_tmp4_ = _tmp3_->next;
#line 357 "src/buffer.vala"
					_tmp5_ = _buffer_ref0 (_tmp4_);
#line 357 "src/buffer.vala"
					_buffer_unref0 (bp);
#line 357 "src/buffer.vala"
					bp = _tmp5_;
#line 2027 "buffer.c"
				}
#line 357 "src/buffer.vala"
				_tmp2_ = FALSE;
#line 357 "src/buffer.vala"
				_tmp6_ = bp;
#line 357 "src/buffer.vala"
				if (!(_tmp6_ != NULL)) {
#line 357 "src/buffer.vala"
					break;
#line 2037 "buffer.c"
				}
#line 358 "src/buffer.vala"
				_tmp7_ = bp;
#line 358 "src/buffer.vala"
				_tmp8_ = _tmp7_->name;
#line 358 "src/buffer.vala"
				_tmp9_ = g_strdup (_tmp8_);
#line 358 "src/buffer.vala"
				bname = _tmp9_;
#line 359 "src/buffer.vala"
				_tmp11_ = bname;
#line 359 "src/buffer.vala"
				if (_tmp11_ != NULL) {
#line 2051 "buffer.c"
					const gchar* _tmp12_;
#line 359 "src/buffer.vala"
					_tmp12_ = bname;
#line 359 "src/buffer.vala"
					_tmp10_ = g_strcmp0 (_tmp12_, name) == 0;
#line 2057 "buffer.c"
				} else {
#line 359 "src/buffer.vala"
					_tmp10_ = FALSE;
#line 2061 "buffer.c"
				}
#line 359 "src/buffer.vala"
				if (_tmp10_) {
#line 360 "src/buffer.vala"
					result = bp;
#line 360 "src/buffer.vala"
					_g_free0 (bname);
#line 360 "src/buffer.vala"
					return result;
#line 2071 "buffer.c"
				}
#line 357 "src/buffer.vala"
				_g_free0 (bname);
#line 2075 "buffer.c"
			}
		}
#line 357 "src/buffer.vala"
		_buffer_unref0 (bp);
#line 2080 "buffer.c"
	}
#line 363 "src/buffer.vala"
	result = NULL;
#line 363 "src/buffer.vala"
	return result;
#line 2086 "buffer.c"
}

static void
buffer_move_to_head (Buffer* bp)
{
	Buffer* prev = NULL;
	Buffer* _tmp9_;
#line 369 "src/buffer.vala"
	g_return_if_fail (bp != NULL);
#line 370 "src/buffer.vala"
	prev = NULL;
#line 2098 "buffer.c"
	{
		Buffer* it = NULL;
		Buffer* _tmp0_;
		Buffer* _tmp1_;
#line 371 "src/buffer.vala"
		_tmp0_ = head_bp;
#line 371 "src/buffer.vala"
		_tmp1_ = _buffer_ref0 (_tmp0_);
#line 371 "src/buffer.vala"
		it = _tmp1_;
#line 2109 "buffer.c"
		{
			gboolean _tmp2_ = FALSE;
#line 371 "src/buffer.vala"
			_tmp2_ = TRUE;
#line 371 "src/buffer.vala"
			while (TRUE) {
#line 2116 "buffer.c"
				Buffer* _tmp8_;
#line 371 "src/buffer.vala"
				if (!_tmp2_) {
#line 2120 "buffer.c"
					Buffer* _tmp3_;
					Buffer* _tmp4_;
					Buffer* _tmp5_;
					Buffer* _tmp6_;
					Buffer* _tmp7_;
#line 371 "src/buffer.vala"
					_tmp3_ = it;
#line 371 "src/buffer.vala"
					_tmp4_ = _buffer_ref0 (_tmp3_);
#line 371 "src/buffer.vala"
					_buffer_unref0 (prev);
#line 371 "src/buffer.vala"
					prev = _tmp4_;
#line 371 "src/buffer.vala"
					_tmp5_ = it;
#line 371 "src/buffer.vala"
					_tmp6_ = _tmp5_->next;
#line 371 "src/buffer.vala"
					_tmp7_ = _buffer_ref0 (_tmp6_);
#line 371 "src/buffer.vala"
					_buffer_unref0 (it);
#line 371 "src/buffer.vala"
					it = _tmp7_;
#line 2144 "buffer.c"
				}
#line 371 "src/buffer.vala"
				_tmp2_ = FALSE;
#line 371 "src/buffer.vala"
				_tmp8_ = it;
#line 371 "src/buffer.vala"
				if (!(_tmp8_ != bp)) {
#line 371 "src/buffer.vala"
					break;
#line 2154 "buffer.c"
				}
			}
		}
#line 371 "src/buffer.vala"
		_buffer_unref0 (it);
#line 2160 "buffer.c"
	}
#line 373 "src/buffer.vala"
	_tmp9_ = prev;
#line 373 "src/buffer.vala"
	if (_tmp9_ != NULL) {
#line 2166 "buffer.c"
		Buffer* _tmp10_;
		Buffer* _tmp11_;
		Buffer* _tmp12_;
		Buffer* _tmp13_;
		Buffer* _tmp14_;
		Buffer* _tmp15_;
#line 374 "src/buffer.vala"
		_tmp10_ = prev;
#line 374 "src/buffer.vala"
		_tmp11_ = bp->next;
#line 374 "src/buffer.vala"
		_tmp12_ = _buffer_ref0 (_tmp11_);
#line 374 "src/buffer.vala"
		_buffer_unref0 (_tmp10_->next);
#line 374 "src/buffer.vala"
		_tmp10_->next = _tmp12_;
#line 375 "src/buffer.vala"
		_tmp13_ = head_bp;
#line 375 "src/buffer.vala"
		_tmp14_ = _buffer_ref0 (_tmp13_);
#line 375 "src/buffer.vala"
		_buffer_unref0 (bp->next);
#line 375 "src/buffer.vala"
		bp->next = _tmp14_;
#line 376 "src/buffer.vala"
		_tmp15_ = _buffer_ref0 (bp);
#line 376 "src/buffer.vala"
		_buffer_unref0 (head_bp);
#line 376 "src/buffer.vala"
		head_bp = _tmp15_;
#line 2197 "buffer.c"
	}
#line 369 "src/buffer.vala"
	_buffer_unref0 (prev);
#line 2201 "buffer.c"
}

void
buffer_switch_to (Buffer* self)
{
	Window* _tmp0_;
	Buffer* _tmp1_;
	Buffer* _tmp2_;
	Buffer* _tmp3_;
	Buffer* _tmp4_;
	Window* _tmp5_;
	Buffer* _tmp6_;
	Buffer* _tmp7_;
	const gchar* _tmp8_;
	Flags _tmp9_;
#line 383 "src/buffer.vala"
	g_return_if_fail (self != NULL);
#line 384 "src/buffer.vala"
	_tmp0_ = cur_wp;
#line 384 "src/buffer.vala"
	_tmp1_ = _tmp0_->bp;
#line 384 "src/buffer.vala"
	_tmp2_ = cur_bp;
#line 384 "src/buffer.vala"
	_vala_assert (_tmp1_ == _tmp2_, "cur_wp.bp == cur_bp");
#line 387 "src/buffer.vala"
	_tmp3_ = cur_bp;
#line 387 "src/buffer.vala"
	if (_tmp3_ == self) {
#line 388 "src/buffer.vala"
		return;
#line 2233 "buffer.c"
	}
#line 391 "src/buffer.vala"
	_tmp4_ = _buffer_ref0 (self);
#line 391 "src/buffer.vala"
	_buffer_unref0 (cur_bp);
#line 391 "src/buffer.vala"
	cur_bp = _tmp4_;
#line 392 "src/buffer.vala"
	_tmp5_ = cur_wp;
#line 392 "src/buffer.vala"
	_tmp6_ = cur_bp;
#line 392 "src/buffer.vala"
	_tmp7_ = _buffer_ref0 (_tmp6_);
#line 392 "src/buffer.vala"
	_buffer_unref0 (_tmp5_->bp);
#line 392 "src/buffer.vala"
	_tmp5_->bp = _tmp7_;
#line 395 "src/buffer.vala"
	buffer_move_to_head (self);
#line 398 "src/buffer.vala"
	_tmp8_ = self->dir;
#line 398 "src/buffer.vala"
	if (chdir (_tmp8_) != 0) {
#line 2257 "buffer.c"
	}
#line 400 "src/buffer.vala"
	_tmp9_ = thisflag;
#line 400 "src/buffer.vala"
	thisflag = _tmp9_ | FLAGS_NEED_RESYNC;
#line 2263 "buffer.c"
}

gboolean
buffer_warn_if_readonly (Buffer* self)
{
	gboolean result = FALSE;
#line 407 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 408 "src/buffer.vala"
	if (self->readonly) {
#line 2274 "buffer.c"
		const gchar* _tmp0_;
#line 409 "src/buffer.vala"
		_tmp0_ = self->name;
#line 409 "src/buffer.vala"
		minibuf_error ("Buffer is readonly: %s", _tmp0_, NULL);
#line 410 "src/buffer.vala"
		result = TRUE;
#line 410 "src/buffer.vala"
		return result;
#line 2284 "buffer.c"
	}
#line 412 "src/buffer.vala"
	result = FALSE;
#line 412 "src/buffer.vala"
	return result;
#line 2290 "buffer.c"
}

gboolean
buffer_warn_if_no_mark (Buffer* self)
{
	Marker* _tmp0_;
	gboolean result = FALSE;
#line 415 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 416 "src/buffer.vala"
	_tmp0_ = self->mark;
#line 416 "src/buffer.vala"
	if (_tmp0_ == NULL) {
#line 417 "src/buffer.vala"
		minibuf_error ("The mark is not set now", NULL);
#line 418 "src/buffer.vala"
		result = TRUE;
#line 418 "src/buffer.vala"
		return result;
#line 2310 "buffer.c"
	} else {
#line 419 "src/buffer.vala"
		if (!self->mark_active) {
#line 420 "src/buffer.vala"
			minibuf_error ("The mark is not active now", NULL);
#line 421 "src/buffer.vala"
			result = TRUE;
#line 421 "src/buffer.vala"
			return result;
#line 2320 "buffer.c"
		}
	}
#line 423 "src/buffer.vala"
	result = FALSE;
#line 423 "src/buffer.vala"
	return result;
#line 2327 "buffer.c"
}

void
buffer_set_temporary (Buffer* self)
{
	Buffer* _tmp0_;
	Buffer* bp = NULL;
	Buffer* _tmp21_;
	Buffer* _tmp30_;
	Buffer* _tmp31_;
#line 430 "src/buffer.vala"
	g_return_if_fail (self != NULL);
#line 431 "src/buffer.vala"
	self->temporary = TRUE;
#line 433 "src/buffer.vala"
	_tmp0_ = head_bp;
#line 433 "src/buffer.vala"
	if (self == _tmp0_) {
#line 2346 "buffer.c"
		Buffer* _tmp1_;
		Buffer* _tmp2_;
		Buffer* _tmp3_;
		Buffer* _tmp4_;
		Buffer* _tmp5_;
#line 434 "src/buffer.vala"
		_tmp1_ = head_bp;
#line 434 "src/buffer.vala"
		_tmp2_ = _tmp1_->next;
#line 434 "src/buffer.vala"
		if (_tmp2_ == NULL) {
#line 435 "src/buffer.vala"
			return;
#line 2360 "buffer.c"
		}
#line 436 "src/buffer.vala"
		_tmp3_ = head_bp;
#line 436 "src/buffer.vala"
		_tmp4_ = _tmp3_->next;
#line 436 "src/buffer.vala"
		_tmp5_ = _buffer_ref0 (_tmp4_);
#line 436 "src/buffer.vala"
		_buffer_unref0 (head_bp);
#line 436 "src/buffer.vala"
		head_bp = _tmp5_;
#line 2372 "buffer.c"
	} else {
		Buffer* _tmp6_;
#line 437 "src/buffer.vala"
		_tmp6_ = self->next;
#line 437 "src/buffer.vala"
		if (_tmp6_ == NULL) {
#line 438 "src/buffer.vala"
			return;
#line 2381 "buffer.c"
		}
	}
	{
		Buffer* _tmp7_;
		Buffer* _tmp8_;
		gboolean _tmp9_ = FALSE;
#line 441 "src/buffer.vala"
		_tmp7_ = head_bp;
#line 441 "src/buffer.vala"
		_tmp8_ = _buffer_ref0 (_tmp7_);
#line 441 "src/buffer.vala"
		_buffer_unref0 (bp);
#line 441 "src/buffer.vala"
		bp = _tmp8_;
#line 441 "src/buffer.vala"
		_tmp9_ = TRUE;
#line 441 "src/buffer.vala"
		while (TRUE) {
#line 2400 "buffer.c"
			Buffer* _tmp13_;
			Buffer* _tmp14_;
			Buffer* _tmp15_;
#line 441 "src/buffer.vala"
			if (!_tmp9_) {
#line 2406 "buffer.c"
				Buffer* _tmp10_;
				Buffer* _tmp11_;
				Buffer* _tmp12_;
#line 441 "src/buffer.vala"
				_tmp10_ = bp;
#line 441 "src/buffer.vala"
				_tmp11_ = _tmp10_->next;
#line 441 "src/buffer.vala"
				_tmp12_ = _buffer_ref0 (_tmp11_);
#line 441 "src/buffer.vala"
				_buffer_unref0 (bp);
#line 441 "src/buffer.vala"
				bp = _tmp12_;
#line 2420 "buffer.c"
			}
#line 441 "src/buffer.vala"
			_tmp9_ = FALSE;
#line 441 "src/buffer.vala"
			_tmp13_ = bp;
#line 441 "src/buffer.vala"
			if (!(_tmp13_ != NULL)) {
#line 441 "src/buffer.vala"
				break;
#line 2430 "buffer.c"
			}
#line 442 "src/buffer.vala"
			_tmp14_ = bp;
#line 442 "src/buffer.vala"
			_tmp15_ = _tmp14_->next;
#line 442 "src/buffer.vala"
			if (_tmp15_ == self) {
#line 2438 "buffer.c"
				Buffer* _tmp16_;
				Buffer* _tmp17_;
				Buffer* _tmp18_;
				Buffer* _tmp19_;
				Buffer* _tmp20_;
#line 443 "src/buffer.vala"
				_tmp16_ = bp;
#line 443 "src/buffer.vala"
				_tmp17_ = bp;
#line 443 "src/buffer.vala"
				_tmp18_ = _tmp17_->next;
#line 443 "src/buffer.vala"
				_tmp19_ = _tmp18_->next;
#line 443 "src/buffer.vala"
				_tmp20_ = _buffer_ref0 (_tmp19_);
#line 443 "src/buffer.vala"
				_buffer_unref0 (_tmp16_->next);
#line 443 "src/buffer.vala"
				_tmp16_->next = _tmp20_;
#line 444 "src/buffer.vala"
				break;
#line 2460 "buffer.c"
			}
		}
	}
#line 447 "src/buffer.vala"
	_tmp21_ = head_bp;
#line 447 "src/buffer.vala"
	_vala_assert (_tmp21_ != NULL, "head_bp != null");
#line 2468 "buffer.c"
	{
		Buffer* _tmp22_;
		Buffer* _tmp23_;
		gboolean _tmp24_ = FALSE;
#line 448 "src/buffer.vala"
		_tmp22_ = head_bp;
#line 448 "src/buffer.vala"
		_tmp23_ = _buffer_ref0 (_tmp22_);
#line 448 "src/buffer.vala"
		_buffer_unref0 (bp);
#line 448 "src/buffer.vala"
		bp = _tmp23_;
#line 448 "src/buffer.vala"
		_tmp24_ = TRUE;
#line 448 "src/buffer.vala"
		while (TRUE) {
#line 2485 "buffer.c"
			Buffer* _tmp28_;
			Buffer* _tmp29_;
#line 448 "src/buffer.vala"
			if (!_tmp24_) {
#line 2490 "buffer.c"
				Buffer* _tmp25_;
				Buffer* _tmp26_;
				Buffer* _tmp27_;
#line 448 "src/buffer.vala"
				_tmp25_ = bp;
#line 448 "src/buffer.vala"
				_tmp26_ = _tmp25_->next;
#line 448 "src/buffer.vala"
				_tmp27_ = _buffer_ref0 (_tmp26_);
#line 448 "src/buffer.vala"
				_buffer_unref0 (bp);
#line 448 "src/buffer.vala"
				bp = _tmp27_;
#line 2504 "buffer.c"
			}
#line 448 "src/buffer.vala"
			_tmp24_ = FALSE;
#line 448 "src/buffer.vala"
			_tmp28_ = bp;
#line 448 "src/buffer.vala"
			_tmp29_ = _tmp28_->next;
#line 448 "src/buffer.vala"
			if (!(_tmp29_ != NULL)) {
#line 448 "src/buffer.vala"
				break;
#line 2516 "buffer.c"
			}
		}
	}
#line 451 "src/buffer.vala"
	_tmp30_ = bp;
#line 451 "src/buffer.vala"
	_tmp31_ = _buffer_ref0 (self);
#line 451 "src/buffer.vala"
	_buffer_unref0 (_tmp30_->next);
#line 451 "src/buffer.vala"
	_tmp30_->next = _tmp31_;
#line 452 "src/buffer.vala"
	_buffer_unref0 (self->next);
#line 452 "src/buffer.vala"
	self->next = NULL;
#line 430 "src/buffer.vala"
	_buffer_unref0 (bp);
#line 2534 "buffer.c"
}

static glong*
_long_dup (glong* self)
{
	glong* dup;
#line 461 "src/buffer.vala"
	dup = g_new0 (glong, 1);
#line 461 "src/buffer.vala"
	memcpy (dup, self, sizeof (glong));
#line 461 "src/buffer.vala"
	return dup;
#line 2547 "buffer.c"
}

static gpointer
__long_dup0 (gpointer self)
{
#line 461 "src/buffer.vala"
	return self ? _long_dup (self) : NULL;
#line 2555 "buffer.c"
}

gsize
buffer_tab_width (Buffer* self)
{
	glong* res = NULL;
	const gchar* _tmp0_;
	glong* _tmp1_;
	gboolean _tmp2_ = FALSE;
	glong* _tmp3_;
	glong* _tmp7_;
	gsize _tmp8_;
	gsize result = 0UL;
#line 458 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 459 "src/buffer.vala"
	_tmp0_ = buffer_get_variable (self, "tab-width");
#line 459 "src/buffer.vala"
	_tmp1_ = parse_number (_tmp0_);
#line 459 "src/buffer.vala"
	res = _tmp1_;
#line 460 "src/buffer.vala"
	_tmp3_ = res;
#line 460 "src/buffer.vala"
	if (_tmp3_ == NULL) {
#line 460 "src/buffer.vala"
		_tmp2_ = TRUE;
#line 2583 "buffer.c"
	} else {
		glong* _tmp4_;
#line 460 "src/buffer.vala"
		_tmp4_ = res;
#line 460 "src/buffer.vala"
		_tmp2_ = (*_tmp4_) < ((glong) 1);
#line 2590 "buffer.c"
	}
#line 460 "src/buffer.vala"
	if (_tmp2_) {
#line 2594 "buffer.c"
		glong _tmp5_;
		glong* _tmp6_;
#line 461 "src/buffer.vala"
		_tmp5_ = (glong) 8;
#line 461 "src/buffer.vala"
		_tmp6_ = __long_dup0 (&_tmp5_);
#line 461 "src/buffer.vala"
		_g_free0 (res);
#line 461 "src/buffer.vala"
		res = _tmp6_;
#line 2605 "buffer.c"
	}
#line 462 "src/buffer.vala"
	_tmp7_ = res;
#line 462 "src/buffer.vala"
	_tmp8_ = *_tmp7_;
#line 462 "src/buffer.vala"
	_g_free0 (_tmp7_);
#line 462 "src/buffer.vala"
	result = _tmp8_;
#line 462 "src/buffer.vala"
	return result;
#line 2617 "buffer.c"
}

static gpointer
_window_ref0 (gpointer self)
{
#line 481 "src/buffer.vala"
	return self ? window_ref (self) : NULL;
#line 2625 "buffer.c"
}

void
buffer_kill (Buffer* self)
{
	Buffer* next_bp = NULL;
	Buffer* _tmp0_;
	Buffer* _tmp20_;
	Buffer* _tmp23_;
	Buffer* _tmp44_;
#line 469 "src/buffer.vala"
	g_return_if_fail (self != NULL);
#line 471 "src/buffer.vala"
	_tmp0_ = self->next;
#line 471 "src/buffer.vala"
	if (_tmp0_ != NULL) {
#line 2642 "buffer.c"
		Buffer* _tmp1_;
		Buffer* _tmp2_;
#line 472 "src/buffer.vala"
		_tmp1_ = self->next;
#line 472 "src/buffer.vala"
		_tmp2_ = _buffer_ref0 (_tmp1_);
#line 472 "src/buffer.vala"
		_buffer_unref0 (next_bp);
#line 472 "src/buffer.vala"
		next_bp = _tmp2_;
#line 2653 "buffer.c"
	} else {
		Buffer* _tmp3_;
#line 474 "src/buffer.vala"
		_tmp3_ = head_bp;
#line 474 "src/buffer.vala"
		if (_tmp3_ == self) {
#line 475 "src/buffer.vala"
			_buffer_unref0 (next_bp);
#line 475 "src/buffer.vala"
			next_bp = NULL;
#line 2664 "buffer.c"
		} else {
			Buffer* _tmp4_;
			Buffer* _tmp5_;
#line 477 "src/buffer.vala"
			_tmp4_ = head_bp;
#line 477 "src/buffer.vala"
			_tmp5_ = _buffer_ref0 (_tmp4_);
#line 477 "src/buffer.vala"
			_buffer_unref0 (next_bp);
#line 477 "src/buffer.vala"
			next_bp = _tmp5_;
#line 2676 "buffer.c"
		}
	}
	{
		Window* wp = NULL;
		Window* _tmp6_;
		Window* _tmp7_;
#line 481 "src/buffer.vala"
		_tmp6_ = head_wp;
#line 481 "src/buffer.vala"
		_tmp7_ = _window_ref0 (_tmp6_);
#line 481 "src/buffer.vala"
		wp = _tmp7_;
#line 2689 "buffer.c"
		{
			gboolean _tmp8_ = FALSE;
#line 481 "src/buffer.vala"
			_tmp8_ = TRUE;
#line 481 "src/buffer.vala"
			while (TRUE) {
#line 2696 "buffer.c"
				Window* _tmp12_;
				Window* _tmp13_;
				Buffer* _tmp14_;
#line 481 "src/buffer.vala"
				if (!_tmp8_) {
#line 2702 "buffer.c"
					Window* _tmp9_;
					Window* _tmp10_;
					Window* _tmp11_;
#line 481 "src/buffer.vala"
					_tmp9_ = wp;
#line 481 "src/buffer.vala"
					_tmp10_ = _tmp9_->next;
#line 481 "src/buffer.vala"
					_tmp11_ = _window_ref0 (_tmp10_);
#line 481 "src/buffer.vala"
					_window_unref0 (wp);
#line 481 "src/buffer.vala"
					wp = _tmp11_;
#line 2716 "buffer.c"
				}
#line 481 "src/buffer.vala"
				_tmp8_ = FALSE;
#line 481 "src/buffer.vala"
				_tmp12_ = wp;
#line 481 "src/buffer.vala"
				if (!(_tmp12_ != NULL)) {
#line 481 "src/buffer.vala"
					break;
#line 2726 "buffer.c"
				}
#line 482 "src/buffer.vala"
				_tmp13_ = wp;
#line 482 "src/buffer.vala"
				_tmp14_ = _tmp13_->bp;
#line 482 "src/buffer.vala"
				if (_tmp14_ == self) {
#line 2734 "buffer.c"
					Window* _tmp15_;
					Buffer* _tmp16_;
					Buffer* _tmp17_;
					Window* _tmp18_;
					Window* _tmp19_;
#line 483 "src/buffer.vala"
					_tmp15_ = wp;
#line 483 "src/buffer.vala"
					_tmp16_ = next_bp;
#line 483 "src/buffer.vala"
					_tmp17_ = _buffer_ref0 (_tmp16_);
#line 483 "src/buffer.vala"
					_buffer_unref0 (_tmp15_->bp);
#line 483 "src/buffer.vala"
					_tmp15_->bp = _tmp17_;
#line 484 "src/buffer.vala"
					_tmp18_ = wp;
#line 484 "src/buffer.vala"
					_tmp18_->topdelta = (gsize) 0;
#line 485 "src/buffer.vala"
					_tmp19_ = wp;
#line 485 "src/buffer.vala"
					_marker_unref0 (_tmp19_->saved_pt);
#line 485 "src/buffer.vala"
					_tmp19_->saved_pt = NULL;
#line 2760 "buffer.c"
				}
			}
		}
#line 481 "src/buffer.vala"
		_window_unref0 (wp);
#line 2766 "buffer.c"
	}
#line 489 "src/buffer.vala"
	_tmp20_ = cur_bp;
#line 489 "src/buffer.vala"
	if (_tmp20_ == self) {
#line 2772 "buffer.c"
		Buffer* _tmp21_;
		Buffer* _tmp22_;
#line 490 "src/buffer.vala"
		_tmp21_ = next_bp;
#line 490 "src/buffer.vala"
		_tmp22_ = _buffer_ref0 (_tmp21_);
#line 490 "src/buffer.vala"
		_buffer_unref0 (cur_bp);
#line 490 "src/buffer.vala"
		cur_bp = _tmp22_;
#line 2783 "buffer.c"
	}
#line 491 "src/buffer.vala"
	_tmp23_ = head_bp;
#line 491 "src/buffer.vala"
	if (_tmp23_ == self) {
#line 2789 "buffer.c"
		Buffer* _tmp24_;
		Buffer* _tmp25_;
		Buffer* _tmp26_;
#line 492 "src/buffer.vala"
		_tmp24_ = head_bp;
#line 492 "src/buffer.vala"
		_tmp25_ = _tmp24_->next;
#line 492 "src/buffer.vala"
		_tmp26_ = _buffer_ref0 (_tmp25_);
#line 492 "src/buffer.vala"
		_buffer_unref0 (head_bp);
#line 492 "src/buffer.vala"
		head_bp = _tmp26_;
#line 2803 "buffer.c"
	}
	{
		Buffer* bp = NULL;
		Buffer* _tmp27_;
		Buffer* _tmp28_;
#line 493 "src/buffer.vala"
		_tmp27_ = head_bp;
#line 493 "src/buffer.vala"
		_tmp28_ = _buffer_ref0 (_tmp27_);
#line 493 "src/buffer.vala"
		bp = _tmp28_;
#line 2815 "buffer.c"
		{
			gboolean _tmp29_ = FALSE;
#line 493 "src/buffer.vala"
			_tmp29_ = TRUE;
#line 493 "src/buffer.vala"
			while (TRUE) {
#line 2822 "buffer.c"
				gboolean _tmp33_ = FALSE;
				Buffer* _tmp34_;
				Buffer* _tmp37_;
				Buffer* _tmp38_;
#line 493 "src/buffer.vala"
				if (!_tmp29_) {
#line 2829 "buffer.c"
					Buffer* _tmp30_;
					Buffer* _tmp31_;
					Buffer* _tmp32_;
#line 493 "src/buffer.vala"
					_tmp30_ = bp;
#line 493 "src/buffer.vala"
					_tmp31_ = _tmp30_->next;
#line 493 "src/buffer.vala"
					_tmp32_ = _buffer_ref0 (_tmp31_);
#line 493 "src/buffer.vala"
					_buffer_unref0 (bp);
#line 493 "src/buffer.vala"
					bp = _tmp32_;
#line 2843 "buffer.c"
				}
#line 493 "src/buffer.vala"
				_tmp29_ = FALSE;
#line 493 "src/buffer.vala"
				_tmp34_ = bp;
#line 493 "src/buffer.vala"
				if (_tmp34_ != NULL) {
#line 2851 "buffer.c"
					Buffer* _tmp35_;
					Buffer* _tmp36_;
#line 493 "src/buffer.vala"
					_tmp35_ = bp;
#line 493 "src/buffer.vala"
					_tmp36_ = _tmp35_->next;
#line 493 "src/buffer.vala"
					_tmp33_ = _tmp36_ != NULL;
#line 2860 "buffer.c"
				} else {
#line 493 "src/buffer.vala"
					_tmp33_ = FALSE;
#line 2864 "buffer.c"
				}
#line 493 "src/buffer.vala"
				if (!_tmp33_) {
#line 493 "src/buffer.vala"
					break;
#line 2870 "buffer.c"
				}
#line 494 "src/buffer.vala"
				_tmp37_ = bp;
#line 494 "src/buffer.vala"
				_tmp38_ = _tmp37_->next;
#line 494 "src/buffer.vala"
				if (_tmp38_ == self) {
#line 2878 "buffer.c"
					Buffer* _tmp39_;
					Buffer* _tmp40_;
					Buffer* _tmp41_;
					Buffer* _tmp42_;
					Buffer* _tmp43_;
#line 495 "src/buffer.vala"
					_tmp39_ = bp;
#line 495 "src/buffer.vala"
					_tmp40_ = bp;
#line 495 "src/buffer.vala"
					_tmp41_ = _tmp40_->next;
#line 495 "src/buffer.vala"
					_tmp42_ = _tmp41_->next;
#line 495 "src/buffer.vala"
					_tmp43_ = _buffer_ref0 (_tmp42_);
#line 495 "src/buffer.vala"
					_buffer_unref0 (_tmp39_->next);
#line 495 "src/buffer.vala"
					_tmp39_->next = _tmp43_;
#line 496 "src/buffer.vala"
					break;
#line 2900 "buffer.c"
				}
			}
		}
#line 493 "src/buffer.vala"
		_buffer_unref0 (bp);
#line 2906 "buffer.c"
	}
#line 501 "src/buffer.vala"
	_tmp44_ = next_bp;
#line 501 "src/buffer.vala"
	if (_tmp44_ == NULL) {
#line 2912 "buffer.c"
		Buffer* _tmp45_;
		Buffer* _tmp46_;
		Buffer* _tmp47_;
		Buffer* _tmp48_;
		Buffer* _tmp49_;
#line 502 "src/buffer.vala"
		_tmp45_ = create_scratch_buffer ();
#line 502 "src/buffer.vala"
		_buffer_unref0 (next_bp);
#line 502 "src/buffer.vala"
		next_bp = _tmp45_;
#line 502 "src/buffer.vala"
		_tmp46_ = next_bp;
#line 502 "src/buffer.vala"
		_tmp47_ = _buffer_ref0 (_tmp46_);
#line 502 "src/buffer.vala"
		_buffer_unref0 (head_bp);
#line 502 "src/buffer.vala"
		head_bp = _tmp47_;
#line 502 "src/buffer.vala"
		_tmp48_ = head_bp;
#line 502 "src/buffer.vala"
		_tmp49_ = _buffer_ref0 (_tmp48_);
#line 502 "src/buffer.vala"
		_buffer_unref0 (cur_bp);
#line 502 "src/buffer.vala"
		cur_bp = _tmp49_;
#line 2940 "buffer.c"
		{
			Window* wp = NULL;
			Window* _tmp50_;
			Window* _tmp51_;
#line 503 "src/buffer.vala"
			_tmp50_ = head_wp;
#line 503 "src/buffer.vala"
			_tmp51_ = _window_ref0 (_tmp50_);
#line 503 "src/buffer.vala"
			wp = _tmp51_;
#line 2951 "buffer.c"
			{
				gboolean _tmp52_ = FALSE;
#line 503 "src/buffer.vala"
				_tmp52_ = TRUE;
#line 503 "src/buffer.vala"
				while (TRUE) {
#line 2958 "buffer.c"
					Window* _tmp56_;
					Window* _tmp57_;
					Buffer* _tmp58_;
					Buffer* _tmp59_;
#line 503 "src/buffer.vala"
					if (!_tmp52_) {
#line 2965 "buffer.c"
						Window* _tmp53_;
						Window* _tmp54_;
						Window* _tmp55_;
#line 503 "src/buffer.vala"
						_tmp53_ = wp;
#line 503 "src/buffer.vala"
						_tmp54_ = _tmp53_->next;
#line 503 "src/buffer.vala"
						_tmp55_ = _window_ref0 (_tmp54_);
#line 503 "src/buffer.vala"
						_window_unref0 (wp);
#line 503 "src/buffer.vala"
						wp = _tmp55_;
#line 2979 "buffer.c"
					}
#line 503 "src/buffer.vala"
					_tmp52_ = FALSE;
#line 503 "src/buffer.vala"
					_tmp56_ = wp;
#line 503 "src/buffer.vala"
					if (!(_tmp56_ != NULL)) {
#line 503 "src/buffer.vala"
						break;
#line 2989 "buffer.c"
					}
#line 504 "src/buffer.vala"
					_tmp57_ = wp;
#line 504 "src/buffer.vala"
					_tmp58_ = head_bp;
#line 504 "src/buffer.vala"
					_tmp59_ = _buffer_ref0 (_tmp58_);
#line 504 "src/buffer.vala"
					_buffer_unref0 (_tmp57_->bp);
#line 504 "src/buffer.vala"
					_tmp57_->bp = _tmp59_;
#line 3001 "buffer.c"
				}
			}
#line 503 "src/buffer.vala"
			_window_unref0 (wp);
#line 3006 "buffer.c"
		}
	}
	{
		Window* wp = NULL;
		Window* _tmp60_;
		Window* _tmp61_;
#line 508 "src/buffer.vala"
		_tmp60_ = head_wp;
#line 508 "src/buffer.vala"
		_tmp61_ = _window_ref0 (_tmp60_);
#line 508 "src/buffer.vala"
		wp = _tmp61_;
#line 3019 "buffer.c"
		{
			gboolean _tmp62_ = FALSE;
#line 508 "src/buffer.vala"
			_tmp62_ = TRUE;
#line 508 "src/buffer.vala"
			while (TRUE) {
#line 3026 "buffer.c"
				Window* _tmp66_;
				Window* _tmp67_;
				Buffer* _tmp68_;
				Buffer* _tmp69_;
#line 508 "src/buffer.vala"
				if (!_tmp62_) {
#line 3033 "buffer.c"
					Window* _tmp63_;
					Window* _tmp64_;
					Window* _tmp65_;
#line 508 "src/buffer.vala"
					_tmp63_ = wp;
#line 508 "src/buffer.vala"
					_tmp64_ = _tmp63_->next;
#line 508 "src/buffer.vala"
					_tmp65_ = _window_ref0 (_tmp64_);
#line 508 "src/buffer.vala"
					_window_unref0 (wp);
#line 508 "src/buffer.vala"
					wp = _tmp65_;
#line 3047 "buffer.c"
				}
#line 508 "src/buffer.vala"
				_tmp62_ = FALSE;
#line 508 "src/buffer.vala"
				_tmp66_ = wp;
#line 508 "src/buffer.vala"
				if (!(_tmp66_ != NULL)) {
#line 508 "src/buffer.vala"
					break;
#line 3057 "buffer.c"
				}
#line 509 "src/buffer.vala"
				_tmp67_ = wp;
#line 509 "src/buffer.vala"
				_tmp68_ = _tmp67_->bp;
#line 509 "src/buffer.vala"
				_tmp69_ = next_bp;
#line 509 "src/buffer.vala"
				if (_tmp68_ == _tmp69_) {
#line 3067 "buffer.c"
					Window* _tmp70_;
#line 510 "src/buffer.vala"
					_tmp70_ = wp;
#line 510 "src/buffer.vala"
					window_resync (_tmp70_);
#line 3073 "buffer.c"
				}
			}
		}
#line 508 "src/buffer.vala"
		_window_unref0 (wp);
#line 3079 "buffer.c"
	}
#line 469 "src/buffer.vala"
	_buffer_unref0 (next_bp);
#line 3083 "buffer.c"
}

Completion*
buffer_make_buffer_completion (void)
{
	Completion* cp = NULL;
	Completion* _tmp0_;
	Completion* result = NULL;
#line 514 "src/buffer.vala"
	_tmp0_ = completion_new (FALSE);
#line 514 "src/buffer.vala"
	cp = _tmp0_;
#line 3096 "buffer.c"
	{
		Buffer* bp = NULL;
		Buffer* _tmp1_;
		Buffer* _tmp2_;
#line 515 "src/buffer.vala"
		_tmp1_ = head_bp;
#line 515 "src/buffer.vala"
		_tmp2_ = _buffer_ref0 (_tmp1_);
#line 515 "src/buffer.vala"
		bp = _tmp2_;
#line 3107 "buffer.c"
		{
			gboolean _tmp3_ = FALSE;
#line 515 "src/buffer.vala"
			_tmp3_ = TRUE;
#line 515 "src/buffer.vala"
			while (TRUE) {
#line 3114 "buffer.c"
				Buffer* _tmp7_;
				Completion* _tmp8_;
				GeeSortedSet* _tmp9_;
				Buffer* _tmp10_;
				const gchar* _tmp11_;
#line 515 "src/buffer.vala"
				if (!_tmp3_) {
#line 3122 "buffer.c"
					Buffer* _tmp4_;
					Buffer* _tmp5_;
					Buffer* _tmp6_;
#line 515 "src/buffer.vala"
					_tmp4_ = bp;
#line 515 "src/buffer.vala"
					_tmp5_ = _tmp4_->next;
#line 515 "src/buffer.vala"
					_tmp6_ = _buffer_ref0 (_tmp5_);
#line 515 "src/buffer.vala"
					_buffer_unref0 (bp);
#line 515 "src/buffer.vala"
					bp = _tmp6_;
#line 3136 "buffer.c"
				}
#line 515 "src/buffer.vala"
				_tmp3_ = FALSE;
#line 515 "src/buffer.vala"
				_tmp7_ = bp;
#line 515 "src/buffer.vala"
				if (!(_tmp7_ != NULL)) {
#line 515 "src/buffer.vala"
					break;
#line 3146 "buffer.c"
				}
#line 516 "src/buffer.vala"
				_tmp8_ = cp;
#line 516 "src/buffer.vala"
				_tmp9_ = _tmp8_->completions;
#line 516 "src/buffer.vala"
				_tmp10_ = bp;
#line 516 "src/buffer.vala"
				_tmp11_ = _tmp10_->name;
#line 516 "src/buffer.vala"
				gee_collection_add ((GeeCollection*) _tmp9_, _tmp11_);
#line 3158 "buffer.c"
			}
		}
#line 515 "src/buffer.vala"
		_buffer_unref0 (bp);
#line 3163 "buffer.c"
	}
#line 517 "src/buffer.vala"
	result = cp;
#line 517 "src/buffer.vala"
	return result;
#line 3169 "buffer.c"
}

static gboolean
_bool_equal (const gboolean * s1,
             const gboolean * s2)
{
#line 532 "src/buffer.vala"
	if (s1 == s2) {
#line 532 "src/buffer.vala"
		return TRUE;
#line 3180 "buffer.c"
	}
#line 532 "src/buffer.vala"
	if (s1 == NULL) {
#line 532 "src/buffer.vala"
		return FALSE;
#line 3186 "buffer.c"
	}
#line 532 "src/buffer.vala"
	if (s2 == NULL) {
#line 532 "src/buffer.vala"
		return FALSE;
#line 3192 "buffer.c"
	}
#line 532 "src/buffer.vala"
	return (*s1) == (*s2);
#line 3196 "buffer.c"
}

gboolean
buffer_check_modified (Buffer* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean* ans = NULL;
	const gchar* _tmp1_;
	gboolean* _tmp2_;
	gboolean* _tmp3_;
	gboolean* _tmp4_;
	gboolean _tmp5_;
	gboolean result = FALSE;
#line 525 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 526 "src/buffer.vala"
	if (!self->modified) {
#line 526 "src/buffer.vala"
		_tmp0_ = TRUE;
#line 3216 "buffer.c"
	} else {
#line 526 "src/buffer.vala"
		_tmp0_ = self->nosave;
#line 3220 "buffer.c"
	}
#line 526 "src/buffer.vala"
	if (_tmp0_) {
#line 527 "src/buffer.vala"
		result = TRUE;
#line 527 "src/buffer.vala"
		return result;
#line 3228 "buffer.c"
	}
#line 529 "src/buffer.vala"
	_tmp1_ = self->name;
#line 529 "src/buffer.vala"
	_tmp2_ = minibuf_read_yesno ("Buffer %s modified; kill anyway? (yes or no) ", _tmp1_, NULL);
#line 529 "src/buffer.vala"
	ans = _tmp2_;
#line 530 "src/buffer.vala"
	_tmp3_ = ans;
#line 530 "src/buffer.vala"
	if (_tmp3_ == NULL) {
#line 531 "src/buffer.vala"
		funcall ("keyboard-quit", NULL, NULL);
#line 3242 "buffer.c"
	}
#line 532 "src/buffer.vala"
	_tmp4_ = ans;
#line 532 "src/buffer.vala"
	_tmp5_ = TRUE;
#line 532 "src/buffer.vala"
	result = _bool_equal (_tmp4_, &_tmp5_) == TRUE;
#line 532 "src/buffer.vala"
	_g_free0 (ans);
#line 532 "src/buffer.vala"
	return result;
#line 3254 "buffer.c"
}

gboolean
buffer_move_char (Buffer* self,
                  glong offset)
{
	gint _tmp0_ = 0;
	gint dir = 0;
	gboolean result = FALSE;
#line 538 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 539 "src/buffer.vala"
	if (offset >= ((glong) 0)) {
#line 539 "src/buffer.vala"
		_tmp0_ = 1;
#line 3270 "buffer.c"
	} else {
#line 539 "src/buffer.vala"
		_tmp0_ = -1;
#line 3274 "buffer.c"
	}
#line 539 "src/buffer.vala"
	dir = _tmp0_;
#line 3278 "buffer.c"
	{
		gulong i = 0UL;
#line 540 "src/buffer.vala"
		i = (gulong) 0;
#line 3283 "buffer.c"
		{
			gboolean _tmp1_ = FALSE;
#line 540 "src/buffer.vala"
			_tmp1_ = TRUE;
#line 540 "src/buffer.vala"
			while (TRUE) {
#line 3290 "buffer.c"
				gboolean _tmp3_ = FALSE;
#line 540 "src/buffer.vala"
				if (!_tmp1_) {
#line 3294 "buffer.c"
					gulong _tmp2_;
#line 540 "src/buffer.vala"
					_tmp2_ = i;
#line 540 "src/buffer.vala"
					i = _tmp2_ + 1;
#line 3300 "buffer.c"
				}
#line 540 "src/buffer.vala"
				_tmp1_ = FALSE;
#line 540 "src/buffer.vala"
				if (!(i < ((gulong) labs (offset)))) {
#line 540 "src/buffer.vala"
					break;
#line 3308 "buffer.c"
				}
#line 541 "src/buffer.vala"
				if (dir > 0) {
#line 541 "src/buffer.vala"
					_tmp3_ = !buffer_eolp (self);
#line 3314 "buffer.c"
				} else {
#line 541 "src/buffer.vala"
					_tmp3_ = !buffer_bolp (self);
#line 3318 "buffer.c"
				}
#line 541 "src/buffer.vala"
				if (_tmp3_) {
#line 3322 "buffer.c"
					gsize _tmp4_;
					gsize _tmp5_;
#line 542 "src/buffer.vala"
					_tmp4_ = buffer_get_pt (self);
#line 542 "src/buffer.vala"
					_tmp5_ = _tmp4_;
#line 542 "src/buffer.vala"
					buffer_set_pt (self, _tmp5_ + dir);
#line 3331 "buffer.c"
				} else {
					gboolean _tmp6_ = FALSE;
#line 543 "src/buffer.vala"
					if (dir > 0) {
#line 543 "src/buffer.vala"
						_tmp6_ = !buffer_eobp (self);
#line 3338 "buffer.c"
					} else {
#line 543 "src/buffer.vala"
						_tmp6_ = !buffer_bobp (self);
#line 3342 "buffer.c"
					}
#line 543 "src/buffer.vala"
					if (_tmp6_) {
#line 3346 "buffer.c"
						Flags _tmp7_;
						gsize _tmp8_;
						gsize _tmp9_;
						const gchar* _tmp10_;
						const gchar* _tmp11_;
#line 544 "src/buffer.vala"
						_tmp7_ = thisflag;
#line 544 "src/buffer.vala"
						thisflag = _tmp7_ | FLAGS_NEED_RESYNC;
#line 545 "src/buffer.vala"
						_tmp8_ = buffer_get_pt (self);
#line 545 "src/buffer.vala"
						_tmp9_ = _tmp8_;
#line 545 "src/buffer.vala"
						_tmp10_ = buffer_get_eol (self);
#line 545 "src/buffer.vala"
						_tmp11_ = _tmp10_;
#line 545 "src/buffer.vala"
						buffer_set_pt (self, _tmp9_ + (dir * strlen (_tmp11_)));
#line 546 "src/buffer.vala"
						if (dir > 0) {
#line 547 "src/buffer.vala"
							funcall ("beginning-of-line", NULL, NULL);
#line 3370 "buffer.c"
						} else {
#line 549 "src/buffer.vala"
							funcall ("end-of-line", NULL, NULL);
#line 3374 "buffer.c"
						}
					} else {
#line 551 "src/buffer.vala"
						result = FALSE;
#line 551 "src/buffer.vala"
						return result;
#line 3381 "buffer.c"
					}
				}
			}
		}
	}
#line 554 "src/buffer.vala"
	result = TRUE;
#line 554 "src/buffer.vala"
	return result;
#line 3391 "buffer.c"
}

gsize
buffer_calculate_goalc (Buffer* self,
                        gsize o)
{
	gsize col = 0UL;
	gsize t = 0UL;
	gsize start = 0UL;
	gsize end = 0UL;
	gsize result = 0UL;
#line 560 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 561 "src/buffer.vala"
	col = (gsize) 0;
#line 561 "src/buffer.vala"
	t = buffer_tab_width (self);
#line 562 "src/buffer.vala"
	start = buffer_start_of_line (self, o);
#line 562 "src/buffer.vala"
	end = o - start;
#line 3413 "buffer.c"
	{
		gsize i = 0UL;
#line 564 "src/buffer.vala"
		i = (gsize) 0;
#line 3418 "buffer.c"
		{
			gboolean _tmp0_ = FALSE;
#line 564 "src/buffer.vala"
			_tmp0_ = TRUE;
#line 564 "src/buffer.vala"
			while (TRUE) {
#line 564 "src/buffer.vala"
				if (!_tmp0_) {
#line 3427 "buffer.c"
					gsize _tmp1_;
					gsize _tmp2_;
#line 564 "src/buffer.vala"
					_tmp1_ = i;
#line 564 "src/buffer.vala"
					i = _tmp1_ + 1;
#line 564 "src/buffer.vala"
					_tmp2_ = col;
#line 564 "src/buffer.vala"
					col = _tmp2_ + 1;
#line 3438 "buffer.c"
				}
#line 564 "src/buffer.vala"
				_tmp0_ = FALSE;
#line 564 "src/buffer.vala"
				if (!(i < end)) {
#line 564 "src/buffer.vala"
					break;
#line 3446 "buffer.c"
				}
#line 565 "src/buffer.vala"
				if (buffer_get_char (self, start + i) == '\t') {
#line 566 "src/buffer.vala"
					col |= t - 1;
#line 3452 "buffer.c"
				}
			}
		}
	}
#line 568 "src/buffer.vala"
	result = col;
#line 568 "src/buffer.vala"
	return result;
#line 3461 "buffer.c"
}

void
buffer_goto_goalc (Buffer* self)
{
	gsize i = 0UL;
	gsize col = 0UL;
	gsize t = 0UL;
#line 574 "src/buffer.vala"
	g_return_if_fail (self != NULL);
#line 575 "src/buffer.vala"
	col = (gsize) 0;
#line 575 "src/buffer.vala"
	t = buffer_tab_width (self);
#line 3476 "buffer.c"
	{
		gboolean _tmp0_ = FALSE;
#line 577 "src/buffer.vala"
		i = buffer_line_o (self);
#line 577 "src/buffer.vala"
		_tmp0_ = TRUE;
#line 577 "src/buffer.vala"
		while (TRUE) {
#line 3485 "buffer.c"
			gsize _tmp2_;
			gsize _tmp3_;
#line 577 "src/buffer.vala"
			if (!_tmp0_) {
#line 3490 "buffer.c"
				gsize _tmp1_;
#line 579 "src/buffer.vala"
				_tmp1_ = i;
#line 579 "src/buffer.vala"
				i = _tmp1_ + 1;
#line 3496 "buffer.c"
			}
#line 577 "src/buffer.vala"
			_tmp0_ = FALSE;
#line 578 "src/buffer.vala"
			_tmp2_ = buffer_get_pt (self);
#line 578 "src/buffer.vala"
			_tmp3_ = _tmp2_;
#line 578 "src/buffer.vala"
			if (!(i < (buffer_line_o (self) + buffer_line_len (self, _tmp3_)))) {
#line 578 "src/buffer.vala"
				break;
#line 3508 "buffer.c"
			}
#line 580 "src/buffer.vala"
			if (col == self->goalc) {
#line 581 "src/buffer.vala"
				break;
#line 3514 "buffer.c"
			} else {
#line 582 "src/buffer.vala"
				if (buffer_get_char (self, i) == '\t') {
#line 3518 "buffer.c"
					{
						gsize w = 0UL;
#line 583 "src/buffer.vala"
						w = t - (col % t);
#line 3523 "buffer.c"
						{
							gboolean _tmp4_ = FALSE;
#line 583 "src/buffer.vala"
							_tmp4_ = TRUE;
#line 583 "src/buffer.vala"
							while (TRUE) {
#line 3530 "buffer.c"
								gboolean _tmp6_ = FALSE;
#line 583 "src/buffer.vala"
								if (!_tmp4_) {
#line 3534 "buffer.c"
									gsize _tmp5_;
#line 583 "src/buffer.vala"
									_tmp5_ = w;
#line 583 "src/buffer.vala"
									w = _tmp5_ - 1;
#line 3540 "buffer.c"
								}
#line 583 "src/buffer.vala"
								_tmp4_ = FALSE;
#line 583 "src/buffer.vala"
								if (w > ((gsize) 0)) {
#line 3546 "buffer.c"
									gsize _tmp7_;
									gsize _tmp8_;
#line 583 "src/buffer.vala"
									col = col + 1;
#line 583 "src/buffer.vala"
									_tmp7_ = col;
#line 583 "src/buffer.vala"
									_tmp8_ = self->goalc;
#line 583 "src/buffer.vala"
									_tmp6_ = _tmp7_ < _tmp8_;
#line 3557 "buffer.c"
								} else {
#line 583 "src/buffer.vala"
									_tmp6_ = FALSE;
#line 3561 "buffer.c"
								}
#line 583 "src/buffer.vala"
								if (!_tmp6_) {
#line 583 "src/buffer.vala"
									break;
#line 3567 "buffer.c"
								}
							}
						}
					}
				} else {
					gsize _tmp9_;
#line 586 "src/buffer.vala"
					col = col + 1;
#line 586 "src/buffer.vala"
					_tmp9_ = col;
#line 3578 "buffer.c"
				}
			}
		}
	}
#line 588 "src/buffer.vala"
	buffer_set_pt (self, i);
#line 3585 "buffer.c"
}

static gsize
_buffer_next_line_buffer_buffer_move_line (gsize o,
                                           gpointer self)
{
	gsize result;
	result = buffer_next_line ((Buffer*) self, o);
#line 593 "src/buffer.vala"
	return result;
#line 3596 "buffer.c"
}

static gsize
_buffer_prev_line_buffer_buffer_move_line (gsize o,
                                           gpointer self)
{
	gsize result;
	result = buffer_prev_line ((Buffer*) self, o);
#line 596 "src/buffer.vala"
	return result;
#line 3607 "buffer.c"
}

gboolean
buffer_move_line (Buffer* self,
                  glong n)
{
	BufferBufferMoveLine func = NULL;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
	gsize save_goalc = 0UL;
	Flags _tmp5_;
	gboolean result = FALSE;
#line 592 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 593 "src/buffer.vala"
	func = _buffer_next_line_buffer_buffer_move_line;
#line 593 "src/buffer.vala"
	func_target = buffer_ref (self);
#line 593 "src/buffer.vala"
	func_target_destroy_notify = buffer_unref;
#line 594 "src/buffer.vala"
	if (n < ((glong) 0)) {
#line 595 "src/buffer.vala"
		n = -n;
#line 596 "src/buffer.vala"
		(func_target_destroy_notify == NULL) ? NULL : (func_target_destroy_notify (func_target), NULL);
#line 596 "src/buffer.vala"
		func = NULL;
#line 596 "src/buffer.vala"
		func_target = NULL;
#line 596 "src/buffer.vala"
		func_target_destroy_notify = NULL;
#line 596 "src/buffer.vala"
		func = _buffer_prev_line_buffer_buffer_move_line;
#line 596 "src/buffer.vala"
		func_target = buffer_ref (self);
#line 596 "src/buffer.vala"
		func_target_destroy_notify = buffer_unref;
#line 3646 "buffer.c"
	}
#line 599 "src/buffer.vala"
	save_goalc = self->goalc;
#line 3650 "buffer.c"
	{
		gboolean _tmp0_ = FALSE;
#line 600 "src/buffer.vala"
		_tmp0_ = TRUE;
#line 600 "src/buffer.vala"
		while (TRUE) {
#line 3657 "buffer.c"
			gsize o = 0UL;
			BufferBufferMoveLine _tmp2_;
			gpointer _tmp2__target;
			gsize _tmp3_;
			gsize _tmp4_;
#line 600 "src/buffer.vala"
			if (!_tmp0_) {
#line 3665 "buffer.c"
				glong _tmp1_;
#line 600 "src/buffer.vala"
				_tmp1_ = n;
#line 600 "src/buffer.vala"
				n = _tmp1_ - 1;
#line 3671 "buffer.c"
			}
#line 600 "src/buffer.vala"
			_tmp0_ = FALSE;
#line 600 "src/buffer.vala"
			if (!(n > ((glong) 0))) {
#line 600 "src/buffer.vala"
				break;
#line 3679 "buffer.c"
			}
#line 601 "src/buffer.vala"
			_tmp2_ = func;
#line 601 "src/buffer.vala"
			_tmp2__target = func_target;
#line 601 "src/buffer.vala"
			_tmp3_ = buffer_get_pt (self);
#line 601 "src/buffer.vala"
			_tmp4_ = _tmp3_;
#line 601 "src/buffer.vala"
			o = _tmp2_ (_tmp4_, _tmp2__target);
#line 602 "src/buffer.vala"
			if (o == ((gsize) G_MAXSIZE)) {
#line 603 "src/buffer.vala"
				break;
#line 3695 "buffer.c"
			}
#line 604 "src/buffer.vala"
			buffer_set_pt (self, o);
#line 3699 "buffer.c"
		}
	}
#line 606 "src/buffer.vala"
	self->goalc = save_goalc;
#line 608 "src/buffer.vala"
	buffer_goto_goalc (self);
#line 609 "src/buffer.vala"
	self->goalc = save_goalc;
#line 610 "src/buffer.vala"
	_tmp5_ = thisflag;
#line 610 "src/buffer.vala"
	thisflag = _tmp5_ | FLAGS_NEED_RESYNC;
#line 612 "src/buffer.vala"
	result = n == ((glong) 0);
#line 612 "src/buffer.vala"
	(func_target_destroy_notify == NULL) ? NULL : (func_target_destroy_notify (func_target), NULL);
#line 612 "src/buffer.vala"
	func = NULL;
#line 612 "src/buffer.vala"
	func_target = NULL;
#line 612 "src/buffer.vala"
	func_target_destroy_notify = NULL;
#line 612 "src/buffer.vala"
	return result;
#line 3724 "buffer.c"
}

gboolean
buffer_move_word (Buffer* self,
                  glong dir)
{
	gboolean gotword = FALSE;
	gboolean result = FALSE;
#line 615 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 616 "src/buffer.vala"
	gotword = FALSE;
#line 3737 "buffer.c"
	{
		gboolean _tmp0_ = FALSE;
#line 617 "src/buffer.vala"
		_tmp0_ = TRUE;
#line 617 "src/buffer.vala"
		while (TRUE) {
#line 617 "src/buffer.vala"
			if (!_tmp0_) {
#line 3746 "buffer.c"
				gboolean _tmp1_ = FALSE;
#line 624 "src/buffer.vala"
				if (!gotword) {
#line 624 "src/buffer.vala"
					_tmp1_ = buffer_move_char (self, dir);
#line 3752 "buffer.c"
				} else {
#line 624 "src/buffer.vala"
					_tmp1_ = FALSE;
#line 3756 "buffer.c"
				}
#line 624 "src/buffer.vala"
				if (!_tmp1_) {
#line 624 "src/buffer.vala"
					break;
#line 3762 "buffer.c"
				}
			}
#line 617 "src/buffer.vala"
			_tmp0_ = FALSE;
#line 3767 "buffer.c"
			{
				gboolean _tmp2_ = FALSE;
#line 618 "src/buffer.vala"
				_tmp2_ = TRUE;
#line 618 "src/buffer.vala"
				while (TRUE) {
#line 3774 "buffer.c"
					gboolean _tmp3_ = FALSE;
					gint _tmp4_ = 0;
					gsize _tmp5_;
					gsize _tmp6_;
#line 618 "src/buffer.vala"
					if (!_tmp2_) {
#line 618 "src/buffer.vala"
						buffer_move_char (self, dir);
#line 3783 "buffer.c"
					}
#line 618 "src/buffer.vala"
					_tmp2_ = FALSE;
#line 618 "src/buffer.vala"
					if (dir > ((glong) 0)) {
#line 618 "src/buffer.vala"
						_tmp3_ = buffer_eolp (self);
#line 3791 "buffer.c"
					} else {
#line 618 "src/buffer.vala"
						_tmp3_ = buffer_bolp (self);
#line 3795 "buffer.c"
					}
#line 618 "src/buffer.vala"
					if (!(!_tmp3_)) {
#line 618 "src/buffer.vala"
						break;
#line 3801 "buffer.c"
					}
#line 619 "src/buffer.vala"
					if (dir < ((glong) 0)) {
#line 619 "src/buffer.vala"
						_tmp4_ = 1;
#line 3807 "buffer.c"
					} else {
#line 619 "src/buffer.vala"
						_tmp4_ = 0;
#line 3811 "buffer.c"
					}
#line 619 "src/buffer.vala"
					_tmp5_ = buffer_get_pt (self);
#line 619 "src/buffer.vala"
					_tmp6_ = _tmp5_;
#line 619 "src/buffer.vala"
					if (iswordchar (buffer_get_char (self, _tmp6_ - _tmp4_))) {
#line 620 "src/buffer.vala"
						gotword = TRUE;
#line 3821 "buffer.c"
					} else {
#line 621 "src/buffer.vala"
						if (gotword) {
#line 622 "src/buffer.vala"
							break;
#line 3827 "buffer.c"
						}
					}
				}
			}
		}
	}
#line 625 "src/buffer.vala"
	result = gotword;
#line 625 "src/buffer.vala"
	return result;
#line 3838 "buffer.c"
}

gboolean
buffer_move_sexp (Buffer* self,
                  glong dir)
{
	gboolean gotsexp = FALSE;
	gboolean single_quote = FALSE;
	gboolean double_quote = FALSE;
	gint level = 0;
	gboolean result = FALSE;
#line 628 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 629 "src/buffer.vala"
	gotsexp = FALSE;
#line 630 "src/buffer.vala"
	single_quote = dir < ((glong) 0);
#line 630 "src/buffer.vala"
	double_quote = single_quote;
#line 631 "src/buffer.vala"
	level = 0;
#line 3860 "buffer.c"
	{
		gboolean _tmp0_ = FALSE;
#line 633 "src/buffer.vala"
		_tmp0_ = TRUE;
#line 633 "src/buffer.vala"
		while (TRUE) {
#line 3867 "buffer.c"
			gboolean _tmp22_ = FALSE;
			gboolean _tmp23_ = FALSE;
#line 633 "src/buffer.vala"
			if (!_tmp0_) {
#line 3872 "buffer.c"
			}
#line 633 "src/buffer.vala"
			_tmp0_ = FALSE;
#line 634 "src/buffer.vala"
			while (TRUE) {
#line 3878 "buffer.c"
				gboolean _tmp1_ = FALSE;
				gint _tmp2_ = 0;
				gsize o = 0UL;
				gsize _tmp3_;
				gsize _tmp4_;
				gchar c = '\0';
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
#line 634 "src/buffer.vala"
				if (dir > ((glong) 0)) {
#line 634 "src/buffer.vala"
					_tmp1_ = !buffer_eolp (self);
#line 3896 "buffer.c"
				} else {
#line 634 "src/buffer.vala"
					_tmp1_ = !buffer_bolp (self);
#line 3900 "buffer.c"
				}
#line 634 "src/buffer.vala"
				if (!_tmp1_) {
#line 634 "src/buffer.vala"
					break;
#line 3906 "buffer.c"
				}
#line 635 "src/buffer.vala"
				if (dir < ((glong) 0)) {
#line 635 "src/buffer.vala"
					_tmp2_ = 1;
#line 3912 "buffer.c"
				} else {
#line 635 "src/buffer.vala"
					_tmp2_ = 0;
#line 3916 "buffer.c"
				}
#line 635 "src/buffer.vala"
				_tmp3_ = buffer_get_pt (self);
#line 635 "src/buffer.vala"
				_tmp4_ = _tmp3_;
#line 635 "src/buffer.vala"
				o = _tmp4_ - _tmp2_;
#line 636 "src/buffer.vala"
				c = buffer_get_char (self, o);
#line 639 "src/buffer.vala"
				if (c == '\"') {
#line 639 "src/buffer.vala"
					_tmp7_ = TRUE;
#line 3930 "buffer.c"
				} else {
#line 639 "src/buffer.vala"
					_tmp7_ = c == '\'';
#line 3934 "buffer.c"
				}
#line 639 "src/buffer.vala"
				if (_tmp7_) {
#line 639 "src/buffer.vala"
					_tmp6_ = o > buffer_line_o (self);
#line 3940 "buffer.c"
				} else {
#line 639 "src/buffer.vala"
					_tmp6_ = FALSE;
#line 3944 "buffer.c"
				}
#line 639 "src/buffer.vala"
				if (_tmp6_) {
#line 640 "src/buffer.vala"
					_tmp5_ = buffer_get_char (self, o - 1) == '\\';
#line 3950 "buffer.c"
				} else {
#line 639 "src/buffer.vala"
					_tmp5_ = FALSE;
#line 3954 "buffer.c"
				}
#line 639 "src/buffer.vala"
				if (_tmp5_) {
#line 641 "src/buffer.vala"
					buffer_move_char (self, dir);
#line 643 "src/buffer.vala"
					c = 'a';
#line 3962 "buffer.c"
				}
#line 646 "src/buffer.vala"
				if (dir > ((glong) 0)) {
#line 646 "src/buffer.vala"
					_tmp9_ = isopenbracketchar (c, single_quote, double_quote);
#line 3968 "buffer.c"
				} else {
#line 646 "src/buffer.vala"
					_tmp9_ = FALSE;
#line 3972 "buffer.c"
				}
#line 646 "src/buffer.vala"
				if (_tmp9_) {
#line 646 "src/buffer.vala"
					_tmp8_ = TRUE;
#line 3978 "buffer.c"
				} else {
					gboolean _tmp10_ = FALSE;
#line 647 "src/buffer.vala"
					if (dir <= ((glong) 0)) {
#line 647 "src/buffer.vala"
						_tmp10_ = isclosebracketchar (c, single_quote, double_quote);
#line 3985 "buffer.c"
					} else {
#line 647 "src/buffer.vala"
						_tmp10_ = FALSE;
#line 3989 "buffer.c"
					}
#line 647 "src/buffer.vala"
					_tmp8_ = _tmp10_;
#line 3993 "buffer.c"
				}
#line 646 "src/buffer.vala"
				if (_tmp8_) {
#line 3997 "buffer.c"
					gboolean _tmp11_ = FALSE;
					gint _tmp12_;
#line 648 "src/buffer.vala"
					if (level == 0) {
#line 648 "src/buffer.vala"
						_tmp11_ = gotsexp;
#line 4004 "buffer.c"
					} else {
#line 648 "src/buffer.vala"
						_tmp11_ = FALSE;
#line 4008 "buffer.c"
					}
#line 648 "src/buffer.vala"
					if (_tmp11_) {
#line 649 "src/buffer.vala"
						result = TRUE;
#line 649 "src/buffer.vala"
						return result;
#line 4016 "buffer.c"
					}
#line 651 "src/buffer.vala"
					_tmp12_ = level;
#line 651 "src/buffer.vala"
					level = _tmp12_ + 1;
#line 652 "src/buffer.vala"
					gotsexp = TRUE;
#line 653 "src/buffer.vala"
					if (c == '\"') {
#line 654 "src/buffer.vala"
						double_quote = !double_quote;
#line 4028 "buffer.c"
					}
#line 655 "src/buffer.vala"
					if (c == '\'') {
#line 656 "src/buffer.vala"
						single_quote = !double_quote;
#line 4034 "buffer.c"
					}
				} else {
					gboolean _tmp13_ = FALSE;
					gboolean _tmp14_ = FALSE;
#line 657 "src/buffer.vala"
					if (dir > ((glong) 0)) {
#line 657 "src/buffer.vala"
						_tmp14_ = isclosebracketchar (c, single_quote, double_quote);
#line 4043 "buffer.c"
					} else {
#line 657 "src/buffer.vala"
						_tmp14_ = FALSE;
#line 4047 "buffer.c"
					}
#line 657 "src/buffer.vala"
					if (_tmp14_) {
#line 657 "src/buffer.vala"
						_tmp13_ = TRUE;
#line 4053 "buffer.c"
					} else {
						gboolean _tmp15_ = FALSE;
#line 658 "src/buffer.vala"
						if (dir <= ((glong) 0)) {
#line 658 "src/buffer.vala"
							_tmp15_ = isopenbracketchar (c, single_quote, double_quote);
#line 4060 "buffer.c"
						} else {
#line 658 "src/buffer.vala"
							_tmp15_ = FALSE;
#line 4064 "buffer.c"
						}
#line 658 "src/buffer.vala"
						_tmp13_ = _tmp15_;
#line 4068 "buffer.c"
					}
#line 657 "src/buffer.vala"
					if (_tmp13_) {
#line 4072 "buffer.c"
						gboolean _tmp16_ = FALSE;
						gint _tmp17_;
#line 659 "src/buffer.vala"
						if (level == 0) {
#line 659 "src/buffer.vala"
							_tmp16_ = gotsexp;
#line 4079 "buffer.c"
						} else {
#line 659 "src/buffer.vala"
							_tmp16_ = FALSE;
#line 4083 "buffer.c"
						}
#line 659 "src/buffer.vala"
						if (_tmp16_) {
#line 660 "src/buffer.vala"
							result = TRUE;
#line 660 "src/buffer.vala"
							return result;
#line 4091 "buffer.c"
						}
#line 662 "src/buffer.vala"
						_tmp17_ = level;
#line 662 "src/buffer.vala"
						level = _tmp17_ - 1;
#line 663 "src/buffer.vala"
						gotsexp = TRUE;
#line 664 "src/buffer.vala"
						if (c == '\"') {
#line 665 "src/buffer.vala"
							double_quote = !double_quote;
#line 4103 "buffer.c"
						}
#line 666 "src/buffer.vala"
						if (c == '\'') {
#line 667 "src/buffer.vala"
							single_quote = !single_quote;
#line 4109 "buffer.c"
						}
#line 669 "src/buffer.vala"
						if (level < 0) {
#line 670 "src/buffer.vala"
							minibuf_error ("Scan error: \"Containing expression ends prematurely\"", NULL);
#line 671 "src/buffer.vala"
							result = FALSE;
#line 671 "src/buffer.vala"
							return result;
#line 4119 "buffer.c"
						}
					}
				}
#line 675 "src/buffer.vala"
				buffer_move_char (self, dir);
#line 677 "src/buffer.vala"
				if (g_ascii_isalnum (c)) {
#line 677 "src/buffer.vala"
					_tmp19_ = TRUE;
#line 4129 "buffer.c"
				} else {
#line 677 "src/buffer.vala"
					_tmp19_ = c == '$';
#line 4133 "buffer.c"
				}
#line 677 "src/buffer.vala"
				if (_tmp19_) {
#line 677 "src/buffer.vala"
					_tmp18_ = TRUE;
#line 4139 "buffer.c"
				} else {
#line 677 "src/buffer.vala"
					_tmp18_ = c == '_';
#line 4143 "buffer.c"
				}
#line 677 "src/buffer.vala"
				if (!_tmp18_) {
#line 4147 "buffer.c"
					gboolean _tmp20_ = FALSE;
#line 678 "src/buffer.vala"
					if (gotsexp) {
#line 678 "src/buffer.vala"
						_tmp20_ = level == 0;
#line 4153 "buffer.c"
					} else {
#line 678 "src/buffer.vala"
						_tmp20_ = FALSE;
#line 4157 "buffer.c"
					}
#line 678 "src/buffer.vala"
					if (_tmp20_) {
#line 4161 "buffer.c"
						gboolean _tmp21_ = FALSE;
#line 679 "src/buffer.vala"
						if (isopenbracketchar (c, single_quote, double_quote)) {
#line 679 "src/buffer.vala"
							_tmp21_ = TRUE;
#line 4167 "buffer.c"
						} else {
#line 680 "src/buffer.vala"
							_tmp21_ = isclosebracketchar (c, single_quote, double_quote);
#line 4171 "buffer.c"
						}
#line 679 "src/buffer.vala"
						if (!_tmp21_) {
#line 681 "src/buffer.vala"
							buffer_move_char (self, -dir);
#line 4177 "buffer.c"
						}
#line 682 "src/buffer.vala"
						result = TRUE;
#line 682 "src/buffer.vala"
						return result;
#line 4183 "buffer.c"
					}
				} else {
#line 685 "src/buffer.vala"
					gotsexp = TRUE;
#line 4188 "buffer.c"
				}
			}
#line 687 "src/buffer.vala"
			if (gotsexp) {
#line 687 "src/buffer.vala"
				_tmp22_ = level == 0;
#line 4195 "buffer.c"
			} else {
#line 687 "src/buffer.vala"
				_tmp22_ = FALSE;
#line 4199 "buffer.c"
			}
#line 687 "src/buffer.vala"
			if (_tmp22_) {
#line 688 "src/buffer.vala"
				result = TRUE;
#line 688 "src/buffer.vala"
				return result;
#line 4207 "buffer.c"
			}
#line 689 "src/buffer.vala"
			if (dir > ((glong) 0)) {
#line 689 "src/buffer.vala"
				_tmp23_ = !buffer_move_line (self, (glong) 1);
#line 4213 "buffer.c"
			} else {
#line 689 "src/buffer.vala"
				_tmp23_ = !buffer_move_line (self, (glong) -1);
#line 4217 "buffer.c"
			}
#line 689 "src/buffer.vala"
			if (_tmp23_) {
#line 690 "src/buffer.vala"
				if (level != 0) {
#line 691 "src/buffer.vala"
					minibuf_error ("Scan error: \"Unbalanced parentheses\"", NULL);
#line 4225 "buffer.c"
				}
#line 692 "src/buffer.vala"
				break;
#line 4229 "buffer.c"
			}
#line 694 "src/buffer.vala"
			if (dir > ((glong) 0)) {
#line 695 "src/buffer.vala"
				funcall ("beginning-of-line", NULL, NULL);
#line 4235 "buffer.c"
			} else {
#line 697 "src/buffer.vala"
				funcall ("end-of-line", NULL, NULL);
#line 4239 "buffer.c"
			}
		}
	}
#line 699 "src/buffer.vala"
	result = FALSE;
#line 699 "src/buffer.vala"
	return result;
#line 4247 "buffer.c"
}

gsize
buffer_offset_to_line (Buffer* self,
                       gsize offset)
{
	gsize n = 0UL;
	gsize result = 0UL;
#line 702 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 703 "src/buffer.vala"
	n = (gsize) 0;
#line 4260 "buffer.c"
	{
		gsize o = 0UL;
#line 704 "src/buffer.vala"
		o = (gsize) 0;
#line 4265 "buffer.c"
		{
			gboolean _tmp0_ = FALSE;
#line 704 "src/buffer.vala"
			_tmp0_ = TRUE;
#line 704 "src/buffer.vala"
			while (TRUE) {
#line 4272 "buffer.c"
				gsize _tmp1_;
#line 704 "src/buffer.vala"
				if (!_tmp0_) {
#line 704 "src/buffer.vala"
					o = buffer_next_line (self, o);
#line 4278 "buffer.c"
				}
#line 704 "src/buffer.vala"
				_tmp0_ = FALSE;
#line 704 "src/buffer.vala"
				if (!(buffer_end_of_line (self, o) < offset)) {
#line 704 "src/buffer.vala"
					break;
#line 4286 "buffer.c"
				}
#line 705 "src/buffer.vala"
				_tmp1_ = n;
#line 705 "src/buffer.vala"
				n = _tmp1_ + 1;
#line 4292 "buffer.c"
			}
		}
	}
#line 706 "src/buffer.vala"
	result = n;
#line 706 "src/buffer.vala"
	return result;
#line 4300 "buffer.c"
}

void
buffer_goto_offset (Buffer* self,
                    gsize o)
{
	gsize old_lineo = 0UL;
#line 709 "src/buffer.vala"
	g_return_if_fail (self != NULL);
#line 710 "src/buffer.vala"
	old_lineo = buffer_line_o (self);
#line 711 "src/buffer.vala"
	buffer_set_pt (self, o);
#line 712 "src/buffer.vala"
	if (buffer_line_o (self) != old_lineo) {
#line 4316 "buffer.c"
		Flags _tmp0_;
#line 713 "src/buffer.vala"
		_tmp0_ = thisflag;
#line 713 "src/buffer.vala"
		thisflag = _tmp0_ | FLAGS_NEED_RESYNC;
#line 4322 "buffer.c"
	}
}

gsize
buffer_get_pt (Buffer* self)
{
	gsize result;
#line 44 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 44 "src/buffer.vala"
	result = self->priv->_pt;
#line 44 "src/buffer.vala"
	return result;
#line 4336 "buffer.c"
}

static void
buffer_set_pt (Buffer* self,
               gsize value)
{
#line 45 "src/buffer.vala"
	g_return_if_fail (self != NULL);
#line 46 "src/buffer.vala"
	if (value < self->priv->_pt) {
#line 4347 "buffer.c"
		Estr* _tmp0_;
		Estr* _tmp1_;
#line 47 "src/buffer.vala"
		_tmp0_ = self->priv->text;
#line 47 "src/buffer.vala"
		estr_move (_tmp0_, value + self->priv->gap, value, self->priv->_pt - value);
#line 48 "src/buffer.vala"
		_tmp1_ = self->priv->text;
#line 48 "src/buffer.vala"
		estr_set (_tmp1_, value, (gint) '\0', MIN (self->priv->_pt - value, self->priv->gap));
#line 4358 "buffer.c"
	} else {
#line 49 "src/buffer.vala"
		if (value > self->priv->_pt) {
#line 4362 "buffer.c"
			Estr* _tmp2_;
			Estr* _tmp3_;
#line 50 "src/buffer.vala"
			_tmp2_ = self->priv->text;
#line 50 "src/buffer.vala"
			estr_move (_tmp2_, self->priv->_pt, self->priv->_pt + self->priv->gap, value - self->priv->_pt);
#line 51 "src/buffer.vala"
			_tmp3_ = self->priv->text;
#line 51 "src/buffer.vala"
			estr_set (_tmp3_, (value + self->priv->gap) - MIN (value - self->priv->_pt, self->priv->gap), (gint) '\0', MIN (value - self->priv->_pt, self->priv->gap));
#line 4373 "buffer.c"
		}
	}
#line 53 "src/buffer.vala"
	self->priv->_pt = value;
#line 54 "src/buffer.vala"
	self->goalc = buffer_calculate_goalc (self, self->priv->_pt);
#line 4380 "buffer.c"
}

gsize
buffer_get_length (Buffer* self)
{
	BufferClass* _klass_;
#line 101 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 101 "src/buffer.vala"
	_klass_ = BUFFER_GET_CLASS (self);
#line 101 "src/buffer.vala"
	if (_klass_->get_length) {
#line 101 "src/buffer.vala"
		return _klass_->get_length (self);
#line 4395 "buffer.c"
	}
#line 101 "src/buffer.vala"
	return 0UL;
#line 4399 "buffer.c"
}

static gsize
buffer_real_get_length (Buffer* base)
{
	gsize result;
	Buffer* self;
	Estr* _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
#line 101 "src/buffer.vala"
	self = base;
#line 101 "src/buffer.vala"
	_tmp0_ = self->priv->text;
#line 101 "src/buffer.vala"
	_tmp1_ = immutable_estr_get_length ((ImmutableEstr*) _tmp0_);
#line 101 "src/buffer.vala"
	_tmp2_ = _tmp1_;
#line 101 "src/buffer.vala"
	result = buffer_realo_to_o (self, _tmp2_);
#line 101 "src/buffer.vala"
	return result;
#line 4422 "buffer.c"
}

const gchar*
buffer_get_eol (Buffer* self)
{
	BufferClass* _klass_;
#line 196 "src/buffer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 196 "src/buffer.vala"
	_klass_ = BUFFER_GET_CLASS (self);
#line 196 "src/buffer.vala"
	if (_klass_->get_eol) {
#line 196 "src/buffer.vala"
		return _klass_->get_eol (self);
#line 4437 "buffer.c"
	}
#line 196 "src/buffer.vala"
	return NULL;
#line 4441 "buffer.c"
}

static const gchar*
buffer_real_get_eol (Buffer* base)
{
	const gchar* result;
	Buffer* self;
	Estr* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 196 "src/buffer.vala"
	self = base;
#line 196 "src/buffer.vala"
	_tmp0_ = self->priv->text;
#line 196 "src/buffer.vala"
	_tmp1_ = immutable_estr_get_eol ((ImmutableEstr*) _tmp0_);
#line 196 "src/buffer.vala"
	_tmp2_ = _tmp1_;
#line 196 "src/buffer.vala"
	result = _tmp2_;
#line 196 "src/buffer.vala"
	return result;
#line 4464 "buffer.c"
}

static void
value_buffer_init (GValue* value)
{
#line 20 "src/buffer.vala"
	value->data[0].v_pointer = NULL;
#line 4472 "buffer.c"
}

static void
value_buffer_free_value (GValue* value)
{
#line 20 "src/buffer.vala"
	if (value->data[0].v_pointer) {
#line 20 "src/buffer.vala"
		buffer_unref (value->data[0].v_pointer);
#line 4482 "buffer.c"
	}
}

static void
value_buffer_copy_value (const GValue* src_value,
                         GValue* dest_value)
{
#line 20 "src/buffer.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "src/buffer.vala"
		dest_value->data[0].v_pointer = buffer_ref (src_value->data[0].v_pointer);
#line 4494 "buffer.c"
	} else {
#line 20 "src/buffer.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4498 "buffer.c"
	}
}

static gpointer
value_buffer_peek_pointer (const GValue* value)
{
#line 20 "src/buffer.vala"
	return value->data[0].v_pointer;
#line 4507 "buffer.c"
}

static gchar*
value_buffer_collect_value (GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
#line 20 "src/buffer.vala"
	if (collect_values[0].v_pointer) {
#line 4518 "buffer.c"
		Buffer * object;
		object = collect_values[0].v_pointer;
#line 20 "src/buffer.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "src/buffer.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4525 "buffer.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "src/buffer.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4529 "buffer.c"
		}
#line 20 "src/buffer.vala"
		value->data[0].v_pointer = buffer_ref (object);
#line 4533 "buffer.c"
	} else {
#line 20 "src/buffer.vala"
		value->data[0].v_pointer = NULL;
#line 4537 "buffer.c"
	}
#line 20 "src/buffer.vala"
	return NULL;
#line 4541 "buffer.c"
}

static gchar*
value_buffer_lcopy_value (const GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
	Buffer ** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "src/buffer.vala"
	if (!object_p) {
#line 20 "src/buffer.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4556 "buffer.c"
	}
#line 20 "src/buffer.vala"
	if (!value->data[0].v_pointer) {
#line 20 "src/buffer.vala"
		*object_p = NULL;
#line 4562 "buffer.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "src/buffer.vala"
		*object_p = value->data[0].v_pointer;
#line 4566 "buffer.c"
	} else {
#line 20 "src/buffer.vala"
		*object_p = buffer_ref (value->data[0].v_pointer);
#line 4570 "buffer.c"
	}
#line 20 "src/buffer.vala"
	return NULL;
#line 4574 "buffer.c"
}

GParamSpec*
param_spec_buffer (const gchar* name,
                   const gchar* nick,
                   const gchar* blurb,
                   GType object_type,
                   GParamFlags flags)
{
	ParamSpecBuffer* spec;
#line 20 "src/buffer.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BUFFER), NULL);
#line 20 "src/buffer.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "src/buffer.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "src/buffer.vala"
	return G_PARAM_SPEC (spec);
#line 4593 "buffer.c"
}

gpointer
value_get_buffer (const GValue* value)
{
#line 20 "src/buffer.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BUFFER), NULL);
#line 20 "src/buffer.vala"
	return value->data[0].v_pointer;
#line 4603 "buffer.c"
}

void
value_set_buffer (GValue* value,
                  gpointer v_object)
{
	Buffer * old;
#line 20 "src/buffer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BUFFER));
#line 20 "src/buffer.vala"
	old = value->data[0].v_pointer;
#line 20 "src/buffer.vala"
	if (v_object) {
#line 20 "src/buffer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BUFFER));
#line 20 "src/buffer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "src/buffer.vala"
		value->data[0].v_pointer = v_object;
#line 20 "src/buffer.vala"
		buffer_ref (value->data[0].v_pointer);
#line 4625 "buffer.c"
	} else {
#line 20 "src/buffer.vala"
		value->data[0].v_pointer = NULL;
#line 4629 "buffer.c"
	}
#line 20 "src/buffer.vala"
	if (old) {
#line 20 "src/buffer.vala"
		buffer_unref (old);
#line 4635 "buffer.c"
	}
}

void
value_take_buffer (GValue* value,
                   gpointer v_object)
{
	Buffer * old;
#line 20 "src/buffer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BUFFER));
#line 20 "src/buffer.vala"
	old = value->data[0].v_pointer;
#line 20 "src/buffer.vala"
	if (v_object) {
#line 20 "src/buffer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BUFFER));
#line 20 "src/buffer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "src/buffer.vala"
		value->data[0].v_pointer = v_object;
#line 4656 "buffer.c"
	} else {
#line 20 "src/buffer.vala"
		value->data[0].v_pointer = NULL;
#line 4660 "buffer.c"
	}
#line 20 "src/buffer.vala"
	if (old) {
#line 20 "src/buffer.vala"
		buffer_unref (old);
#line 4666 "buffer.c"
	}
}

static void
buffer_class_init (BufferClass * klass,
                   gpointer klass_data)
{
#line 20 "src/buffer.vala"
	buffer_parent_class = g_type_class_peek_parent (klass);
#line 20 "src/buffer.vala"
	((BufferClass *) klass)->finalize = buffer_finalize;
#line 20 "src/buffer.vala"
	g_type_class_adjust_private_offset (klass, &Buffer_private_offset);
#line 20 "src/buffer.vala"
	BUFFER_CLASS (klass)->get_length = buffer_real_get_length;
#line 20 "src/buffer.vala"
	BUFFER_CLASS (klass)->get_eol = buffer_real_get_eol;
#line 4684 "buffer.c"
}

static void
buffer_instance_init (Buffer * self,
                      gpointer klass)
{
#line 20 "src/buffer.vala"
	self->priv = buffer_get_instance_private (self);
#line 20 "src/buffer.vala"
	self->ref_count = 1;
#line 4695 "buffer.c"
}

static void
buffer_finalize (Buffer * obj)
{
	Buffer * self;
#line 20 "src/buffer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUFFER, Buffer);
#line 20 "src/buffer.vala"
	g_signal_handlers_destroy (self);
#line 314 "src/buffer.vala"
	while (TRUE) {
#line 4708 "buffer.c"
		Marker* _tmp0_;
		Marker* _tmp1_;
#line 314 "src/buffer.vala"
		_tmp0_ = self->markers;
#line 314 "src/buffer.vala"
		if (!(_tmp0_ != NULL)) {
#line 314 "src/buffer.vala"
			break;
#line 4717 "buffer.c"
		}
#line 315 "src/buffer.vala"
		_tmp1_ = self->markers;
#line 315 "src/buffer.vala"
		marker_unchain (_tmp1_);
#line 4723 "buffer.c"
	}
#line 21 "src/buffer.vala"
	_g_free0 (self->name);
#line 22 "src/buffer.vala"
	_g_free0 (self->filename);
#line 23 "src/buffer.vala"
	_buffer_unref0 (self->next);
#line 25 "src/buffer.vala"
	_marker_unref0 (self->mark);
#line 26 "src/buffer.vala"
	_marker_unref0 (self->markers);
#line 29 "src/buffer.vala"
	_g_hash_table_unref0 (self->vars);
#line 40 "src/buffer.vala"
	_g_free0 (self->dir);
#line 57 "src/buffer.vala"
	_immutable_estr_unref0 (self->priv->text);
#line 4741 "buffer.c"
}

static GType
buffer_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_buffer_init, value_buffer_free_value, value_buffer_copy_value, value_buffer_peek_pointer, "p", value_buffer_collect_value, "p", value_buffer_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Buffer), 0, (GInstanceInitFunc) buffer_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType buffer_type_id;
	buffer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Buffer", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Buffer_private_offset = g_type_add_instance_private (buffer_type_id, sizeof (BufferPrivate));
	return buffer_type_id;
}

GType
buffer_get_type (void)
{
	static volatile gsize buffer_type_id__volatile = 0;
	if (g_once_init_enter (&buffer_type_id__volatile)) {
		GType buffer_type_id;
		buffer_type_id = buffer_get_type_once ();
		g_once_init_leave (&buffer_type_id__volatile, buffer_type_id);
	}
	return buffer_type_id__volatile;
}

gpointer
buffer_ref (gpointer instance)
{
	Buffer * self;
	self = instance;
#line 20 "src/buffer.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "src/buffer.vala"
	return instance;
#line 4777 "buffer.c"
}

void
buffer_unref (gpointer instance)
{
	Buffer * self;
	self = instance;
#line 20 "src/buffer.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "src/buffer.vala"
		BUFFER_GET_CLASS (self)->finalize (self);
#line 20 "src/buffer.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4791 "buffer.c"
	}
}

Buffer*
create_auto_buffer (const gchar* name)
{
	Buffer* bp = NULL;
	Estr* _tmp0_;
	Estr* _tmp1_;
	Buffer* _tmp2_;
	Buffer* _tmp3_;
	gchar* _tmp4_;
	Buffer* result = NULL;
#line 718 "src/buffer.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 719 "src/buffer.vala"
	_tmp0_ = estr_of_empty (IMMUTABLE_ESTR_eol_lf);
#line 719 "src/buffer.vala"
	_tmp1_ = _tmp0_;
#line 719 "src/buffer.vala"
	_tmp2_ = buffer_new (_tmp1_);
#line 719 "src/buffer.vala"
	_tmp3_ = _tmp2_;
#line 719 "src/buffer.vala"
	_immutable_estr_unref0 (_tmp1_);
#line 719 "src/buffer.vala"
	bp = _tmp3_;
#line 720 "src/buffer.vala"
	_tmp4_ = g_strdup (name);
#line 720 "src/buffer.vala"
	_g_free0 (bp->name);
#line 720 "src/buffer.vala"
	bp->name = _tmp4_;
#line 721 "src/buffer.vala"
	bp->needname = TRUE;
#line 722 "src/buffer.vala"
	bp->temporary = TRUE;
#line 723 "src/buffer.vala"
	bp->nosave = TRUE;
#line 724 "src/buffer.vala"
	result = bp;
#line 724 "src/buffer.vala"
	return result;
#line 4835 "buffer.c"
}

Buffer*
create_scratch_buffer (void)
{
	Buffer* _tmp0_;
	Buffer* result = NULL;
#line 728 "src/buffer.vala"
	_tmp0_ = create_auto_buffer ("*scratch*");
#line 728 "src/buffer.vala"
	result = _tmp0_;
#line 728 "src/buffer.vala"
	return result;
#line 4849 "buffer.c"
}

static gboolean
__lambda32_ (glong uniarg,
             GeeQueue* args)
{
	gboolean ok = FALSE;
	gchar* buf = NULL;
	gpointer _tmp0_;
	const gchar* _tmp1_;
	Buffer* bp = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gboolean result = FALSE;
#line 736 "src/buffer.vala"
	ok = TRUE;
#line 738 "src/buffer.vala"
	_tmp0_ = gee_queue_poll (args);
#line 738 "src/buffer.vala"
	buf = (gchar*) _tmp0_;
#line 739 "src/buffer.vala"
	_tmp1_ = buf;
#line 739 "src/buffer.vala"
	if (_tmp1_ == NULL) {
#line 4874 "buffer.c"
		Completion* cp = NULL;
		Completion* _tmp2_;
		Completion* _tmp3_;
		Buffer* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
#line 740 "src/buffer.vala"
		_tmp2_ = buffer_make_buffer_completion ();
#line 740 "src/buffer.vala"
		cp = _tmp2_;
#line 741 "src/buffer.vala"
		_tmp3_ = cp;
#line 741 "src/buffer.vala"
		_tmp4_ = cur_bp;
#line 741 "src/buffer.vala"
		_tmp5_ = _tmp4_->name;
#line 741 "src/buffer.vala"
		_tmp6_ = minibuf_read_completion ("Kill buffer (default %s): ", "", _tmp3_, NULL, _tmp5_, NULL);
#line 741 "src/buffer.vala"
		_g_free0 (buf);
#line 741 "src/buffer.vala"
		buf = _tmp6_;
#line 743 "src/buffer.vala"
		_tmp7_ = buf;
#line 743 "src/buffer.vala"
		if (_tmp7_ == NULL) {
#line 744 "src/buffer.vala"
			ok = funcall ("keyboard-quit", NULL, NULL);
#line 4904 "buffer.c"
		}
	}
#line 747 "src/buffer.vala"
	bp = NULL;
#line 748 "src/buffer.vala"
	_tmp9_ = buf;
#line 748 "src/buffer.vala"
	if (_tmp9_ != NULL) {
#line 4913 "buffer.c"
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
#line 748 "src/buffer.vala"
		_tmp10_ = buf;
#line 748 "src/buffer.vala"
		_tmp11_ = strlen (_tmp10_);
#line 748 "src/buffer.vala"
		_tmp12_ = _tmp11_;
#line 748 "src/buffer.vala"
		_tmp8_ = _tmp12_ > 0;
#line 4925 "buffer.c"
	} else {
#line 748 "src/buffer.vala"
		_tmp8_ = FALSE;
#line 4929 "buffer.c"
	}
#line 748 "src/buffer.vala"
	if (_tmp8_) {
#line 4933 "buffer.c"
		const gchar* _tmp13_;
		Buffer* _tmp14_;
		Buffer* _tmp15_;
#line 749 "src/buffer.vala"
		_tmp13_ = buf;
#line 749 "src/buffer.vala"
		_tmp14_ = buffer_find (_tmp13_);
#line 749 "src/buffer.vala"
		_buffer_unref0 (bp);
#line 749 "src/buffer.vala"
		bp = _tmp14_;
#line 750 "src/buffer.vala"
		_tmp15_ = bp;
#line 750 "src/buffer.vala"
		if (_tmp15_ == NULL) {
#line 4949 "buffer.c"
			const gchar* _tmp16_;
#line 751 "src/buffer.vala"
			_tmp16_ = buf;
#line 751 "src/buffer.vala"
			minibuf_error ("Buffer `%s' not found", _tmp16_, NULL);
#line 752 "src/buffer.vala"
			ok = FALSE;
#line 4957 "buffer.c"
		}
	} else {
		Buffer* _tmp17_;
		Buffer* _tmp18_;
#line 755 "src/buffer.vala"
		_tmp17_ = cur_bp;
#line 755 "src/buffer.vala"
		_tmp18_ = _buffer_ref0 (_tmp17_);
#line 755 "src/buffer.vala"
		_buffer_unref0 (bp);
#line 755 "src/buffer.vala"
		bp = _tmp18_;
#line 4970 "buffer.c"
	}
#line 757 "src/buffer.vala"
	if (ok) {
#line 4974 "buffer.c"
		Buffer* _tmp19_;
#line 758 "src/buffer.vala"
		_tmp19_ = bp;
#line 758 "src/buffer.vala"
		if (!buffer_check_modified (_tmp19_)) {
#line 759 "src/buffer.vala"
			ok = FALSE;
#line 4982 "buffer.c"
		} else {
			Buffer* _tmp20_;
#line 761 "src/buffer.vala"
			_tmp20_ = bp;
#line 761 "src/buffer.vala"
			buffer_kill (_tmp20_);
#line 4989 "buffer.c"
		}
	}
#line 764 "src/buffer.vala"
	result = ok;
#line 764 "src/buffer.vala"
	_buffer_unref0 (bp);
#line 764 "src/buffer.vala"
	_g_free0 (buf);
#line 764 "src/buffer.vala"
	return result;
#line 5000 "buffer.c"
}

static gboolean
___lambda32__function (glong uniarg,
                       GeeQueue* args)
{
	gboolean result;
	result = __lambda32_ (uniarg, args);
#line 733 "src/buffer.vala"
	return result;
#line 5011 "buffer.c"
}

void
buffer_init_lisp (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
#line 733 "src/buffer.vala"
	_tmp0_ = lisp_func_new ("kill-buffer", ___lambda32__function, TRUE, "Kill buffer BUFFER.\nWith a nil argument, kill the current buffer.");
#line 733 "src/buffer.vala"
	_tmp1_ = _tmp0_;
#line 733 "src/buffer.vala"
	_lisp_func_unref0 (_tmp1_);
#line 5025 "buffer.c"
}

