#include "config.h"
/*
 * This file specifies types and arguments for efuns.
 * An argument can have two different types with the syntax 'type1 | type2'.
 * An argument is marked as optional if it also takes the type 'void'.
 *
 * Look at the end for the list of functions that are optionally available.
 * If you don't want them, simply comment out them. All other functions must
 * remain defined.
 */
string *regexp(string *, string);
void add_action(string, void|string, void|int);
void add_attribute(string, void|int|object, void|object);
void add_prot_attribute(string, void|int|object, void|object);
void add_verb(string);
void add_worth(int, void|object);
void add_xverb(string);
object *all_inventory(string|object default: F_THIS_OBJECT);
mixed *allocate(int);
mixed assoc(mixed, mixed *, void|mixed, void|mixed);
int atoi(string);
void break_point();
unknown call_other(string|object, string, ...);
void call_out(string, int, void|mixed);
mixed *call_out_info();
object caller();
string capitalize(string);
int cat(string, void|int, void|int);
int check_ref(mixed *|object, void|int);
int cindent(string);
string clear_bit(string, string);
object clone_object(string);
int command(string, void|object);
object *contents(string|object);
int cp(string, string);
string crypt(string, int|string);
string ctime(void|int);
mixed debug_info(int, void|mixed, ...);
object *deep_inventory(object);
void delete_attribute(string, void|object);
mixed deletea(string|mixed *, int, void|int);
string describe(mixed *, string, void|int);
void destruct(object, void|int);
void disable_commands();
void ed(void|string, void|string);
void enable_commands();
object environment(void|string|object);
int exec(object, object);
int exists(string);
string *explode(string, string);
mixed extract(mixed *|string, int, void|int);
string file_name(object default: F_THIS_OBJECT);
int file_size(string);
string *files(string);
mixed *filter_array(mixed *, string, string|object, void|mixed);
int find_call_out(string);
object find_living(string);
object find_object(string);
object find_player(string);
object first_inventory(string|object default: F_THIS_OBJECT);
string format(string, void|int);
string function_exists(string, object default: F_THIS_OBJECT);
mixed *get_attribute(void|string|object, void|object);
string *get_dir(string);
string *grab_file(string, void|int, void|int);
string implode(mixed *, string);
int in_editor(void|object);
int index(string|mixed *, mixed, void|int);
void input_to(string, void|int);
mixed insert_alist(mixed, mixed, ...);
int interactive(object default: F_THIS_OBJECT);
mixed *intersect_alist(mixed *,mixed *);
int intp(mixed);
int living(object);
void localcmd();
void log_file(string, string);
string lower_case(string);
void ls(string|int);
mixed *map_array(mixed *, string, string|object, void|mixed);
int member_array(mixed, mixed *);
int memused();
int mkdir(string);
void move_object(string|object, string|object);
object next_inventory(object);
void notify_fail(string);
int objectp(mixed);
mixed *order_alist(mixed *, void|mixed *, ...);
string pad(string|int, int, void|int);
int pointerp(mixed);
object present(string|object, void|object);
object previous_object();
void print(string, void|int);
string process_string(string);
string query_arg();
int query_attribute(string, void|object);
string query_host_name();
int query_idle(object);
string query_ip_name(void|object);
string query_ip_number(void|object);
string query_load_average();
object query_snoop(object);
string query_verb();
int random(int);
string read_bytes(string, void|int, void|int);
string read_file(string, void|int, void|int);
mixed *reallocate(mixed *, int);
int remote_command();
int remove_call_out(string);
void remove_interactive(object);
int remove_shadow(void|object);
int rename(string, string);
int restore_object(string);
int rm(string);
int rmdir(string);
int root(void|object);
#ifdef RUSAGE
string rusage();
#endif
void save_object(string);
void say(string, void|object|object *);
int searcha(string|mixed *, mixed, void|int);
string set_bit(string, int);
int set_heart_beat(int);
int set_light(int);
void set_living_name(string);
object shadow(object, int);
void shout(string);
void shutdown();
int sizeof(mixed *|int);
object snoop(void|object, void|object);
mixed *sort_array(mixed *, string, object|string default: F_THIS_OBJECT);
int stringp(mixed);
int strlen(string);
void swap(object);
void tail(string);
void tell_object(object, string);
void tell_room(string|object, string, void|object *);
int test_bit(string, int);
string this_arg(); 
object this_object();
object this_player(void|int);
string this_verb();
void throw(mixed);
int time();
int trace(int);
string traceprefix(string|int);
string typeof(mixed);
mixed *unique_array(mixed *, string, void|mixed);
object *users();
string version();
void wizlist(void|string);
void write(mixed);
int write_bytes(string, int, string);
int write_file(string, string);

#ifdef COMPAT_MODE
string create_wizard(string, void|string);
string creator(object);
int transfer(object, string|object);
#else
int export_uid(object);
string geteuid(object default: F_THIS_OBJECT);
string getuid(object default: F_THIS_OBJECT);
int seteuid(string|int);
#endif

#ifdef MALLOC_malloc
void combine_free_list();
#endif
