/*
  Copyright Dave Bone 1998 - 2011 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.

	file:	yacco2_characters.lex

	Note:	
		This is one of the terminal classes used to generate
		the enumerated terminals
		It defines 8 bit characters.

		Remember, it generates the C++ definitions which get used
		in the parallel grammars recognizing the
		basic character sets etc.
*/
/@
@i "/yacco2/library/copyright.w"
@** Raw characters vocabulary.\fbreak
@/
raw-characters
(file-name	yacco2_characters
,name-space	NS_yacco2_characters) {
// 
// 7 bit char set
//
"x00"	(sym-class raw_nul{
  user-declaration
    public:
    raw_nul(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_nul::raw_nul(INT Ext_file,size_t Pos){
      T_CTOR_RW("x00",T_raw_nul_,false,false,Ext_file,Pos)}
  ***
  }
)
 
"x01"	(sym-class raw_soh{
  user-declaration
    public: raw_soh(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_soh::raw_soh(INT Ext_file,size_t Pos){
      T_CTOR_RW("x01",T_raw_soh_,false,false,Ext_file,Pos)}
  ***
  }
) 
	 
"x02"	(sym-class raw_stx{ 
  user-declaration
    public: raw_stx(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_stx::raw_stx(INT Ext_file,size_t Pos){
      T_CTOR_RW("x02",T_raw_stx_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x03"	(sym-class raw_etx{
  user-declaration
    public: raw_etx(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_etx::raw_etx(INT Ext_file,size_t Pos){
      T_CTOR_RW("x03",T_raw_etx_,false,false,Ext_file,Pos)}
  ***
})
 	  	 
"x04"	(sym-class raw_eot{
  user-declaration
    public:
    raw_eot(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_eot::raw_eot(INT Ext_file,size_t Pos){
      T_CTOR_RW("x04",T_raw_eot_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x05"	(sym-class raw_enq{
  user-declaration
    public:
    raw_enq(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_enq::raw_enq(INT Ext_file,size_t Pos){
      T_CTOR_RW("x05",T_raw_enq_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x06"	(sym-class raw_ack{
  user-declaration
    public:
    raw_ack(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_ack::raw_ack(INT Ext_file,size_t Pos){
      T_CTOR_RW("x06",T_raw_ack_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x07"	(sym-class raw_bel{
  user-declaration
    public:
    raw_bel(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_bel::raw_bel(INT Ext_file,size_t Pos){
      T_CTOR_RW("x07",T_raw_bel_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x08"	(sym-class raw_bs{
  user-declaration
    public:
    raw_bs(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_bs::raw_bs(INT Ext_file,size_t Pos){
      T_CTOR_RW("x08",T_raw_bs_,false,false,Ext_file,Pos)}
  ***
})
	 
"x09"	(sym-class raw_ht{
  user-declaration
    public:
    raw_ht(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_ht::raw_ht(INT Ext_file,size_t Pos){
      T_CTOR_RW("x09",T_raw_ht_,false,false,Ext_file,Pos)}
  ***
})
	 	
"x0a"	AD (sym-class raw_lf{
  user-declaration
    public:
    raw_lf(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_lf::raw_lf(INT Ext_file,size_t Pos){
      T_CTOR_RW("x0a",T_raw_lf_,false,false,Ext_file,Pos)}
  ***
})
	 
"x0b"	(sym-class raw_vt{
  user-declaration
    public:
    raw_vt(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_vt::raw_vt(INT Ext_file,size_t Pos){
      T_CTOR_RW("x0b",T_raw_vt_,false,false,Ext_file,Pos)}
  ***
})
	 	 	 
"x0c"	(sym-class raw_ff{
  user-declaration
    public:
    raw_ff(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_ff::raw_ff(INT Ext_file,size_t Pos){
      T_CTOR_RW("x0c",T_raw_ff_,false,false,Ext_file,Pos)}
  ***
})
	 	
"x0d"	AD (sym-class raw_cr{
  user-declaration
    public:
    raw_cr(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_cr::raw_cr(INT Ext_file,size_t Pos){
      T_CTOR_RW("x0d",T_raw_cr_,false,false,Ext_file,Pos)}
  ***
})
	  	
"x0e"	(sym-class raw_so{
  user-declaration
    public:
    raw_so(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_so::raw_so(INT Ext_file,size_t Pos){
      T_CTOR_RW("x0e",T_raw_so_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x0f"	(sym-class raw_si{
  user-declaration
    public:
    raw_si(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_si::raw_si(INT Ext_file,size_t Pos){
      T_CTOR_RW("x0f",T_raw_si_,false,false,Ext_file,Pos)}
  ***
})
 	
"x10"	(sym-class raw_dle{
  user-declaration
    public:
    raw_dle(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_dle::raw_dle(INT Ext_file,size_t Pos){
      T_CTOR_RW("x10",T_raw_dle_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x11"	(sym-class raw_dc1{
  user-declaration
    public:
    raw_dc1(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_dc1::raw_dc1(INT Ext_file,size_t Pos){
      T_CTOR_RW("x11",T_raw_dc1_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x12"	(sym-class raw_dc2{
  user-declaration
    public:
    raw_dc2(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_dc2::raw_dc2(INT Ext_file,size_t Pos){
      T_CTOR_RW("x12",T_raw_dc2_,false,false,Ext_file,Pos)}
  ***
})
 	 	 
"x13"	(sym-class raw_dc3{
  user-declaration
    public:
    raw_dc3(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_dc3::raw_dc3(INT Ext_file,size_t Pos){
      T_CTOR_RW("x13",T_raw_dc3_,false,false,Ext_file,Pos)}
  ***
}) 
	  
"x14"	(sym-class raw_dc4{
  user-declaration
    public:
    raw_dc4(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_dc4::raw_dc4(INT Ext_file,size_t Pos){
      T_CTOR_RW("x14",T_raw_dc4_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x15"	(sym-class raw_nak{
  user-declaration
    public:
    raw_nak(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_nak::raw_nak(INT Ext_file,size_t Pos){
      T_CTOR_RW("x15",T_raw_nak_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x16"	(sym-class raw_syn{
  user-declaration
    public:
    raw_syn(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_syn::raw_syn(INT Ext_file,size_t Pos){
      T_CTOR_RW("x16",T_raw_syn_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x17"	(sym-class raw_etb{
  user-declaration
    public:
    raw_etb(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_etb::raw_etb(INT Ext_file,size_t Pos){
      T_CTOR_RW("x17",T_raw_etb_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"x18"	(sym-class raw_can{
  user-declaration
    public:
    raw_can(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_can::raw_can(INT Ext_file,size_t Pos){
      T_CTOR_RW("x18",T_raw_can_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x19"	(sym-class raw_em{
  user-declaration
    public:
    raw_em(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_em::raw_em(INT Ext_file,size_t Pos){
      T_CTOR_RW("x19",T_raw_em_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x1a"	(sym-class raw_sub{
  user-declaration
    public:
    raw_sub(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_sub::raw_sub(INT Ext_file,size_t Pos){
      T_CTOR_RW("x1a",T_raw_sub_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"x1b"	(sym-class raw_esc{
  user-declaration
    public:
    raw_esc(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_esc::raw_esc(INT Ext_file,size_t Pos){
      T_CTOR_RW("x1b",T_raw_esc_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x1c"	(sym-class raw_fs{
  user-declaration
    public:
    raw_fs(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_fs::raw_fs(INT Ext_file,size_t Pos){
      T_CTOR_RW("x1c",T_raw_fs_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x1d"	(sym-class raw_gs{
  user-declaration
    public:
    raw_gs(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_gs::raw_gs(INT Ext_file,size_t Pos){
      T_CTOR_RW("x1d",T_raw_gs_,false,false,Ext_file,Pos)}
  ***
})
 	 
"x1e"	(sym-class raw_rs{
  user-declaration
    public:
    raw_rs(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_rs::raw_rs(INT Ext_file,size_t Pos){
      T_CTOR_RW("x1e",T_raw_rs_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"x1f"	(sym-class raw_us{
  user-declaration
    public:
    raw_us(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_us::raw_us(INT Ext_file,size_t Pos){
      T_CTOR_RW("x1f",T_raw_us_,false,false,Ext_file,Pos)}
  ***
})
// 	 
" "		(sym-class raw_sp{
  user-declaration
    public:
    raw_sp(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_sp::raw_sp(INT Ext_file,size_t Pos){
      T_CTOR_RW(" ",T_raw_sp_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"!"		(sym-class raw_exclam{
  user-declaration
    public:
    raw_exclam(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_exclam::raw_exclam(INT Ext_file,size_t Pos){
      T_CTOR_RW("!",T_raw_exclam_,false,false,Ext_file,Pos)}
  ***
})
 	 
"\""	(sym-class raw_dbl_quote{
  user-declaration
    public:
    raw_dbl_quote(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_dbl_quote::raw_dbl_quote(INT Ext_file,size_t Pos){
      T_CTOR_RW("\"",T_raw_dbl_quote_,false,false,Ext_file,Pos)}
  ***
})
 	 
"#"		(sym-class raw_no_sign{
  user-declaration
    public:
    raw_no_sign(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_no_sign::raw_no_sign(INT Ext_file,size_t Pos){
      T_CTOR_RW("#",T_raw_no_sign_,false,false,Ext_file,Pos)}
  ***
})
 	 
"$"		(sym-class raw_dollar_sign{
  user-declaration
    public:
    raw_dollar_sign(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_dollar_sign::raw_dollar_sign(INT Ext_file,size_t Pos){
      T_CTOR_RW("$",T_raw_dollar_sign_,false,false,Ext_file,Pos)}
  ***
})
	 	 
"%"		(sym-class raw_percent{
  user-declaration
    public:
    raw_percent(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_percent::raw_percent(INT Ext_file,size_t Pos){
      T_CTOR_RW("%",T_raw_percent_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"&"		(sym-class raw_ampersign{
  user-declaration
    public:
    raw_ampersign(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_ampersign::raw_ampersign(INT Ext_file,size_t Pos){
      T_CTOR_RW("&",T_raw_ampersign_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"'"		(sym-class raw_right_quote{
  user-declaration
    public:
    raw_right_quote(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_right_quote::raw_right_quote(INT Ext_file,size_t Pos){
      T_CTOR_RW("'",T_raw_right_quote_,false,false,Ext_file,Pos)}
  ***
}) // ` aka apostrophe
	 
"("		(sym-class raw_open_bracket{
  user-declaration
    public:
    raw_open_bracket(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_open_bracket::raw_open_bracket(INT Ext_file,size_t Pos){
      T_CTOR_RW("(",T_raw_open_bracket_,false,false,Ext_file,Pos)}
  ***
})
 	 
")"		(sym-class raw_close_bracket{
  user-declaration
    public:
    raw_close_bracket(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_close_bracket::raw_close_bracket(INT Ext_file,size_t Pos){
      T_CTOR_RW(")",T_raw_close_bracket_,false,false,Ext_file,Pos)}
  ***
})
 	 
"*"		(sym-class raw_asteric{
  user-declaration
    public:
    raw_asteric(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_asteric::raw_asteric(INT Ext_file,size_t Pos){
      T_CTOR_RW("*",T_raw_asteric_,false,false,Ext_file,Pos)}
  ***
})
 	 
"+"		(sym-class raw_plus{
  user-declaration
    public:
    raw_plus(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_plus::raw_plus(INT Ext_file,size_t Pos){
      T_CTOR_RW("+",T_raw_plus_,false,false,Ext_file,Pos)}
  ***
})
	 
","		(sym-class raw_comma{
  user-declaration
    public:
    raw_comma(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_comma::raw_comma(INT Ext_file,size_t Pos){
      T_CTOR_RW(",",T_raw_comma_,false,false,Ext_file,Pos)}
  ***
})
 	 
"-"		(sym-class raw_minus{
  user-declaration
    public:
    raw_minus(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_minus::raw_minus(INT Ext_file,size_t Pos){
      T_CTOR_RW("-",T_raw_minus_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"."		(sym-class raw_period{
  user-declaration
    public:
    raw_period(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_period::raw_period(INT Ext_file,size_t Pos){
      T_CTOR_RW(".",T_raw_period_,false,false,Ext_file,Pos)}
  ***
})
	 
"/"		(sym-class raw_slash{
  user-declaration
    public:
    raw_slash(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_slash::raw_slash(INT Ext_file,size_t Pos){
      T_CTOR_RW("/",T_raw_slash_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"0"		(sym-class raw_0{
  user-declaration
    public:
    raw_0(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_0::raw_0(INT Ext_file,size_t Pos){
      T_CTOR_RW("0",T_raw_0_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"1"		(sym-class raw_1{
  user-declaration
    public:
    raw_1(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_1::raw_1(INT Ext_file,size_t Pos){
      T_CTOR_RW("1",T_raw_1_,false,false,Ext_file,Pos)}
  ***
})
 	 
"2"		(sym-class raw_2{
  user-declaration
    public:
    raw_2(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_2::raw_2(INT Ext_file,size_t Pos){
      T_CTOR_RW("2",T_raw_2_,false,false,Ext_file,Pos)}
  ***
})
 	 
"3"		(sym-class raw_3{
  user-declaration
    public:
    raw_3(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_3::raw_3(INT Ext_file,size_t Pos){
      T_CTOR_RW("3",T_raw_3_,false,false,Ext_file,Pos)}
  ***
})
 	 
"4"		(sym-class raw_4{
  user-declaration
    public:
    raw_4(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_4::raw_4(INT Ext_file,size_t Pos){
      T_CTOR_RW("4",T_raw_4_,false,false,Ext_file,Pos)}
  ***
})
 	 
"5"		(sym-class raw_5{
  user-declaration
    public:
    raw_5(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_5::raw_5(INT Ext_file,size_t Pos){
      T_CTOR_RW("5",T_raw_5_,false,false,Ext_file,Pos)}
  ***
})
 	 
"6"		(sym-class raw_6{
  user-declaration
    public:
    raw_6(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_6::raw_6(INT Ext_file,size_t Pos){
      T_CTOR_RW("6",T_raw_6_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"7"		(sym-class raw_7{
  user-declaration
    public:
    raw_7(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_7::raw_7(INT Ext_file,size_t Pos){
      T_CTOR_RW("7",T_raw_7_,false,false,Ext_file,Pos)}
  ***
})
 	 
"8"		(sym-class raw_8{
  user-declaration
    public:
    raw_8(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_8::raw_8(INT Ext_file,size_t Pos){
      T_CTOR_RW("8",T_raw_8_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"9"		(sym-class raw_9{
  user-declaration
    public:
    raw_9(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_9::raw_9(INT Ext_file,size_t Pos){
      T_CTOR_RW("9",T_raw_9_,false,false,Ext_file,Pos)}
  ***
}) 
	 
":"		(sym-class raw_colon{
  user-declaration
    public:
    raw_colon(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_colon::raw_colon(INT Ext_file,size_t Pos){
      T_CTOR_RW(":",T_raw_colon_,false,false,Ext_file,Pos)}
  ***
})
 	 
";"		(sym-class raw_semi_colon{
  user-declaration
    public:
    raw_semi_colon(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_semi_colon::raw_semi_colon(INT Ext_file,size_t Pos){
      T_CTOR_RW(";",T_raw_semi_colon_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"<"		(sym-class raw_less_than{
  user-declaration
    public:
    raw_less_than(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_less_than::raw_less_than(INT Ext_file,size_t Pos){
      T_CTOR_RW("<",T_raw_less_than_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"="		(sym-class raw_eq{
  user-declaration
    public:
    raw_eq(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_eq::raw_eq(INT Ext_file,size_t Pos){
      T_CTOR_RW("=",T_raw_eq_,false,false,Ext_file,Pos)}
  ***
}) 
	 
">"		(sym-class raw_gt_than{
  user-declaration
    public:
    raw_gt_than(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_gt_than::raw_gt_than(INT Ext_file,size_t Pos){
      T_CTOR_RW(">",T_raw_gt_than_,false,false,Ext_file,Pos)}
  ***
})
 	 
"?"		(sym-class raw_question_mark{
  user-declaration
    public:
    raw_question_mark(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_question_mark::raw_question_mark(INT Ext_file,size_t Pos){
      T_CTOR_RW("?",T_raw_question_mark_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"@"		(sym-class raw_at_sign{
  user-declaration
    public:
    raw_at_sign(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_at_sign::raw_at_sign(INT Ext_file,size_t Pos){
      T_CTOR_RW("@",T_raw_at_sign_,false,false,Ext_file,Pos)}
  ***
})
	 	 
// 	 
"A"		(sym-class raw_A{
  user-declaration
    public:
    raw_A(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_A::raw_A(INT Ext_file,size_t Pos){
      T_CTOR_RW("A",T_raw_A_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"B"		(sym-class raw_B{
  user-declaration
    public:
    raw_B(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_B::raw_B(INT Ext_file,size_t Pos){
      T_CTOR_RW("B",T_raw_B_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"C"		(sym-class raw_C{
  user-declaration
    public:
    raw_C(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_C::raw_C(INT Ext_file,size_t Pos){
      T_CTOR_RW("C",T_raw_C_,false,false,Ext_file,Pos)}
  ***
})
 	 
"D"		(sym-class raw_D{
  user-declaration
    public:
    raw_D(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_D::raw_D(INT Ext_file,size_t Pos){
      T_CTOR_RW("D",T_raw_D_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"E"		(sym-class raw_E{
  user-declaration
    public:
    raw_E(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_E::raw_E(INT Ext_file,size_t Pos){
      T_CTOR_RW("E",T_raw_E_,false,false,Ext_file,Pos)}
  ***
}) 	
 
"F"		(sym-class raw_F{
  user-declaration
    public:
    raw_F(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_F::raw_F(INT Ext_file,size_t Pos){
      T_CTOR_RW("F",T_raw_F_,false,false,Ext_file,Pos)}
  ***
})
 	 
"G"		(sym-class raw_G{
  user-declaration
    public:
    raw_G(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_G::raw_G(INT Ext_file,size_t Pos){
      T_CTOR_RW("G",T_raw_G_,false,false,Ext_file,Pos)}
  ***
})
 	 
"H"		(sym-class raw_H{
  user-declaration
    public:
    raw_H(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_H::raw_H(INT Ext_file,size_t Pos){
      T_CTOR_RW("H",T_raw_H_,false,false,Ext_file,Pos)}
  ***
})
 	 
"I"		(sym-class raw_I{
  user-declaration
    public:
    raw_I(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_I::raw_I(INT Ext_file,size_t Pos){
      T_CTOR_RW("I",T_raw_I_,false,false,Ext_file,Pos)}
  ***
})
 	 
"J"		(sym-class raw_J{
  user-declaration
    public:
    raw_J(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_J::raw_J(INT Ext_file,size_t Pos){
      T_CTOR_RW("J",T_raw_J_,false,false,Ext_file,Pos)}
  ***
}) 	
 
"K"		(sym-class raw_K{
  user-declaration
    public:
    raw_K(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_K::raw_K(INT Ext_file,size_t Pos){
      T_CTOR_RW("K",T_raw_K_,false,false,Ext_file,Pos)}
  ***
}) 	
 
"L"		(sym-class raw_L{
  user-declaration
    public:
    raw_L(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_L::raw_L(INT Ext_file,size_t Pos){
      T_CTOR_RW("L",T_raw_L_,false,false,Ext_file,Pos)}
  ***
})
 	 
"M"		(sym-class raw_M{
  user-declaration
    public:
    raw_M(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_M::raw_M(INT Ext_file,size_t Pos){
      T_CTOR_RW("M",T_raw_M_,false,false,Ext_file,Pos)}
  ***
})
 	 
"N"		(sym-class raw_N{
  user-declaration
    public:
    raw_N(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_N::raw_N(INT Ext_file,size_t Pos){
      T_CTOR_RW("N",T_raw_N_,false,false,Ext_file,Pos)}
  ***
}) 	
 
"O"		(sym-class raw_O{
  user-declaration
    public:
    raw_O(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_O::raw_O(INT Ext_file,size_t Pos){
      T_CTOR_RW("O",T_raw_O_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"P"		(sym-class raw_P{
  user-declaration
    public:
    raw_P(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_P::raw_P(INT Ext_file,size_t Pos){
      T_CTOR_RW("P",T_raw_P_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"Q"		(sym-class raw_Q{
  user-declaration
    public:
    raw_Q(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_Q::raw_Q(INT Ext_file,size_t Pos){
      T_CTOR_RW("Q",T_raw_Q_,false,false,Ext_file,Pos)}
  ***
})
 	 
"R"		(sym-class raw_R{
  user-declaration
    public:
    raw_R(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_R::raw_R(INT Ext_file,size_t Pos){
      T_CTOR_RW("R",T_raw_R_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"S"		(sym-class raw_S{
  user-declaration
    public:
    raw_S(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_S::raw_S(INT Ext_file,size_t Pos){
      T_CTOR_RW("S",T_raw_S_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"T"		(sym-class raw_T{
  user-declaration
    public:
    raw_T(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_T::raw_T(INT Ext_file,size_t Pos){
      T_CTOR_RW("T",T_raw_T_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"U"		(sym-class raw_U{
  user-declaration
    public:
    raw_U(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_U::raw_U(INT Ext_file,size_t Pos){
      T_CTOR_RW("U",T_raw_U_,false,false,Ext_file,Pos)}
  ***
})
 	 
"V"		(sym-class raw_V{
  user-declaration
    public:
    raw_V(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_V::raw_V(INT Ext_file,size_t Pos){
      T_CTOR_RW("V",T_raw_V_,false,false,Ext_file,Pos)}
  ***
}) 	
 
"W"		(sym-class raw_W{
  user-declaration
    public:
    raw_W(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_W::raw_W(INT Ext_file,size_t Pos){
      T_CTOR_RW("W",T_raw_W_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"X"		(sym-class raw_X{
  user-declaration
    public:
    raw_X(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_X::raw_X(INT Ext_file,size_t Pos){
      T_CTOR_RW("X",T_raw_X_,false,false,Ext_file,Pos)}
  ***
}) 	
 
"Y"		(sym-class raw_Y{
  user-declaration
    public:
    raw_Y(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_Y::raw_Y(INT Ext_file,size_t Pos){
      T_CTOR_RW("Y",T_raw_Y_,false,false,Ext_file,Pos)}
  ***
}) 	
 
"Z"		(sym-class raw_Z{
  user-declaration
    public:
    raw_Z(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_Z::raw_Z(INT Ext_file,size_t Pos){
      T_CTOR_RW("Z",T_raw_Z_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"["		(sym-class raw_open_sq_bracket{
  user-declaration
    public:
    raw_open_sq_bracket(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_open_sq_bracket::raw_open_sq_bracket(INT Ext_file,size_t Pos){
      T_CTOR_RW("[",T_raw_open_sq_bracket_,false,false,Ext_file,Pos)}
  ***
})
 	 
"\\"	(sym-class raw_back_slash{
  user-declaration
    public:
    raw_back_slash(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_back_slash::raw_back_slash(INT Ext_file,size_t Pos){
      T_CTOR_RW("\\",T_raw_back_slash_,false,false,Ext_file,Pos)}
  ***
})
 	 
"]"		(sym-class raw_close_sq_bracket{
  user-declaration
    public:
    raw_close_sq_bracket(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_close_sq_bracket::raw_close_sq_bracket(INT Ext_file,size_t Pos){
      T_CTOR_RW("]",T_raw_close_sq_bracket_,false,false,Ext_file,Pos)}
  ***
})
 	 
"^"		(sym-class raw_up_arrow{
  user-declaration
    public:
    raw_up_arrow(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_up_arrow::raw_up_arrow(INT Ext_file,size_t Pos){
      T_CTOR_RW("^",T_raw_up_arrow_,false,false,Ext_file,Pos)}
  ***
})
 	 
"_"		(sym-class raw_under_score{
  user-declaration
    public:
    raw_under_score(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_under_score::raw_under_score(INT Ext_file,size_t Pos){
      T_CTOR_RW("_",T_raw_under_score_,false,false,Ext_file,Pos)}
  ***
})
 	 
"`"		(sym-class raw_left_quote{
  user-declaration
    public:
    raw_left_quote(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_left_quote::raw_left_quote(INT Ext_file,size_t Pos){
      T_CTOR_RW("`",T_raw_left_quote_,false,false,Ext_file,Pos)}
  ***
})
 
	 
"a"		(sym-class raw_a{
  user-declaration
    public:
    raw_a(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_a::raw_a(INT Ext_file,size_t Pos){
      T_CTOR_RW("a",T_raw_a_,false,false,Ext_file,Pos)}
  ***
})
 	 
"b"		(sym-class raw_b{
  user-declaration
    public:
    raw_b(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_b::raw_b(INT Ext_file,size_t Pos){
      T_CTOR_RW("b",T_raw_b_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"c"		(sym-class raw_c{
  user-declaration
    public:
    raw_c(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_c::raw_c(INT Ext_file,size_t Pos){
      T_CTOR_RW("c",T_raw_c_,false,false,Ext_file,Pos)}
  ***
})
 	 
"d"		(sym-class raw_d{
  user-declaration
    public:
    raw_d(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_d::raw_d(INT Ext_file,size_t Pos){
      T_CTOR_RW("d",T_raw_d_,false,false,Ext_file,Pos)}
  ***
})
 	 
"e"		(sym-class raw_e{
  user-declaration
    public:
    raw_e(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_e::raw_e(INT Ext_file,size_t Pos){
      T_CTOR_RW("e",T_raw_e_,false,false,Ext_file,Pos)}
  ***
})
 	 
"f"		(sym-class raw_f{
  user-declaration
    public:
    raw_f(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_f::raw_f(INT Ext_file,size_t Pos){
      T_CTOR_RW("f",T_raw_f_,false,false,Ext_file,Pos)}
  ***
}) 	 

"g"		(sym-class raw_g{
  user-declaration
    public:
    raw_g(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_g::raw_g(INT Ext_file,size_t Pos){
      T_CTOR_RW("g",T_raw_g_,false,false,Ext_file,Pos)}
  ***
})
 	 
"h"		(sym-class raw_h{
  user-declaration
    public:
    raw_h(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_h::raw_h(INT Ext_file,size_t Pos){
      T_CTOR_RW("h",T_raw_h_,false,false,Ext_file,Pos)}
  ***
})
 	 
"i"		(sym-class raw_i{
  user-declaration
    public:
    raw_i(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_i::raw_i(INT Ext_file,size_t Pos){
      T_CTOR_RW("i",T_raw_i_,false,false,Ext_file,Pos)}
  ***
})
 	 
"j"		(sym-class raw_j{
  user-declaration
    public:
    raw_j(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_j::raw_j(INT Ext_file,size_t Pos){
      T_CTOR_RW("j",T_raw_j_,false,false,Ext_file,Pos)}
  ***
})
 	 
"k"		(sym-class raw_k{
  user-declaration
    public:
    raw_k(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_k::raw_k(INT Ext_file,size_t Pos){
      T_CTOR_RW("k",T_raw_k_,false,false,Ext_file,Pos)}
  ***
})
 	 
"l"		(sym-class raw_l{
  user-declaration
    public:
    raw_l(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_l::raw_l(INT Ext_file,size_t Pos){
      T_CTOR_RW("l",T_raw_l_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"m"		(sym-class raw_m{
  user-declaration
    public:
    raw_m(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_m::raw_m(INT Ext_file,size_t Pos){
      T_CTOR_RW("m",T_raw_m_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"n"		(sym-class raw_n{
  user-declaration
    public:
    raw_n(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_n::raw_n(INT Ext_file,size_t Pos){
      T_CTOR_RW("n",T_raw_n_,false,false,Ext_file,Pos)}
  ***
})
 	 
"o"		(sym-class raw_o{
  user-declaration
    public:
    raw_o(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_o::raw_o(INT Ext_file,size_t Pos){
      T_CTOR_RW("o",T_raw_o_,false,false,Ext_file,Pos)}
  ***
})
 	 
"p"		(sym-class raw_p{
  user-declaration
    public:
    raw_p(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_p::raw_p(INT Ext_file,size_t Pos){
      T_CTOR_RW("p",T_raw_p_,false,false,Ext_file,Pos)}
  ***
})
 	 
"q"		(sym-class raw_q{
  user-declaration
    public:
    raw_q(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_q::raw_q(INT Ext_file,size_t Pos){
      T_CTOR_RW("q",T_raw_q_,false,false,Ext_file,Pos)}
  ***
})
 	 
"r"		(sym-class raw_r{
  user-declaration
    public:
    raw_r(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_r::raw_r(INT Ext_file,size_t Pos){
      T_CTOR_RW("r",T_raw_r_,false,false,Ext_file,Pos)}
  ***
})
 	 
"s"		(sym-class raw_s{
  user-declaration
    public:
    raw_s(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_s::raw_s(INT Ext_file,size_t Pos){
      T_CTOR_RW("s",T_raw_s_,false,false,Ext_file,Pos)}
  ***
})
 	 
"t"		(sym-class raw_t{
  user-declaration
    public:
    raw_t(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_t::raw_t(INT Ext_file,size_t Pos){
      T_CTOR_RW("t",T_raw_t_,false,false,Ext_file,Pos)}
  ***
})
 	 
"u"		(sym-class raw_u{
  user-declaration
    public:
    raw_u(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_u::raw_u(INT Ext_file,size_t Pos){
      T_CTOR_RW("u",T_raw_u_,false,false,Ext_file,Pos)}
  ***
})
 	 
"v"		(sym-class raw_v{
  user-declaration
    public:
    raw_v(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_v::raw_v(INT Ext_file,size_t Pos){
      T_CTOR_RW("v",T_raw_v_,false,false,Ext_file,Pos)}
  ***
})
 	 
"w"		(sym-class raw_w{
  user-declaration
    public:
    raw_w(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_w::raw_w(INT Ext_file,size_t Pos){
      T_CTOR_RW("w",T_raw_w_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"x"		(sym-class raw_x{
  user-declaration
    public:
    raw_x(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_x::raw_x(INT Ext_file,size_t Pos){
      T_CTOR_RW("x",T_raw_x_,false,false,Ext_file,Pos)}
  ***
})
 	 
"y"		(sym-class raw_y{
  user-declaration
    public:
    raw_y(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_y::raw_y(INT Ext_file,size_t Pos){
      T_CTOR_RW("y",T_raw_y_,false,false,Ext_file,Pos)}
  ***
})
 	 
"z"		(sym-class raw_z{
  user-declaration
    public:
    raw_z(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_z::raw_z(INT Ext_file,size_t Pos){
      T_CTOR_RW("z",T_raw_z_,false,false,Ext_file,Pos)}
  ***
})
 	 
"{"		(sym-class raw_open_brace{
  user-declaration
    public:
    raw_open_brace(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_open_brace::raw_open_brace(INT Ext_file,size_t Pos){
      T_CTOR_RW("{",T_raw_open_brace_,false,false,Ext_file,Pos)}
  ***
}) 
	 
"|"		(sym-class raw_vertical_line{
  user-declaration
    public:
    raw_vertical_line(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_vertical_line::raw_vertical_line(INT Ext_file,size_t Pos){
      T_CTOR_RW("|",T_raw_vertical_line_,false,false,Ext_file,Pos)}
  ***
})
 	 
"}"		(sym-class raw_close_brace{
  user-declaration
    public:
    raw_close_brace(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_close_brace::raw_close_brace(INT Ext_file,size_t Pos){
      T_CTOR_RW("}",T_raw_close_brace_,false,false,Ext_file,Pos)}
  ***
})
 	 
"~"		(sym-class raw_tilde{
  user-declaration
    public:
    raw_tilde(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_tilde::raw_tilde(INT Ext_file,size_t Pos){
      T_CTOR_RW("~",T_raw_tilde_,false,false,Ext_file,Pos)}
  ***
})
	 
"x7f"	(sym-class raw_del{
  user-declaration
    public:
    raw_del(INT Ext_file,size_t Pos);
  ***
  user-implementation
    raw_del::raw_del(INT Ext_file,size_t Pos){
      T_CTOR_RW("x7f",T_raw_del_,false,false,Ext_file,Pos)}
  ***
}) 	 
//
//
// 8 bit char set
//
"x80"	(sym-class raw_x80{
user-declaration
  public:
  raw_x80(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x80::raw_x80(INT Ext_file,size_t Pos){
      T_CTOR_RW("x80",T_raw_x80_,false,false,Ext_file,Pos)}
***
})

"x81"	(sym-class raw_x81{
user-declaration
  public:
  raw_x81(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x81::raw_x81(INT Ext_file,size_t Pos){
      T_CTOR_RW("x81",T_raw_x81_,false,false,Ext_file,Pos)}
***
})

"x82"	(sym-class raw_x82{
user-declaration
  public:
  raw_x82(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x82::raw_x82(INT Ext_file,size_t Pos){
      T_CTOR_RW("x82",T_raw_x82_,false,false,Ext_file,Pos)}
***
})

"x83"	(sym-class raw_x83{
user-declaration
  public:
  raw_x83(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x83::raw_x83(INT Ext_file,size_t Pos){
      T_CTOR_RW("x83",T_raw_x83_,false,false,Ext_file,Pos)}
***
})

"x84"	(sym-class raw_x84{
user-declaration
  public:
  raw_x84(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x84::raw_x84(INT Ext_file,size_t Pos){
      T_CTOR_RW("x84",T_raw_x84_,false,false,Ext_file,Pos)}
***
})

"x85"	(sym-class raw_x85{
user-declaration
  public:
  raw_x85(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x85::raw_x85(INT Ext_file,size_t Pos){
      T_CTOR_RW("x85",T_raw_x85_,false,false,Ext_file,Pos)}
***
})

"x86"	(sym-class raw_x86{
user-declaration
  public:
  raw_x86(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x86::raw_x86(INT Ext_file,size_t Pos){
      T_CTOR_RW("x86",T_raw_x86_,false,false,Ext_file,Pos)}
***
})

"x87"	(sym-class raw_x87{
user-declaration
  public:
  raw_x87(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x87::raw_x87(INT Ext_file,size_t Pos){
      T_CTOR_RW("x87",T_raw_x87_,false,false,Ext_file,Pos)}
***
})

"x88"	(sym-class raw_x88{
user-declaration
  public:
  raw_x88(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x88::raw_x88(INT Ext_file,size_t Pos){
      T_CTOR_RW("x88",T_raw_x88_,false,false,Ext_file,Pos)}
***
})

"x89"	(sym-class raw_x89{
user-declaration
  public:
  raw_x89(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x89::raw_x89(INT Ext_file,size_t Pos){
      T_CTOR_RW("x89",T_raw_x89_,false,false,Ext_file,Pos)}
***
})

"x8a"	(sym-class raw_x8a{
user-declaration
  public:
  raw_x8a(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x8a::raw_x8a(INT Ext_file,size_t Pos){
      T_CTOR_RW("x8a",T_raw_x8a_,false,false,Ext_file,Pos)}
***
})

"x8b"	(sym-class raw_x8b{
user-declaration
  public:
  raw_x8b(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x8b::raw_x8b(INT Ext_file,size_t Pos){
      T_CTOR_RW("x8b",T_raw_x8b_,false,false,Ext_file,Pos)}
***
})

"x8c"	(sym-class raw_x8c{
user-declaration
  public:
  raw_x8c(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x8c::raw_x8c(INT Ext_file,size_t Pos){
      T_CTOR_RW("x8c",T_raw_x8c_,false,false,Ext_file,Pos)}
***
})

"x8d"	(sym-class raw_x8d{
user-declaration
  public:
  raw_x8d(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x8d::raw_x8d(INT Ext_file,size_t Pos){
      T_CTOR_RW("x8d",T_raw_x8d_,false,false,Ext_file,Pos)}
***
})

"x8e"	(sym-class raw_x8e{
user-declaration
  public:
  raw_x8e(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x8e::raw_x8e(INT Ext_file,size_t Pos){
      T_CTOR_RW("x8e",T_raw_x8e_,false,false,Ext_file,Pos)}
***
})

"x8f"	(sym-class raw_x8f{
user-declaration
  public:
  raw_x8f(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x8f::raw_x8f(INT Ext_file,size_t Pos){
      T_CTOR_RW("x8f",T_raw_x8f_,false,false,Ext_file,Pos)}
***
})

"x90"	(sym-class raw_x90{
user-declaration
  public:
  raw_x90(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x90::raw_x90(INT Ext_file,size_t Pos){
      T_CTOR_RW("x90",T_raw_x90_,false,false,Ext_file,Pos)}
***
})

"x91"	(sym-class raw_x91{
user-declaration
  public:
  raw_x91(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x91::raw_x91(INT Ext_file,size_t Pos){
      T_CTOR_RW("x91",T_raw_x91_,false,false,Ext_file,Pos)}
***
})

"x92"	(sym-class raw_x92{
user-declaration
  public:
  raw_x92(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x92::raw_x92(INT Ext_file,size_t Pos){
      T_CTOR_RW("x92",T_raw_x92_,false,false,Ext_file,Pos)}
***
})

"x93"	(sym-class raw_x93{
user-declaration
  public:
  raw_x93(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x93::raw_x93(INT Ext_file,size_t Pos){
      T_CTOR_RW("x93",T_raw_x93_,false,false,Ext_file,Pos)}
***
})

"x94"	(sym-class raw_x94{
user-declaration
  public:
  raw_x94(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x94::raw_x94(INT Ext_file,size_t Pos){
      T_CTOR_RW("x94",T_raw_x94_,false,false,Ext_file,Pos)}
***
})

"x95"	(sym-class raw_x95{
user-declaration
  public:
  raw_x95(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x95::raw_x95(INT Ext_file,size_t Pos){
      T_CTOR_RW("x95",T_raw_x95_,false,false,Ext_file,Pos)}
***
})

"x96"	(sym-class raw_x96{
user-declaration
  public:
  raw_x96(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x96::raw_x96(INT Ext_file,size_t Pos){
      T_CTOR_RW("x96",T_raw_x96_,false,false,Ext_file,Pos)}
***
})

"x97"	(sym-class raw_x97{
user-declaration
  public:
  raw_x97(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x97::raw_x97(INT Ext_file,size_t Pos){
      T_CTOR_RW("x97",T_raw_x97_,false,false,Ext_file,Pos)}
***
})

"x98"	(sym-class raw_x98{
user-declaration
  public:
  raw_x98(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x98::raw_x98(INT Ext_file,size_t Pos){
      T_CTOR_RW("x98",T_raw_x98_,false,false,Ext_file,Pos)}
***
})

"x99"	(sym-class raw_x99{
user-declaration
  public:
  raw_x99(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x99::raw_x99(INT Ext_file,size_t Pos){
      T_CTOR_RW("x99",T_raw_x99_,false,false,Ext_file,Pos)}
***
})

"x9a"	(sym-class raw_x9a{
user-declaration
  public:
  raw_x9a(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x9a::raw_x9a(INT Ext_file,size_t Pos){
      T_CTOR_RW("x9a",T_raw_x9a_,false,false,Ext_file,Pos)}
***
})

"x9b"	(sym-class raw_x9b{
user-declaration
  public:
  raw_x9b(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x9b::raw_x9b(INT Ext_file,size_t Pos){
      T_CTOR_RW("x9b",T_raw_x9b_,false,false,Ext_file,Pos)}
***
})

"x9c"	(sym-class raw_x9c{
user-declaration
  public:
  raw_x9c(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x9c::raw_x9c(INT Ext_file,size_t Pos){
      T_CTOR_RW("x9c",T_raw_x9c_,false,false,Ext_file,Pos)}
***
})

"x9d"	(sym-class raw_x9d{
user-declaration
  public:
  raw_x9d(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x9d::raw_x9d(INT Ext_file,size_t Pos){
      T_CTOR_RW("x9d",T_raw_x9d_,false,false,Ext_file,Pos)}
***
})

"x9e"	(sym-class raw_x9e{
user-declaration
  public:
  raw_x9e(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x9e::raw_x9e(INT Ext_file,size_t Pos){
      T_CTOR_RW("x9e",T_raw_x9e_,false,false,Ext_file,Pos)}
***
})

"x9f"	(sym-class raw_x9f{
user-declaration
  public:
  raw_x9f(INT Ext_file,size_t Pos);
***
user-implementation
  raw_x9f::raw_x9f(INT Ext_file,size_t Pos){
      T_CTOR_RW("x9f",T_raw_x9f_,false,false,Ext_file,Pos)}
***
})

"xa0"	(sym-class raw_xa0{
user-declaration
  public:
  raw_xa0(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xa0::raw_xa0(INT Ext_file,size_t Pos){
      T_CTOR_RW("xa0",T_raw_xa0_,false,false,Ext_file,Pos)}
***
})

"xa1"	(sym-class raw_xa1{
user-declaration
  public:
  raw_xa1(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xa1::raw_xa1(INT Ext_file,size_t Pos){
      T_CTOR_RW("xa1",T_raw_xa1_,false,false,Ext_file,Pos)}
***
})

"xa2"	(sym-class raw_xa2{
user-declaration
  public:
  raw_xa2(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xa2::raw_xa2(INT Ext_file,size_t Pos){
      T_CTOR_RW("xa2",T_raw_xa2_,false,false,Ext_file,Pos)}
***
})

"xa3"	(sym-class raw_xa3{
user-declaration
  public:
  raw_xa3(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xa3::raw_xa3(INT Ext_file,size_t Pos){
      T_CTOR_RW("xa3",T_raw_xa3_,false,false,Ext_file,Pos)}
***
})

"xa4"	(sym-class raw_xa4{
user-declaration
  public:
  raw_xa4(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xa4::raw_xa4(INT Ext_file,size_t Pos){
      T_CTOR_RW("xa4",T_raw_xa4_,false,false,Ext_file,Pos)}
***
})

"xa5"	(sym-class raw_xa5{
user-declaration
  public:
  raw_xa5(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xa5::raw_xa5(INT Ext_file,size_t Pos){
      T_CTOR_RW("xa5",T_raw_xa5_,false,false,Ext_file,Pos)}
***
})

"xa6"	(sym-class raw_xa6{
user-declaration
  public:
  raw_xa6(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xa6::raw_xa6(INT Ext_file,size_t Pos){
      T_CTOR_RW("xa6",T_raw_xa6_,false,false,Ext_file,Pos)}
***
})

"xa7"	(sym-class raw_xa7{
user-declaration
  public:
  raw_xa7(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xa7::raw_xa7(INT Ext_file,size_t Pos){
      T_CTOR_RW("xa7",T_raw_xa7_,false,false,Ext_file,Pos)}
***
})

"xa8"	(sym-class raw_xa8{
user-declaration
  public:
  raw_xa8(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xa8::raw_xa8(INT Ext_file,size_t Pos){
      T_CTOR_RW("xa8",T_raw_xa8_,false,false,Ext_file,Pos)}
***
})

"xa9"	(sym-class raw_xa9{
user-declaration
  public:
  raw_xa9(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xa9::raw_xa9(INT Ext_file,size_t Pos){
      T_CTOR_RW("xa9",T_raw_xa9_,false,false,Ext_file,Pos)}
***
})

"xaa"	(sym-class raw_xaa{
user-declaration
  public:
  raw_xaa(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xaa::raw_xaa(INT Ext_file,size_t Pos){
      T_CTOR_RW("xaa",T_raw_xaa_,false,false,Ext_file,Pos)}
***
})

"xab"	(sym-class raw_xab{
user-declaration
  public:
  raw_xab(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xab::raw_xab(INT Ext_file,size_t Pos){
      T_CTOR_RW("xab",T_raw_xab_,false,false,Ext_file,Pos)}
***
})

"xac"	(sym-class raw_xac{
user-declaration
  public:
  raw_xac(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xac::raw_xac(INT Ext_file,size_t Pos){
      T_CTOR_RW("xac",T_raw_xac_,false,false,Ext_file,Pos)}
***
})

"xad"	(sym-class raw_xad{
user-declaration
  public:
  raw_xad(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xad::raw_xad(INT Ext_file,size_t Pos){
      T_CTOR_RW("xad",T_raw_xad_,false,false,Ext_file,Pos)}
***
})

"xae"	(sym-class raw_xae{
user-declaration
  public:
  raw_xae(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xae::raw_xae(INT Ext_file,size_t Pos){
      T_CTOR_RW("xae",T_raw_xae_,false,false,Ext_file,Pos)}
***
})

"xaf"	(sym-class raw_xaf{
user-declaration
  public:
  raw_xaf(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xaf::raw_xaf(INT Ext_file,size_t Pos){
      T_CTOR_RW("xaf",T_raw_xaf_,false,false,Ext_file,Pos)}
***
})

"xb0"	(sym-class raw_xb0{
user-declaration
  public:
  raw_xb0(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xb0::raw_xb0(INT Ext_file,size_t Pos){
      T_CTOR_RW("xb0",T_raw_xb0_,false,false,Ext_file,Pos)}
***
})

"xb1"	(sym-class raw_xb1{
user-declaration
  public:
  raw_xb1(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xb1::raw_xb1(INT Ext_file,size_t Pos){
      T_CTOR_RW("xb1",T_raw_xb1_,false,false,Ext_file,Pos)}
***
})

"xb2"	(sym-class raw_xb2{
user-declaration
  public:
  raw_xb2(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xb2::raw_xb2(INT Ext_file,size_t Pos){
      T_CTOR_RW("xb2",T_raw_xb2_,false,false,Ext_file,Pos)}
***
})

"xb3"	(sym-class raw_xb3{
user-declaration
  public:
  raw_xb3(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xb3::raw_xb3(INT Ext_file,size_t Pos){
      T_CTOR_RW("xb3",T_raw_xb3_,false,false,Ext_file,Pos)}
***
})

"xb4"	(sym-class raw_xb4{
user-declaration
  public:
  raw_xb4(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xb4::raw_xb4(INT Ext_file,size_t Pos){
      T_CTOR_RW("xb4",T_raw_xb4_,false,false,Ext_file,Pos)}
***
})

"xb5"	(sym-class raw_xb5{
user-declaration
  public:
  raw_xb5(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xb5::raw_xb5(INT Ext_file,size_t Pos){
      T_CTOR_RW("xb5",T_raw_xb5_,false,false,Ext_file,Pos)}
***
})

"xb6"	(sym-class raw_xb6{
user-declaration
  public:
  raw_xb6(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xb6::raw_xb6(INT Ext_file,size_t Pos){
      T_CTOR_RW("xb6",T_raw_xb6_,false,false,Ext_file,Pos)}
***
})

"xb7"	(sym-class raw_xb7{
user-declaration
  public:
  raw_xb7(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xb7::raw_xb7(INT Ext_file,size_t Pos){
      T_CTOR_RW("xb7",T_raw_xb7_,false,false,Ext_file,Pos)}
***
})

"xb8"	(sym-class raw_xb8{
user-declaration
  public:
  raw_xb8(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xb8::raw_xb8(INT Ext_file,size_t Pos){
      T_CTOR_RW("xb8",T_raw_xb8_,false,false,Ext_file,Pos)}
***
})

"xb9"	(sym-class raw_xb9{
user-declaration
  public:
  raw_xb9(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xb9::raw_xb9(INT Ext_file,size_t Pos){
      T_CTOR_RW("xb9",T_raw_xb9_,false,false,Ext_file,Pos)}
***
})

"xba"	(sym-class raw_xba{
user-declaration
  public:
  raw_xba(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xba::raw_xba(INT Ext_file,size_t Pos){
      T_CTOR_RW("xba",T_raw_xba_,false,false,Ext_file,Pos)}
***
})

"xbb"	(sym-class raw_xbb{
user-declaration
  public:
  raw_xbb(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xbb::raw_xbb(INT Ext_file,size_t Pos){
      T_CTOR_RW("xbb",T_raw_xbb_,false,false,Ext_file,Pos)}
***
})

"xbc"	(sym-class raw_xbc{
user-declaration
  public:
  raw_xbc(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xbc::raw_xbc(INT Ext_file,size_t Pos){
      T_CTOR_RW("xbc",T_raw_xbc_,false,false,Ext_file,Pos)}
***
})

"xbd"	(sym-class raw_xbd{
user-declaration
  public:
  raw_xbd(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xbd::raw_xbd(INT Ext_file,size_t Pos){
      T_CTOR_RW("xbd",T_raw_xbd_,false,false,Ext_file,Pos)}
***
})

"xbe"	(sym-class raw_xbe{
user-declaration
  public:
  raw_xbe(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xbe::raw_xbe(INT Ext_file,size_t Pos){
      T_CTOR_RW("xbe",T_raw_xbe_,false,false,Ext_file,Pos)}
***
})

"xbf"	(sym-class raw_xbf{
user-declaration
  public:
  raw_xbf(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xbf::raw_xbf(INT Ext_file,size_t Pos){
      T_CTOR_RW("xbf",T_raw_xbf_,false,false,Ext_file,Pos)}
***
})

"xc0"	(sym-class raw_xc0{
user-declaration
  public:
  raw_xc0(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xc0::raw_xc0(INT Ext_file,size_t Pos){
      T_CTOR_RW("xc0",T_raw_xc0_,false,false,Ext_file,Pos)}
***
})

"xc1"	(sym-class raw_xc1{
user-declaration
  public:
  raw_xc1(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xc1::raw_xc1(INT Ext_file,size_t Pos){
      T_CTOR_RW("xc1",T_raw_xc1_,false,false,Ext_file,Pos)}
***
})

"xc2"	(sym-class raw_xc2{
user-declaration
  public:
  raw_xc2(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xc2::raw_xc2(INT Ext_file,size_t Pos){
      T_CTOR_RW("xc2",T_raw_xc2_,false,false,Ext_file,Pos)}
***
})

"xc3"	(sym-class raw_xc3{
user-declaration
  public:
  raw_xc3(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xc3::raw_xc3(INT Ext_file,size_t Pos){
      T_CTOR_RW("xc3",T_raw_xc3_,false,false,Ext_file,Pos)}
***
})

"xc4"	(sym-class raw_xc4{
user-declaration
  public:
  raw_xc4(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xc4::raw_xc4(INT Ext_file,size_t Pos){
      T_CTOR_RW("xc4",T_raw_xc4_,false,false,Ext_file,Pos)}
***
})

"xc5"	(sym-class raw_xc5{
user-declaration
  public:
  raw_xc5(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xc5::raw_xc5(INT Ext_file,size_t Pos){
      T_CTOR_RW("xc5",T_raw_xc5_,false,false,Ext_file,Pos)}
***
})

"xc6"	(sym-class raw_xc6{
user-declaration
  public:
  raw_xc6(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xc6::raw_xc6(INT Ext_file,size_t Pos){
      T_CTOR_RW("xc6",T_raw_xc6_,false,false,Ext_file,Pos)}
***
})

"xc7"	(sym-class raw_xc7{
user-declaration
  public:
  raw_xc7(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xc7::raw_xc7(INT Ext_file,size_t Pos){
      T_CTOR_RW("xc7",T_raw_xc7_,false,false,Ext_file,Pos)}
***
})

"xc8"	(sym-class raw_xc8{
user-declaration
  public:
  raw_xc8(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xc8::raw_xc8(INT Ext_file,size_t Pos){
      T_CTOR_RW("xc8",T_raw_xc8_,false,false,Ext_file,Pos)}
***
})

"xc9"	(sym-class raw_xc9{
user-declaration
  public:
  raw_xc9(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xc9::raw_xc9(INT Ext_file,size_t Pos){
      T_CTOR_RW("xc9",T_raw_xc9_,false,false,Ext_file,Pos)}
***
})

"xca"	(sym-class raw_xca{
user-declaration
  public:
  raw_xca(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xca::raw_xca(INT Ext_file,size_t Pos){
      T_CTOR_RW("xca",T_raw_xca_,false,false,Ext_file,Pos)}
***
})

"xcb"	(sym-class raw_xcb{
user-declaration
  public:
  raw_xcb(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xcb::raw_xcb(INT Ext_file,size_t Pos){
      T_CTOR_RW("xcb",T_raw_xcb_,false,false,Ext_file,Pos)}
***
})

"xcc"	(sym-class raw_xcc{
user-declaration
  public:
  raw_xcc(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xcc::raw_xcc(INT Ext_file,size_t Pos){
      T_CTOR_RW("xcc",T_raw_xcc_,false,false,Ext_file,Pos)}
***
})

"xcd"	(sym-class raw_xcd{
user-declaration
  public:
  raw_xcd(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xcd::raw_xcd(INT Ext_file,size_t Pos){
      T_CTOR_RW("xcd",T_raw_xcd_,false,false,Ext_file,Pos)}
***
})

"xce"	(sym-class raw_xce{
user-declaration
  public:
  raw_xce(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xce::raw_xce(INT Ext_file,size_t Pos){
      T_CTOR_RW("xce",T_raw_xce_,false,false,Ext_file,Pos)}
***
})

"xcf"	(sym-class raw_xcf{
user-declaration
  public:
  raw_xcf(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xcf::raw_xcf(INT Ext_file,size_t Pos){
      T_CTOR_RW("xcf",T_raw_xcf_,false,false,Ext_file,Pos)}
***
})

"xd0"	(sym-class raw_xd0{
user-declaration
  public:
  raw_xd0(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xd0::raw_xd0(INT Ext_file,size_t Pos){
      T_CTOR_RW("xd0",T_raw_xd0_,false,false,Ext_file,Pos)}
***
})

"xd1"	(sym-class raw_xd1{
user-declaration
  public:
  raw_xd1(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xd1::raw_xd1(INT Ext_file,size_t Pos){
      T_CTOR_RW("xd1",T_raw_xd1_,false,false,Ext_file,Pos)}
***
})

"xd2"	(sym-class raw_xd2{
user-declaration
  public:
  raw_xd2(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xd2::raw_xd2(INT Ext_file,size_t Pos){
      T_CTOR_RW("xd2",T_raw_xd2_,false,false,Ext_file,Pos)}
***
})

"xd3"	(sym-class raw_xd3{
user-declaration
  public:
  raw_xd3(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xd3::raw_xd3(INT Ext_file,size_t Pos){
      T_CTOR_RW("xd3",T_raw_xd3_,false,false,Ext_file,Pos)}
***
})

"xd4"	(sym-class raw_xd4{
user-declaration
  public:
  raw_xd4(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xd4::raw_xd4(INT Ext_file,size_t Pos){
      T_CTOR_RW("xd4",T_raw_xd4_,false,false,Ext_file,Pos)}
***
})

"xd5"	(sym-class raw_xd5{
user-declaration
  public:
  raw_xd5(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xd5::raw_xd5(INT Ext_file,size_t Pos){
      T_CTOR_RW("xd5",T_raw_xd5_,false,false,Ext_file,Pos)}
***
})

"xd6"	(sym-class raw_xd6{
user-declaration
  public:
  raw_xd6(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xd6::raw_xd6(INT Ext_file,size_t Pos){
      T_CTOR_RW("xd6",T_raw_xd6_,false,false,Ext_file,Pos)}
***
})

"xd7"	(sym-class raw_xd7{
user-declaration
  public:
  raw_xd7(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xd7::raw_xd7(INT Ext_file,size_t Pos){
      T_CTOR_RW("xd7",T_raw_xd7_,false,false,Ext_file,Pos)}
***
})

"xd8"	(sym-class raw_xd8{
user-declaration
  public:
  raw_xd8(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xd8::raw_xd8(INT Ext_file,size_t Pos){
      T_CTOR_RW("xd8",T_raw_xd8_,false,false,Ext_file,Pos)}
***
})

"xd9"	(sym-class raw_xd9{
user-declaration
  public:
  raw_xd9(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xd9::raw_xd9(INT Ext_file,size_t Pos){
      T_CTOR_RW("xd9",T_raw_xd9_,false,false,Ext_file,Pos)}
***
})

"xda"	(sym-class raw_xda{
user-declaration
  public:
  raw_xda(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xda::raw_xda(INT Ext_file,size_t Pos){
      T_CTOR_RW("xda",T_raw_xda_,false,false,Ext_file,Pos)}
***
})

"xdb"	(sym-class raw_xdb{
user-declaration
  public:
  raw_xdb(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xdb::raw_xdb(INT Ext_file,size_t Pos){
      T_CTOR_RW("xdb",T_raw_xdb_,false,false,Ext_file,Pos)}
***
})

"xdc"	(sym-class raw_xdc{
user-declaration
  public:
  raw_xdc(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xdc::raw_xdc(INT Ext_file,size_t Pos){
      T_CTOR_RW("xdc",T_raw_xdc_,false,false,Ext_file,Pos)}
***
})

"xdd"	(sym-class raw_xdd{
user-declaration
  public:
  raw_xdd(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xdd::raw_xdd(INT Ext_file,size_t Pos){
      T_CTOR_RW("xdd",T_raw_xdd_,false,false,Ext_file,Pos)}
***
})

"xde"	(sym-class raw_xde{
user-declaration
  public:
  raw_xde(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xde::raw_xde(INT Ext_file,size_t Pos){
      T_CTOR_RW("xde",T_raw_xde_,false,false,Ext_file,Pos)}
***
})

"xdf"	(sym-class raw_xdf{
user-declaration
  public:
  raw_xdf(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xdf::raw_xdf(INT Ext_file,size_t Pos){
      T_CTOR_RW("xdf",T_raw_xdf_,false,false,Ext_file,Pos)}
***
})

"xe0"	(sym-class raw_xe0{
user-declaration
  public:
  raw_xe0(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xe0::raw_xe0(INT Ext_file,size_t Pos){
      T_CTOR_RW("xe0",T_raw_xe0_,false,false,Ext_file,Pos)}
***
})

"xe1"	(sym-class raw_xe1{
user-declaration
  public:
  raw_xe1(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xe1::raw_xe1(INT Ext_file,size_t Pos){
      T_CTOR_RW("xe1",T_raw_xe1_,false,false,Ext_file,Pos)}
***
})

"xe2"	(sym-class raw_xe2{
user-declaration
  public:
  raw_xe2(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xe2::raw_xe2(INT Ext_file,size_t Pos){
      T_CTOR_RW("xe2",T_raw_xe2_,false,false,Ext_file,Pos)}
***
})

"xe3"	(sym-class raw_xe3{
user-declaration
  public:
  raw_xe3(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xe3::raw_xe3(INT Ext_file,size_t Pos){
      T_CTOR_RW("xe3",T_raw_xe3_,false,false,Ext_file,Pos)}
***
})

"xe4"	(sym-class raw_xe4{
user-declaration
  public:
  raw_xe4(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xe4::raw_xe4(INT Ext_file,size_t Pos){
      T_CTOR_RW("xe4",T_raw_xe4_,false,false,Ext_file,Pos)}
***
})

"xe5"	(sym-class raw_xe5{
user-declaration
  public:
  raw_xe5(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xe5::raw_xe5(INT Ext_file,size_t Pos){
      T_CTOR_RW("xe5",T_raw_xe5_,false,false,Ext_file,Pos)}
***
})

"xe6"	(sym-class raw_xe6{
user-declaration
  public:
  raw_xe6(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xe6::raw_xe6(INT Ext_file,size_t Pos){
      T_CTOR_RW("xe6",T_raw_xe6_,false,false,Ext_file,Pos)}
***
})

"xe7"	(sym-class raw_xe7{
user-declaration
  public:
  raw_xe7(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xe7::raw_xe7(INT Ext_file,size_t Pos){
      T_CTOR_RW("xe7",T_raw_xe7_,false,false,Ext_file,Pos)}
***
})

"xe8"	(sym-class raw_xe8{
user-declaration
  public:
  raw_xe8(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xe8::raw_xe8(INT Ext_file,size_t Pos){
      T_CTOR_RW("xe8",T_raw_xe8_,false,false,Ext_file,Pos)}
***
})

"xe9"	(sym-class raw_xe9{
user-declaration
  public:
  raw_xe9(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xe9::raw_xe9(INT Ext_file,size_t Pos){
      T_CTOR_RW("xe9",T_raw_xe9_,false,false,Ext_file,Pos)}
***
})

"xea"	(sym-class raw_xea{
user-declaration
  public:
  raw_xea(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xea::raw_xea(INT Ext_file,size_t Pos){
      T_CTOR_RW("xea",T_raw_xea_,false,false,Ext_file,Pos)}
***
})

"xeb"	(sym-class raw_xeb{
user-declaration
  public:
  raw_xeb(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xeb::raw_xeb(INT Ext_file,size_t Pos){
      T_CTOR_RW("xeb",T_raw_xeb_,false,false,Ext_file,Pos)}
***
})

"xec"	(sym-class raw_xec{
user-declaration
  public:
  raw_xec(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xec::raw_xec(INT Ext_file,size_t Pos){
      T_CTOR_RW("xec",T_raw_xec_,false,false,Ext_file,Pos)}
***
})

"xed"	(sym-class raw_xed{
user-declaration
  public:
  raw_xed(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xed::raw_xed(INT Ext_file,size_t Pos){
      T_CTOR_RW("xed",T_raw_xed_,false,false,Ext_file,Pos)}
***
})

"xee"	(sym-class raw_xee{
user-declaration
  public:
  raw_xee(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xee::raw_xee(INT Ext_file,size_t Pos){
      T_CTOR_RW("xee",T_raw_xee_,false,false,Ext_file,Pos)}
***
})

"xef"	(sym-class raw_xef{
user-declaration
  public:
  raw_xef(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xef::raw_xef(INT Ext_file,size_t Pos){
      T_CTOR_RW("xef",T_raw_xef_,false,false,Ext_file,Pos)}
***
})

"xf0"	(sym-class raw_xf0{
user-declaration
  public:
  raw_xf0(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xf0::raw_xf0(INT Ext_file,size_t Pos){
      T_CTOR_RW("xf0",T_raw_xf0_,false,false,Ext_file,Pos)}
***
})

"xf1"	(sym-class raw_xf1{
user-declaration
  public:
  raw_xf1(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xf1::raw_xf1(INT Ext_file,size_t Pos){
      T_CTOR_RW("xf1",T_raw_xf1_,false,false,Ext_file,Pos)}
***
})

"xf2"	(sym-class raw_xf2{
user-declaration
  public:
  raw_xf2(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xf2::raw_xf2(INT Ext_file,size_t Pos){
      T_CTOR_RW("xf2",T_raw_xf2_,false,false,Ext_file,Pos)}
***
})

"xf3"	(sym-class raw_xf3{
user-declaration
  public:
  raw_xf3(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xf3::raw_xf3(INT Ext_file,size_t Pos){
      T_CTOR_RW("xf3",T_raw_xf3_,false,false,Ext_file,Pos)}
***
})

"xf4"	(sym-class raw_xf4{
user-declaration
  public:
  raw_xf4(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xf4::raw_xf4(INT Ext_file,size_t Pos){
      T_CTOR_RW("xf4",T_raw_xf4_,false,false,Ext_file,Pos)}
***
})

"xf5"	(sym-class raw_xf5{
user-declaration
  public:
  raw_xf5(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xf5::raw_xf5(INT Ext_file,size_t Pos){
      T_CTOR_RW("xf5",T_raw_xf5_,false,false,Ext_file,Pos)}
***
})

"xf6"	(sym-class raw_xf6{
user-declaration
  public:
  raw_xf6(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xf6::raw_xf6(INT Ext_file,size_t Pos){
      T_CTOR_RW("xf6",T_raw_xf6_,false,false,Ext_file,Pos)}
***
})

"xf7"	(sym-class raw_xf7{
user-declaration
  public:
  raw_xf7(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xf7::raw_xf7(INT Ext_file,size_t Pos){
      T_CTOR_RW("xf7",T_raw_xf7_,false,false,Ext_file,Pos)}
***
})

"xf8"	(sym-class raw_xf8{
user-declaration
  public:
  raw_xf8(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xf8::raw_xf8(INT Ext_file,size_t Pos){
      T_CTOR_RW("xf8",T_raw_xf8_,false,false,Ext_file,Pos)}
***
})

"xf9"	(sym-class raw_xf9{
user-declaration
  public:
  raw_xf9(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xf9::raw_xf9(INT Ext_file,size_t Pos){
      T_CTOR_RW("xf9",T_raw_xf9_,false,false,Ext_file,Pos)}
***
})

"xfa"	(sym-class raw_xfa{
user-declaration
  public:
  raw_xfa(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xfa::raw_xfa(INT Ext_file,size_t Pos){
      T_CTOR_RW("xfa",T_raw_xfa_,false,false,Ext_file,Pos)}
***
})

"xfb"	(sym-class raw_xfb{
user-declaration
  public:
  raw_xfb(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xfb::raw_xfb(INT Ext_file,size_t Pos){
      T_CTOR_RW("xfb",T_raw_xfb_,false,false,Ext_file,Pos)}
***
})

"xfc"	(sym-class raw_xfc{
user-declaration
  public:
  raw_xfc(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xfc::raw_xfc(INT Ext_file,size_t Pos){
      T_CTOR_RW("xfc",T_raw_xfc_,false,false,Ext_file,Pos)}
***
})

"xfd"	(sym-class raw_xfd{
user-declaration
  public:
  raw_xfd(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xfd::raw_xfd(INT Ext_file,size_t Pos){
      T_CTOR_RW("xfd",T_raw_xfd_,false,false,Ext_file,Pos)}
***
})

"xfe"	(sym-class raw_xfe{
user-declaration
  public:
  raw_xfe(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xfe::raw_xfe(INT Ext_file,size_t Pos){
      T_CTOR_RW("xfe",T_raw_xfe_,false,false,Ext_file,Pos)}
***
})

"xff"	(sym-class raw_xff{
user-declaration
  public:
  raw_xff(INT Ext_file,size_t Pos);
***
user-implementation
  raw_xff::raw_xff(INT Ext_file,size_t Pos){
      T_CTOR_RW("xff",T_raw_xff_,false,false,Ext_file,Pos)}
***
}
)

}
