/*
  Copyright Dave Bone 1998 - 2014
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.

File:    yacco2_err_symbols.lex
Date:    7 July 2003
Author:  Dave Bone
*/
/@
@i "/yacco2/copyright.w"
@** Error symbols vocabulary.\fbreak
Error symbols for the telling.\fbreak
Due to my verbosity and |cweb|'s (\TeX) black slug output 
some of my symbol keys are
more cryptic in description as i wanted to title them with
their enumeration symbol.
Now, the enumeration symbol is removed from the index so there is
no blob of ...
If the truth be told, these descriptions should
be indirect key values that allow for 
multilingual translation.
One step at a time...

Upon experimentation with error keys 
having a suffixed Exxx indicator in the key itself
whereby
the xxx is a number: 001 and 
associating a translation file with the error construct, i nixed the ideas.
It is simply a post error evaluation on the given
error keys to translate them using some form of associated map. 
The error enumeration key with a language indicator would suffice.
A simple database could be used.
For example T\_Enum::T\_LR1\_err\_nested\_files\_exceeded\_ with
 a country code of ``DE'' for
German would translate ``nested files exceeded''.
Not finding a translation should default to the error token's
literal key.
See grammar ``o2\_err\_hdr.lex'' for a context sensitive approach to error reporting.


Ahh... grandeur. Now what about unicode?
@/

error-symbols
(file-name	yacco2_err_symbols
,name-space	NS_yacco2_err_symbols)
{
"nested files exceeded"  
(sym-class	Err_nested_files_exceeded	{
	user-declaration
		public:
	Err_nested_files_exceeded(yacco2::INT Nested_file_cnt,std::string& File_name);
		yacco2::INT nested_cnt(){return nested_cnt_;};
		std::string* file_exceeded(){return &file_exceeded_;};
		private:
			yacco2::INT nested_cnt_;
			std::string file_exceeded_;
	***
	user-implementation
		Err_nested_files_exceeded::
		Err_nested_files_exceeded(yacco2::INT Nested_cnt,std::string& File_name)
	      T_CTOR("nested files exceeded",T_Enum::T_Err_nested_files_exceeded_,0,false,false)
		  {nested_cnt_ = Nested_cnt;file_exceeded_ += File_name.c_str();}
	***
	}
)
"no end-of-code"  (sym-class	Err_no_end_of_code)
"no cmd-lne-data" (sym-class	Err_no_cmd_lne_data)
"no filename"     (sym-class	Err_no_filename)
"bad filename" 
(sym-class	Err_bad_filename	{
	user-declaration
		public:
		Err_bad_filename(std::string& File_name);
		Err_bad_filename(const char* File_name);
		std::string* file_name();
		private:
			std::string file_name_;
	***
	user-implementation
		Err_bad_filename::
		Err_bad_filename(std::string& File_name)
      T_CTOR("bad filename",T_Enum::T_Err_bad_filename_,0,false,false)
		  {file_name_ += File_name.c_str();}
		Err_bad_filename::
		Err_bad_filename(const char* File_name)
      T_CTOR("bad filename",T_Enum::T_Err_bad_filename_,0,false,false)
		  {file_name_ += File_name;}
		std::string* Err_bad_filename::file_name(){return &file_name_;}
	***
	}
)
"bad filename to output grammar header" 
(sym-class	Err_bad_fsmheader_filename	{
	user-declaration
		public:
		Err_bad_fsmheader_filename(std::string& File_name);
		Err_bad_fsmheader_filename(const char* File_name);
		std::string* file_name();
		private:
			std::string file_name_;
	***
	user-implementation
		Err_bad_fsmheader_filename::
		Err_bad_fsmheader_filename(std::string& File_name)
T_CTOR("bad filename to output grammar header",T_Enum::T_Err_bad_fsmheader_filename_,0,false,false)
		  {file_name_ += File_name.c_str();}
		Err_bad_fsmheader_filename::
		Err_bad_fsmheader_filename(const char* File_name)
T_CTOR("bad filename to output grammar header",T_Enum::T_Err_bad_fsmheader_filename_,0,false,false)
		  {file_name_ += File_name;}
		std::string* Err_bad_fsmheader_filename::file_name(){return &file_name_;}
	***
	}
)
"bad filename to output cpp" 
(sym-class	Err_bad_fsmcpp_filename	{
	user-declaration
		public:
		Err_bad_fsmcpp_filename(std::string& File_name);
		Err_bad_fsmcpp_filename(const char* File_name);
		std::string* file_name();
		private:
			std::string file_name_;
	***
	user-implementation
		Err_bad_fsmcpp_filename::
		Err_bad_fsmcpp_filename(std::string& File_name)
T_CTOR("bad filename to output cpp",T_Enum::T_Err_bad_fsmcpp_filename_,0,false,false)
		  {file_name_ += File_name.c_str();}
		Err_bad_fsmcpp_filename::
		Err_bad_fsmcpp_filename(const char* File_name)
T_CTOR("bad filename to output cpp",T_Enum::T_Err_bad_fsmcpp_filename_,0,false,false)
		  {file_name_ += File_name;}
		std::string* Err_bad_fsmcpp_filename::file_name(){return &file_name_;}
	***
	}
)
"bad filename to output sym" 
(sym-class	Err_bad_fsmsym_filename	{
	user-declaration
		public:
		Err_bad_fsmsym_filename(std::string& File_name);
		Err_bad_fsmsym_filename(const char* File_name);
		std::string* file_name();
		private:
			std::string file_name_;
	***
	user-implementation
		Err_bad_fsmsym_filename::
		Err_bad_fsmsym_filename(std::string& File_name)
T_CTOR("bad filename to output sym",T_Enum::T_Err_bad_fsmsym_filename_,0,false,false)
		  {file_name_ += File_name.c_str();}
		Err_bad_fsmsym_filename::
		Err_bad_fsmsym_filename(const char* File_name)
T_CTOR("bad filename to output sym",T_Enum::T_Err_bad_fsmsym_filename_,0,false,false)
		  {file_name_ += File_name;}
		std::string* Err_bad_fsmsym_filename::file_name(){return &file_name_;}
	***
	}
)
"bad filename to output tbl" 
(sym-class	Err_bad_fsmtbl_filename	{
	user-declaration
		public:
		Err_bad_fsmtbl_filename(std::string& File_name);
		Err_bad_fsmtbl_filename(const char* File_name);
		std::string* file_name();
		private:
			std::string file_name_;
	***
	user-implementation
	Err_bad_fsmtbl_filename::
	Err_bad_fsmtbl_filename(std::string& File_name)
T_CTOR("bad filename to output tbl",T_Enum::T_Err_bad_fsmtbl_filename_,0,false,false)
	  {file_name_ += File_name.c_str();}
	Err_bad_fsmtbl_filename::
	Err_bad_fsmtbl_filename(const char* File_name)
T_CTOR("bad filename to output tbl",T_Enum::T_Err_bad_fsmtbl_filename_,0,false,false)
	  {file_name_ += File_name;}
	std::string* Err_bad_fsmtbl_filename::file_name(){return &file_name_;}
	***
	}
)
"bad filename to output enumeration header" 
(sym-class	Err_bad_enum_filename	{
	user-declaration
		public:
		Err_bad_enum_filename(std::string& File_name);
		Err_bad_enum_filename(const char* File_name);
		std::string* file_name();
		private:
			std::string file_name_;
	***
	user-implementation
		Err_bad_enum_filename::
		Err_bad_enum_filename(std::string& File_name)
T_CTOR("bad filename to output enumeration header",T_Enum::T_Err_bad_enum_filename_,0,false,false)
		  {file_name_ += File_name.c_str();}
		Err_bad_enum_filename::
		Err_bad_enum_filename(const char* File_name)
T_CTOR("bad filename to output enumeration header",T_Enum::T_Err_bad_enum_filename_,0,false,false)
		  {file_name_ += File_name;}
		std::string* Err_bad_enum_filename::file_name(){return &file_name_;}
	***
	}
)

"bad filename for Errors vocabulary header" 
(sym-class	Err_bad_errors_hdrfilename	{
	user-declaration
		public:
		Err_bad_errors_hdrfilename(std::string& File_name);
		Err_bad_errors_hdrfilename(const char* File_name);
		std::string* file_name();
		private:
		std::string file_name_;
	***
	user-implementation
		Err_bad_errors_hdrfilename::
		Err_bad_errors_hdrfilename(std::string& File_name)
T_CTOR("bad filename for Errors vocabulary header",T_Enum::T_Err_bad_errors_hdrfilename_,0,false,false)
		  {file_name_ += File_name.c_str();}
		Err_bad_errors_hdrfilename::
		Err_bad_errors_hdrfilename(const char* File_name)
T_CTOR("bad filename for Errors vocabulary header",T_Enum::T_Err_bad_errors_hdrfilename_,0,false,false)
		  {file_name_ += File_name;}
		std::string* Err_bad_errors_hdrfilename::file_name(){return &file_name_;}
	***
	}
)

"bad filename for Errors vocabulary implementation" 
(sym-class	Err_bad_errors_impfilename	{
	user-declaration
		public:
		Err_bad_errors_impfilename(std::string& File_name);
		Err_bad_errors_impfilename(const char* File_name);
		std::string* file_name();
		private:
		std::string file_name_;
	***
	user-implementation
		Err_bad_errors_impfilename::
		Err_bad_errors_impfilename(std::string& File_name)
T_CTOR("bad filename for Errors vocabulary implementation",T_Enum::T_Err_bad_errors_impfilename_,0,false,false)
		  {file_name_ += File_name.c_str();}
		Err_bad_errors_impfilename::
		Err_bad_errors_impfilename(const char* File_name)
T_CTOR("bad filename for Errors vocabulary implementation",T_Enum::T_Err_bad_errors_impfilename_,0,false,false)
		  {file_name_ += File_name;}
		std::string* Err_bad_errors_impfilename::file_name(){return &file_name_;}
	***
	}
)

"bad cmd-opt"     (sym-class	Err_bad_cmd_lne_opt)
"bad int-no"      (sym-class	Err_bad_int_no)
"bad int-no range"(sym-class	Err_bad_int_no_range)
"no int present"  (sym-class	Err_no_int_present)
"bad eos"         (sym-class	Err_bad_eos)  
"bad esc"         (sym-class	Err_bad_esc)  
"comment-overrun" (sym-class	Err_comment_overrun) 

"bad char"	
  (sym-class	Err_bad_char{
	user-declaration
		public:
		Err_bad_char(CAbs_lr1_sym* Err_char);
		yacco2::CAbs_lr1_sym* bad_char()const;
		void zero_out_bad_char();
		private:
		yacco2::CAbs_lr1_sym* bad_char_;
	***
	destructor
	  if(R->bad_char_!=0)
		delete R->bad_char();
	***
	user-implementation
		Err_bad_char::
		Err_bad_char(CAbs_lr1_sym* Bad_char)
T_CTOR("bad char",T_Enum::T_Err_bad_char_,&dtor_Err_bad_char,false,false)
		  {bad_char_ = Bad_char;}
		yacco2::CAbs_lr1_sym* Err_bad_char::bad_char()const{return bad_char_;}
		void Err_bad_char::zero_out_bad_char(){bad_char_ = 0;}
	***
	}
)

"bad univ-seq"	(sym-class	Err_bad_univ_seq{
	user-declaration
		public:
		Err_bad_univ_seq(unsigned long Value);
		unsigned long bad_univ_seq()const;
		private:unsigned long bad_univ_seq_;
	***
	user-implementation
		Err_bad_univ_seq::
		Err_bad_univ_seq(unsigned long Bad_univ_seq)
	    T_CTOR("bad univ seq",T_Enum::T_Err_bad_univ_seq_,0,false,false)
	    {bad_univ_seq_ = Bad_univ_seq;
	    }
		unsigned long 
		Err_bad_univ_seq::bad_univ_seq()const{return bad_univ_seq_;}
	***
	}
)
"improper closing of rules construct"  
    (sym-class	Err_improper_closing_of_rules)
"no identifier present"     (sym-class Err_no_identifier_present)
"no directive present"      (sym-class Err_no_directive_present)
"duplicate directive"       (sym-class Err_duplicate_directive)
"no syntax-code present"    (sym-class Err_no_syntax_code_present)
"no open-parenthesis"       (sym-class Err_no_open_parenthesis)
"no close-parenthesis"      (sym-class Err_no_close_parenthesis)
"no fsm-id-present"         (sym-class Err_no_fsm_id_present)
"no fsm-id-string present"  (sym-class Err_no_fsm_id_string)
"no fsm-filename present"   (sym-class Err_no_fsm_filename_present)
"no fsm-filename id present"(sym-class Err_no_fsm_filename_id_present)

"no comma present"          (sym-class Err_no_comma_present)
"no fsm-namespace present"  (sym-class Err_no_fsm_namespace_present)
"no fsm-namespace id present"(sym-class Err_no_fsm_namespace_id_present)
"no fsm-class present"      (sym-class Err_no_fsm_class_present)

"no fsm-version present"         (sym-class Err_no_fsm_version_present)
"no fsm-version string present"  (sym-class Err_no_fsm_version_string)
"no fsm-date present"         (sym-class Err_no_fsm_date_present)
"no fsm-date string present"  (sym-class Err_no_fsm_date_string)
"no fsm-debug present"         (sym-class Err_no_fsm_debug_present)
"no fsm-debug string present"  (sym-class Err_no_fsm_debug_string)
"no fsm-comments present"         (sym-class Err_no_fsm_comments_present)
"no fsm-comments string present"  (sym-class Err_no_fsm_comments_string)
"invalid fsm-debug value"  (sym-class Err_fsm_debug_string_not_true_or_false)

"no parallel-thread-function"  (sym-class Err_no_pp_thread_function_present)
"no parallel-control-monitor"  (sym-class Err_no_pp_ctrl_mntor_kw_present)
"no parallel thread function"  (sym-class Err_no_pp_fnct_id_present)
"no parallel-la-boundary" (sym-class Err_no_pp_bndry_present)
"no parallel-la-boundary-expr" (sym-class Err_no_pp_la_bndary_expr_present)
"no ***" (sym-class Err_no_syntax_code_end_present)
"no parallel-code" (sym-class Err_no_pp_code_present)
"no parallel-code-syntax-code" (sym-class Err_no_pp_code_stc_present)
"not an arbitration-code keyword" (sym-class Err_not_arbitration_code_kw)

"no open-brace"       (sym-class Err_no_open_brace)
"no close-brace"      (sym-class Err_no_close_brace)
"no constant-defs-directive present" (sym-class Err_no_constant_defs_present)
"no file-name present"   (sym-class Err_no_filename_present)
"no file-name-id present"(sym-class Err_no_filename_id_present)
"no name-space present"  (sym-class Err_no_namespace_present)
"no name-space-id present"(sym-class Err_no_namespace_id_present)
"no constant-defs-code present"(sym-class Err_no_kdefs_code_present)
"no constant-defs keyword present"(sym-class Err_no_kdefs_kw_present)
"no terminal-def-code present"(sym-class Err_no_tdef_code_present)

"no symbol definition present" (sym-class Err_no_sym_defs_present)
"no key-value present in definition" (sym-class Err_no_terminal_key_present)
"duplicate-entry in alphabet" (sym-class Err_dup_entry_in_alphabet)
"already defined AB tag" (sym-class Err_already_defined_AB)
"already defined AD tag" (sym-class Err_already_defined_AD)
"improper directive" (sym-class Err_improper_directive)
"no sym-class present" (sym-class Err_no_sym_class_present)
"no sym-class id present" (sym-class Err_no_sym_class_id_present)

"zero len symbol" (sym-class Err_zero_len_sym)
"stbl full" (sym-class Err_sym_tbl_full)
"stbl char-pool full" (sym-class Err_sym_tbl_char_pool_full)
"dup-entry in sym-table" (sym-class Err_dup_entry_in_sym_table)
"subscript out-of-range" (sym-class Err_subscript_out_of_range)
"stbl scope-stk overflow" (sym-class Err_sym_tbl_nested_scope_stk_overflow)
"stbl scope-stk underflow" (sym-class Err_sym_tbl_nested_scope_stk_underflow)
"stbl context-buf-overflow" (sym-class Err_sym_tbl_context_buf_overflow)
"report-card-ptr-0" (sym-class Err_report_card_ptr_0)
"bad pos of t def" (sym-class Err_cannot_define_term_after_sufx_dir)
"dup ? sufx directive" (sym-class Err_dup_sufx_directive)
"bad pos of terminals-refs" (sym-class Err_terminals_refs_def_after_terminals)
"terminals-refs duplicate" (sym-class Err_terminals_refs_dup_def)
"no rule name present" (sym-class Err_no_rule_name_present)
"no sub rule present" (sym-class Err_no_sub_rule_present)
"undefined terminal in subrule" (sym-class Err_subrule_use_undefined_T)
"unknown symbol type in stbl" (sym-class Err_stbl_entry_unknown)
"subrule overrun" (sym-class Err_subrule_overrun)
"stbl has entry but not a rule" (sym-class Err_stble_has_entry_but_not_a_rule)

"no file-of-T-alphabet" (sym-class Err_file_of_T_alphabet_kw_not_present)
"emitfile kw not present" (sym-class Err_emitfile_kw_not_present)
"preamble kw not present" (sym-class Err_preamble_kw_not_present)
"no preamble source code" (sym-class Err_preamble_srce_code_not_present)
"no end-preamble present" (sym-class Err_end_preamble_kw_not_present)
"command line chaffe" (sym-class Err_cmd_line_chaffe)
"T-alphabet kw not present" (sym-class Err_T_alphabet_kw_not_present)
"T-alphabet file not present" (sym-class Err_T_alphabet_file_not_present)
"no end-T-alphabet present" (sym-class Err_end_T_alphabet_kw_not_present)
"no T in T-alphabet list" (sym-class Err_no_terminals_in_T_alphabet_list)
"rotten chr in T-alphabet" (sym-class Err_rotten_chr_in_T_alphabet)
"no transitive present" (sym-class Err_transitive_kw_not_present)
"no grammar-name present" (sym-class Err_grammar_name_kw_not_present)
"no name-space" (sym-class Err_namespace_kw_not_present)
"no file-name kw present" (sym-class Err_filename_kw_not_present)
"no thread-name present" (sym-class Err_threadname_kw_not_present)
"no monolithic present" (sym-class Err_monolithic_kw_not_present)
"no no-of-T present" (sym-class Err_no_of_T_kw_not_present)
"no list-of-native-terminals" (sym-class Err_list_of_terminals_kw_not_present)
"no list-of-transit..." (sym-class Err_no_list_of_trans_threads_kw)
"no Ts in T-alphabet" (sym-class Err_no_terminals_present_in_T_alphabet)
"linker's transitive value not n or y" (sym-class Err_transitive_value_bad)
"linker's monolithic value not n or y" (sym-class Err_monolithic_value_bad)
"no grammar-name value" (sym-class Err_grammar_name_value_not_present)
"no name-space value" (sym-class Err_namespace_value_not_present)
"no thread-name value" (sym-class Err_threadname_value_not_present)
"no file-name value" (sym-class Err_filename_value_not_present)
"no-of-T value not present" (sym-class Err_no_of_T_value_not_present)
"no# in list-of-native-term..." (sym-class Err_no_of_terminals_not_present)
"no end-list-of-native..." (sym-class Err_end_list_native_T_kw_not_present)
"no end-list-of-trans..." (sym-class Err_end_list_of_transitive_threads_kw_not_present)

"# T in list not eq"	(sym-class	Err_no_of_native_Ts_in_list_not_equal{
	user-declaration
		public:
		Err_no_of_native_Ts_in_list_not_equal(unsigned long Value);
		unsigned long no()const;
		private:unsigned long no_;
	***
	user-implementation
		Err_no_of_native_Ts_in_list_not_equal::
		Err_no_of_native_Ts_in_list_not_equal(unsigned long No)
T_CTOR("no terminals in list not equal, chk items in list",T_Enum::T_Err_no_of_native_Ts_in_list_not_equal_,0,false,false)
	    {  no_ = No;}
		unsigned long 
		Err_no_of_native_Ts_in_list_not_equal::no()const{return no_;}
	***
	}
)

"# threads in list not eq"	(sym-class	Err_no_of_threads_in_list_not_equal{
	user-declaration
		public:
		Err_no_of_threads_in_list_not_equal(unsigned long No);
		unsigned long no()const;
		private:unsigned long no_;
	***
	user-implementation
		Err_no_of_threads_in_list_not_equal::
		Err_no_of_threads_in_list_not_equal(unsigned long No)
T_CTOR("no threads in list not equal, chk list",T_Enum::T_Err_no_of_threads_in_list_not_equal_,0,false,false)
	    {  no_ = No;}
		unsigned long 
		Err_no_of_threads_in_list_not_equal::no()const{return no_;}
	***
	}
)

"thread xrefed, but not defed"	
    (sym-class	Err_thread_refed_but_not_defined{
	user-declaration
		public:
		Err_thread_refed_but_not_defined(CAbs_lr1_sym* Th_id);
		CAbs_lr1_sym* th_id();
		private:CAbs_lr1_sym* th_id_;
	***
	user-implementation
		Err_thread_refed_but_not_defined::
		Err_thread_refed_but_not_defined(CAbs_lr1_sym* Th_id)
T_CTOR("thread xrefed, but not defed",T_Enum::T_Err_thread_refed_but_not_defined_,0,false,false)
	    {  th_id_ = Th_id;}
yacco2::CAbs_lr1_sym* Err_thread_refed_but_not_defined::th_id(){return th_id_;};
	***
	}
)
"T in list not defined in T-alphabet"
/@
\Olinker message. It indicates that the terminal
is not defined in ``T-alphabet'' construct.
This is the T vocabulary.
If the terminal is not defined, it means that the 
grammar writer has not generated the vocabulary.
So turn on the /t option and re-compile a grammar thus
creating the updated list.
@/
 (sym-class Err_bad_T_in_list)
 
"transitive list thread not defined by fsc files"
/@
The hand coded ``???.fsc'' control file provides
all the threads' ``fsc'' files has thread entries missing.
Typically the grammar writer created a new thread but forgot the 
include it in the global ``fsc'' file.
So go add the missing thread entries in the global ``fsc'' file.
@/
 (sym-class Err_bad_th_in_list)
"thread defined by another fsc file" 
/@
Each individual thread's fsc file contains its bio.
This error indicates that the grammar writer probably
cloned off a grammar but did not
edit properly the vital statistics.
So go edit the erroneous grammar and correct
its thread name, namespace etc.
@/
(sym-class Err_already_defined_in_fsc_file)

"thread in stbl but subscript badly set" 
/@
More of a sanity check in the symbol table.
If this occurs i'm really in trouble.
@/
(sym-class Err_bad_thread_subscript)

"token found in stbl but not a kw"
/@
The symbol is not a keyword. Could be an initialization
problem with my \O2 setup.
@/
 (sym-class Err_not_a_keyword)

"no# in list-of-trans..." 
/@
Cross check against the \O2 linker ``fsc'' info.
The ``list-of-transitive-threads'' construct also
states the number of entries in its list.
Some how they don't jive.
i think thar's something rotten in the fingers and 
diletants playing with the file?
@/
(sym-class Err_no_of_threads_not_present)

"re-compile grammar: bad T-alphabet" 
/@
Mismatch with the contents of the ``T-alphabet'' construct and the 
number of terminals stated in each individual grammar ``fsc'' file.
Usually means that terminals of some ilk have changed the
population and requires a recompilation per grammar
to match the vocabulary numbers.
That is regen grammars with the ``-t'' and ``-err'' switches.
This gens the eumeration file that ``o2linker'' depends on.
@/
(sym-class Err_bad_T_alphabet)

"fsc file does not exist" (sym-class Err_fsc_file_does_not_exist)
"file-name file does not exist" (sym-class Err_filename_file_does_not_exist)
"T-alphabet file does not exist" 
    (sym-class Err_T_alphabet_file_does_not_exist)
"emitfile file does not exist" (sym-class Err_emitfile_file_does_not_exist)
"emitfile file not present" (sym-class Err_emitfile_file_not_present)
"fsc file not present" (sym-class Err_fsc_cntl_file_not_present)
"file of T-alphabet not present" (sym-class Err_file_of_T_alphabet_not_present)

"O2 epsilon badly gened: 0 items in fsc lists" 
/@
\O2 states that a thread has epsilon pass thru of thread calling.
Example the called thread start state has an epsilon subrule.
Sanity check or paranoia on my work.
@/
(sym-class Err_epsilon_pass_thru)

"O2 epsilon: T present, but no T list"
/@ 
\O2 states that a thread has epsilon pass thru of thread calling.
Example the called thread start state has an epsilon subrule.
Sanity check or paranoia on my work.
@/
(sym-class Err_epsilon_pass_thru_no_Ts)

"rule not found in stbl" 
/@
Post process the grammar's vocabulary. 
A rule can be referenced before
its definition.
Just help the grammar writer of misselling or forgetfulness.
@/
(sym-class Err_rule_not_in_stbl)

"T not found in stbl" 
/@
Either the grammmar writer forgot to add a new T definition or
its a mistype.
@/
(sym-class Err_T_not_in_stbl)

"bad directive" (sym-class Err_bad_directive)

"bad term in la expr" 
/@
Must be a Rule or a T term within the subrule expression.
@/
(sym-class Err_bad_term_in_la_expr)

"removal of term against empty set in la expr" 
/@
Bad expression where a removal expression is against an empty set.
For example, a - eolr - b is invalid. The eolr empties the set.
a - eolr + b is a round about way of having just b in the set.
@/
(sym-class Err_empty_set_removal_in_la_expr)

"bad operator la expr: not a + or -" 
/@
Thread's lookahead expression malformed.
@/
(sym-class Err_bad_operator_in_la_expr)

"not a lhs kw" (sym-class Err_not_a_lhs_kw)
"no parallel-la-bndary expr"
    (sym-class Err_pp_la_boundary_attribute_not_fnd)
"duplicate fsm phrase" (sym-class Err_already_processed_fsm_phase)
"duplicate parallel-parse phrase" (sym-class Err_already_processed_pp_phase)
"duplicate T_enum phrase" (sym-class Err_already_processed_T_enum_phase)
"duplicate error phrase" (sym-class Err_already_processed_error_phase)
"duplicate raw character phrase" (sym-class Err_already_processed_rc_phase)
"duplicate lrk phrase" (sym-class Err_already_processed_lrk_phase)
"duplicate terminal phrase" (sym-class Err_already_processed_T_phase)
"duplicate rule phrase" (sym-class Err_already_processed_rule_phase)
"T not returned from a thread" (sym-class Err_not_T_for_rtned_token_from_th)
"not a namespace id in thread expr" (sym-class Err_not_id_for_ns_in_th_stmt)
"not a thread name id in expr" (sym-class Err_not_id_for_th_name_in_th_stmt)
"bad thread expr" (sym-class Err_bad_th_qualifier)
"not :: in thread expr" (sym-class Err_not_dbl_colon_in_th_stmt)
"bad term in subrule expr" (sym-class Err_not_T_or_R_in_subrule_expr)
"? ended subrule expr" (sym-class Err_not_T_or_R_or_eos_in_subrule_expr)
"not an eosr in subrule expr" (sym-class Err_not_eos_in_subrule_expr)
"invalid logical name" (sym-class Err_invalid_logical_name)
"invalid logical value" (sym-class Err_invalid_logical_value)
"duplicate logical name" (sym-class Err_duplicate_logical_name)
"missing terminals-refs kw" (sym-class Err_missing_terminals_refs_kw)
"missing terminals-sufx kw" (sym-class Err_missing_terminals_sufx_kw)
"not a terminal definition" (sym-class Err_not_a_terminal_definition)
"missing lrk-sufx kw" (sym-class Err_missing_lrk_sufx_kw)
"rule does not gen T strings - sick grammar" (sym-class ERR_sick_grammar)
"misplaced or missing fsm phrase" (sym-class ERR_no_fsm_phrase)
"misplaced or missing T enumeration phrase" (sym-class ERR_no_T_enum_phrase)
"misplaced or missing lrk phrase" (sym-class ERR_no_lrk_phrase)
"misplaced or missing rc phrase" (sym-class ERR_no_rc_phrase)
"misplaced or missing errors phrase" (sym-class ERR_no_errors_phrase)
"misplaced or missing terminals phrase" (sym-class ERR_no_terminals_phrase)
"misplaced or missing rules phrase" (sym-class ERR_no_rules_phrase)
"rule used but undefined" (sym-class Err_used_rule_but_undefined)
"rule already defined" (sym-class Err_rule_already_defined)
"la expression calculates an empty set" (sym-class Err_la_expr_calc_empty_set)
"no closing brace ending rules defs"
    (sym-class Err_no_close_brace_ending_rules_defs)

"use of T outside Rules's construct"
/@
Thrown by |pass3.lex| grammar.
The terminal definitions have already been parsed and
stored in the symbol table.
The symbol table returns the found item as a terminal rather than
the unfound identifier.
Cause is reference of a terminal outside of the Rules construct.
Probably a typo by the grammar writer.
@/
  (sym-class Err_use_of_T_outside_Rules_construct)

"not a kw to start the top/down parse construct"
/@
Thrown by |pass3.lex| grammar.
Caused by an identifier that has been misplaced.
Could be a typo
where the item should be within the
defining Rules Vocabulary or 
a premature ending of the Rules construct by an extra close brace
whereby it is trying to define a rule.
@/
 (sym-class Err_not_kw_defining_grammar_construct)

"use of Non-terminal (rule) outside Rules's construct"
/@
Thrown by |pass3.lex| grammar.
The rule reference has already been 
seen by the parsed Rules construct and
stored in the symbol table.
The symbol table returns the found item as a rule.
Cause is a reference to the rule outside of the Rules construct.
Probably a typo by the grammar writer caused by the premature
parsing of the Rules Vocabulary.
@/
  (sym-class Err_use_of_N_outside_Rules_construct)

"misplaced or misspelt Rule or T outside of Rules defs"
/@
Thrown by |pass3.lex| grammar.
It is outside of a proper grammar's construct and 
does not have a symbol table entry.
So it could be a misspelt T or an orphanned rule outside of its
defining Rules construct.
@/
  (sym-class Err_misplaced_or_misspelt_Rule_or_T)

"not a Rule in chained dispatcher expr" 
/@
Thrown by |subrule_def.lex| grammar supporting the
new back-to-back thread call construct whereby the following procedure call is chained to
the pushed ``return T'' of the 1st thread call.
The term following the 1st thread call expression must be a rule whose
contents use the \\TRAshift operator.
@/
(sym-class Err_not_a_Rule)
"Empty file no grammar constructs present" (sym-class Err_empty_file)
"term not a lhs or parallel-control-monitor kw" (sym-class Err_not_lhs_pcnrl_mntr)
}// end of error symbol definitions


