---
myst:
  html_meta:
    keywords: LaTeX,enseignement de l'écriture,réglure Seyès,grands carreaux,petits carreaux
---
# Comment écrire sur des grands carreaux ?

## Dessiner la réglure

:::{todo} À rédiger.
:::

### Exemple avec « TikZ »

Avec la classe <ctanpkg:sesamanuel> et [sa documentation](texdoc:sesamath-doc-fr), page 68 (en français).

### Exemple avec « PSTricks »

Tiré de [LaTeX pour le prof de maths](https://math.univ-lyon1.fr/irem/IMG/pdf/LatexPourLeProfDeMaths.pdf), page 105 :

```{noedit}
\newcommand\quadrillage[1]{%
  \psset{unit=.8cm}
  \begin{pspicture}(0,-1)(20,#1)
  \multirput(0,1){#1}{%
    \psline[linewidth=0.15pt](0,0.25)(20,0.25)
    \psline[linewidth=0.15pt](0,0.5)(20,0.5)
    \psline[linewidth=0.15pt](0,0.75)(20,0.75)}
    \psgrid[subgriddiv=1,gridlabels=0,%
            gridwidth=1pt,gridcolor=darkgray,%
            subgridwidth=0.1pt, subgridcolor=gray,%
            labels=none](20,#1)%
    \psline[linewidth=1.2pt](2,0)(2,#1)
  \end{pspicture}%
  \smallbreak%
}
```

## Écriture cursive sur les lignes

L'extension <ctanpkg:frcursive> :

French Cursive is a cursive hand-writing font family. Its design is based on the French academic tradition for running-hand. The base shape is upright with lightly contrasted stems and hairlines. All lowercase letters are connected, but most uppercase are independent.

```
\documentclass{article}
\usepackage[T1]{fontenc}
  \usepackage{frcursive}
  \usepackage[french]{babel}
  \pagestyle{empty}

\begin{document}
\cursive\seyes{Mon tailleur est riche\dots}
\end{document}
```

:::{sources}
- [Jean-Alexandre Seyès](wpfr:Jean-Alexandre_Seyès), inventeur de la [réglure à grands carreaux](wpfr:Réglure),
- [Papier seyes en pdf à télécharger](https://pi.ac3j.fr/papier-seyes-en-pdf-telecharger/), réalisé avec PSTricks par Fabrice Arnaud.
:::
