%%
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3c
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%   https://www.latex-project.org/lppl.txt
%% and version 1.3c or later is part of all distributions of LaTeX
%% version 2005/12/01 or later.
%%
%% This work has the LPPL maintenance status `maintained'.
%% The Current Maintainer of this work is Amanullah Nabavi.
%%
%% Copyright (C) 2025 by Amanullah Nabavi nabave786@gmail.com
%%


\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{mohe-book}[2025/01/01 v1.0.0 Custom Latex Class]
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}
\ProcessOptions\relax
\LoadClass[twoside,letterpaper,openright]{book}

\renewcommand{\normalsize}{\fontsize{12}{14.4}\selectfont}
\setlength{\textwidth}{13cm}
\setlength{\textheight}{20cm}
\setlength{\columnsep}{0.8cm}
\pagenumbering{arabic}

\RequirePackage{longfigure}
\RequirePackage{longtable}
\RequirePackage{float}
\RequirePackage{totcount}
\RequirePackage{etoolbox}
\RequirePackage{caption}
\captionsetup{width=0.8\linewidth,labelfont=bf,font=small}
\RequirePackage{enumitem}
\setlist[enumerate, 1]{itemsep=0pt,format=\bfseries,topsep=2pt,label=\arabic*.,ref={\arabic*},left=1pt}
\setlist[enumerate, 2]{itemsep=0pt,format=\bfseries,topsep=2pt,label=(\alph*)}
\RequirePackage{tasks}
\settasks{label=\arabic*.,label-format=\bfseries,style=enumerate,ref={\arabic*},item-indent=1.6em,label-width=1.1em,label-offset=0.5em}
%\RequirePackage{chapterbib}
\RequirePackage{tocloft}
\RequirePackage{lastpage}
\RequirePackage{emptypage}
\RequirePackage{amsmath}
\RequirePackage{amstext}
\RequirePackage{amsthm}
\RequirePackage{amssymb}
\RequirePackage{thmtools}
\RequirePackage{mathtools}
\RequirePackage[inner=4cm,outer=4cm,top=4.5cm,bottom=4.5cm]{geometry}
\RequirePackage{graphics}
\RequirePackage{graphicx}
\RequirePackage{makeidx}
\makeindex
\RequirePackage{fancyhdr}
\RequirePackage{fourier-orns}
\RequirePackage{multicol}
\RequirePackage{xcolor}
\RequirePackage{titlesec}
\RequirePackage{ptext}
\usepackage[xindy,acronym,symbols,esclocations=true,toc,nonumberlist,stylemods=mcols,entrycounter]{glossaries-extra}
\makeglossaries
\RequirePackage{varioref}
\RequirePackage{hyperref}
\RequirePackage{cleveref}
\hypersetup{colorlinks=true,linkcolor=black,urlcolor=cyan,citecolor=yellow,bookmarksopen=true,hypertexnames=true}
\RequirePackage{xpatch}
\newcounter{acronymcount}
\xpretocmd{\newacronym}{\stepcounter{acronymcount}}{}{}
\xpretocmd{\printindex}{\cleardoublepage\phantomsection\addcontentsline{toc}{chapter}{نمایه}}{}{}
\newcommand{\printmyglossary}{\cleardoublepage
\printglossary[style={myFaToEn},title={واژه‌نامه}]}
\newcommand{\printmyacronyms}{\cleardoublepage\printacronyms[style={myAbbr},title={فهرست اختصارات}]}
\newcommand{\printmysymbols}{\cleardoublepage\printsymbols[style={mySymbols},title={فهرست نمادها}]}



\AtEndPreamble{
\newtheoremstyle{mohestyle}{2pt plus 1pt minus 1pt}{3pt plus 1pt minus 1pt}{}{}{\bfseries}{:}{3pt}{}
	%%%% تنظیمات مربوط به واژه‌نامه
\newglossarystyle{myFaToEn}{%
	\renewenvironment{theglossary}{}{}
		\renewcommand*{\glsgroupskip}{\vskip 10pt}	
		\renewcommand*{\glossentry}[2]{\vskip 5pt\noindent\textbf{\glsentryname{##1}}\hfill\space \lr{\glsentrydesc{##1}}}
		\twocolumn{}}
	%%%%%% تنظیمات فهرست نمادها
	\newglossarystyle{mySymbols}{%
		\renewenvironment{theglossary}{}{}
		\renewcommand*{\glsgroupskip}{\vskip 10pt}	
		\renewcommand*{\glossentry}[2]{\vskip 5pt\noindent
			\begin{tabular}{p{2cm}p{10cm}}
				\textbf{\glsentryname{##1}}&\glsentrydesc{##1}
		\end{tabular}}
		\onecolumn{}
	}
	%%%%%%%  تنظیمات فهرست اختصارات
	\newglossarystyle{myAbbr}{%
		\renewenvironment{theglossary}{}{}
		\renewcommand*{\glsgroupskip}{\vskip 0pt}	
		\renewcommand*{\glossentry}[2]{\vskip 10pt\noindent	
			\begin{tabular}{p{2cm}p{10cm}}
				\textbf{\glsentryname{##1}}&\glsentrydesc{##1}
		\end{tabular}}
		\onecolumn{}
	}

%%%%%%% برای شکستن معادلات در حالت نمایش
\allowdisplaybreaks
%%%%%% section and subsection vertical spacing
\titlespacing{\section}{0pt}{15pt \@plus 5pt \@minus 5pt}{10pt \@plus 2pt \@minus 2pt}
\titlespacing*{\section}{0pt}{15pt plus 5pt minus 5pt}{10pt plus 2pt minus 2pt}
\titlespacing{\subsection}{0pt}{10pt plus 2pt minus 2pt}{5pt plus 2pt minus 2pt}
\titlespacing*{\subsection}{0pt}{10pt plus 2pt minus 2pt}{5pt plus 2pt minus 2pt}
%%%%%%% تنظیمات مربوط به مراجع هوشمند
\crefname{equation}{معادله}{معادلات}
\crefname{chapter}{فصل}{فصل‌های}
\crefname{section}{بخش}{بخش‌های}
\crefname{page}{صفحه}{صفحات}
\crefname{table}{جدول}{جدوال}
\crefname{figure}{شکل}{شکل‌های}
\crefname{mesal}{مثال}{مثال‌های}
\crefname{thm}{قضیه}{قضایای}
\crefname{lemm}{لم}{لم‌های}
\crefname{natija}{نتیجه}{نتایج}
\newcommand{\crefpairconjunction}{ و }
\newcommand{\crefrangeconjunction}{ الی }
}
%%%%% دستورات ساخته شده برای این قالب
\newcommand{\booktitle}[1]{\gdef\@booktitle{#1}}
\newcommand{\tauthors}[1]{\gdef\@tauthors{#1}}
\newcommand{\university}[1]{\gdef\@university{#1}}
\newcommand{\faculty}[1]{\gdef\@faculty{#1}}
\newcommand{\department}[1]{\gdef\@department{#1}}
\newcommand{\wyear}[1]{\gdef\@wyear{#1}}
\newcommand{\publisher}[1]{\gdef\@publisher{#1}}
\newcommand{\tfirstname}[1]{\gdef\@tfirstname{#1}}
\newcommand{\tlastname}[1]{\gdef\@tlastname{#1}}
\newcommand{\paddress}[1]{\gdef\@paddress{#1}}
\newcommand{\volumes}[1]{\gdef\@volumes{#1}}
\newcommand{\npages}[1]{\gdef\@npages{#1}}
\newcommand{\isbn}[1]{\gdef\@isbn{\ensuremath{#1}}}
\newcommand{\torank}[1]{\gdef\@torank{#1}}
\newcommand{\editor}[1]{\gdef\@editor{#1}}
\newcommand{\printnum}[1]{\gdef\@printnum{#1}}
\newcommand{\teraaz}[1]{\gdef\@teraaz{#1}}
\newcommand{\cutt}[1]{\gdef\@cutt{#1}}
\newcommand{\price}[1]{\gdef\@price{#1}}
\newcommand{\booktype}[1]{\gdef\@booktype{#1}}
\newcommand{\tbirthy}[1]{\gdef\@tbirthy{#1}}
\newcommand{\rank}[1]{\gdef\@rank{#1}}
\newcommand{\authorfname}[1]{\gdef\@authorfname{#1}}
\newcommand{\authorlname}[1]{\gdef\@authorlname{#1}}
\newcommand{\authorby}[1]{\gdef\@authorby{#1}}
\newcommand{\taqdimba}[1]{\gdef\@taqdimba{#1}}
\newcommand{\pishgoftartitle}[1]{\gdef\@pishgoftartitle{#1}}
\newcommand{\pishgoftarmatn}[1]{\gdef\@pishgoftarmatn{#1}}
\newcommand{\taqrizonetitle}[1]{\gdef\@taqrizonetitle{#1}}
\newcommand{\taqrizonematn}[1]{\gdef\@taqrizonematn{#1}}
\newcommand{\taqriztwotitle}[1]{\gdef\@taqriztwotitle{#1}}
\newcommand{\taqriztwomatn}[1]{\gdef\@taqriztwomatn{#1}}
\newcommand{\taqrizthreetitle}[1]{\gdef\@taqrizthreetitle{#1}}
\newcommand{\taqrizthreematn}[1]{\gdef\@taqrizthreematn{#1}}
\newcommand{\taqrizfourtitle}[1]{\gdef\@taqrizfourtitle{#1}}
\newcommand{\taqrizfourmatn}[1]{\gdef\@taqrizfourmatn{#1}}

%%%%%% begin Options
\newif\if@taalif
\newif\if@tarjoma
\newif\if@tahqiq
\newif\if@ihdaa
\newif\if@symbols
\newif\if@lofigures
\newif\if@lotables
\newif\if@pishgoftar
\newif\if@adadifront
\newif\if@taqrizone
\newif\if@taqriztwo
\newif\if@taqrizthree
\newif\if@taqrizfour
\newif\if@empty
\DeclareOption{taalif}{\@taaliftrue}   
\DeclareOption{tarjoma}{\@tarjomatrue}
\DeclareOption{tahqiq}{\@tahqiqtrue}
\DeclareOption{ihdaa}{\@ihdaatrue}
\DeclareOption{symbols}{\@symbolstrue}
\DeclareOption{lofigures}{\@lofigurestrue}
\DeclareOption{lotables}{\@lotablestrue}
\DeclareOption{pishgoftar}{\@pishgoftartrue}
\DeclareOption{adadifront}{\@adadifronttrue}
\DeclareOption{taqrizone}{\@taqrizonetrue}
\DeclareOption{taqriztwo}{\@taqriztwotrue}
\DeclareOption{taqrizthree}{\@taqrizthreetrue}
\DeclareOption{taqrizfour}{\@taqrizfourtrue}
\DeclareOption{empty}{\@emptytrue}
\ProcessOptions
%%%%%% end Options
%%%%%%% puts toctitle to center
\renewcommand{\cfttoctitlefont}{\hfill\bfseries\huge}
\renewcommand{\cftaftertoctitle}{\hfill}
%%%%%%% puts loftitle to center
\renewcommand{\cftloftitlefont}{\hfill\bfseries\huge}
\renewcommand{\cftafterloftitle}{\hfill}
%%%%%%% puts lottitle to center
\renewcommand{\cftlottitlefont}{\hfill\bfseries\huge}
\renewcommand{\cftafterlottitle}{\hfill}
%%%%%%% puts {شکل} and then {:} in lof
\renewcommand{\cftfigpresnum}{شکل\;}
\renewcommand{\cftfigaftersnum}{:}
\addtolength{\cftfignumwidth}{3.5em}
%%%%%%% puts {حدول} and then {:} in lot
\renewcommand{\cfttabpresnum}{جدول\;}
\renewcommand{\cfttabaftersnum}{:}
\addtolength{\cfttabnumwidth}{3.5em}

\setlength{\cftchapindent}{-0.1em}
\setlength{\cftfigindent}{-0.1em}
\setlength{\cfttabindent}{-0.1em}
\renewcommand{\cftdotsep}{\cftnodots}


\AtBeginDocument{
\frontmatter
\if@adadifront\pagenumbering{adadi}\else\pagenumbering{harfi}\fi	
\pagestyle{fancy}
\renewcommand{\headrulewidth}{0pt}
\fancyhead{}
\abovedisplayskip=3pt
\belowdisplayskip=3pt	
\null
%%%%%%%% شروع صفحه هشدار
{\ifx\@booktitle\undefined {\Large\bfseries\textcolor{red}{
لطفا عنوان کتاب خویش را توسط کد
\lr{\texttt{\detokenize{\booktitle{arg1}}}}
مشخص کنید
		 }}\newline\else\fi
%%%%%%%%%
\ifx\@authorfname\undefined {\Large\bfseries\textcolor{red}{
لطفا نام خویش را توسط کد
		\lr{\texttt{\detokenize{\authorfname{arg1}}}}
مشخص کنید
}}\newline\else\fi
%%%%%%%%%%
\ifx\@authorlname\undefined {\Large\bfseries\textcolor{red}{
لطفا تخلص خویش را توسط کد
		\lr{\texttt{\detokenize{\authorlname{arg1}}}}
		مشخص کنید
}}\newline\else\fi
%%%%%%%%%%%
\ifx\@authorby\undefined {\Large\bfseries\textcolor{red}{
لطفا سال تولد خویش را توسط کد
		\lr{\texttt{\detokenize{\authorby{arg1}}}}
مشخص کنید
}}\newline\else\fi
%%%%%%%%%%%%
\ifx\@university\undefined {\Large\bfseries\textcolor{red}{
لطفا دانشگاه خویش را توسط کد
		\lr{\texttt{\detokenize{\university{arg1}}}}
		مشخص کنید
}}\newline\else\fi
%%%%%%%%%%%%%
\ifx\@department\undefined {\Large\bfseries\textcolor{red}{
لطفا دیپارتمنت خویش را توسط کد
		\lr{\texttt{\detokenize{\department{arg1}}}}
		مشخص کنید
}}\newline\else\fi
%%%%%%%%%%%%%%%
\ifx\@wyear\undefined {\Large\bfseries\textcolor{red}{
لطفا سال چاپ را توسط کد
		\lr{\texttt{\detokenize{\wyear{arg1}}}}
		مشخص کنید
}}\newline\else\fi
%%%%%%%%%%
\ifx\@publisher\undefined {\Large\bfseries\textcolor{red}{
لطفا انتشارات را توسط کد
		\lr{\texttt{\detokenize{\publisher{arg1}}}}
		مشخص کنید یا خالی بگذارید
}}\newline\else\fi
%%%%%%%%%%
\if@tarjoma {\ifx\@tauthors\undefined {\Large\bfseries\textcolor{red}{
			لطفا مؤلف/مؤلفان کتاب خویش را توسط کد
			\lr{\texttt{\detokenize{\tauthors{arg1}}}}
			مشخص کنید
	}}\newline\else\fi} \fi
%%%%%%%%%%%%%%%%
\ifx\@paddress\undefined {\Large\bfseries\textcolor{red}{
لطفا مکان نشر را توسط کد
		\lr{\texttt{\detokenize{\paddress{arg1}}}}
		مشخص کنید یا خالی بگذارید
}}\newline\else\fi
%%%%%%%%%%%%%
\ifx\@volumes\undefined {\Large\bfseries\textcolor{red}{
لطفا تعداد جلد را توسط کد
		\lr{\texttt{\detokenize{\volumes{1}}}}
		مشخص کنید 
}}\newline\else\fi
%%%%%%%%%%%
\ifx\@isbn\undefined {\Large\bfseries\textcolor{red}{
لطفا شابک را توسط کد
		\lr{\texttt{\detokenize{\isbn{111-222-333}}}}
		مشخص کنید یا خالی بگذارید
}}\newline\else\fi
%%%%%%%%%
\ifx\@torank\undefined {\Large\bfseries\textcolor{red}{
لطفا رتبه علمی را که قرار است به آن نایل آیید توسط کد
		\lr{\texttt{\detokenize{\torank{arg1}}}}
		مشخص کنید
}}\newline\else\fi
%%%%%%%%%%%%%
\ifx\@editor\undefined {\Large\bfseries\textcolor{red}{
لطفا ویراستار اثر خویش را توسط کد
		\lr{\texttt{\detokenize{\editor{arg1}}}}
		مشخص کنید 
}}\newline\else\fi
%%%%%%%%%%%%%%
\ifx\@printnum\undefined {\Large\bfseries\textcolor{red}{
لطفا نوبت چاپ را توسط کد
		\lr{\texttt{\detokenize{\printnum{1}}}}
		مشخص کنید
}}\newline\else\fi
%%%%%%%%%%%%
\ifx\@teraaz\undefined {\Large\bfseries\textcolor{red}{
لطفا تیراژ را توسط کد
		\lr{\texttt{\detokenize{\teraaz{arg1}}}}
		مشخص کنید یا خالی بگذارید
}}\newline\else\fi
%%%%%%%%%%%
\ifx\@cutt\undefined {\Large\bfseries\textcolor{red}{
لطفا نوعیت قطع  را توسط کد
		\lr{\texttt{\detokenize{\cutt{arg1}}}}
		مشخص کنید
}}\newline\else\fi
%%%%%%%%%%
\ifx\@price\undefined {\Large\bfseries\textcolor{red}{
لطفا قیمت کتاب خویش را توسط کد
		\lr{\texttt{\detokenize{\price{arg1}}}}
		مشخص کنید یا خالی بگذارید
}}\newline\else\fi
%%%%%%%%%%%%%%%%
\ifx\@booktype\undefined {\Large\bfseries\textcolor{red}{
لطفا نوعیت اثر خویش را توسط کد
		\lr{\texttt{\detokenize{\booktype{arg1}}}}
		مشخص کنید. در اینجا با جزییات بنویسید: مثلا «این کتاب به عنوان مواد درسی برای رشته‌های ریاضی، فیزیک، و انجینیری تألیف شده است»
}}\newline\else\fi
%%%%%%%%%%%%%%%%%%
\if@ihdaa {\ifx\@taqdimba\undefined {\Large\bfseries\textcolor{red}{
لطفا تقدیم شوندگان را توسط کد
			\lr{\texttt{\detokenize{\taqdimba{arg1}}}}
			مشخص کنید
	}}\newline\else\fi} \fi
%%%%%%%%%%%%%%%%%%
\ifx\@rank\undefined {\Large\bfseries\textcolor{red}{
لطفا رتبه علمی خویش را توسط کد
		\lr{\texttt{\detokenize{\rank{arg1}}}}
مشخص کنید
}}\newline\else\fi
%%%%%%%%%%%%
\if@pishgoftar {\ifx\@pishgoftartitle\undefined {\Large\bfseries\textcolor{red}{
لطفا عنوان پیشگفتار خویش را توسط کد
			\lr{\texttt{\detokenize{\pishgoftartitle{arg1}}}}
			مشخص کنید
	}}\newline\else\fi} \fi
%%%%%%%%%%%%%%%%
\if@pishgoftar {\ifx\@pishgoftarmatn\undefined {\Large\bfseries\textcolor{red}{
لطفا متن پیشگفتار خویش را توسط کد
			\lr{\texttt{\detokenize{\pishgoftarmatn{arg1}}}}
			درج کنید
	}}\newline\else\fi} \fi
%%%%%%%%%%%%%%%%%%
\if@taqrizone {\ifx\@taqrizonetitle\undefined {\Large\bfseries\textcolor{red}{
لطفا عنوان تقریظ اول را توسط کد
			\lr{\texttt{\detokenize{\taqrizonetitle{arg1}}}}
مشخص کنید
	}}\newline\else\fi} \fi
%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%
\if@taqrizone {\ifx\@taqrizonematn\undefined {\Large\bfseries\textcolor{red}{
لطفا متن تقریظ اول را توسط کد
			\lr{\texttt{\detokenize{\taqrizonematn{arg1}}}}
درج کنید
	}}\newline\else\fi} \fi
%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%
\if@taqriztwo {\ifx\@taqriztwotitle\undefined {\Large\bfseries\textcolor{red}{
لطفا عنوان تقریظ دوم را توسط کد
			\lr{\texttt{\detokenize{\taqriztwotitle{arg1}}}}
			درج کنید
	}}\newline\else\fi} \fi
%%%%%%%%%%%%%%%%%%
\if@taqriztwo {\ifx\@taqriztwomatn\undefined {\Large\bfseries\textcolor{red}{
لطفا متن تقریظ دوم را توسط کد
			\lr{\texttt{\detokenize{\taqriztwomatn{arg1}}}}
			درج کنید
	}}\newline\else\fi} \fi
%%%%%%%%%%%%%%%%%%
\if@taqrizthree {\ifx\@taqrizthreetitle\undefined {\Large\bfseries\textcolor{red}{
لطفا عنوان تقریظ سوم را توسط کد
			\lr{\texttt{\detokenize{\taqrizthreetitle{arg1}}}}
			درج کنید
	}}\newline\else\fi} \fi
%%%%%%%%%%%%%%%%%%
\if@taqrizthree {\ifx\@taqrizthreematn\undefined {\Large\bfseries\textcolor{red}{
لطفا متن تقریظ سوم را توسط کد
			\lr{\texttt{\detokenize{\taqrizthreematn{arg1}}}}
			درج کنید
	}}\newline\else\fi} \fi
%%%%%%%%%%%%%%%%%%
\if@taqrizfour {\ifx\@taqrizfourtitle\undefined {\Large\bfseries\textcolor{red}{
لطفا عنوان تقریظ چهارم را توسط کد
			\lr{\texttt{\detokenize{\taqrizfourtitle{arg1}}}}
			درج کنید
	}}\newline\else\fi} \fi
%%%%%%%%%%%%%%%%%%
\if@taqrizfour {\ifx\@taqrizfourmatn\undefined {\Large\bfseries\textcolor{red}{
لطفا متن تقریظ چهارم را توسط کد
			\lr{\texttt{\detokenize{\taqrizfourmatn{arg1}}}}
			درج کنید
	}}\newline\else\fi} \fi
%%%%%%%%%%%%%%%%%%%%%%%%%
}
%%%%%%%%%%%%% ختم صفحه هشدارد
%%%%%%%% شروع صفحه بسم الله %%%%%%%%
\begin{center}
\vspace{2cm}
\thispagestyle{empty}
\IfFileExists{besmillah.jpg}{\includegraphics[width=13cm,height=12cm]{besmillah.jpg}}{\textcolor{red}{\\\Huge\bfseries\lr{besmillah.jpg Does not Exist!!!!!!}}}
\end{center}\null\vspace{1cm}
{\begin{center}
\Large 
الحمد لله رب العالمين وَالصَّلاَةُ والسلام على أشرف المرسلين سيدنا محمد وعلى آله وصحبه ومن تبعهم بإحسان إلى يوم الدين
\end{center}}
\vfill
\thispagestyle{empty}\cleardoublepage

%%%%%%%%%% صفحه عنوان %%%%%%%%%
\cleardoublepage\thispagestyle{empty}\null\vspace{8cm}
\begin{center}
	\bfseries
	{\Huge{\ifx\@booktitle\undefined{\lr{undefined}}\else\@booktitle\fi}}\\ 
{\if@tarjoma{\null\vspace{10pt}\bfseries\large
مؤلف/مؤلفان: 
\space{\ifx\@tauthors\undefined{\textcolor{red}{\lr{undefined tauthors}}}\else\@tauthors\fi}	
}\\\fi}
	\null\vspace{10pt}
{
	\if@taalif مؤلف: \else {\if@tahqiq محقق: \else {\if@tarjoma مترجم: \else {\lr{unspecified option}}\fi}\fi} \fi
}
\space {\ifx\@authorfname\undefined{\lr{undefined}}\else\@authorfname\fi}\space{\ifx\@authorlname\undefined{\lr{undefined}}\else\@authorlname\fi}\\
	\null \vspace{10pt}
	{استاد
		\space {\ifx\@university\undefined{\lr{undefined}}\else\@university\fi}} \\
	\null \vspace{10pt}
	{\ifx\@booktype\undefined{\lr{undefined}}\else\@booktype\fi}\\
	\null\vspace{10pt}
	{ناشر: 
		\space{\ifx\@publisher\undefined{\lr{undefined}}\else\@publisher\fi}}\\ 
	\null\vspace{10pt}
	{سال چاپ: 
		\space{\ifx\@wyear\undefined{\lr{undefined}}\else\@wyear\fi}}
\end{center}
\clearpage
%%%%%%%%%  پشت صفحه عنوان 
\thispagestyle{empty}
{ 
	\begin{center}\small
		\begin{tabular}{|p{3cm}p{0.5mm}p{7cm}|}
			\hline
			سر شناسه: & & 
			{\ifx\@authorlname\undefined{\lr{undefined}}\else\@authorlname\fi}, \space {\ifx\@authorfname\undefined{\lr{undefined}}\else\@authorfname\fi},\space{\ifx\@authorby\undefined{\lr{undefined}}\else\@authorby\fi}\space\\
			عنوان و نام 
			{
				\if@taalif مؤلف: \else {\if@tahqiq محقق: \else {\if@tarjoma مترجم: \else {\lr{unspecified option}}\fi}\fi} \fi
			} & &
			{\ifx\@booktitle\undefined{\lr{undefined}}\else\@booktitle\fi},\space{\ifx\@authorfname\undefined{\lr{undefined}}\else\@authorfname\fi}\space{\ifx\@authorlname\undefined{\lr{undefined}}\else\@authorlname\fi}\\
			مشخصات نشر:& &
			{\ifx\@paddress\undefined{\lr{undefined}}\else\@paddress\fi}, {\ifx\@publisher\undefined{\lr{undefined}}\else\@publisher\fi}, {\ifx\@wyear\undefined{\lr{undefined}}\else\@wyear\fi}\\
			مشخصات ظاهری:& &
			{{\ifx\@volumes\undefined{\lr{undefined}}\else\adadinumeral{\@volumes}\fi}} \text{جلد}, \pageref{LastPage} \text{صفحه}\\
			شابک :& &
			{\ifx\@isbn\undefined{\lr{undefined}}\else\@isbn\fi}\\
			یادداشت: & & برای ترفیع به رتبه علمی 
			{\ifx\@torank\undefined{\lr{undefined}}\else\@torank\fi}\\
			موضوع:& & 
			{\ifx\@department\undefined{\lr{undefined}}\else\@department\fi}\\
			\hline	
		\end{tabular}\\
		\null
		\vspace{2cm}
\IfFileExists{logo.jpg}{\includegraphics[width=3cm,height=3cm]{logo.jpg}\\}{\textcolor{red}{\newline\Huge\bfseries\lr{logo.jpg Does not Exist!!!!!!}}\\}
		\null\vspace{20pt}
{	
	\if@taalif
{\large\bfseries\ifx\@rank\undefined{\lr{undefined rank}}\else\@rank\fi}\space {\Large\bfseries\ifx\@authorfname\undefined{\lr{undefined}}\else\@authorfname\fi}\space{\Large\bfseries\ifx\@authorlname\undefined{\lr{undefined}}\else\@authorlname\fi} \else {\if@tahqiq
{\large\bfseries\ifx\@rank\undefined{\lr{undefined rank}}\else\@rank\fi}\space
 {\Large\bfseries\ifx\@authorfname\undefined{\lr{undefined}}\else\@authorfname\fi}\space{\Large\bfseries\ifx\@authorlname\undefined{\lr{undefined}}\else\@authorlname\fi} \else {\if@tarjoma {\Large\bfseries\ifx\@tauthors\undefined{\lr{undefined tauthors}}\else\@tauthors\fi} \else {\lr{unspecified option}}\fi}\fi} \fi
}\\
		\null\vspace{15pt}
		{\Huge\bfseries{\ifx\@booktitle\undefined{\lr{undefined booktitle}}\else\@booktitle\fi}}\\
		%%%%%%%%%%%%%%%%%%%%%%%%%
		{\if@tarjoma
			\null\vspace{15pt}
			{\large \bfseries
				مترجم: 
{\large\bfseries\ifx\@rank\undefined{\lr{undefined rank}}\else\@rank\fi}\space{\ifx\@authorfname\undefined{\lr{undefined}}\else\@authorfname\fi}\space{\ifx\@authorlname\undefined{\lr{undefined}}\else\@authorlname\fi}}\\
			\fi}
		%%%%%%%%%%%%%%%
		\null{
\if@taalif\vspace{15pt} \else {\if@tahqiq\vspace{15pt} \else {\if@tarjoma\vspace{1pt} \else\vspace{15pt} \fi} \fi} \fi	
	}
		{\large \bfseries
			ویراستار: 
			{\ifx\@editor\undefined{\lr{undefined}}\else\@editor\fi}}\\
		\null\vspace{1pt}
		{\large\bfseries نوبت چاپ: 
			\space{{\ifx\@printnum\undefined{\lr{undefined}}\else\tartibinumeral{\@printnum}\fi}}}\\
		\null\vspace{1pt}
		{\large\bfseries تیراژ: 
			\space{\ifx\@teraaz\undefined{\lr{undefined}}\else\@teraaz\fi} }\\
		\null\vspace{1pt}
		{\large\bfseries سال چاپ: 
			\space{\ifx\@wyear\undefined{\lr{undefined}}\else\@wyear\fi}}\\
		\null\vspace{1pt}
		{\large\bfseries قطع: 
			\space{\ifx\@cutt\undefined{\lr{undefined}}\else\@cutt\fi}}\\
		\null\vspace{1pt}
		{\large\bfseries قیمت کتاب: 
			\space{\ifx\@price\undefined{\lr{undefined}}\else\@price\fi}}\\
		\null\vspace{1pt}
		{\large\bfseries شابک: 
			\space{\ifx\@isbn\undefined{\lr{undefined}}\else\@isbn\fi}}\\
		\null\vspace{1pt}
		{\large\bfseries
			حق چاپ برای وزارت تحصیلات عالی و 
			\space{\ifx\@university\undefined{\lr{undefined}}\else\@university\fi}\space
			محفوظ است}
	\end{center}
	\clearpage}
%%%%%% شروع صفحه اهدا
{\if@ihdaa\thispagestyle{empty}\null\vfill\centering\bfseries\huge
تقدیم به 
\space{\ifx\@taqdimba\undefined{\lr{undefined taqdimba}}\else\@taqdimba\fi}
\vfill\cleardoublepage
\fi}
%%%%%%%%%% ختم صفحه اهدا
%%%%%%%%%%%%%% شروع صفحه پیشگفتار
{\if@pishgoftar{\cleardoublepage{\begin{center}
\large\bfseries{\ifx\@pishgoftartitle\undefined{\lr{undefined pishgoftartitle}}\else\@pishgoftartitle\fi}\end{center}}{{\ifx\@pishgoftarmatn\undefined{\lr{undefined pishgoftarmatn}}\else\noindent\@pishgoftarmatn\fi}}}\fi}
%%%%%%%% ختم صفحه پیشگفتار
%%%%%%%%%%%%% شروع تقریظ یک
{\if@taqrizone\cleardoublepage
\begin{center}
\large\bfseries 
\ifx\@taqrizonetitle\undefined {\lr{undefined title}}\else \@taqrizonetitle\fi
\end{center}\noindent
\ifx\@taqrizonematn\undefined{\lr{undefined matn}}\else\@taqrizonematn\fi
\fi}
%%%%%%%%%%%%%%% ختم تقریظ یک
%%%%%%%%%%%%% شروع تقریظ دوم
{\if@taqriztwo\cleardoublepage
	\begin{center}
		\large\bfseries 
		\ifx\@taqriztwotitle\undefined {\lr{undefined title}}\else \@taqriztwotitle\fi
	\end{center}\noindent
	\ifx\@taqriztwomatn\undefined{\lr{undefined matn}}\else\@taqriztwomatn\fi
	\fi}
%%%%%%%%%%%%%%% ختم تقریظ دوم
%%%%%%%%%%%%% شروع تقریظ سوم
{\if@taqrizthree\cleardoublepage
	\begin{center}
		\large\bfseries 
		\ifx\@taqrizthreetitle\undefined {\lr{undefined title}}\else \@taqrizthreetitle\fi
	\end{center}\noindent
	\ifx\@taqrizthreematn\undefined{\lr{undefined matn}}\else\@taqrizthreematn\fi
	\fi}
%%%%%%%%%%%%%%% ختم تقریظ سوم
%%%%%%%%%%%%% شروع تقریظ چهارم
{\if@taqrizfour\cleardoublepage
	\begin{center}
		\large\bfseries 
		\ifx\@taqrizfourtitle\undefined {\lr{undefined title}}\else \@taqrizfourtitle\fi
	\end{center}\noindent
	\ifx\@taqrizfourmatn\undefined{\lr{undefined matn}}\else\@taqrizfourmatn\fi
	\fi}
%%%%%%%%%%%%%%% ختم تقریظ دوم
%%%%% تنظیمات عناوین فصل‌ها
\cleardoublepage 
\titleformat{\chapter}[display]{\bfseries\Huge\centering}{ {فصل} \tartibinumeral{\thechapter} }{10pt}{}[]
\linespread{1.15}
% removing fasl 1 from header
\setlength{\headheight}{15pt}\renewcommand{\chaptermark}[1]{\markboth{\space#1}{}}
% setting header according to mohe
\pagestyle{fancy}\renewcommand\headrule{\hrulefill\raisebox{-2.1pt}[0pt]{\quad\decofourleft\decotwo\decofourright\quad}\hrulefill}\fancyhead[LO]{\leftmark\hspace{5pt}|\hspace{-5pt}|\hspace{5pt}\thepage}\fancyhead[RE]{\thepage\hspace{5pt}|\hspace{-5pt}|\hspace{5pt}{{\ifx\@booktitle\undefined{\lr{undefined}}\else\@booktitle\fi}}}\fancyhead[RO]{ }\fancyhead[LE]{}\fancyfoot{}\cfoot{}
\cleardoublepage
}
\AtEndDocument{\glsaddall}
