: ***************************************************************************
: PROJECT: MusixTeX PreProcessor
: FILE   : configur.bat -*-4dos-*-
: AUTHOR : J. C. Nieuwenhuizen
:
: copyright (c) FlowerSoft 1995
: ---------------------------------------------------------------------------
: ABSTRACT: script to configure mpp and to determine specifics of C++ release
: --
 
set file=configur.bat

set line=15
set error=host-name is one of unix, msdos, gnu
iff %# != 1 then
goto :error
elseiff %1 == gnu then
elseiff %1 == msdos then
elseiff %1 == unix then
else
goto :error
endiff

echo determining C++ release

set compile=
set config=config.h
echo. > %config

set line=32
set error=cannot configure for unix under msdos
iff %1 == gnu then
set compile=gpp
elseiff %1 == msdos then
set compile=\tc\bin\tcc -P
else
goto :error
endiff

echo using compiler: "%compile"

:check assignment operator
:
set line=46
set error=error compiling assign.cc
%compile -DTEST assign.cc >& NUL
iff %? != 0 then
goto :error
endiff

set line=53
set warning=assignment operator has left to right associativity
assign
iff %? != 0 then
    gosub :warning
    echo #define ASSIGN_LEFT_TO_RIGHT>> %config
endiff

::check comma operator
::
:set line=63
:set error=error compiling comma.cc
:%compile  -DTEST comma.cc >& NUL
:iff %? != 0 then
:goto :error
:endiff

:set line=70
:set warning=comma operator groups right to left
:comma
:iff %? != 0 then
:    gosub :warning
:    echo #define COMMA_RIGHT_TO_LEFT>> %config
:endiff

:check postfix operator
:
set line=80
set error=error compiling postfix.cc
%compile  -DTEST postfix.cc >& NUL
iff %? != 0 then
goto :error
endiff

set line=87
set warning=old C++ release; please upgrade
postfix
iff %? != 0 then
    gosub :warning
    echo #define POSTFIX_INT>> %config
    echo #define DELETE_ARRAY( size ) delete[ size ]>> %config
    echo #define NESTED_IN( Class )>> %config
else
    echo #define POSTFIX_INT int>> %config
    echo #define DELETE_ARRAY( size ) delete[]>> %config
    echo #define NESTED_IN( Class ) Class::>> %config
endiff

:check support of nested classes
:
:set line=103
:set error=error compiling nest.cc
:%compile  -DTEST nest.cc >& NUL
:iff %? != 0 then
:goto :error
:endiff
:
:set line=110
:set warning=old C++ release; please upgrade
:nest
:iff %? != 0 then
:    gosub :warning
:    echo #define NESTED_IN( Class ) >> %config
:else
:    echo #define NESTED_IN( Class ) Class:: >> %config
:endiff

set name=mpp

iff %1 == gnu then
    set line=127
    set warning=cannot find "sed"; using preconfigured makefile
    sed -f gnu.sed %name.in >& NUL
    iff %? != 0 then
        gosub :warning
    else
        sed -f gnu.sed %name.in > %name.gnu 
    endiff    
    iff %? != 0 then
        gosub :warning
    endiff    
    set line=137
    set error=cannot find "%name.gnu"
    iff not exist %name.gnu then
        goto :error
    endiff    
    copy %name.gnu Makefile >& NUL
elseiff %1 == msdos then
    set line=145
    set warning=cannot find "sed"; using preconfigured makefile
    sed -f msdos.sed %name.in >& NUL
    iff %? != 0 then
        gosub :warning
    else
        sed -f msdos.sed %name.in > %name.dos
    endiff    
    set line=152
    set error=cannot find "%name.dos"
    iff not exist %name.dos then
        goto :error
    endiff    
    copy %name.dos Makefile >& NUL
endiff

rem no errors occurred
echo configured for %1
goto :end

rem "warning" subroutine
:warning
echo %file: %line: warning: %warning
return

rem "error" routine
:error
echo %file: %line: %error
:end
