{$N-,V-,W-,G+}

Unit wbibgui;

Interface

Uses
  commdlg, bibvars, wbibdisp, bibstrg, bibutil, win31, wbibstat, WinDos,
  WinTypes, WinProcs, WObjects, rc_id, strings, rc_Strng,
  bibfile, bib8bit, wc_help, bibtmplt, wbib3d;

const
  RelTo_Size   = 0; RelTo_Abs    = 0;
  RelTo_Left   = 1; RelTo_Top    = 1;
  RelTo_Right  = 2; RelTo_Bottom = 2;

  TabbedLBox_XShift   = 2;
  TabbedLBox_TagShift = 3;
  TabbedLBox_Red      = #1;
  TabbedLBox_Blue     = #2;
  TabbedLBox_Green    = #3;
  TabbedLBox_FilenameColor   = #4;
  TabbedLBox_DupEntriesColor = #5;

type

  PMenuHelpObj = ^MenuHelpObj;
  MenuHelpObj = object(TObject)
    M,S: word;
    constructor init(am,as: word);
  end;

  PControlPos = ^TControlPos;
  TControlPos = object(Tobject)
    Initial: TRect;
    ctop,cleft,cbottom,cright: integer;
    Handle: HWnd;
    constructor init(HDlg,H: Hwnd; aleft,aright,atop,abottom: integer);
  end;

  PAccelKey = ^TAccelKey;
  TAccelKey = object(TObject)
    SCode: word;
    id: integer;
    Ctrl: boolean;
    constructor init(ch: char; Aid: integer; ACtrl: boolean);
  end;

  PBasicDialog = ^TBasicDialog;
  TBasicDialog = object(TDialog)
    OldMessageParent: HWnd;
    OldCurrentWindow: PWindow;
    HelpContext: longint;
    OldCursor:  HCursor;
    OldWindowText: PChar;
    constructor init(AParent: PWindowsObject; AName: PChar);
    procedure   SetupWindow; virtual;
    procedure   WMSysColorChange(var Msg : TMessage);
                              virtual wm_first + wm_SysColorChange;  { 3-D controls }
    procedure   GetHelp(var Msg: TMessage);     virtual wm_First+bib_DlgHelp;
    procedure   wmEnterIdle(var Msg: TMessage); virtual wm_First+wm_EnterIdle;
    procedure   wmSetCursor(var Msg: TMessage); virtual wm_First+wm_SetCursor;
    procedure   InitPos; virtual;
    procedure   WaitingMessage(S: PChar);
    procedure   WaitingOff;
    procedure   SearchingMessage;
    destructor  done; virtual;
  end;

  PResizableDialog = ^TResizableDialog;
  TResizableDialog = object(TBasicDialog)
    PosRec:     InitialSizePtr;
    MinimalSize:TPoint;
    ControlPos: TCollection;
    ResizeWidth,ResizeHeight: boolean;
    constructor init(AParent: PWindowsObject; AName: PChar;
                APosRec: InitialSizePtr);
    procedure   DisableSysMinimize;
    procedure   NewControl(id,left,right,top,bottom: integer);
    procedure   SetupWindow;   virtual;
    procedure   InitPos;       virtual;
    procedure   FixControlPos; virtual;
    procedure   wmSize(var Msg: TMessage); virtual wm_First+wm_Size;
    function    WmGetMinMaxInfo(var Msg: TMessage): bool;
                                virtual wm_first+wm_GetMinMaxInfo;
    procedure   wmDestroy(var Msg: TMessage); virtual wm_First+wm_Destroy;
  end;

  PEditEx = ^TEditEx;
  TEditEx = object(TEdit)
    function Create: boolean; virtual;
  end;

  PEditRestricted = ^TEditRestricted;
  TEditRestricted = object(TEdit)
    Forbid: array[0..255] of longint;
    NForbid: integer;
    Exclude: string;
    procedure   MapExcluded(ForbidChars: CharSet);
    constructor Init(AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
                X,Y,W,H,ATextLen: Integer; Multiline : Boolean;
                ForbidChars: CharSet);
    constructor InitResource(AParent: PWindowsObject; AnId: Integer;
                ATextLen: Integer;  ForbidChars: CharSet);
    procedure   wmChar(var Msg: TMessage); virtual wm_first+wm_Char;
    function    CanClose: boolean; virtual;
  end;

  PEditNoCr = ^TEditNoCr;
  TEditNoCr = object(TEditRestricted)
    procedure paste; virtual;
  end;

  PEditTemplate = ^TEditTemplate;
  TEditTemplate = object(TEditNoCr)
    constructor InitResource(AParent: PWindowsObject; id: integer);
    function    CanClose: boolean; virtual;
  end;

  PEditBalanced = ^TEditBalanced;
  TEditBalanced = object(TeditNoCr)
    function CanClose: boolean; virtual;
  end;

  PGetStringDlg = ^TGetStringDlg;
  TGetStringDlg = object(TBasicDialog)
    Answer: PChar;
    Title: array[0..255] of char;
    Forbid:  CharSet;
    MarkOnStartup: boolean;
    Ebox: PEditNoCr;
    MaxLength: Word;
    constructor Init(AParent: PWindowsObject; AName: PChar;
                ATitle: string; Forbidden: CharSet; PAnswer: PChar;
                MarkText: boolean; MaxTextLength: word);
    procedure   SetupWindow; virtual;
    procedure   Ok(var Msg: TMessage); virtual id_First + id_OK;
  end;

  PSearchFieldsDlg = ^TSearchFieldsDlg;
  TSearchFieldsDlg = object(TBasicDialog)
    FieldList: PString;
    constructor init(AParent: PWindowsObject; AFieldList: PString);
    procedure   SetupWindow; virtual;
    procedure   AllBtn(var Msg: TMessage);   virtual id_first+dl_SelectionListAll;
    procedure   ClearBtn(var Msg: TMessage); virtual id_first+dl_SelectionListClear;
    procedure   ok(var Msg: TMessage);       virtual id_first+id_ok;
  end;

  PGetStringModeDlg = ^TGetStringModeDlg;
  TGetStringModeDlg = object(TGetStringDlg)
    RegExp,CaseSen,UseFields,Negate: Pboolean;
    RegExpCBox,CaseSenCBox: PCheckbox;
    FieldStr: PString;
    flds: array[0..100] of PString;
    constructor Init(AParent: PWindowsObject; AName: PChar;
                ATitle: string; Forbidden: CharSet; PAnswer: PChar;
                PRegExp,PCaseSen: PBoolean; AskMode,MarkText: Boolean;
                MaxTextLength: word; AFieldStr: PString;
                AUseFields,ANegate: PBoolean);
    procedure   SetupWindow; virtual;
    procedure   SelectFieldsBtn(var Msg: TMessage);
                                  virtual id_first+dl_SearchStrSelFields;
    procedure   SelFieldsCBox(var Msg: TMessage);
                                  virtual id_first+dl_SearchStrFList;
    procedure   Ok(var Msg: TMessage); virtual id_First + id_OK;
    destructor  done; virtual;
  end;

  PRegistersDlg = ^TRegistersDlg;
  TRegistersDlg = object(TBasicDialog)
    SaveDlg:      Boolean;
    HLbox, HEbox: HWnd;
    InEBox:       PEdit;
    constructor init(AParent: PWindowsObject; ASave: boolean; PEBox: PEdit);
    procedure   SetupWindow; virtual;
    procedure   SaveInRegs;
    procedure   GetFromRegs;
    procedure   LBoxMessage(var Msg: TMessage); virtual id_first+dl_RegsLBox;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

  PSelectFieldsDlg = ^TSelectFieldsDlg;
  TSelectFieldsDlg = object(TBasicDialog)
    DumpFields: PFieldArr;
    WithName,WithString,Undeclared: boolean;
    constructor init(AParent: PWindowsObject; AFieldList: PFieldArr;
                AWithName,AWithString,AUndeclared: boolean);
    procedure   SetupWindow; virtual;
    procedure   AllBtn(var Msg: TMessage);   virtual id_first+dl_SelectionListAll;
    procedure   ClearBtn(var Msg: TMessage); virtual id_first+dl_SelectionListClear;
    procedure   ok(var Msg: TMessage);       virtual id_first+id_ok;
  end;

  PExpFieldsDlg = ^TExpFieldsDlg;
  TExpFieldsDlg = object(TSelectFieldsDlg)
    Undec: PBoolean;
    Title: PChar;
    constructor init(AParent: PWindowsObject; AFieldList: PFieldArr;
                     AUndec: PBoolean; ATitle: PChar);
    procedure   SetupWindow; virtual;
    procedure   AllBtn(var Msg: TMessage);   virtual id_first+dl_SelectionListAll;
    procedure   ClearBtn(var Msg: TMessage); virtual id_first+dl_SelectionListClear;
    procedure   ok(var Msg: TMessage);       virtual id_first+id_ok;
  end;

  PEditAFieldDlg = ^TEditAFieldDlg;
  TEditAFieldDlg = object(TBasicDialog)
    P: Pointer;
    Title: PChar;
    EBox: PEdit;
    MaxLen: word;
    Slen: PWord;
    IsPString: boolean;
    constructor init(AParent: PWindowsObject; Aname,Atitle: PChar;
                     IsBalanced: boolean; AP: Pointer;
                     ASLen: PWord; AMaxLen: word);
    procedure   SetupWindow; virtual;
    procedure   BibEnterIdle(var Msg: TMessage); virtual wm_first+bib_EnterIdle;
    procedure   SaveRegs(var Msg: TMessage); virtual id_first+dl_EditFieldSav;
    procedure   LoadRegs(var Msg: TMessage); virtual id_first+dl_EditFieldRcl;
    procedure   CutBtn(var Msg: TMessage);   virtual id_first+dl_EditFieldCutBtn;
    procedure   CopyBtn(var Msg: TMessage);  virtual id_first+dl_EditFieldCopyBtn;
    procedure   PasteBtn(var Msg: TMessage); virtual id_first+dl_EditFieldPasteBtn;
    procedure   UndoBtn(var Msg: TMessage);  virtual id_first+dl_EditFieldUndoBtn;
    procedure   ok(var Msg: TMessage);       virtual id_first+id_ok;
  end;

  PCopyToClipDlg = ^TCopyToClipDlg;
  TCopyToClipDlg = object(TBasicDialog)
    EBox: PEdit;
    Entry: EntryRecPtr;
    fld: integer;
    constructor init(AParent: PWindowsObject; AEntry: EntryRecPtr;
                     Afld: integer);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

  PFontEncodingDlg = ^TFontEncodingDlg;
  TFontEncodingDlg = object(TBasicDialog)
    enc8a,enc7a,enc8b,enc7b: PBoolean;
    enca,encb: PInteger;
    constructor init(AParent: PWindowsObject;
                     Aenc8a,Aenc7a,Aenc8b,Aenc7b: PBoolean;
                     Aenca,Aencb: PInteger);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

  PEncTranslateDlg = ^TEncTranslateDlg;
  TEncTranslateDlg = object(TFontEncodingDlg)
    procedure SetupWindow; virtual;
  end;

  PCopyFieldDlg = ^TCopyFieldDlg;
  TCopyFieldDlg = object(TBasicDialog)
    Entry:    EntryRecPtr;
    Result:   PInteger;
    Extended: PBoolean;
    constructor init(AParent: PWindowsObject; AEntry: EntryRecPtr;
                     AResult: PInteger; AExtended: PBoolean);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

  PModifyFontsDlg = ^TModifyFontsDlg;
  TModifyFontsDlg = object(TBasicDialog)
    ScreenFonts,TagColorChanged,EncodingsChanged,ENameColorChanged: boolean;
    Changed: array[boolean] of boolean;
    constructor init(AParent: PWindowsObject; AScreenFonts: boolean);
    procedure   LoadUp;
    procedure   SetupWindow; virtual;
    procedure   Modify(var Msg: TMessage);       virtual id_first+dl_ModFontModify;
    procedure   SetAColor(var Msg: TMessage);    virtual id_first+dl_ModFontsModColor;
    procedure   FontEncodings(var Msg: TMessage);virtual id_first+dl_ModFontEnc;
    procedure   HandleLBox(var Msg: TMessage);   virtual id_first+dl_ModFontsLBox;
    procedure   HandleColorLBox(var Msg: TMessage);virtual id_first+dl_ModFontsColors;
    procedure   DisplayFonts(var Msg: TMessage); virtual id_first+dl_ModFontDisp;
    procedure   PrinterFonts(var Msg: TMessage); virtual id_first+dl_ModFontPrint;
    procedure   Cancel(var Msg: TMessage);       virtual id_first+id_Cancel;
  end;

var
  DialogDepth,ScreenResX,ScreenResY: integer;
  ScreenRect: TRect;
  FindRepMsg: word;

procedure UploadFieldList(Fields: string; EWindow: HWnd; F: PChar);
procedure RegisterBibDBClasses;
procedure UnRegisterBibDBClasses;
procedure WaitingMessage(s: string);
procedure SearchingMessage;
procedure SuspendWaiting(suspend: boolean);
procedure WaitingOff;
function  SelectFont(Wnd: HWnd; FontInd: integer; effects: boolean): boolean;
function  SelectColor(Wnd: HWnd; var Clr: Longint): boolean;
procedure GetAString(prompt: string; Var S: string; y0,maxlen,linelen: Byte;
                     exclude: CharSet; var accept: boolean; MarkText: boolean);
procedure GetStringMode(prompt: string; Var S: string; y0,maxlen,linelen: Byte;
                        exclude: CharSet; var accept,CaseSen,RegExp: boolean;
                        MarkText: boolean);
procedure GetSearchString(prompt: string; var S: string;
                          exclude: CharSet; var modified, retain: boolean;
                          var CaseSen,RegExp: boolean;
                          var FieldStr: string; var UseFields,Negate: boolean);
procedure UpdateExpFields;
procedure CopyFieldToClip(Parent: PWindowsObject; Entry: EntryRecPtr; fld: integer;
                          Shift,Ctrl: boolean; S: PString);
procedure PutTextIntoEbox(F: PChar; EBox: PEdit);
function  CreateHelvFont(Bold: boolean; FontHeight: Pinteger): HFont;
procedure DrawTabbedLBoxItem(P: PDrawItemStruct; Font: HFont; Tag: Boolean;
                             var TabStops; NTabs: integer; UseItemData: boolean);


Implementation

uses wbibabv1;

const
  TrayName: PChar = 'Shell_TrayWnd';

Var
  NonWaitingCursor: HCursor;
  RegisteredClasses: TStrCollection;

procedure GetVisibleRect(var Screen: TRect);
var
  Tray: HWnd;
  TrayRect: TRect;
begin
  GetWindowRect(GetDesktopWindow,Screen);
  if Win95 then
  begin
    Tray:=FindWindow(TrayName,Nil);
    if Tray<>0 then
    begin
      GetWindowRect(Tray,TrayRect);
      if (TrayRect.Left<=Screen.Left) and
         (TrayRect.Right>=Screen.Right) then   { Top or bottom }
      begin
        if TrayRect.Top<=Screen.Top then   { At the top }
          Screen.Top:=TrayRect.Bottom+1
        else if TrayRect.Bottom>=Screen.Bottom then { At the bottom }
          Screen.Bottom:=TrayRect.Top-1;
      end else if (TrayRect.Top<=Screen.Top) and
                  (TrayRect.bottom>=Screen.bottom) then { left or right }
      begin
        if TrayRect.left<=Screen.left then   { At the left }
          Screen.left:=TrayRect.right+1
        else if TrayRect.right>=Screen.right then { At the right }
          Screen.right:=TrayRect.left-1;
      end;
    end;
  end;
end;                     { GetVisibleRect }

{ Various Collection objects }

constructor MenuHelpObj.init(am,as: word);
begin
  TObject.init;
  M:=am; S:=as;
end;

constructor TControlPos.init(HDlg,H: Hwnd;
                             aleft,aright,atop,abottom: integer);
var
  T: TPoint;
  Rect,CRect: Trect;
begin
  TObject.init;
  Handle:=H;
  ctop:=atop; cleft:=aleft; cbottom:=abottom; cright:=aright;
  GetWindowRect(H,CRect);
  T.X:=CRect.left; T.Y:=CRect.top;
  ScreenToClient(HDlg,T);
  CRect.left:=T.X; CRect.Top:=T.Y;
  T.X:=CRect.right; T.Y:=CRect.bottom;
  ScreenToClient(HDlg,T);
  CRect.right:=T.X; CRect.bottom:=T.Y;
  Initial:=CRect;
  GetClientRect(HDlg,Rect);
  if aleft=RelTo_Right         then Initial.left  :=Rect.right-CRect.left;
  if atop =RelTo_Bottom        then Initial.top   :=Rect.bottom-CRect.top;
  if aright=RelTo_Size         then Initial.right :=CRect.right-CRect.left
  else if aright=RelTo_Right   then Initial.right :=Rect.right-CRect.right;
  if abottom=RelTo_Size        then Initial.bottom:=CRect.bottom-CRect.top
  else if abottom=RelTo_Bottom then Initial.bottom:=Rect.bottom-CRect.bottom;
end;                           { TControlPos.init }

constructor TAccelKey.init(ch: char; Aid: integer; ACtrl: boolean);
begin
  TObject.init;
  id:=Aid;
  Ctrl:=ACtrl;
  SCode:=LoWord(OEMKeyScan(Ord(ch)));
end;                            { TAccelKey.init }

{ TBasicDialog methods }

constructor TBasicDialog.init(AParent: PWindowsObject; AName: PChar);
begin
  TDialog.init(AParent,AName);
  HelpContext:=0;
  OldWindowText:=Nil;
  AmWaiting:=false;
  inc(DialogDepth);
  if CurrentHelpBar<>Nil then CurrentHelpBar^.ClearHelpText;
end;

procedure TBasicDialog.SetupWindow;
begin
  TDialog.SetupWindow;
  OldMessageParent:=MessageParent;
  OldCurrentWindow:=CurrentWindow;
  MessageParent:=HWindow;
  CurrentWindow:=@Self;
  if UseCtl3d and Win95 and Win95_3d then
    SetWindowLong(HWindow,gwl_Style,
       GetWindowLong(HWindow,gwl_Style) or DS_3DLOOK);
end;

procedure TBasicDialog.WMSysColorChange(var Msg : TMessage);
begin
  if Ctl3Dv2Active then Ctl3dColorChange;
end;

procedure TBasicDialog.GetHelp(var Msg: TMessage);
begin
  if HelpContext<>0 then
    WinHelp(HWindow,HelpFile,Help_Context,HelpContext)
  else messagebeep(0);
end;

procedure TBasicDialog.wmEnterIdle(var Msg: TMessage);
begin
  if (Msg.wParam=msgf_DialogBox) then
  begin
    if (GetKeyState(vk_F1)<0) then
      SendMessage(Msg.lparamLo,bib_DlgHelp,0,0)
    else SendMessage(Msg.lparamLo,bib_EnterIdle,0,0);
  end;
end;

procedure TBasicDialog.wmSetCursor(var Msg: TMessage);
begin
  if AmWaiting and not SuspendedWaiting then
  begin
    SetCursor(WaitingCursor);
    Msg.Result:=1;
    SetWindowLong(HWindow,DWL_MSGRESULT, MAKELONG(1, 0));
  end else DefWndProc(Msg);
end;

procedure TBasicDialog.InitPos;
var
  Rect: TRect;
  XShift,YShift: integer;
  Screen: TRect;
begin
  GetVisibleRect(Screen);
  GetWindowRect(HWindow,Rect);
  Xshift:=0; YShift:=0;
  if Rect.right>Screen.right      then XShift:=Screen.right-Rect.right;
  if Rect.left+XShift<Screen.Left then XShift:=Screen.Left-Rect.left;
  if Rect.bottom>Screen.bottom    then YShift:=Screen.bottom-Rect.bottom;
  if Rect.top+YShift<Screen.Top   then YShift:=Screen.Top-Rect.top;

  if (Xshift<>0) or (YShift<>0) then
    MoveWindow(HWindow,Rect.left+XShift,Rect.top+Yshift,
               Rect.right-Rect.left, Rect.bottom-Rect.top,true);
end;                           { TBasicDialog.InitPos }

procedure TBasicDialog.WaitingMessage(S: PChar);
var
  F: array[0..255] of char;
begin
  if AmWaiting and ((S=Nil) or (S[0]=#0)) then
  begin
    SetCursor(ArrowCursor);
    SetWindowText(HWindow,OldWindowText);
    StrDispose(OldWindowText); OldWindowText:=Nil;
    AmWaiting:=false;
    WinYieldCounter:=0;
    Exit;
  end;
  if not AmWaiting then
  begin
    OldCursor:=SetCursor(WaitingCursor);
    GetWindowText(HWindow,F,255);
    if OldWindowText<>Nil then
    begin
      StrDispose(OldWindowText); OldWindowText:=Nil;
    end;
    OldWindowText:=StrNew(F);
  end;
  SetWindowText(HWindow,S);
  AmWaiting:=true;
  WinYieldCounter:=0;
  AbortFlag:=false;
end;                         { TBasicDialog.WaitingMessage }

procedure TBasicDialog.WaitingOff;
begin
  if AmWaiting then WaitingMessage('');
end;                       { TBasicDialog.WaitingOff }

procedure TBasicDialog.SearchingMessage;
begin
  WaitingMessage('Searching...');
end;

destructor TBasicDialog.Done;
begin
  MessageParent:=OldMessageParent;
  if (OldCurrentWindow=Nil) or (IsWindow(OldCurrentWindow^.HWindow)=bool(0))
      then CurrentWindow:=MainW
  else CurrentWindow:=OldCurrentWindow;
  if OldWindowText<>Nil then StrDispose(OldWindowText);
  dec(DialogDepth);
  TDialog.done;
end;                { TBasicDialog.Done }

{ TResizableDialog methods }

constructor TResizableDialog.init(AParent: PWindowsObject; AName: PChar;
                                APosRec: InitialSizePtr);
begin
  TBasicDialog.init(AParent,Aname);
  DisableAutoCreate;
  PosRec:=APosRec;
  ControlPos.Init(10,10);
  ResizeWidth:=true; ResizeHeight:=true;
end;

procedure TResizableDialog.DisableSysMinimize;
var
  H: HMenu;
begin
  H:=GetSystemMenu(HWindow,false);
  RemoveMenu(H,sc_minimize,mf_ByCommand);
end;

procedure TResizableDialog.NewControl(id,left,right,top,bottom: integer);
begin
  ControlPos.Insert(new(PControlPos,Init(Hwindow,GetItemHandle(id),
                    left,right,top,bottom)));
end;

procedure TResizableDialog.SetupWindow;
var
  Rect: TRect;
begin
  TBasicDialog.SetupWindow;
  GetWindowRect(HWindow,Rect);
  MinimalSize.X:=Rect.right-Rect.Left;
  MinimalSize.Y:=Rect.bottom-Rect.top;
  FixControlPos;
end;               { TResizableDialog.SetupWindow }

procedure TResizableDialog.InitPos;
var
  Rect: TRect;
  Xset,Yset,Wset,Hset: integer;
  changed: boolean;
  Screen: TRect;
begin
  if PosRec=Nil then
  begin
    TBasicDialog.InitPos; Exit;
  end;
  GetVisibleRect(Screen);
  if PosRec^.H<>0 then
  with PosRec^ do
  begin
    XSet:=X; Yset:=Y; Wset:=W; HSet:=H; changed:=true;
  end else
  begin
    GetWindowRect(HWindow,Rect);
    with Rect do
    begin
      XSet:=left; YSet:=top; WSet:=right-left; HSet:=bottom-top;
    end;
    Changed:=false;
  end;
  if Xset+Wset>Screen.right then
  begin
    XSet:=Screen.right-Wset; changed:=true;
  end;
  if Xset<Screen.Left then
  begin
    XSet:=Screen.Left; changed:=true;
  end;
  if XSet+Wset>Screen.right then
  begin
    WSet:=Screen.right-Xset; changed:=true;
  end;
  if Yset+Hset>Screen.bottom then
  begin
    YSet:=Screen.bottom-Hset; changed:=true;
  end;
  if Yset<Screen.Top then
  begin
    YSet:=Screen.Top; changed:=true;
  end;
  if Yset+Hset>Screen.bottom then
  begin
    HSet:=Screen.bottom-Yset; changed:=true;
  end; 
  if changed then MoveWindow(HWindow,Xset,Yset,Wset,Hset,false);
end;                              { TResizableDialog.InitPos }

procedure TResizableDialog.FixControlPos;
begin end;

procedure TResizableDialog.wmSize(var Msg: TMessage);
var
  i: integer;
  Rect: TRect;
  X,Y,W,H: integer;
begin
  GetClientRect(HWindow,Rect);
  for i:=0 to ControlPos.Count-1 do
    with PControlPos(ControlPos.at(i))^ do
    begin
      if cleft=RelTo_Right then X:=Rect.right-Initial.left
      else X:=Initial.left;
      if ctop=RelTo_bottom then Y:=Rect.bottom-Initial.top
      else Y:=Initial.top;
      if cright=RelTo_Left then W:=Initial.right-X
      else if cright=RelTo_Size then W:=Initial.right
      else W:=Rect.right-Initial.Right-X;
      if cbottom=RelTo_top then H:=Initial.bottom-Y
      else if cbottom=RelTo_Size then H:=Initial.bottom
      else H:=Rect.bottom-Initial.bottom-Y;
      MoveWindow(Handle,X,Y,W,H,true);
    end;
  InvalidateRect(HWindow,nil,true);
end;                    { TResizableDialog.wmSize }

function TResizableDialog.WmGetMinMaxInfo(var Msg: TMessage): bool;
var
  P: TPoint;
  Screen: TRect;
begin
  GetVisibleRect(Screen);
  PMinMaxInfo(Msg.lparam)^.ptMinTrackSize:=MinimalSize;
  P.X:=Screen.right-Screen.Left; P.Y:=Screen.bottom-Screen.Top;
  if not ResizeWidth  then P.X:=MinimalSize.X;
  if not ResizeHeight then P.Y:=MinimalSize.Y;
  PMinMaxInfo(Msg.lparam)^.ptMaxTrackSize:=P;

  WmGetMinMaxInfo:=bool(0);
end;                      { TResizableDialog.WmGetMinMaxInfo }

procedure TResizableDialog.wmDestroy(var Msg: TMessage);
var
  Placement: TWindowPlacement;
begin
  ControlPos.Done;
  if PosRec<>Nil then
  begin
    FillChar(Placement,sizeof(TWindowPlacement),0);
    Placement.length:=sizeof(TWindowPlacement);
    if GetWindowPlacement(HWindow,@Placement)<>bool(0) then
    with PosRec^, Placement.rcNormalPosition do
      if (X<>left) or (Y<>top) or (W<>(right-left)) or (H<>(bottom-top)) then
      begin
        X:=left; Y:=top; W:=right-left; H:=bottom-top;
        OptionsModified.WindowsParams:=true;
      end;
  end;
  TBasicDialog.wmDestroy(Msg);
end;                           { TResizableDialog.wmDestroy }


{ Edit boxes }

{ TEditEx methods - a 64K edit box without a local heap }

function TEditEx.Create: Boolean;
var
  HParent            : HWnd;
  EditDS, AInstance  : THandle;
  EditDSPtr          : Pointer;
begin
  DisableAutoCreate;
  If (Parent=NIL) then HParent:=0 else HParent:=Parent^.HWindow;
  EditDS:=GlobalAlloc(GMEM_DDEShare or GMEM_Moveable or GMEM_ZeroInit, 4096);
  if (EditDS=0) then AInstance:=HInstance
  else begin
    EditDSPtr:=GlobalLock(EditDS);
    LocalInit(HiWord(LongInt(EditDSPtr)), 16, Word(GlobalSize(EditDS)-16));
    UnlockSegment(HiWord(LongInt(EditDSPtr)));
    AInstance:=HiWord(LongInt(EditDSPtr));
  end;
  If Register then
     with Attr do CreateWindowEx(ExStyle, GetClassName, Title,
                  Style, X, Y, W, H, HParent, Id, AInstance, Param);
  HWindow:=GetDlgItem(HParent, Attr.ID);
  if (HWindow=0) Then Status:=em_InvalidWindow
  else if (GetObjectPtr(HWindow)=NIL) then
  begin
    {
    AttachProperties(HWindow, @Self);
    }
    DefaultProc:=TFarProc(SetWindowLong(HWindow, gwl_WndProc,
                          LongInt(Instance)));
    SetupWindow;
  end;
  Create:=(Status=0);
  SendMessage(HWindow, em_LimitText, 0, 0);
end;

{ TEditRestricted }

procedure TEditRestricted.MapExcluded(ForbidChars: CharSet);
var
  i: word;
  j: longint;
begin
  NForbid:=0; Exclude:='';
  for i:=1 to 255 do
  if Chr(i) in ForbidChars then
  begin
    Exclude:=Exclude+Chr(i);
    if (i>=32) and (i<=128) then
    begin
      j:=OemKeyScan(i);
      if integer(LoWord(j))<>-1 then
      begin
        inc(NForbid);
        Forbid[NForbid]:=j;
      end;
    end;
  end; 
end;                             { TEditRestricted.MapExcluded }

constructor TEditRestricted.Init(AParent: PWindowsObject; AnId: Integer;
                ATitle: PChar; X,Y,W,H,ATextLen: Integer; Multiline : Boolean;
                ForbidChars: CharSet);
begin
  TEdit.Init(AParent,AnId,ATitle,X,Y,W,H,ATextLen,Multiline);
  MapExcluded(ForbidChars);
end;

constructor TEditRestricted.InitResource(AParent: PWindowsObject; AnId: Integer;
            ATextLen: Integer; ForbidChars: CharSet);
begin
  TEdit.InitResource(AParent,AnId,ATextLen);
  MapExcluded(ForbidChars);
end;

procedure TEditRestricted.wmChar(var Msg: TMessage);
var
  found: boolean;
  i: integer;
  ScanCode: word;
  ShftState: word;
  FullVal: longint;
begin
  found:=false;
  ScanCode:=LoByte(HiWord(Msg.lParam)); ShftState:=0;
  i:=GetKeyState(vk_shift);
  if i<0 then ShftState:=ShftState or 2;
  i:=GetKeyState(vk_control);
  if i<0 then ShftState:=ShftState or 4;
  FullVal:=MakeLong(ScanCode,ShftState);
  i:=0;
  while (i<NForbid) and (not found) do
  begin
    inc(i);
    Found:=FullVal=Forbid[i];
  end;
  if found then
  begin
    MessageBeep(0); Msg.Result:=1
  end else DefWndProc(Msg);
end;                            { TEditRestricted.wmChar }

function TEditRestricted.CanClose: boolean;
var
  F: array[0..1] of char;
  i: integer;
begin
  F[1]:=#0;
  for i:=1 to length(Exclude) do
  begin
    F[0]:=Exclude[i];
    if search(0,F,true)>-1 then
    begin
      ErrorMessageRC(Str_IllegalInput,'');
      SetFocus(HWindow);
      CanClose:=false;
      Exit;
    end;
  end;
  CanClose:=true;
end;                                { TEditRestricted.CanClose }

{ TEditNoCr }

procedure TEditNoCr.paste;
var
  T: THandle;
  l,n,i: longint;
  Data,buf: PChar;
begin
  if not IsClipboardFormatAvailable(cf_text) then Exit;
  
  OpenClipboard(HWindow);
  T:=GetClipboardData(cf_text);
  l:=GlobalSize(T);
  Data:=GlobalLock(T);
  GetMem(buf,l+1);
  StrPCopy(buf,'');
  n:=0;
  for i:=0 to StrLen(Data)-1 do
  if Data[i] in [#0..#32] then
  begin
    if (n>0) and (Buf[n-1]<>' ') then
    begin
      buf[n]:=' '; inc(n);
    end;
  end else
  begin
    buf[n]:=Data[i]; inc(n);
  end;
  buf[n]:=#0;
  GlobalUnlock(T);
  CloseClipboard;
  Insert(Buf);
  FreeMem(buf,l+1);
end;                         { TEditNoCr.paste }

{ TEditTemplate methods }

constructor TEditTemplate.InitResource(AParent: PWindowsObject; id: integer);
begin
  TEditNoCr.InitResource(AParent,id,255,[]);
end;

function TEditTemplate.CanClose: boolean;
var
  F: array[0..255] of char;
  S: string;
  nbr: integer;
  o_k: boolean;
begin
  CanClose:=false;
  if not TEditNoCr.CanClose then Exit;
  o_k:=true;
  GetWindowText(HWindow,F,255);
  if StrLen(F)<>0 then
  begin
    S:=StrPas(F);
    nbr:=ChrQty(S,lbrace)-ChrQty(S,rbrace);
    if nbr<>0 then
    begin
      ErrorMessageRC(Str_UnbalancedBraces,''); o_k:=false;;
    end else
    begin
      PrepareTemplate(S); DecompTemplate(S,S);
      if (Pos('_unknown',S)>0) and
         AskIfRC(Str_TempUnknownField,'','Warning','Correct','Accept') then o_k:=false;
    end;
  end;
  if o_k then CanClose:=true
  else SetFocus(HWindow);
end;                           { TEditTemplate.CanClose }

{ TEditBalanced methods }

function TEditBalanced.CanClose: boolean;
var
  S: PChar;
  Slen: word;
  BareQuote: boolean;
begin
  if not TEditNoCr.CanClose then
  begin
    CanClose:=false;
  end;
  SLen:=GetWindowTextLength(HWindow);
  GetMem(S,SLen+1);
  GetWindowText(HWindow,S,Slen+1);
  if OkField(S^,Slen,3,
         StringRC(Str_UnbalancedBracesInText,''),
         StringRC(Str_IllegalMacroSyntax,''), BareQuote) then
      CanClose:=true
  else begin
    CanClose:=false;
    SetFocus(HWindow);
  end;
  FreeMem(S,SLen+1);
end;                            { TEditBalanced.CanClose }

{ TGetStringDlg methods }

constructor TGetStringDlg.Init(AParent: PWindowsObject; AName: PChar;
            Atitle: string; Forbidden: CharSet; PAnswer: PChar;
            MarkText: boolean; MaxTextLength: word);
begin
  TBasicDialog.Init(AParent,AName);
  Answer:=Panswer;
  Forbid:=Forbidden;
  StrPCopy(Title,Atitle);
  MarkOnStartup:=MarkText;
  MaxLength:=MaxTextLength;
  New(Ebox,InitResource(@Self,dl_GetStringEbox,MaxTextLength,Forbid));
end;                              { TStringDlg.Init }

procedure TGetStringDlg.SetupWindow;
begin
  TBasicDialog.SetupWindow;
  if StrLen(Title)>0 then SetWindowText(HWindow,Title);
  if StrLen(Answer)>0 then
  begin
    SetWindowText(EBox^.HWindow,Answer);
    if MarkOnStartup then Ebox^.SetSelection(0,StrLen(Answer)-1);
  end;
end;                              { GetStringDlg.SetupWindow }

procedure TGetStringDlg.Ok(var Msg: TMessage);
begin
  if CanClose then
  begin
    if GetWindowText(EBox^.HWindow,Answer,MaxLength)=0 then
      StrPCopy(Answer,'');
    EndDlg(id_OK);
  end;                               { TGetStringDlg.OK }
end;

{ TGetStringModeDlg methods }

procedure UploadFieldList(Fields: string; EWindow: HWnd; F: PChar);
var
  i,j,k,l: integer;
  tmp: string;
  WasNil: boolean;
begin
  WasNil:=(F=Nil);
  l:=-1;
  if Fields='' then l:=0
  else if length(Fields)>OrigFieldLast+1 then l:=Length(PattStr_All)+1
  else for i:=1 to length(Fields) do
  begin
    if Fields[i]=PattField_Name        then tmp:=PattStr_Name
    else if Fields[i]=PattField_Tagged then tmp:=PattStr_Tagged
    else if Fields[i]=PattField_Type   then tmp:=PattStr_Type
    else if Fields[i]=PattField_Undec  then tmp:=PattStr_Undec
    else tmp:=TypeField^[Ord(Fields[i])];
    l:=l+length(tmp)+1;
  end;
  if WasNil then GetMem(F,l+8);
  F[0]:=#0;
  if length(Fields)>OrigFieldLast+1 then StrPCopy(F,PattStr_All)
  else begin
    j:=0;
    for i:=1 to length(Fields) do
    begin
      if Fields[i]=PattField_Name        then tmp:=PattStr_Name
      else if Fields[i]=PattField_Tagged then tmp:=PattStr_Tagged
      else if Fields[i]=PattField_Type   then tmp:=PattStr_Type
      else if Fields[i]=PattField_Undec  then tmp:=PattStr_Undec
      else tmp:=TypeField^[Ord(Fields[i])];
      for k:=1 to length(tmp) do F[j+k-1]:=tmp[k];
      j:=j+length(tmp); F[j]:='+'; inc(j);
    end;
    if j>0 then F[j-1]:=#0;
  end;
  if EWindow<>0 then SetWindowText(EWindow,F);
  if WasNil then FreeMem(F,l+8);
end;                             { UploadFieldList }

{ TSearchFieldsDlg methods }

constructor TSearchFieldsDlg.init(AParent: PWindowsObject; AFieldList: PString);
begin
  TBasicDialog.init(AParent,PChar(rc_ExpFieldsDlg));
  FieldList:=AFieldList;
end;

procedure TSearchFieldsDlg.SetupWindow;
var
  Ind,i: integer;

procedure InsertField(fld: char; Name: string);
var
  F: array[0..255] of char;
begin
  StrPCopy(F,Name);
  SendDlgItemMsg(dl_SelectionListLBox,lb_AddString,0,longint(@F));
  if Pos(fld,FieldList^)>0 then
      SendDlgItemMsg(dl_SelectionListLBox,lb_SetSel,word(true),Ind);
  inc(Ind);
end;

begin
  TBasicDialog.SetupWindow;
  SetWindowText(HWindow,'Search fields');
  Ind:=0;
  InsertField(PattField_Name,PattStr_Name);
  for i:=1 to OrigFieldLast do InsertField(Chr(i),TypeField^[i]);
  InsertField(Chr(StringIndex),TypeField^[StringIndex]);
  if Pos(PattField_Undec,FieldList^)>0 then
    CheckDlgButton(HWindow,dl_ExpFieldsUndec,1);
  InitPos;
end;

procedure TSearchFieldsDlg.AllBtn(var Msg: TMessage);
begin
  SendDlgItemMsg(dl_SelectionListLBox,lb_SetSel,word(true),-1);
  CheckDlgButton(HWindow,dl_ExpFieldsUndec,1);
end;

procedure TSearchFieldsDlg.ClearBtn(var Msg: TMessage);
begin
  SendDlgItemMsg(dl_SelectionListLBox,lb_SetSel,word(false),-1);
  CheckDlgButton(HWindow,dl_ExpFieldsUndec,0);
end;

procedure TSearchFieldsDlg.ok(var Msg: TMessage);
var
  SelectionBuf: array[1..MaxField+3] of integer;
  Nselected,i: integer;
begin
  FillChar(SelectionBuf,sizeof(SelectionBuf),0);
  NSelected:=SendDlgItemMsg(dl_SelectionListLBox,lb_GetSelItems,MaxField+3,
    Longint(@SelectionBuf));
  if (NSelected<>lb_err) and (NSelected>0) then
  begin
    FieldList^:='';
    for i:=1 to NSelected do FieldList^:=FieldList^+Chr(SelectionBuf[i]);
    if IsDlgButtonChecked(HWindow,dl_ExpFieldsUndec)<>0 then
      FieldList^:=FieldList^+PattField_Undec;
    EndDlg(id_ok);
  end else
    EndDlg(id_cancel);
end;                              { TSearchFieldsDlg.ok }

constructor TGetStringModeDlg.Init(AParent: PWindowsObject; AName: PChar;
            Atitle: string; Forbidden: CharSet; PAnswer: PChar;
            PRegExp,PCaseSen: PBoolean; AskMode,MarkText: boolean;
            MaxTextLength: Word; AFieldStr: PString; AUseFields,ANegate: PBoolean);
var
  i: integer;
begin
  TGetStringDlg.Init(AParent,Aname,Atitle,Forbidden,PAnswer,MarkText,
                     MaxTextLength);
  RegExp:=PRegExp; CaseSen:=PCaseSen;
  FieldStr:=AFieldStr; UseFields:=AUseFields;
  Negate:=ANegate;
  RegExpCBox:=Nil; CaseSenCBox:=Nil;
  if AskMode then
  begin
    New(RegExpCBox,InitResource(@Self,dl_StrModeRegExp));
    New(CaseSenCBox,InitResource(@Self,dl_StrModeCase));
  end;
  for i:=0 to 100 do flds[i]:=Nil;
end;                              { TGetStringModeDlg.Init }

procedure TGetStringModeDlg.SetupWindow;
var
  F,F2: PChar;
  i: integer;
begin
  TGetStringDlg.SetupWindow;
  if RegExpCBox<>Nil then
  begin
    if RegExp^ then RegExpCBox^.Check
    else RegExpCBox^.Uncheck;
    if CaseSen^ then CaseSenCBox^.Check
    else CaseSenCBox^.UnCheck;
  end;
  if FieldStr<>Nil then
  begin
    New(flds[0]); flds[0]^:=FieldStr^;
    GetMem(F,1024);
    StrPCopy(F,'Current: ');
    F2:=@F[StrLen(F)];
    UploadFieldList(FieldStr^,0,F2);
    SendDlgItemMsg(dl_SearchStrFList,cb_AddString,0,longint(F));
    for i:=1 to PMenuNum do
    begin
      UploadFieldList(PString(@PmenuChoice[i,0])^,0,F);
      SendDlgItemMsg(dl_SearchStrFList,cb_AddString,0,longint(F));
      flds[i]:=NewStr(PString(@PmenuChoice[i,0])^);
    end;
    StrPCopy(F,'Default scope or explicit patterns');
    SendDlgItemMsg(dl_SearchStrFList,cb_AddString,0,longint(F));
    FreeMem(F,1024);
    if UseFields^ then
      SendDlgItemMsg(dl_SearchStrFList,cb_SetCurSel,0,0)
    else
      SendDlgItemMsg(dl_SearchStrFList,cb_SetCurSel,PMenuNum+1,0);
    if Negate^ then CheckDlgButton(HWindow,dl_SearchStrNegate,bf_Checked);
  end;
end;                       { TGetStringModeDlg.SetupWindow }

procedure TGetStringModeDlg.SelectFieldsBtn(var Msg: TMessage);
var
  F,F2: PChar;
begin
  if Application^.ExecDialog(New(PSearchFieldsDlg,
            Init(@Self,flds[0])))=id_ok then
  begin
    SendDlgItemMsg(dl_SearchStrFList,cb_DeleteString,0,0);
    GetMem(F,1024);
    StrPCopy(F,'Current: ');
    F2:=@F[StrLen(F)]; UploadFieldList(flds[0]^,0,F2);
    SendDlgItemMsg(dl_searchStrFList,cb_InsertString,0,longint(F));
    FreeMem(F,1024);
    SendDlgItemMsg(dl_SearchStrFList,cb_SetCurSel,0,0);
  end;
  SetFocus(EBox^.HWindow);
end;

procedure TGetStringModeDlg.SelFieldsCBox(var Msg: TMessage);
begin
  if Msg.lParamHi=cbn_CloseUp then SetFocus(EBox^.HWindow);
end;

procedure TGetStringModeDlg.Ok(var Msg: TMessage);
var
  Sel: integer;
begin
  if CanClose then
  begin
    if GetWindowText(EBox^.HWindow,Answer,MaxLength)=0 then
      StrPCopy(Answer,'');
    if RegExpCBox<>Nil then
    begin
      RegExp^:=RegExpCBox^.GetCheck=bf_Checked;
      CaseSen^:=CaseSenCBox^.GetCheck=bf_Checked;
    end;
    if FieldStr<>Nil then
    begin
      Sel:=SendDlgItemMsg(dl_SearchStrFList,cb_GetCurSel,0,0);
      if Sel=cb_Err then Sel:=PMenuNum+1;
      if Sel=PMenuNum+1 then
      begin
        UseFields^:=false; FieldStr^:=flds[0]^;
      end else
      begin 
        UseFields^:=true; FieldStr^:=flds[Sel]^;
      end;
      Negate^:=IsDlgButtonChecked(HWindow,dl_SearchStrNegate)=bf_Checked;
    end;
    EndDlg(id_OK);
  end;
end;                             { TGetStringModeDlg.Ok }

destructor TGetStringModeDlg.Done;
var
  i: integer;
begin
  if flds[0]<>Nil then Dispose(flds[0]);
  for i:=1 to 100 do
    if flds[i]<>Nil then DisposeStr(flds[i]);
  TBasicDialog.Done;
end;

{ TRegistersDlg methods }

constructor TRegistersDlg.Init(Aparent: PWindowsObject; ASave: boolean;
            PEBox: PEdit);
begin
  TBasicDialog.init(Aparent,PChar(rc_SaveRegisterDlg));
  SaveDlg:=ASave;
  InEBox:=PEbox;
end;                          { TRegistersDlg.Init }

procedure TRegistersDlg.SetupWindow;
var
  line: string;
  F: array[0..260] of char;
  i,StartPos,EndPos: integer;
  Rect: TRect;
begin
  TBasicDialog.SetupWindow;
  HLBox:=GetItemHandle(dl_RegsLBox);
  HEBox:=GetItemHandle(dl_RegsEBox);
  GetClientRect(HLBox,Rect);
  SendDlgItemMsg(dl_RegsLBox,lb_SetColumnWidth,(Rect.right-Rect.left) div 2,0);
  for i:=0 to 35 do
  begin
    RecallBufferStack(line[0],MemoryPos+i);
    if i<26 then StrPCopy(F,Chr(i+Ord('A'))+': '+line)
    else StrPCopy(F,Chr(i-26+Ord('0'))+': '+line);
    SendDlgItemMsg(dl_RegsLBox,lb_AddString,0,longint(@F));
  end;

  if SaveDlg then
  begin
    InEBox^.GetSelection(StartPos,EndPos);
    if StartPos<EndPos then
    begin
      if EndPos-StartPos>255 then EndPos:=StartPos+255;
      InEBox^.GetSubText(F,StartPos,EndPos);
      SetWindowText(HEBox,F);
    end;
  end else
  begin
    SetWindowText(HWindow,'Load from Register'); 
    SetWindowText(GetItemHandle(id_ok),'&Recall');
  end;
  InitPos;
end;                          { TRegistersDlg.SetupWindow }

procedure TRegistersDlg.SaveInRegs;
var
  F: array[0..255] of char;
  ind,slen: integer;
  ch: char;
  S: string;
  S1: string[1];
begin
  ind:=SendDlgItemMsg(dl_RegsLBox,lb_GetCurSel,0,0);
  if ind=lb_Err then Exit;
  slen:=GetWindowText(HEBox,F,255);
  if slen=0 then
  begin
    if Ind<26 then ch:=Chr(ind+Ord('A')) else ch:=Chr(ind-26+Ord('0'));
    S1:=ch;
    if not YesNoRC(Str_EraseRegister,S1) then Exit;
  end;
  S:=StrPas(F);
  PushBufferStack(S,256,MemoryMode,MemoryPos+ind);
  OptionsModified.Registers:=true;
end;                           { TRegistersDlg.SaveInRegs }

procedure TRegistersDlg.GetFromRegs;
var
  F: array[0..255] of char;
begin
  GetWindowText(HEBox,F,255);
  InEBox^.Insert(F);
end;                            { TRegistersDlg.GetFromRegs }

procedure TRegistersDlg.LBoxMessage(var Msg: TMessage);
var
  line: string;
  ind: integer;
  F: array[0..255] of char;
begin
  if Msg.lParamhi=lbn_DblClk then ok(Msg)
  else if (not SaveDlg) and (Msg.lParamHi=lbn_SelChange) then
  begin
    ind:=SendDlgItemMsg(dl_RegsLBox,lb_GetCurSel,0,0);
    if ind=lb_Err then Exit;
    RecallBufferStack(line[0],MemoryPos+ind);
    StrPCopy(F,line);
    SetWindowText(HEbox,F);
  end;
end;                           { TRegistersDlg.LBoxMessage }

procedure TRegistersDlg.ok(var Msg: TMessage);
begin
  if CanClose then
  begin
    if SaveDlg then SaveInRegs
    else GetFromRegs;
    EndDlg(id_ok);
  end;
end;                          { TRegistersDlg.ok }

{ TSelectFieldsDlg methods }

constructor TSelectFieldsDlg.init(AParent: PWindowsObject; AFieldList: PFieldArr;
            AWithName,AWithString,AUndeclared: boolean);
begin
  TBasicDialog.init(AParent,PChar(rc_SelectionListDlg));
  DumpFields:=AFieldList;
  WithName:=AWithName; WithString:=AWithString;
  Undeclared:=AUndeclared;
end;

procedure TSelectFieldsDlg.SetupWindow;
var
  i,shft,last: integer;
  F: array[0..255] of char;
begin
  TBasicDialog.SetupWindow;
  SetWindowText(HWindow,'Fields');
  Shft:=0;
  if WithName then
  begin
    StrPCopy(F,'_name');
    SendDlgItemMsg(dl_SelectionListLBox,lb_AddString,0,longint(@F));
    if DumpFields^[0] then
      SendDlgItemMsg(dl_SelectionListLBox,lb_SetSel,word(true),0);
    shft:=1;
  end;

  if Undeclared then Last:=FieldLast
  else Last:=OrigFieldLast;
  for i:=1 to Last do
  begin
    StrPCopy(F,typefield^[i]);
    SendDlgItemMsg(dl_SelectionListLBox,lb_AddString,0,longint(@F));
    if DumpFields^[i] then
      SendDlgItemMsg(dl_SelectionListLBox,lb_SetSel,word(true),i-1+shft);
  end;

  if WithString then
  begin
    StrPCopy(F,TypeField^[StringIndex]);
    SendDlgItemMsg(dl_SelectionListLBox,lb_AddString,0,longint(@F));
    if DumpFields^[FieldLast+1] then
      SendDlgItemMsg(dl_SelectionListLBox,lb_SetSel,word(true),Last+shft);
  end;
  InitPos;
end;                              { TSelectFieldsDlg.SetupWindow }

procedure TSelectFieldsDlg.AllBtn(var Msg: TMessage);
begin
  SendDlgItemMsg(dl_SelectionListLBox,lb_SetSel,word(true),-1);
end;

procedure TSelectFieldsDlg.ClearBtn(var Msg: TMessage);
begin
  SendDlgItemMsg(dl_SelectionListLBox,lb_SetSel,word(false),-1);
end;

procedure TSelectFieldsDlg.ok(var Msg: TMessage);
var
  SelectionBuf: array[1..MaxField+1] of integer;
  Nselected,i: integer;
begin
  FillChar(SelectionBuf,sizeof(SelectionBuf),0);
  NSelected:=SendDlgItemMsg(dl_SelectionListLBox,lb_GetSelItems,fieldlast,
    Longint(@SelectionBuf));
  for i:=1 to MaxField+1 do DumpFields^[i]:=false;
  if NSelected<>lb_err then
  for i:=1 to NSelected do DumpFields^[SelectionBuf[i]+1]:=true;
  EndDlg(id_ok);
end;

{ TExpFieldsDlg methods }

constructor TExpFieldsDlg.init(AParent: PWindowsObject; AFieldList: PFieldArr;
                               AUndec: PBoolean; ATitle: PChar);
begin
  TBasicDialog.init(AParent,PChar(rc_ExpFieldsDlg));
  DumpFields:=AFieldList;
  WithName:=false; WithString:=false; Undeclared:=false;
  Undec:=AUndec;
  Title:=ATitle;
end;

procedure TExpFieldsDlg.SetupWindow;
begin
  TSelectFieldsDlg.SetupWindow;
  if Title<>Nil then SetWindowText(HWindow,Title);
  if Undec^ then CheckDlgButton(HWindow,dl_ExpFieldsUndec,1)
  else CheckDlgButton(HWindow,dl_ExpFieldsUndec,0);
end;

procedure TExpFieldsDlg.AllBtn(var Msg: TMessage);
begin
  TSelectFieldsDlg.AllBtn(Msg);
  CheckDlgButton(HWindow,dl_ExpFieldsUndec,1);
end;

procedure TExpFieldsDlg.ClearBtn(var Msg: TMessage);
begin
  TSelectFieldsDlg.ClearBtn(Msg);
  CheckDlgButton(HWindow,dl_ExpFieldsUndec,0);
end;

procedure TExpFieldsDlg.ok(var Msg: TMessage);
begin
  Undec^:=IsDlgButtonChecked(HWindow,dl_ExpFieldsUndec)<>0;
  TSelectFieldsDlg.ok(Msg);
end;

{ TEditAField methods }

constructor TEditAFieldDlg.init(AParent: PWindowsObject; Aname,Atitle: PChar;
                     IsBalanced: boolean; AP: Pointer; ASLen: PWord; AMaxLen: word);
begin
  TBasicDialog.Init(AParent,PChar(Aname));
  if IsBalanced then
    EBox:=New(PEditBalanced,InitResource(@Self,dl_EditFieldEBox,AMaxLen+1,[]))
  else
    EBox:=New(PEditNoCr,InitResource(@Self,dl_EditFieldEBox,AMaxLen+1,[]));
  P:=AP; Title:=Atitle; SLen:=ASlen; IsPString:=Slen=Nil;
  MaxLen:=AMaxLen;
end;

procedure TEditAFieldDlg.SetupWindow;
var
  F: array[0..255] of char;
  PC: PChar;
begin
  TBasicDialog.SetupWindow;
  if (Title<>Nil) and (StrLen(Title)>0) then SetWindowText(HWindow,Title);
  if IsPString then
  begin
    StrPCopy(F,PString(P)^); SetWindowText(EBox^.HWindow,F);
  end else
  begin
    PC:=PChar(P); PC[Slen^]:=#0;
    SetWindowText(EBox^.HWindow,PC);
  end;
  PC:=Nil;
  SendDlgItemMsg(dl_EditFieldEBox,em_LimitText,MaxLen,0);
end;                             { TEditAFieldDlg.SetupWindow }

procedure TEditAFieldDlg.BibEnterIdle(var Msg: TMessage);
var
  CurSelection: Longint;
  IsSelected: boolean;
begin
  CurSelection:=SendDlgItemMsg(dl_EditFieldEBox,em_GetSel,0,0);
  IsSelected:=LoWord(CurSelection)<>HiWord(CurSelection);
  EnableWindow(GetItemHandle(dl_EditFieldCutBtn),IsSelected);
  EnableWindow(GetItemHandle(dl_EditFieldCopyBtn),IsSelected);
  EnableWindow(GetItemHandle(dl_EditFieldPasteBtn),
                           IsClipboardFormatAvailable(cf_Text));
  EnableWindow(GetItemHandle(dl_EditFieldUndoBtn),EBox^.CanUndo);
end;

procedure TEditAFieldDlg.SaveRegs(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PRegistersDlg,init(@Self,true,EBox)));
  SetFocus(Ebox^.HWindow);
end;

procedure TEditAFieldDlg.LoadRegs(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PRegistersDlg,init(@Self,false,EBox)));
  SetFocus(Ebox^.HWindow);
end;

procedure TEditAFieldDlg.CutBtn(var Msg: TMessage);
begin EBox^.Cut; SetFocus(Ebox^.HWindow); end;

procedure TEditAFieldDlg.CopyBtn(var Msg: TMessage);
begin EBox^.Copy; SetFocus(Ebox^.HWindow); end;

procedure TEditAFieldDlg.PasteBtn(var Msg: TMessage);
begin EBox^.paste; SetFocus(Ebox^.HWindow); end;

procedure TEditAFieldDlg.UndoBtn(var Msg: TMessage);
begin EBox^.Undo; SetFocus(Ebox^.HWindow); end;

procedure TEditAFieldDlg.ok(var Msg: TMessage);
var
  F: array[0..255] of char;
begin
  if not CanClose then Exit;
  if IsPString then
  begin
    GetWindowText(EBox^.HWindow,F,255);
    PString(P)^:=StrPas(F);
  end else
  begin
    Slen^:=GetWindowText(EBox^.HWindow,PChar(P),MaxLen);
  end;
  EndDlg(id_ok);
end;

{ TCopyToClipDlg methods }

constructor TCopyToClipDlg.init(AParent: PWindowsObject; AEntry: EntryRecPtr;
                     Afld: integer);
begin
  TBasicDialog.init(AParent,PChar(rc_CopyToClipDlg));
  Entry:=AEntry;
  fld:=Afld;
  New(EBox,InitResource(@Self,dl_CopyToClipEBox,MaxBig));
end;

procedure TCopyToClipDlg.SetupWindow;
var
  OutBuf: Pchar;
  l,FreeSize: word;
begin
  TBasicDialog.SetupWindow;
  InitPos;
  with entry^ do
  if fld=0 then
  begin
    GetMem(OutBuf,length(name)+1);
    StrPCopy(OutBuf,name);
    EBox^.Insert(OutBuf);
    FreeMem(OutBuf,length(name)+1);
  end else if (index[fld]=0) then EndDlg(id_Cancel)
  else if (content[index[fld]]<>'') and (content[index[fld]]<>#0) then
  begin
    FreeSize:=0; l:=0; OutBuf:=Nil;
    if ExpandMacros and (content[index[fld]][1]='@') then
    begin
      if BigIndex[fld]=0 then
        DecodeAbbrevs(content[index[fld]][2],length(content[index[fld]])-1,
                      OutBuf,l,FreeSize)
      else
        DecodeAbbrevs(Big[BigIndex[fld]]^[2],Blen[BigIndex[fld]]-1,
                      OutBuf,l,FreeSize);
    end else if BigIndex[fld]=0 then
    begin
      l:=length(Content[index[fld]]); FreeSize:=l+1;
      GetMem(OutBuf,l+1);
      StrPCopy(OutBuf,Content[index[fld]]);
    end else
    begin
      OutBuf:=PChar(Big[BigIndex[fld]]); l:=Blen[BigIndex[fld]];
      OutBuf[l]:=#0;
    end;
    if OutBuf<>Nil then EBox^.Insert(OutBuf);
    if FreeSize>0 then FreeMem(OutBuf,FreeSize);
  end;
end;                          { TCopyToClipDlg.SetupWindow }

procedure TCopyToClipDlg.ok(var Msg: TMessage);
var
  StartPos,EndPos: integer;
begin
  EBox^.GetSelection(StartPos,EndPos);
  if StartPos<EndPos then EBox^.Copy
  else begin
    EBox^.SetSelection(0,-1);
    EBox^.Copy;
  end;
  EndDlg(id_ok);
end;

{ TFontEncodingDlg methods }

constructor TFontEncodingDlg.init(AParent: PWindowsObject;
                     Aenc8a,Aenc7a,Aenc8b,Aenc7b: PBoolean;
                     Aenca,Aencb: PInteger);
begin
  TBasicDialog.init(AParent,PChar(rc_FontEncodingDlg));
  enc8a:=AEnc8a; enc7a:=AEnc7a; Enc8b:=AEnc8b;Enc7b:=AEnc7b;
  encA:=AEncA; Encb:=AEncB;
  HelpContext:=hc_encoding;
end;                            { TFontEncodingDlg.init }

procedure TFontEncodingDlg.SetupWindow;
var
  i: integer;
  comm: string;
  F: array[0..255] of char;
begin
  TBasicDialog.SetupWindow;
  if Enc8a^      then CheckDlgButton(HWindow,dl_EncodingProg8bit,bf_Checked)
  else if Enc7a^ then CheckDlgButton(HWindow,dl_EncodingProg7bit,bf_Checked)
  else                CheckDlgButton(HWindow,dl_EncodingProgNone,bf_Checked);
  if Enc8b^      then CheckDlgButton(HWindow,dl_EncodingFile8bit,bf_Checked)
  else if Enc7b^ then CheckDlgButton(HWindow,dl_EncodingFile7bit,bf_Checked)
  else                CheckDlgButton(HWindow,dl_EncodingFileNone,bf_Checked);
  for i:=0 to EncodingsList.Count-1 do
  begin
    comm:='';
    if PEncoding(EncodingsList.at(i))^.comment<>Nil then
      comm:=PEncoding(EncodingsList.at(i))^.comment^;
    if comm<>'' then comm:='  '+comm;
    StrPCopy(F,PEncoding(EncodingsList.at(i))^.Name^+comm);;
    SendDlgItemMsg(dl_EncodingFileEBox,cb_AddString,0,Longint(@F));
    SendDlgItemMsg(dl_FileEncodingFileEBox,cb_AddString,0,Longint(@F));
  end;
  SendDlgItemMsg(dl_EncodingFileEBox,cb_SetCurSel,EncA^,0);
  SendDlgItemMsg(dl_FileEncodingFileEBox,cb_SetCurSel,EncB^,0);
end;                       { TFontEncodingDlg.SetupWindow }

procedure TFontEncodingDlg.ok(var Msg: TMessage);
begin
  if not CanClose then Exit;
  Enc8A^:=IsDlgButtonChecked(HWindow,dl_EncodingProg8bit)=bf_Checked;
  Enc7A^:=IsDlgButtonChecked(HWindow,dl_EncodingProg7bit)=bf_Checked;
  Enc8B^:=IsDlgButtonChecked(HWindow,dl_EncodingFile8bit)=bf_Checked;
  Enc7B^:=IsDlgButtonChecked(HWindow,dl_EncodingFile7bit)=bf_Checked;

  EncA^:=SendDlgItemMsg(dl_EncodingFileEBox,cb_GetCurSel,0,0);
  EncB^:=SendDlgItemMsg(dl_FileEncodingFileEBox,cb_GetCurSel,0,0);
  EndDlg(id_ok);
end;                         { TFontEncodingDlg.ok }

procedure TEncTranslateDlg.SetupWindow;
begin
  TFontEncodingDlg.SetupWindow;
  ShowWindow(GetItemHandle(dl_EncodingFileNone),sw_hide);
  SetWindowText(HWindow,'Translation');
  SetDlgItemText(HWindow,dl_EncodingDispGBox,'From encoding:');
  SetDlgItemText(HWindow,dl_EncodingFileGBox,'To encoding:');
  HelpContext:=hc_OperationsSubmenu;
end;                { TEncTranslateDlg.SetupWindow }

{ TCopyFieldDlg methods }

constructor TCopyFieldDlg.init(AParent: PWindowsObject; AEntry: EntryRecPtr;
            AResult: PInteger; AExtended: PBoolean);
begin
  TBasicDialog.init(AParent,PChar(rc_CopyFieldDlg));
  Result:=AResult; Extended:=AExtended; Entry:=AEntry;
end;

procedure TCopyFieldDlg.SetupWindow;
var
  F: array[0..255] of char;
  i: integer;
begin
  TBasicDialog.SetupWindow;
  for i:=1 to Entry^.nentry do
  begin
    StrPCopy(F,Entry^.field[i]);
    SendDlgItemMsg(dl_CopyFieldLbox,lb_AddString,0,Longint(@F));
  end;
  SendDlgItemMsg(dl_CopyFieldLBox,lb_SetCurSel,0,0);
end;                 { TCopyFieldDlg.SetupWindow }

procedure TCopyFieldDlg.ok(var Msg: TMessage);
var
  i: integer;
  F: array[0..255] of char;
begin
  if not CanClose then Exit;
  i:=SendDlgItemMsg(dl_CopyFieldLBox,lb_GetCurSel,0,0);
  SendDlgItemMsg(dl_CopyFieldLBox,lb_GetText,i,Longint(@F));
  Result^:=FindInFieldList(StrPas(F));
  Extended^:=IsDlgButtonChecked(HWindow,dl_CopyFieldExtended)=bf_Checked;
  EndDlg(id_ok);
end;                  { TCopyFieldDlg.ok }

{ TModifyFontsDlg methods }

constructor TModifyFontsDlg.init(AParent: PWindowsObject; AScreenFonts: boolean);
begin
  TBasicDialog.Init(AParent,PChar(rc_ModifyFonts));
  ScreenFonts:=AScreenFonts;
  TagColorChanged:=false;
  EncodingsChanged:=false;
  ENameColorChanged:=false;
end;

procedure TModifyFontsDlg.Loadup;
var
  i,IndOffset: integer;
  F: array[0..255] of char;

procedure AddAString(S: string; Ind: longint);
var
  i: integer;
begin
  if Fonts^[Ind].Default then S:=S+' (null)';
  StrPCopy(F,S);
  i:=SendDlgItemMsg(dl_ModFontsLBox,lb_AddString,0,Longint(@F));
  SendDlgItemMsg(dl_ModFontsLBox,lb_SetItemData,i,Ind);
end;

begin             { TModifyFontsDlg.Loadup }
  IndOffset:=0; if not ScreenFonts then IndOffset:=PrintLabelFont-LabelFont;
  
  SendDlgItemMsg(dl_ModFontsLBox,lb_ResetContent,0,0);
  AddAString('Entry header',LabelFont +IndOffset);
  AddAString('Normal text', NormalFont+IndOffset);
  AddAString('Bold text',   BoldFont  +IndOffset);
  AddAString('Hyperlinks',  HyperFont +IndOffset);
  if ScreenFonts then
  begin
    AddAString('Field editor',     FieldEditFont);
    AddAString('ShowFormat editor',ShowFormatFont);
    AddAString('Pattern fields',   PattFieldFont);
    AddAString('Pattern text',     PattTextFont);
    AddAString('Pattern operators',PattOpFont);
    AddAString('Status bar',       StatusBarFont);
  end else
    AddAString('Page header',      PageHeaderFont);
  for i:=3 to 16 do
    AddAString('Special font #'+num2str(i),i+IndOffset);
    
end;                             { TModifyFontsDlg.LoadUp }

procedure TModifyFontsDlg.SetupWindow;
var
  F: array[0..32] of char;
begin
  TBasicDialog.SetupWindow;
  if ScreenFonts then CheckDlgButton(HWindow,dl_ModFontDisp,bf_Checked)
  else CheckDlgButton(HWindow,dl_ModFontPrint,bf_Checked);
  LoadUp;
  Changed[true]:=false; Changed[false]:=false;

  StrPCopy(F,'Tag symbol');
  SendDlgItemMsg(dl_ModFontsColors,lb_AddString,0,longint(@F));
  StrPCopy(F,'Entry label background');
  SendDlgItemMsg(dl_ModFontsColors,lb_AddString,0,longint(@F));
  StrPCopy(F,'File|Open filename');
  SendDlgItemMsg(dl_ModFontsColors,lb_AddString,0,longint(@F));
  StrPCopy(F,'Duplicate entries');
  SendDlgItemMsg(dl_ModFontsColors,lb_AddString,0,longint(@F));
end;                             { TModifyFontsDlg.SetupWindow }

procedure TModifyFontsDlg.Modify(var Msg: TMessage);
var
  i,FontInd: integer;
  F: array[0..255] of char;
  P: PChar;
begin
  i:=SendDlgItemMsg(dl_ModFontsLBox,lb_GetCurSel,0,0);
  if i=LB_ERR then Exit;
  FontInd:=SendDlgItemMsg(dl_ModFontsLBox,lb_GetItemData,i,0);
  if SelectFont(HWindow,FontInd,FontInd<>FieldEditFont) then
  begin
    SendDlgItemMsg(dl_ModFontsLBox,lb_GetText,i,Longint(@F));
    P:=StrPos(F,' (null)');
    if P<>Nil then
    begin
      P^:=#0;
      SendDlgItemMsg(dl_ModFontsLBox,lb_InsertString,i,Longint(@F));
      SendDlgItemMsg(dl_ModFontsLBox,lb_SetItemData,i,FontInd);
      SendDlgItemMsg(dl_ModFontsLBox,lb_DeleteString,i+1,0);
    end;
    changed[ScreenFonts]:=true;
  end;
end;                              { TModifyFontsDlg.Modify }

procedure TModifyFontsDlg.SetAColor(var Msg: TMessage);
var
  i: integer;
begin
  i:=SendDlgItemMsg(dl_ModFontsColors,lb_GetCurSel,0,0);
  if i=lb_Err then Exit;
  case i of
    0: if SelectColor(HWindow,TagColor) then TagColorChanged:=true;
    1: if SelectColor(HWindow,ENameBackColor) then ENameColorChanged:=true;
    2: SelectColor(HWindow,FilenameColor);
    3: SelectColor(HWindow,DupEntriesColor);
  end;
end;                   { TModifyFontsDlg.SetAColor }

procedure TModifyFontsDlg.FontEncodings(var Msg: TMessage);
begin
  if EncodingsList.Count<3 then
    ErrorMessageRC(Str_NoEncodingsFound,'')
  else if Application^.ExecDialog(New(PFontEncodingDlg,init(
    @Self,@Prog8bit,@Prog7Bit,@File8Bit,@File7Bit,
    @DispEncoding,@FReadEncoding)))=id_ok then
      EncodingsChanged:=true;
end;                           { TBrowseWindow.FontEncodings }

procedure TModifyFontsDlg.HandleLBox(var Msg: TMessage);
begin
  if Msg.lParamHi=lbn_DblClk then Modify(Msg);
end;

procedure TModifyFontsDlg.HandleColorLBox(var Msg: TMessage);
begin
  if Msg.lParamHi=lbn_DblClk then SetAColor(Msg);
end;

procedure TModifyFontsDlg.DisplayFonts;
var
  ScrFonts: boolean;
begin
  ScrFonts:=IsDlgButtonChecked(HWindow,dl_ModFontDisp)=bf_Checked;
  if ScrFonts<>ScreenFonts then
  begin
    ScreenFonts:=ScrFonts;
    LoadUp;
  end;
end;                   { TModifyFontsDlg.DisplayFonts }

procedure TModifyFontsDlg.PrinterFonts;
var
  ScrFonts: boolean;
begin
  ScrFonts:=IsDlgButtonChecked(HWindow,dl_ModFontDisp)=bf_Checked;
  if ScrFonts<>ScreenFonts then
  begin
    ScreenFonts:=ScrFonts;
    LoadUp;
  end;
end;                 { TModifyFontsDlg.PrinterFonts }

procedure TModifyFontsDlg.Cancel(var Msg: TMessage);
var
  id: integer;
begin
  id:=id_cancel;
  if changed[true]    then id:=id or $10;
  if changed[false]   then id:=id or $20;
  if TagColorChanged  then id:=id or $40;
  if EncodingsChanged then id:=id or $80;
  if ENameColorChanged then
  begin
    DeleteObject(ENameBackBrush); ENameBackBrush:=0;
  end;
  EndDlg(id);
end;                    { TModifyFontsDlg.Cancel }


{==============================================}
{ Other stuff }
{==============================================}

{$F+}
function FindRepDlgProc(Dlg: HWnd; Msg, wParam: Word; lParam: LongInt): LongInt;
                        export;
begin
  FindRepDlgProc:=0;
  if Msg=FindRepMsg then FindRepDlgProc:=SendMessage(Dlg,bib_FindRep,wParam,lParam)
  else FindRepDlgProc:=DefDlgProc(Dlg,Msg,wParam,lParam);
end;

function ToolbarDlgProc(Dlg: HWnd; Msg, wParam: Word; lParam: LongInt): LongInt;
                        export;
var
  Rect: TRect;
  DC: HDC;
begin
  ToolbarDlgProc:=0;
  ToolbarDlgProc:=DefDlgProc(Dlg,Msg,wParam,lParam);
  if Msg=wm_Paint then
  begin
    DC:=GetDC(Dlg);
    GetClientRect(Dlg,Rect);
    SelectObject(DC,GetStockObject(Black_Pen));
    MoveTo(DC,Rect.left,Rect.bottom-1);
    LineTo(DC,Rect.right,Rect.bottom-1);
    ReleaseDC(Dlg,DC);
  end;
end;
{$F-}

procedure RegisterBibDBClasses;
var
  Class: TWndClass;
begin
  with Class do
  begin
    Style        :=cs_HRedraw or cs_VRedraw;
    lpfnWndProc  :=@DefDlgProc;
    cbClsExtra   :=0;
    cbWndExtra   :=DlgWindowExtra;
    HCursor      :=LoadCursor(0,idc_Arrow);
    Hicon        :=MainIcon;
    hbrBackground:=HBrush(Color_Background+1);
    lpszMenuName :=PChar(rc_EditEntryMenu);
    lpszClassName:=BibDBEdWinClass;
    RegisteredClasses.Insert(StrNew(lpszClassName));
  end;
  Class.HInstance:=HInstance;
  RegisterClass(Class);
  
  with Class do
  begin
    Style        :=cs_HRedraw or cs_VRedraw;
    lpfnWndProc  :=@DefDlgProc;
    cbClsExtra   :=0;
    cbWndExtra   :=DlgWindowExtra;
    HCursor      :=LoadCursor(0,idc_Arrow);
    Hicon        :=MainIcon;
    hbrBackground:=HBrush(Color_Background+1);
    lpszMenuName :=PChar(rc_PatternMenu);
    lpszClassName:=BibDBEdPattClass;
    RegisteredClasses.Insert(StrNew(lpszClassName));
  end;
  Class.HInstance:=HInstance;
  RegisterClass(Class);
  {}
  With Class do
  begin
    Style        :=cs_HRedraw or cs_VRedraw;
{    lpfnWndProc  :=@DefDlgProc;}
    lpfnWndProc  :=@ToolbarDlgProc;
    cbClsExtra   :=0;
    cbWndExtra   :=DlgWindowExtra;
    HIcon        :=0;
    HCursor      :=CrossCursor;
    hBrBackground:=HBrush(Color_BtnFace+1);
    lpszMenuName :=Nil;
    lpszClassName:=BibDBToolbarClass;
    RegisteredClasses.Insert(StrNew(lpszClassName));
  end;
  Class.HInstance:=HInstance;
  RegisterClass(Class); 
end;                       { RegisterBibDBClasses }

procedure UnregisterBibDBClasses;
var
  i: integer;
begin
  for i:=0 to RegisteredClasses.Count-1 do 
    UnRegisterClass(RegisteredClasses.at(i), Hinstance);
  RegisteredClasses.Done;
end;

function SelectFont(Wnd: HWnd; FontInd: integer; effects: boolean): boolean;
var
  ChooseFontRec: TChooseFont;
  Styl: array[0..lf_FaceSize+10] of char;
  Lfnt: TLogFont;
begin
  SelectFont:=false;
{  GetMem(Styl,lf_FaceSize+4);}
  move(Fonts^[FontInd].Logfont,Lfnt,sizeof(TLogFont));
  with Fonts^[FontInd] do
    if Font<>0 then
    begin
      DeleteObject(Font); Initialized:=false; Height:=0;
    end;
  FillChar(ChooseFontRec, SizeOf(TChooseFont), 0);
  with ChooseFontRec do
  begin
    lStructSize:=sizeof(TChooseFont);
    hWndOwner:=HMainW;
    hDC:=0;
    iPointSize:=0;
    lpLogFont:=@Lfnt;
    Flags:=cf_InitToLogFontStruct or cf_ScreenFonts or cf_ForceFontExist;
    { Get around a Win95 bug (?) - check it later !!!!!!!!!!!!!!!!!! }
    if effects then Flags:=Flags or cf_Effects;
    lpszStyle:=@Styl;
    lpTemplateName:=Nil;
    rgbColors:=Fonts^[FontInd].Color;
    lCustData:=FontInd;
  end;
  ChooseFontRec.hInstance:=HInstance;
  if ChooseFont(ChooseFontRec) then
  with Fonts^[FontInd] do
  begin
    move(Lfnt,Logfont,sizeof(TLogFont));
    if Initialized then DeleteObject(Font);
    Font:=0;
    Color:=ChooseFontRec.rgbColors;
    Height:=0; Initialized:=false; Default:=false;
    PointSize:=ChooseFontRec.iPointSize;
    OptionsModified.WindowsParams:=true;
    SelectFont:=true;
  end;
{  FreeMem(Styl,lf_FaceSize+4);}
end;                               { SelectFont }

function SelectColor(Wnd: HWnd; var Clr: Longint): boolean;
var
  ChooseClr: TChooseColor;
  i        : Integer;
  CC: array[0..15] of LongInt;
begin
  if CustColors=Nil then
  begin
    New(CustColors);
    for i:=0 to 15 do
      CustColors^[i]:=i*$100000;
  end;
  Move(CustColors^,CC,sizeof(CC));
  SelectColor:=false;
  with ChooseClr do
  begin
    HWndOwner   := Wnd;
    lStructSize := Sizeof(TChooseColor);
    rgbResult   := Clr;
    lpCustColors:= @CC;
    Flags       := {cc_FullOpen or} cc_RGBInit;
  end;
  if ChooseColor(ChooseClr) then
  begin
    Clr := ChooseClr.RGBResult;
    Move(CC,CustColors^,sizeof(CC));
{    InvalidateRect(HMainW, nil, True);}
    OptionsModified.WindowsParams:=true;
    SelectColor:=true;
  end;
end;                           { SelectColor }

procedure GetAString(prompt: string; Var S: string; y0,maxlen,linelen: Byte;
                     exclude: CharSet; var accept: boolean; MarkText: boolean);
var
  Answer: Pchar;
begin
  GetMem(Answer,256);
  StrPCopy(Answer,S);
  accept:=false;
  if Application^.ExecDialog(New(PGetStringDlg,
    Init(MainW,PChar(rc_GotoNumberDlg),Prompt,Exclude,Answer,MarkText,maxlen)))
               =id_OK then
  begin
    S:=StrPas(Answer);
    accept:=true;
  end;
  FreeMem(Answer,256);
end;                     { GetAString }

procedure GetStringMode(prompt: string; Var S: string; y0,maxlen,linelen: Byte;
                        exclude: CharSet; var accept,CaseSen,RegExp: boolean;
                        MarkText: boolean);
var
  Answer: Pchar;
begin
  GetMem(Answer,256);
  StrPCopy(Answer,S);
  accept:=false;
  if Application^.ExecDialog(New(PGetStringModeDlg,
    Init(MainW,PChar(rc_StringModeDlg),Prompt,Exclude,Answer,
         @RegExp,@CaseSen,true,MarkText,maxlen,Nil,Nil,Nil)))=id_OK then
  begin
    S:=StrPas(Answer);
    accept:=true;
  end;
  FreeMem(Answer,256);
end;                    { GetStringMode }

procedure GetSearchString(prompt: string; var S: string;
                          exclude: CharSet; var modified, retain: boolean;
                          var CaseSen,RegExp: boolean;
                          var FieldStr: string; var UseFields,Negate: boolean);
var
  Answer: array[0..255] of char;
begin
  retain:=false; modified:=false;
  StrPCopy(Answer,S);
  if Application^.ExecDialog(New(PGetStringModeDlg,
    Init(MainW,PChar(rc_SearchStrDlg),Prompt,Exclude,Answer,
         @RegExp,@CaseSen,true,true,253,@FieldStr,@UseFields,@Negate)))=id_OK then
  begin
    S:=StrPas(Answer);
    Modified:=true;
    retain:=true;
  end;
end;                          { GetSearchString }

procedure UpdateExpFields;
var
  i: integer;
begin
  Application^.ExecDialog(New(PExpFieldsDlg,init(MainW,@DumpFields,
                          @DumpUndecFields,nil)));
  for i:=OrigFieldLast+1 to MaxField do DumpFields[i]:=DumpUndecFields;
end;

procedure WaitingMessage(s: string);
begin
  WinYieldCounter:=0;
  if (not AmWaiting) and (s='') then Exit;
  if S='' then
  begin
    StatusBar^.HideStatusMessage;
    SuspendedWaiting:=false; AmWaiting:=false;
    SetCursor(NonWaitingCursor);
  end else
  begin
    StatusBar^.PutStatusMessage(S);
    NonWaitingCursor:=SetCursor(WaitingCursor);
    AmWaiting:=true;
    AbortFlag:=false;
  end;
end;                                    { WaitingMessage }

procedure SuspendWaiting(suspend: boolean);
var
  Origin: pointer;
begin
  WinYieldCounter:=0;
  if not AmWaiting then Exit;
  if suspend and not SuspendedWaiting then
  begin
    StatusBar^.HideStatusMessage;
    SuspendedWaiting:=true;
    SetCursor(NonWaitingCursor);
  end else if SuspendedWaiting and not Suspend then
  begin
    StatusBar^.ShowStatusMessage;
    SuspendedWaiting:=false;
    SetCursor(WaitingCursor);
  end;
end;                             { SuspendWaiting }

procedure WaitingOff;
begin
  if AmWaiting then WaitingMessage('');
end;

procedure SearchingMessage;
begin
  if not AmWaiting then WaitingMessage('Searching...');
end;

Procedure Delay(ms : Word);
Var
  theend,marker: Longint;
Begin
{----Potential overflow if windows runs for 49 days without a stop}
  marker:=GetTickCount;
{$R-}
  theend:=Longint(marker+ms);
{$R+}
{----First see if timer overrun will occur and wait for it. Then test as
usual}
  If (theend<marker)
    Then While (GetTickCount>=0) DO;
  While (theend>GettickCount) Do;
End; {of Delay}

procedure CopyFieldToClip(parent: PWindowsObject; Entry: EntryRecPtr; fld: integer;
                          Shift,Ctrl: boolean; S: PString);
var
  F,OutBuf: PChar;
  H: THandle;
  l: word;
  tmp: string;
  Ex: boolean;
  Rec: ^ENameClickRec;
  FreeSize: word;
begin
  if (Entry=Nil) or (entry^.nentry=0) or ((fld>0) and (entry^.index[fld]=0)) then Exit;
  if fld>0 then Ex:=Shift;
  if fld<0 then
  begin
    if S=Nil then Exit;
    l:=length(S^);
    H:=GlobalAlloc(GHND,l+1);
    F:=GlobalLock(H);
    StrPCopy(F,S^);
  end else with entry^ do
  begin
    if (fld<>0) and ((content[index[fld]]='') or (content[index[fld]]=#0)) then Exit;
    if fld=0 then      { Entry name }
    begin
      tmp:='';
      if S<>Nil then
      begin
        tmp:=S^;
        StrRepl(tmp,'#1',name,1,255,255);
      end else if not (Ctrl or Shift) then tmp:=name
      else begin
        if Ctrl and Shift then rec:=@NameClickCtrlShift
        else if Ctrl then rec:=@NameClickCtrl
        else rec:=@NameClickShift;
        if rec^.action=ENameClick_Copy then tmp:=name
        else if rec^.action=ENameClick_CopyEx then
        begin
          Application^.ExecDialog(New(PCopyToClipDlg,init(Parent,Entry,0)));
          Exit;
        end else if rec^.action=ENameClick_String then
        begin
          tmp:=rec^.S^;
          StrRepl(tmp,'#1',name,1,255,255);
        end;
      end;
      l:=length(tmp);
      H:=GlobalAlloc(GHND,l+1);
      F:=GlobalLock(H);
      StrPCopy(F,tmp);
    end else if Ex then
    begin
      Application^.ExecDialog(New(PCopyToClipDlg,init(Parent,Entry,fld)));
      Exit;
    end else
    begin
      OutBuf:=Nil; l:=0; FreeSize:=0;
      if ExpandMacros and (content[index[fld]][1]='@') then
      begin
        if BigIndex[fld]=0 then
          DecodeAbbrevs(content[index[fld]][2],length(content[index[fld]])-1,
                        OutBuf,l,FreeSize)
        else
          DecodeAbbrevs(Big[BigIndex[fld]]^[2],Blen[BigIndex[fld]]-1,
                        OutBuf,l,FreeSize);
      end else if BigIndex[fld]=0 then
      begin
        OutBuf:=@Content[index[fld]][1]; l:=length(Content[index[fld]]);
      end else
      begin
        OutBuf:=PChar(Big[BigIndex[fld]]); l:=Blen[BigIndex[fld]];
      end;
      H:=GlobalAlloc(GHND,l+1);
      F:=GlobalLock(H);
      if OutBuf<>Nil then Move(OutBuf^,F^,l);
      F[l]:=#0;
      if FreeSize>0 then FreeMem(OutBuf,FreeSize);
    end;
  end;
  GlobalUnlock(H);
  if OpenClipboard(Parent^.HWindow) and EmptyClipboard
     and (SetClipboardData(cf_Text,H)<>0) then
  begin
    CloseClipboard;
    FlashWindow(Parent^.HWindow,true);
    Delay(30);
    FlashWindow(Parent^.HWindow,false);
  end else
  begin
    GlobalFree(H);
    ErrorMessageRC(Str_ClipboardAlreadyOpen,'');
  end;
end;                             { CopyFieldToClip }

procedure PutTextIntoEbox(F: PChar; EBox: PEdit);
begin
  EBox^.Clear;
  EBox^.SetText(F);
  EBox^.ClearModify;
end;

function CreateHelvFont(Bold: boolean; FontHeight: Pinteger): HFont;
var
  L: TLogFont;
  DC: hDC;
  OldFont: HFont;
  Metrics: TTextMetric;
  H: HWnd;
  Font: HFont;
begin
  CreateHelvFont:=0;
  if FontHeight<>Nil then FontHeight^:=0;

  FillChar(L,sizeof(L),0);
  with L do
  begin
    lfHeight        := -MulDiv(80,ScreenresY,720);
    if Bold then
      lfWeight      := fw_bold
    else
      lfWeight      := fw_Normal;
    lfCharSet       := Ansi_CharSet;
    lfOutPrecision  := Out_Default_Precis;
    lfClipPrecision := Clip_Default_Precis;
    lfQuality       := Default_Quality;
    lfPitchAndFamily:= Variable_Pitch or ff_Swiss;
    StrLCopy(@lfFaceName,'MS Sans Serif',lf_FaceSize-1);
  end;
  Font:=CreateFontIndirect(L);

  if Font<>0 then
  begin
    CreateHelvFont:=Font;
    if FontHeight<>Nil then
    begin
      H:=GetDesktopWindow;
      DC:=GetDC(H);
      OldFont:=SelectObject(DC,Font);
      GetTextMetrics(DC,Metrics);
      SelectObject(DC,OldFont);
      ReleaseDC(H,DC);
      FontHeight^:=Metrics.tmHeight;
    end;
  end;
end;                            { CreateHelvFont }

procedure DrawTabbedLBoxItem(P: PDrawItemStruct; Font: HFont; Tag: Boolean;
                             var TabStops; NTabs: integer; UseItemData: boolean);
type
  TTabStops = array[1..100] of integer;
  PTabStops = ^TTabStops;
var
  OldFont: HFont;
  OldBrush,BackBrush: HBrush;
  F,F1,F2: PChar;
  pl,ThisLen,X0,y0,TagHeight,CurPoint,CurTab: integer;
  Metrics: TTextMetric;
  Pen,OldPen: HPen;
  SavedDC: integer;
  Colorch: Char;
  Tabs: PTabStops;

function FindNextColor(P: PChar): PChar;
begin
  FindNextColor:=Nil;
  while (P^>#9) do inc(P);
  {if P<>#0 then }FindNextColor:=P;
end;

begin
  pl:=0; F:=Nil; X0:=TabbedLBox_XShift;
  Tabs:=@TabStops; CurTab:=0;
  with P^ do
  begin
    if integer(ItemID)<0 then Exit;
    SavedDC:=SaveDC(hDC);
    if ItemState and ods_Selected<>0 then
    begin
      BackBrush:=CreateSolidBrush(GetSysColor(color_HighLight));
      SetTextColor(hDC,GetSysColor(Color_HighlightText));
    end else
    begin
      BackBrush:=CreateSolidBrush(GetSysColor(color_Window));
      SetTextColor(hDC,GetSysColor(Color_WindowText));
    end;
    OldBrush:=SelectObject(hDC,BackBrush);
    FillRect(hDC,rcItem,BackBrush);
    SelectObject(hDC,OldBrush);
    DeleteObject(BackBrush);

    OldFont:=SelectObject(hDC,Font);

    if Tag then
    begin
      GetTextMetrics(hDC,Metrics);
      x0:=TabbedLBox_XShift;
      y0:=rcItem.Bottom-Metrics.tmDescent;
      TagHeight:=Metrics.tmAscent-Metrics.tmInternalLeading;
      if ItemData=1 then
      begin
        Pen:=CreatePen(ps_Solid,2,TagColor);
        OldPen:=SelectObject(hDC,Pen);
        MoveTo(hDC,x0+1,y0-1);
        LineTo(hDC,x0+TagHeight,y0-TagHeight);
        MoveTo(hDC,x0,y0-TagHeight);
        LineTo(hDC,x0+TagHeight,y0);
        SelectObject(hDC,OldPen);
        DeleteObject(Pen);
      end;
      x0:=x0+TagHeight+TabbedLBox_TagShift;
    end;

    SetBKMode(hDC,Transparent);
    if UseItemData then
    begin
      if F<>Nil then FreeMem(F,pl);
      pl:=StrLen(PChar(ItemData))+1;
      GetMem(F,pl); StrCopy(F,PChar(ItemData));
    end else
    begin
      ThisLen:=SendMessage(hWndItem,lb_GetTextLen,ItemID,0)+1;
      if ThisLen>pl then
      begin
        if F<>Nil then FreeMem(F,pl);
        pl:=ThisLen; GetMem(F,pl);
      end;
      SendMessage(hWndItem,lb_GetText,ItemID,longint(F));
    end;
    CurPoint:=x0;
    F1:=F;
    repeat
      F2:=FindNextColor(F1); ColorCh:=F2^; F2^:=#0;
      if F2<>F1 then
      begin
        TextOut(hDC,CurPoint,rcItem.Top,F1,F2-F1);
        CurPoint:=CurPoint+LoWord(GetTextExtent(hDC,F1,F2-F1));
      end;
      case ColorCH of
        #9: begin
              while (CurTab<NTabs) and (Tabs^[CurTab+1]+x0<CurPoint) do inc(CurTab);
              if CurTab<NTabs then inc(CurTab);
              if (CurTab<=NTabs) and (CurTab>0) and (Tabs^[CurTab]+x0>CurPoint)
                then CurPoint:=Tabs^[CurTab]+x0;
            end;
        TabbedLBox_Red:   SetTextColor(hDC,RGB(255,0,0));
        TabbedLBox_Green: SetTextColor(hDC,RGB(0,255,0));
        TabbedLBox_Blue:  SetTextColor(hDC,RGB(0,0,255));
        TabbedLBox_FilenameColor:   SetTextColor(hDC,FilenameColor);
        TabbedLBox_DupEntriesColor: SetTextColor(hDC,DupEntriesColor);
      end;
      if ColorCH<>#0 then F1:=F2+1;
    until ColorCH=#0;
{    F:=PTabbedLBoxItem(Lines^.at(ItemID))^.Line;}
{
    if F[0]=TabbedLBox_Red then    
    begin
      SetTextColor(hDC,RGB(255,0,0));
      TabbedTextOut(hDC,x0,rcItem.Top,F+1,StrLen(F)-1,NTabs,TabStops,0);
    end else TabbedTextOut(hDC,x0,rcItem.Top,F,StrLen(F),NTabs,TabStops,0);
    }
    SelectObject(hDC,OldFont);

    if ItemState and ods_Focus<>0 then DrawFocusRect(hDC,rcItem);
    RestoreDC(hDC,SavedDC);
  end;
  if (F<>Nil) then FreeMem(F,pl);
end;                          { DrawTabbedLBoxItem }

procedure InitwBibGUI;
var
  Desktop: HWnd;
  DC: hDC;
begin
  AmWaiting:=false; SuspendedWaiting:=false;
  NonWaitingCursor:=LoadCursor(0,idc_arrow);
  CurrentWindow:=Nil;
  RegisteredClasses.Init(4,10);
  DialogDepth:=0;
  Desktop:=GetDesktopWindow;
  DC:=GetDC(Desktop);
  ScreenResX:=GetDeviceCaps(DC,LogPixelsY);
  ScreenResY:=GetDeviceCaps(DC,LogPixelsY);
  ReleaseDC(Desktop,DC);
  GetClientRect(DeskTop,ScreenRect);
end;                              { InitwBibGUI }

begin
  InitwbibGUI;
  FindRepMsg:=RegisterWindowMessage('commdlg_FindReplace');
end.

