/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LCHuvKt;
import com.github.ajalt.colormath.model.LUVColorSpace;
import com.github.ajalt.colormath.model.LUVColorSpaces;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.XYZ;
import com.github.ajalt.colormath.model.XYZColorSpace;
import com.github.ajalt.colormath.model.XYZKt;
import com.github.ajalt.colormath.model.xyY;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0000H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0000H\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J;\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Lcom/github/ajalt/colormath/model/LUV;", "Lcom/github/ajalt/colormath/Color;", "l", "", "u", "v", "alpha", "space", "Lcom/github/ajalt/colormath/model/LUVColorSpace;", "<init>", "(FFFFLcom/github/ajalt/colormath/model/LUVColorSpace;)V", "getL", "()F", "getU", "getV", "getAlpha", "getSpace", "()Lcom/github/ajalt/colormath/model/LUVColorSpace;", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toXYZ", "Lcom/github/ajalt/colormath/model/XYZ;", "toLCHuv", "Lcom/github/ajalt/colormath/model/LCHuv;", "toLUV", "toArray", "", "clamp", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "colormath"})
@SourceDebugExtension(value={"SMAP\nLUV.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LUV.kt\ncom/github/ajalt/colormath/model/LUV\n+ 2 InternalMath.kt\ncom/github/ajalt/colormath/internal/InternalMathKt\n+ 3 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n*L\n1#1,110:1\n31#2,3:111\n89#3,12:114\n*S KotlinDebug\n*F\n+ 1 LUV.kt\ncom/github/ajalt/colormath/model/LUV\n*L\n104#1:111,3\n108#1:114,12\n*E\n"})
public final class LUV
implements Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float l;
    private final float u;
    private final float v;
    private final float alpha;
    @NotNull
    private final LUVColorSpace space;

    public LUV(float l, float u, float v, float alpha, @NotNull LUVColorSpace space) {
        Intrinsics.checkNotNullParameter(space, "space");
        this.l = l;
        this.u = u;
        this.v = v;
        this.alpha = alpha;
        this.space = space;
    }

    public final float getL() {
        return this.l;
    }

    public final float getU() {
        return this.u;
    }

    public final float getV() {
        return this.v;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @NotNull
    public LUVColorSpace getSpace() {
        return this.space;
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        return this.l == 0.0f ? RGB.Companion.invoke(0.0f, 0.0f, 0.0f, this.getAlpha()) : this.toXYZ().toSRGB();
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        XYZColorSpace xyzSpace = XYZKt.XYZColorSpace(this.getSpace().getWhitePoint());
        if (this.l == 0.0f) {
            return XYZColorSpace.DefaultImpls.invoke$default(xyzSpace, 0.0f, 0.0f, 0.0f, 0.0f, 8, null);
        }
        xyY wp = this.getSpace().getWhitePoint().getChromaticity();
        double denominator0 = (double)wp.getAbsoluteX() + 15.0 * (double)wp.getAbsoluteY() + 3.0 * (double)wp.getAbsoluteZ();
        double u0 = 4.0 * (double)wp.getAbsoluteX() / denominator0;
        double v0 = 9.0 * (double)wp.getAbsoluteY() / denominator0;
        double y = (double)this.l > 8.0 ? Math.pow(((double)this.l + 16.0) / 116.0, 3) : (double)this.l / 903.2962962962963;
        double a = ((double)((float)52 * this.l) / ((double)this.u + (double)((float)13 * this.l) * u0) - 1.0) / (double)3;
        double b = (double)-5 * y;
        double c = -0.3333333333333333;
        double d = y * ((double)((float)39 * this.l) / ((double)this.v + (double)((float)13 * this.l) * v0) - (double)5);
        double x = (d - b) / (a - c);
        double z = x * a + b;
        return xyzSpace.invoke(x, y, z, Float.valueOf(this.getAlpha()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LCHuv toLCHuv() {
        void h;
        void a$iv;
        float f = this.u;
        float b$iv = this.v;
        boolean $i$f$toPolarModel = false;
        float c$iv = (float)Math.sqrt((double)(a$iv * a$iv + b$iv * b$iv));
        float h$iv = (double)c$iv > -1.0E-7 && (double)c$iv < 1.0E-7 ? Float.NaN : InternalMathKt.radToDeg((float)Math.atan2(b$iv, (double)a$iv));
        float f2 = InternalMathKt.normalizeDeg(h$iv);
        float c = c$iv;
        boolean bl = false;
        return LCHuvKt.LCHuvColorSpace(this.getSpace().getWhitePoint()).invoke(this.l, c, (float)h, this.getAlpha());
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.l, this.u, this.v, this.getAlpha()};
        return fArray;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public LUV clamp() {
        void p3;
        void p2;
        void p1;
        Color color;
        void v3$iv;
        void v2$iv;
        void v1$iv;
        void $this$clamp3$iv;
        Color color2 = this;
        float f = this.l;
        float f2 = this.u;
        float f3 = this.v;
        float alpha$iv = this.getAlpha();
        boolean $i$f$clamp3 = false;
        List<ColorComponentInfo> list = $this$clamp3$iv.getSpace().getComponents();
        ColorComponentInfo c1$iv = list.get(0);
        ColorComponentInfo c2$iv = list.get(1);
        ColorComponentInfo c3$iv = list.get(2);
        float f4 = c1$iv.getMin();
        boolean bl = v1$iv <= c1$iv.getMax() ? f4 <= v1$iv : false;
        if (bl) {
            f4 = c2$iv.getMin();
            boolean bl2 = v2$iv <= c2$iv.getMax() ? f4 <= v2$iv : false;
            if (bl2) {
                f4 = c3$iv.getMin();
                boolean bl3 = v3$iv <= c3$iv.getMax() ? f4 <= v3$iv : false;
                if (bl3) {
                    boolean bl4 = 0.0f <= alpha$iv ? alpha$iv <= 1.0f : false;
                    if (bl4) {
                        color = $this$clamp3$iv;
                        return (LUV)color;
                    }
                }
            }
        }
        float f5 = RangesKt.coerceIn(alpha$iv, 0.0f, 1.0f);
        float f6 = RangesKt.coerceIn((float)v3$iv, c3$iv.getMin(), c3$iv.getMax());
        float f7 = RangesKt.coerceIn((float)v2$iv, c2$iv.getMin(), c2$iv.getMax());
        float p0 = RangesKt.coerceIn((float)v1$iv, c1$iv.getMin(), c1$iv.getMax());
        boolean bl5 = false;
        color = LUV.copy$default(this, p0, (float)p1, (float)p2, (float)p3, null, 16, null);
        return (LUV)color;
    }

    public final float component1() {
        return this.l;
    }

    public final float component2() {
        return this.u;
    }

    public final float component3() {
        return this.v;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final LUVColorSpace component5() {
        return this.space;
    }

    @NotNull
    public final LUV copy(float l, float u, float v, float alpha, @NotNull LUVColorSpace space) {
        Intrinsics.checkNotNullParameter(space, "space");
        return new LUV(l, u, v, alpha, space);
    }

    public static /* synthetic */ LUV copy$default(LUV lUV, float f, float f2, float f3, float f4, LUVColorSpace lUVColorSpace, int n, Object object) {
        if ((n & 1) != 0) {
            f = lUV.l;
        }
        if ((n & 2) != 0) {
            f2 = lUV.u;
        }
        if ((n & 4) != 0) {
            f3 = lUV.v;
        }
        if ((n & 8) != 0) {
            f4 = lUV.alpha;
        }
        if ((n & 0x10) != 0) {
            lUVColorSpace = lUV.space;
        }
        return lUV.copy(f, f2, f3, f4, lUVColorSpace);
    }

    @NotNull
    public String toString() {
        return "LUV(l=" + this.l + ", u=" + this.u + ", v=" + this.v + ", alpha=" + this.alpha + ", space=" + this.space + ')';
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.l);
        result2 = result2 * 31 + Float.hashCode(this.u);
        result2 = result2 * 31 + Float.hashCode(this.v);
        result2 = result2 * 31 + Float.hashCode(this.alpha);
        result2 = result2 * 31 + this.space.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LUV)) {
            return false;
        }
        LUV lUV = (LUV)other;
        if (Float.compare(this.l, lUV.l) != 0) {
            return false;
        }
        if (Float.compare(this.u, lUV.u) != 0) {
            return false;
        }
        if (Float.compare(this.v, lUV.v) != 0) {
            return false;
        }
        if (Float.compare(this.alpha, lUV.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual(this.space, lUV.space);
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return Color.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return Color.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return Color.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return Color.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return Color.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return Color.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return Color.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return Color.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return Color.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return Color.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return Color.DefaultImpls.toHPLuv(this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0001J\u0011\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J)\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0096\u0003J)\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0096\u0003R\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0005R\t\u0010\u001a\u001a\u00020\u001bX\u0096\u0005R\t\u0010\u001c\u001a\u00020\u001dX\u0096\u0005\u00a8\u0006\u001e"}, d2={"Lcom/github/ajalt/colormath/model/LUV$Companion;", "Lcom/github/ajalt/colormath/model/LUVColorSpace;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "convert", "Lcom/github/ajalt/colormath/model/LUV;", "color", "Lcom/github/ajalt/colormath/Color;", "create", "components", "", "invoke", "l", "", "u", "v", "alpha", "", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "name", "", "whitePoint", "Lcom/github/ajalt/colormath/WhitePoint;", "colormath"})
    public static final class Companion
    implements LUVColorSpace {
        private final /* synthetic */ LUVColorSpace $$delegate_0;

        private Companion() {
            this.$$delegate_0 = LUVColorSpaces.INSTANCE.getLUV65();
        }

        @Override
        @NotNull
        public LUV invoke(float l, float u, float v, float alpha) {
            return this.$$delegate_0.invoke(l, u, v, alpha);
        }

        @Override
        @NotNull
        public LUV invoke(@NotNull Number l, @NotNull Number u, @NotNull Number v, @NotNull Number alpha) {
            Intrinsics.checkNotNullParameter(l, "l");
            Intrinsics.checkNotNullParameter(u, "u");
            Intrinsics.checkNotNullParameter(v, "v");
            Intrinsics.checkNotNullParameter(alpha, "alpha");
            return this.$$delegate_0.invoke(l, u, v, alpha);
        }

        @Override
        @NotNull
        public LUV convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return (LUV)this.$$delegate_0.convert(color);
        }

        @Override
        @NotNull
        public LUV create(@NotNull float[] components) {
            Intrinsics.checkNotNullParameter(components, "components");
            return (LUV)this.$$delegate_0.create(components);
        }

        @Override
        @NotNull
        public WhitePoint getWhitePoint() {
            return this.$$delegate_0.getWhitePoint();
        }

        @Override
        @NotNull
        public String getName() {
            return this.$$delegate_0.getName();
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return this.$$delegate_0.getComponents();
        }

        public boolean equals(@Nullable Object other) {
            return Intrinsics.areEqual(LUVColorSpaces.INSTANCE.getLUV65(), other);
        }

        public int hashCode() {
            return LUVColorSpaces.INSTANCE.getLUV65().hashCode();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

