/* common.h - Common Definitions for C4P
   Time-stamp: "97/01/03 17:42:15 mik"

   Copyright (C) 1991, 92, 93, 94, 95, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#if ! defined (COMMON_H)
#define COMMON_H

#define BUF_SIZE 8192
#define CHAR_POOL_SIZE 10000
#define TYPE_TABLE_SIZE 10000
#define HASH_PRIME 211
#define MAX_SYMBOLS 2000
#define MAX_BOUNDS 100
#define MAX_FAST_VARS 30

#define MAX_ARGS 5
#define MAX_ARG_LEN 64
#define MAX_CMD_LEN 128

typedef unsigned long DWORD;
typedef unsigned short WORD;

typedef union
{
  long ivalue;
  double fvalue;
} value_t;

typedef WORD SYMBOL_PTR;
typedef WORD STRING_PTR;

typedef struct SYMBOL
{
  unsigned s_kind;
  SYMBOL_PTR s_key;
  const char *s_repr;
  unsigned s_type;
  void *s_type_ptr;
  unsigned s_block_level;
  value_t s_value;
  const char *s_translated_type;
  SYMBOL_PTR s_next;
  unsigned s_flags;

#define S_BY_REFERENCE 0x0001
#define S_FAST 0x0002
} symbol_t;

#define C_FILE_NUM 0
#define H_FILE_NUM 1
#define NO_MARK 12345

#define UNKNOWN_TYPE 0
#define INTEGER_TYPE 1
#define BOOLEAN_TYPE 2
#define CHARACTER_TYPE 3
#define REAL_TYPE 4
#define LONG_REAL_TYPE 5
#define SUBRANGE_NODE 11
#define ARRAY_NODE 21
#define RECORD_NODE 22
#define STRING_TYPE 23
#define NAMED_TYPE_NODE 101
#define FUNCTION_TYPE 102
#define FIELD_LIST_NODE 1001
#define VARIANT_FIELD_LIST_NODE 1002
#define RECORD_SECTION_NODE 1003
#define VARIANT_NODE 1004
#define DECLARATOR_NODE 1005
#define PARAMETER_NODE 1006
#define PROTOTYPE_NODE 1007
#define FILE_NODE 1008

typedef struct
{
  unsigned type;
  void *type_ptr;
} file_node;

typedef struct DCL_STRUCT
{
  symbol_t *name;
  struct DCL_STRUCT *next;
} declarator_node;

typedef struct PAR_STRUCT
{
  const char *name;
  symbol_t *type_symbol;
  int by_reference;
  struct PAR_STRUCT *next;
} parameter_node;

typedef struct
{
  symbol_t *name;
  parameter_node *formal_parameter;
  symbol_t *result_type;
} prototype_node;

typedef struct
{
  symbol_t *name;
} named_type_node;

typedef struct
{
  unsigned component_type;
  void *component_type_ptr;
  long lower_bound;
  long upper_bound;
} array_node;

typedef struct
{
  long lower_bound;
  long upper_bound;
} subrange_node;

typedef struct RS_STRUCT
{
  declarator_node *name;
  unsigned type;
  void *type_ptr;
  struct RS_STRUCT *next;
} record_section_node;

typedef struct
{
  symbol_t *pseudo_name;
  struct VFL_STRUCT *variant_field_list; /* variant field list */
} variant_node;

typedef struct VFL_STRUCT
{
  symbol_t *pseudo_name;
  record_section_node *fixed_part;
  variant_node *variant_part;
  struct VFL_STRUCT *next;
} variant_field_list_node;

typedef struct
{
  record_section_node *fixed_part;
  variant_node *variant_part;
} field_list_node;

typedef struct
{
  field_list_node *field_list;
} record_node;

void c4p_error (const char *, ...);
void c4p_warning (const char *, ...);

char *strcpye (char *, const char *);

void *new_type_node (unsigned, ...);
void declare_var_list (declarator_node *, unsigned, unsigned,
		       unsigned, void *);
void define_type (symbol_t *, unsigned, unsigned, void *);
unsigned translate_field_name (const char *, record_node *, void **);
void generate_routine_head (prototype_node *);
void mark_type_table (void);
void unmark_type_table (void);
unsigned coerce (unsigned, unsigned);

void open_name_file (void);
void close_name_file (void);
void begin_routine (prototype_node *, unsigned);
void end_routine (unsigned);
void add_loner (const char *);
void begin_new_c_file (const char *, int);
void open_header_file (void);

void symtab_init (void);
void new_mapping (const char *, const char *);
symbol_t *new_symbol_instance (const char *);
symbol_t *lookup (const char *);
void mark_symbol_table (void);
void mark_string_table (void);
void unmark_symbol_table (void);
void unmark_string_table (void);
STRING_PTR new_string (const char *s);
const char *get_string (STRING_PTR);
symbol_t *new_pseudo_symbol (void);
symbol_t *define_symbol (symbol_t *, unsigned, unsigned, unsigned, void *,
			 value_t *);
int is_fast_var (const char *);
void new_fast_var (const char *);

const char *subrange (long, long);

void open_file (unsigned, const char *);
void close_file (unsigned);
void reopen_file (unsigned, const char *);
void out_form (const char *, ...);
void out_s (const char *);
void out_stop (void);
void out_resume (void);
void redir_file (int);
void translate_char (int);
void translate_string (const char *);
void declare_fast_var_macro (unsigned);

char *get_buf_text (char *, unsigned, unsigned);
unsigned get_buf_mark (void);
void out_buf_over (unsigned, const char *, unsigned);

extern unsigned curly_brace_level;
extern unsigned extra_indent;
extern unsigned c_file_line_count;
extern unsigned max_lines_per_c_file;
extern char *pascal_file_name;
extern char *c_file_name;
extern int one_c_file;
extern int macroizing;
extern int n_fast_vars;

#endif /* COMMON_H */
