// Copyright (c) 1991 by Parag Patel.  All Rights Reserved.
// $Header: darray.h,v 1.3 91/02/22 15:59:22 hmgr Exp $

// Handle simple dynamic arrays of arbitrary type and range.
// They are automatically grown to fit any array-like reference.
// by Parag Patel

#ifndef __DARRAY_H_
#define __DARRAY_H_


// this is used to create an ARRAY of a TYPE
#define declare_array(ARRAY, TYPE) \
class ARRAY \
{ \
	long len; \
	long max; \
	TYPE *arr; \
	TYPE &bumpsize(long); \
public: \
	ARRAY() { arr = 0; max = len = 0; } \
	ARRAY(long siz) \
		{ arr = 0; max = len = 0; if (siz > 0) bumpsize(siz-1); } \
	ARRAY(const ARRAY &); \
	~ARRAY() { delete[max] arr; } \
	ARRAY &operator=(const ARRAY &); \
	long size() const { return len; } \
	void reset(long l = 0) { bumpsize(l); len = l; } \
	TYPE &operator[](long e) \
		{ if (e < len) return arr[e]; else return bumpsize(e); } \
};

// this implements an ARRAY of a TYPE
#define implement_array(ARRAY, TYPE) \
TYPE &ARRAY::bumpsize(long elt) \
{ \
	if (elt < 0) \
	    elt = 0; \
	if (elt >= max) \
	{ \
		long omax = max; \
		if (max <= 0) \
			max = 1; \
		TYPE *narr = new TYPE[max = elt + (max > 1024 ? 1024 : max)]; \
		for (long i = 0; i < len; i++) \
			narr[i] = arr[i]; \
		delete[omax] arr; \
		arr = narr; \
	} \
	if (elt >= len) \
		len = elt + 1; \
	return arr[elt]; \
} \
ARRAY &ARRAY::operator=(const ARRAY &a) \
{ \
	if (&a == this) \
	    return *this; \
	if (a.len > len) \
		bumpsize(a.len); \
	len = a.len; \
	for (long i = 0; i < len; i++) \
		arr[i] = a.arr[i]; \
	return *this; \
} \
ARRAY::ARRAY(const ARRAY &t) \
{ \
	arr = 0; \
	max = len = 0; \
	*this = t; \
}

#endif /* __DARRAY_H_ */
