.TH SPACEVPL 1 "VPLUtils Release @RELEASE@"
.SH NAME
spacevpl \- alter character dimensions and shifts in TeX's PL and VPL fonts
.SH SYNOPSIS
.B spacevpl
[
.B \-quiet
] [
.B \-range
.I range
] [
.B \-wd
.I expr
] [
.B \-ht
.I expr
] [
.B \-dp
.I expr
] [
.B \-ic
.I expr
] [
.B \-hs
.I expr
] [
.B \-vs
.I expr
]
.I font
.SH DESCRIPTION
.I Spacevpl
alters the dimensions of characters in a property list (PL) or virtual
property list (VPL) file.
.PP
The options
.B \-wd, \-ht, \-dp, \-ic, \-hs
and
.B \-vs
are used to specify how the character width, height, depth, italic correction,
horizontal shift, and vertical shift are altered. The
.I expr
argument to these options is an arithmetic expression, which may include
numeric constants (given in points) and any of
.I  wd, ht, dp, ic, hs
and
.I vs
to specify the original values of the character dimensions, or
.I ds
to specify the design size of the font. These operands are combined with the
operators
.I \-, *, /, +.
Sub-expressions may be enclosed in parentheses.
.PP
The
.B \-range
option specifies the range of characters which are modified. The range is a
comma separated list of numbers or subranges of the form
.I low\-high.
If
.I low
and/or
.I high
are omitted, the subrange is unbounded at the appropriate end(s).
.PP
Normally
.I spacevpl
informs you about what it is doing; the
.B \-quiet
option prevents this behaviour.
.SH EXAMPLES
To create adjust a normal italic font so that it is more appropriate for maths
typesetting, add the italic correction onto the character width, and remove
the italic correction. Extra left and right sidebearings is applied too:
.sp
.ce
spacevpl -wd 'ic+wd+.15*ds' -ic 0 -hs '0.02*ds' in.pl >out.vpl
.sp
.SH AUTHOR
Angus Duggan
.SH "SEE ALSO"
@MAN@, vftovp(1), vptovf(1), tftopl(1), afm2tfm(1)
.SH BUGS
.I Spacevpl
is slow.
