/*
 * Master configuration file for C versions of TeX and Metafont
 *
 * Tim Morgan  2/13/88
 *	Last updated 7/1/88
 * Updates by "svb."
 */

/*
 * Default editor command string: %d expands to the line number where
 * TeX or Metafont found an error and %s expands to the name of the file.
 */
#define	EDITOR		"/usr/ucb/vi +%d %s"

/*
 * If the type "int" is at least 32 bits (including a sign bit), this
 * symbol should be #undef'd; otherwise, it should be #define'd.  If
 * your compiler uses 16-bit int's, arrays larger than 32kb may give
 * you problems, especially if indices are automatically cast to int's.
 */
#undef	SIXTEENBIT

/*
 * Our character set is 7-bit ASCII unless NONASCII is defined.
 * For other character sets, make sure that first_text_char and
 * last_text_char are defined correctly in TeX (they're 0 and 127,
 * respectively, by default).  In the file tex.defines, change
 * the indicated range of type "char" to be the same as
 * first_text_char..last_text_char, re-tangle, and "#define NONASCII".
 */
#undef	NONASCII

/* Define if we're running under System V */
#undef	SYSV

/* Define if we're running under 4.2 or 4.3 BSD */
#define	BSD

/*
 * The type "schar" should be defined here to be the smallest signed
 * type available.  ANSI C compilers may need to use "signed char".
 * If you don't have signed characters, then use "short".
 */
typedef	char schar;

/*
 * The type "integer" must be a signed integer capable of holding at
 * least the range of numbers (-2^31)..(2^32-1).
 * The ANSI draft C standard says that "long" meets this requirement.
 */
typedef long integer;

/* Boolean can by any convenient type */
typedef char boolean;

/*
 * The type glueratio should be a floating-point type which won't
 * unnecessarily increase the size of the memoryword structure.
 * If you're building a normal-sized TeX, then it must meet
 * the following restriction: sizeof(glueratio) <= sizeof(integer).
 * But if you build a BIG TeX, you can and should change this to
 * double to avoid loss of precision and conversions to and from
 * double during calculations.
 */
typedef float glueratio;

/* Real can by any convenient floating-point type */
typedef double real;

/* TeX search paths. */
#define	TEXINPUTS	".:/usr/local/lib/tex/input"
#define	TEXFONTS	".:/usr/local/lib/fonts"
#define	TEXPOOL		".:/usr/local/lib/tex/pool"
#define	TEXFORMATS	".:/usr/local/lib/tex"

/* Metafont search paths. */
#define	MFINPUTS	".:/usr/local/lib/mf84"
#define	MFBASES		".:/usr/local/lib/mf84/bases"
#define	MFPOOL		".:/usr/local/lib/mf84"

/* BibTeX search path for .bib files */
#define	BIBINPUTS	".:/usr/local/lib/tex"
/* NB: TEXINPUTS is used by BibTeX to search for .bst files */

/*
 * Metafont Window Support: More than one may be defined, as long
 * as you don't try to have X10 and X11 support in the same binary
 * (because there are conflicting routine names in the libraries).
 */
#undef	SUNWIN			/* SunWindows support */
#undef	X10WIN			/* X Version 10 support */
#undef	X11WIN			/* X Version 11 support */
#undef	HP2627WIN		/* HP 2627 support */
#undef	TEKTRONIXWIN		/* Tektronix 4014 support */

/* NB: You can't define X10WIN and X11WIN simultaneously */
#if defined(X10WIN) && defined(X11WIN)
syntax error
#endif

/*
 * The maximum length of a filename including a directory specifier.
 * This value is also defined in the change files for tex and mf, so
 * it appears in texd.h and mfd.h as "filenamesize".  It can be safely
 * changed in these files if necessary, although you should really edit
 * the files tex/ctex.ch and mf/cmf.ch.  Most sites should not have to
 * change this value anyway, since it doesn't hurt much if it's too large.
 * If you change it here, then change it in both the changefiles to match!
 */
#define	FILENAMESIZE	1024

/*
 * Define the variable REGFIX if you want TeX to be compiled with local
 * variables declared as "register".  On SunOS 3.2 this will cause
 * problems, and possibly with other C compilers as well, so if you have
 * problems with the trip test, try #undef'ing it.
 */
#define	REGFIX
