/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


#include <stdio.h>
#include "defs.h"
#include "char.h"
#include "pdr.h"
#include "extfil.h"

extern char * TeXMacroDefs;
extern CAFM AfmChar[1];
extern int MaxCharCode;

/* The first parameter of the TeXMacroDefs command */
int TeXMacroDefsControl;

/*
 * WriteTeXMacros
 * **************
 * Write TeX macro definitions for all those characters, for which
 * we assigned the character code, because that character code
 * in the AFM file was -1. If the file name, under which those
 * definitions are to be stored, is empty, then this procedure will
 * do nothing.
 */
WriteTeXMacros()
{
  int i;
  EX_FILES ef;

  /* TeXMacroDefsControl==1 when this routine is called. */

  if (TeXMacroDefs == NULL)
    return;
  FExOpen(&ef, EFT_WRITE, 0, TeXMacroDefs, NULL);
  for (i=0; i<=MaxCharCode; i++) {
    if (AfmChar[i].c_used) {
      switch (AfmChar[i].c_type) {
      case CT_AFM:
	  if (TeXMacroDefsControl == 1)
	    fprintf (EX_FP(ef), "\\def\\X%s{\\char'%o }\n", AfmChar[i].c_string, i);
	  break;
        case CT_ASS:
	  fprintf (EX_FP(ef), "\\def\\X%s{\\char'%o }\n", AfmChar[i].c_string, i);
	  break;
        case CT_EXECPS:
	  break;
	case CT_WIDTH_ONLY:
	  break;
	default:
	  Fatal ("WriteTeXMacros(): default.");
	}
    }
  }
  FExClose (&ef);
}
