/* Copyright information can be found in file "Copyright" */

/************************************************************************/
/* pfd-2.y                                                               */
/************************************************************************/

%type <d> Number

%%      /* Rules Section */

program:	Start Rules  End 
;	

Start:          K_StartPfd T_SEMICOLON
;

Rules:  	|
                Rules Rule
;

Rule:  
                BaseFont |
		CharWidth |
                Comment |
                DesignSize |
		EmulateFont |
                EncodingClass |
                ExcludeChars |
                ExecPsCode |
                ExtraSpace |
  		FontDimen |
                HRatio |
                InvisibleSlitexFont |
                KPX |
                Ligature |
		MapChars |
                MaxCharCode |
                MonoCase |
                NoAfmKernings |
                NoAfmLigatures |
                OutlineFactor |
                Quad |
                Shrink |
                Slant |
                Space |
                Stretch |
                TeXMacroDefs |
                TiltAngle |
                WidthDelta |
                XHeight
;

BaseFont:       K_BaseFontName T_STRING T_SEMICOLON
                {      BaseFontName = $2;
		       fprintf (stderr, "Basefont: %s\n", BaseFontName);
                }
;

CharWidth:	K_CharWidth T_ID	T_INT	T_SEMICOLON
		{ ChangeWidthPfd($2, $3);
		}
;

Comment:        K_Comment T_STRING T_SEMICOLON
;

DesignSize:     K_DesignSize Number T_ID T_SEMICOLON
                {
		  CompareStringError ($3, "pt",
				      "DesignSize: unit must be \"pt\"");
		  DesignSize = $2;
			
		}
;

EmulateFont:    K_EmulateFont T_STRING T_SEMICOLON
                {  EmulateFont ($2);
		}
;

EncodingClass:  K_EncodingClass T_INT T_SEMICOLON
                { if ($2 < -1 || $2 >= NEVS)
		    Fatal2 ("pfd-2.y:(): Encoding class out of range [0..%d] or -1",
			    NEVS - 1);
		  EncodingClass = $2;
		}

End:            K_EndPfd T_SEMICOLON
;

ExcludeChars:   K_ExcludeChar ExcludeCharList T_SEMICOLON
;

ExcludeCharList:  ExcludeChar 
                | ExcludeCharList T_COMMA ExcludeChar
;

ExcludeChar:    T_ID
                {
		  InsertKeyIntoHashTable (ExcludeCharHashTable, $1);
		}
              |
;

ExecPsCode:     K_ExecPsCode T_INT /* type */
                T_INT /* character code */
                T_INT T_INT T_INT  /* height, depth, width */
                T_STRING T_SEMICOLON
           {
		  CharExecPs($2, $3, $4, $5, $6, $7);
	   }

ExtraSpace:      K_ExtraSpace T_INT T_SEMICOLON
           {       ExtraSpace = $2;
	   }
;

FontDimen:      K_FontDimen T_INT T_INT T_SEMICOLON
                {  if ($2<=7 || $2 >22)
		     Fatal ("PfdYacc(): Fontdimen: index wrong");
		   FontDimenArray[$2] = $3;
		}
;

HRatio:         K_HRatio Number  T_SEMICOLON
                { HRatio = $2;
		  if (HRatio < 0.1 || HRatio > 10.0)
		    Fatal ("PfdYacc(): HRatio outside range [0.1...10]");
		}
;

InvisibleSlitexFont:      K_InvisibleSlitexFont T_SEMICOLON
                {
		  SlitexInvisible = TRUE;
		}
;

/*
 * A KPX command can be used to change the kerning as it
 * is defined in the .afm file, or it can simply add a new kerning
 */
KPX:            K_KPX  T_ID  T_ID  T_INT T_SEMICOLON
                { SaveKerningInfo ($2, $3, $4); }
;

Ligature:       K_Ligature T_ID T_ID T_ID T_SEMICOLON
                { SaveLigatureInfo ($2, $3, $4); }
;

MapChars:       K_MapChar MapCharList T_SEMICOLON
;

MapCharList:    MapChar
         |
                MapCharList T_COMMA MapChar
;

MapChar:        T_ID T_INT
                {
		  MapChar($1, $2);
		}
;

MaxCharCode:     K_MaxCharCode T_INT T_SEMICOLON
                {
		  MaxCharCode = $2;
		  if (MaxCharCode != 127 && MaxCharCode != 255)
		    Fatal ("MaxCharCode(): must be either 127 or 255");
		}

/* Not working yet: mono case PS fonts */
MonoCase:       K_MonoCase Number   T_SEMICOLON
                {      MonoCase = $2 ;
                }
;

NoAfmKernings: K_NoAfmKernings T_SEMICOLON
                {  UseAfmKernings = FALSE;
                }
;

NoAfmLigatures: K_NoAfmLigatures T_SEMICOLON
                {  UseAfmLigatures = FALSE;
                }
;

/* Not working yet: outline Postscript fonts. */
OutlineFactor:  K_OutlineFactor Number T_SEMICOLON
                {        OutlineFactor = $2 ;
 	        }
;

Quad:           K_Quad T_INT T_SEMICOLON
                {       Quad = $2;
		}
;

Shrink:         K_Shrink T_INT T_SEMICOLON
                {
		  Shrink = $2;
		}
;

Slant:          K_Slant T_INT T_SEMICOLON
                {
		  Slant = $2;
		}
;

Space:          K_Space T_INT T_SEMICOLON
                {
		  Space = $2;
		}
;

Stretch:        K_Stretch T_INT T_SEMICOLON
                {
		  Stretch = $2;
		}
;

TeXMacroDefs:  K_TeXMacroDefs T_INT T_STRING   T_SEMICOLON
                {
		  TeXMacroDefsControl = $2;
		  TeXMacroDefs = $3;
		  if (TeXMacroDefsControl < 0 || TeXMacroDefsControl > 1)
		    Fatal ("TeXMacroDefs command: 1st parameter out of range");
		}
;

TiltAngle:      K_TiltAngle Number  T_SEMICOLON
                {
		  TiltAngle = $2 ;
		}
;

WidthDelta:     K_WidthDelta Number T_SEMICOLON
                {
		  WidthDelta = $2 ;
		}
;

XHeight:        K_XHeight T_INT T_SEMICOLON
                {
		  XHeight = $2;
		}
;

/* Number: read in a floating point number or an integer, return
   floating pointer number (always) */
Number:         T_INT  { $$ = (double) $1; }
                |
                T_FLOAT  { $$ = $1; }
;
