/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


/* Handle all PS procedure characters here */

#include <stdio.h>
#include "defs.h"
#include "char.h"
#include "pdr.h"

extern void CheckCharCode();
extern CAFM AfmChar[MAX_CHAR_PS];
extern int Verbose;

/*
 * CharExecPs
 * **********
 * Handle characters here which execute PS code.
 *
 * type: type of PS procedure (right now there is only one type: type 0)
 * width, height, depth: size information
 * ps_code: pointer to the character string containing the PS code
 *        to be executed.
 */
CharExecPs (type, char_code, width, height, depth, ps_code)
     int type;
     int char_code;
     int width;
     int height;
     int depth;
     char * ps_code;
{
  if (Verbose > V_SOME)
    printf ("CharExecPs(): '%o\n", char_code);

#ifdef DEBUG
  fprintf (stderr, "ExecPsCode(): code = '%o (ht: %d, dp: %d, wd: %d)\n",
	   char_code, height, depth, width);
  fprintf (stderr, "-->%s<--\n", ps_code);
#endif
  CheckCharCode (char_code, "ExecPsCode()");
  if (type != 0)
    Fatal ("ExecPsCode(): type == 0 is the only legal type");
  if (AfmChar[char_code].c_used)
    Fatal2 ("ExecPsCode(): character code '%o already used", char_code);
  if (AfmChar[char_code].c_map)
    Fatal2 ("ExecPsCode(): character code '%o was marked for mapping",
	   char_code);
  AfmChar[char_code].c_used = TRUE;
  AfmChar[char_code].c_type = CT_EXECPS;
  AfmChar[char_code].c_execps_type = type;

  /*
   * Enter the dimensions. This does not quite make sense because
   * we don't use the concept of a bounding box. We enter the dimensions
   * in such a way that they come out right when written to the pdr
   * file.
   */
  AfmChar[char_code].c_wx = width;
  AfmChar[char_code].c_llx = 0;
  AfmChar[char_code].c_lly = depth;
  AfmChar[char_code].c_urx = width;
  AfmChar[char_code].c_ury = height;
  AfmChar[char_code].c_string = ps_code;
}
