/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


#include <stdio.h>
#include "defs.h"
#include "tfm.h"
#include "pdr.h"
#include "char.h"

extern CAFM AfmChar[MAX_CHAR_PS];

/* Name of the font being emulated. If this is NULL, no font
 * emulation is going on. */
char * EmulateFontName = NULL;

/*
 * EmulateFont
 * ***********
 * Handle emulating a font.
 *
 * name: the font, which emulates the BaseFont.
 */
void
EmulateFont(name)
     char *name;
{
  EmulateFontName = name;
}

/*
 * EmulateInit
 * ***********
 * Initialize handling the font emulation.
 */
void
EmulateInit()
{
  EmulateFontName = NULL;
}

/*
 * EnterTfmDataIntoAfmCharArray
 * ****************************
 * tfm: pointer to the data structure containing all the tfm
 *      file data.
 */
void
EnterTfmDataIntoAfmCharArray (tfm)
     TFM_S_P tfm;
{
  int code;
#ifdef	DEBUG
  fprintf (stderr, "\nCharacter Width relationship\n\n");
#endif

  for (code=tfm->tfm_bc; code<= tfm->tfm_ec; code++)	{
    if (tfm->tfm_c_def[code])	{
      /* Character is defined. */
      AfmChar[code].c_tfm = tfm->tfm_c_width[code];
      switch (AfmChar[code].c_type) {
	case CT_NONE:
	  AfmChar[code].c_type = CT_WIDTH_ONLY;
	  AfmChar[code].c_used = TRUE;
#ifdef DEBUG
	  fprintf (stderr, "%% '%o: CT_WIDTH_ONLY\n", code);
#endif
	  break;
        case CT_AFM:
        case CT_ASS:
	case CT_EXECPS:
	  break;
	case CT_WIDTH_ONLY:
	  Fatal ("ReadTfmFileInfo(): illegal CT_WIDTH_ONLY.");
	default:
	  Fatal ("ReadTfmFileInfo(): illegal CT_.");
      }
    }   /* fi */
  }	    /* for */
}
