/* Copyright 1990 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* System calls related functions. */

/* Includes. */
#include <stdio.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/file.h>
#include <sys/stat.h>

#if SYS_V == 1
#include <string.h>
#else
#include <strings.h>
#endif

#if SYS_V == 1
#define index  strchr
#define rindex strrchr
#endif

#define TRUE 1
#define FALSE 0

/* Externals. */
extern int FileBusinessVerbose;
extern char *ProgName;

/* Global variables. */

/* If SafeSystemCall is called, AND the executable's code file name
   is NOT an absolute path name, then it is checked, whether
   it's code resides in one of the following directories and if
   not, execution is refused. */
char *AcceptablePath[] = {
  "/usr/local/bin",
  "/bin",
  "/usr/bin",
  "/usr/ucb",
  NULL
  };


/*
 * SafeSystemCall
 * **************
 *
 * str: string to be used in a system call.
 * RET: the return status of the 'system' call executed.
 */
int
SafeSystemCall(str)
     char *str;
{
  char command[1024]; /* The full command including its arguments. */
  char executable[1024]; /* The executable only. */

  int ret; /* Return status. */

  if (Strlen(str) == 0 || Strlen(str) >= 1024)
    Fatal("SafeSystemCall(): illegal argument");

  /* First extract the executables file name. */
  sprintf (executable, "%s", str);
  NoDotDotInFileName(executable, "SafeSystemCall()");

  if (executable[0] == '/')
    /* Safe: absolute path name provided. */
    command[0] = command[0];
  else {
    /* Unsafe: no absolute path name provided. */
    fprintf (stderr, "UNSAFE: %s\n", str);
  }

  ret = system(str);
  if (ret != 0)
    fprintf (stderr, "%s: SafeSystemCall() of \"%s\", return status is %d (non-zero)",
	     ProgName, str, ret);
  return(ret);
}
