/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


/* Main program of the dvi to PostScript driver. */

/*
 * The following environment variables are used by this program:
 * TEXFONTS, TEXFONTS_DVI2PS, 
 * TEXFONTS_DVI2PS_GF, TEXFONTS_DVI2PS_PK, TEXFONTS_DVI2PS_PXL,
 * TEXFONTS_DVI2PS_PDR.
 */

#include <stdio.h>
#if SYS_V == 1
#include <string.h>
#else
#include <strings.h>
#endif
#include "defs.h"
#include "units.h"
#include "dvitps.h"
#include "extfil.h" 
#include "fontd.h"
#include "emit.h"

extern char *StrcpyAlloc();
extern void Usage();
extern void StartMessage();
extern void InitFontHandling();
extern void FontNewDviFile();
extern void SetTime();
extern void InitPaperFormats();
extern void SwitchPsOutput();
extern void PsInitialStuff();
extern void LoopThroughDviFiles();
extern void ClosePsOutput();
extern void PsEndSend();
extern void ReadDvitpsCap();
extern int DecodeArgs();
extern int Verbose;
extern char *tmpdir_default;
extern char *texfonts_default;
extern char *driver_ps_prologue_path; /* Default for PrologueFilesPath */
char * PrologueFilesPath; /* Search path for prologue files: this is the
			     path actually used, and it's different from the default,
			     if the -P option of the driver is used. */
extern char *PsDownLoadHashTable;
extern char *SetUpHashTable();
extern int PssColumn;
extern char *Argv[1];
extern int Argc;
extern int DviFileCounter;
extern int CountPages;
extern int UsualOrientation;
extern int ThisPagesOrientation;
extern int ValidCapabilities;
extern int FileBusinessVerbose;
extern char *PIX;

char *ProgName; /* Program's name. */

/* Information about FNT_DEF in dvi file. */
FE_P Fonts[MAX_FONTS]; /* List of pointers to the font info structures,
			  NULL if unused. */
int CurFontNumber; /* Currently valid font number. */
FE_P CurFontPointer; /* = Fonts[CurFontNumber] ; */

/* The current host's name. It's written to the PostScript file, for instance */
char HostName[STRSIZE] = "";

/* The following page counter is for printing page numbers on stderr
 * while processing a dvi file. */
int StderrOutputPageNumber;
int StderrOutputPageNumberMod; /* Modulo this value output starts on a new line. */

#ifdef POSITIONING_TESTING
/* All positioning information is written to this file. */
EX_FILES PositionFile;
#endif

/*
 * main
 * ****
 */
main(argc, argv)
     int argc;
     char *argv[];
{
  int ret_decode_args;

#ifdef POSITIONING_TESTING
  FExOpen (&PositionFile, EFT_WRITE_NO_STDOUT, "/dev/null", NULL, NULL);
#endif

  ProgName = argv[0];
  InitProgName (ProgName, tmpdir_default);
  SetTime(); /* Sets time driver was started up. */
  DvitpsCheckDefaults(); /* Check defaults */
  /* Read driver's capability files. This reading may fail (no error), or
     the -B option of the driver may specify a directory where the capability
     file is located. */
  ReadDvitpsCap();

  if (gethostname(HostName, STRSIZE) != 0) /* Get hostname. */
    Fatal ("main(): gethostname() failed.");

  InitPaperFormats(); /* Initialize paper formats. */
  CountPages = 0;

  /* The following setting will trigger the initialization of the PIX array. */
  PIX = NULL;

  PssColumn = 0;
  DviFileCounter = 0;

  FileBusinessVerbose = TRUE;
  FExInit();
  InitSignalHandling();

  /* Get path which determines where to look for prologue files; might
     be later overwritten by the -P option of the driver! */
  PrologueFilesPath = StrcpyAlloc(driver_ps_prologue_path);

  /* Read in all options. */
  ret_decode_args = DecodeArgs (argc, argv);

  /* Set up the capability stuff again.  Now there must be no error. */
  ReadDvitpsCap();
  if (ValidCapabilities)
    InitFontHandling(); /* This procedure contains the only "getenv()" calls.
			   Call must be made now so that any options determining
			   the font search path had a chance to set up everything. */

  /* Abort in case no dvi file is given. */
  if (ret_decode_args == Argc)
    Usage();

  /* We must have font capability information now! */
  if (! ValidCapabilities)
    Fatal ("main(): no valid font capability file found.");

  StderrOutputPageNumber = 0;
  switch(Verbose) {
    case V_QUIET:
      StderrOutputPageNumberMod = 1; /* ignored anyway. */
      break;
    case V_SOME:
      StderrOutputPageNumberMod = 10;
      break;
    case V_A_LOT:
      StderrOutputPageNumberMod = 5;
      break;
    default:
      Fatal ("main(): Verbose.");
  }
  ThisPagesOrientation = UsualOrientation;

  /* PS code generated starts here. */
  SwitchPsOutput(0);
  PsInitialStuff();

  StartMessage();

  PsDownLoadHashTable = SetUpHashTable (20, 0,
					"PostScript code prologue file hash table");

  LoopThroughDviFiles(ret_decode_args);

  /* Done */
  ClosePsOutput();
  PsEndSend();

  exit (0);
} /* main */
