/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* DEBUG_GF: print each single instruction from the .gf file. */

#include <stdio.h>
#include "defs.h"
#include "units.h"
#include "dvitps.h"
#include "extfil.h"
#include "fontd.h"
#include "gf-com.h"

extern char * GetBytes();
extern void PsDownLoad();
extern void OpenFontFileCached();
extern void WarningTfmVersusPxlWidth();
extern void HandleCheckSum();
extern int HConv;
extern FE_P CurFontPointer;

/*
 * ReadGfFileInfo()
 * ****************
 * Read in the postamble of a gf file and get this way the
 * offsets of all the characters to access the pixel patterns into this file.
 * This is the way the driver is "familiarized" with a particular font.
 */
void
ReadGfFileInfo()
{
  char * buffer;
  int post_start; /* Where the postamble starts. */
  int c;
  int cin; /* Character index. */
  CE_P ce;
  int i;
  int tfm; /* tfm width as read from the gf file. */
  int check_sum; /* The check sum as found in the gf file. */

  PsDownLoad ("pixel-fonts.pro", 0);
  OpenFontFileCached();

  /* Preamble. */
  if (NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 1) != GF_PRE)
    Fatal ("ReadGfFileInfo(): illegal preamble");
  if (NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 1) != GF_FILE_ID)
    Fatal ("ReadGfFileInfo(): illegal gf file id preamble");
  buffer = GetBytes (CurFontPointer->f_ex_file.ef_filep,
		     NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 1));

  /* Postamble now, go to the end, go backwards. */
  FExSeek(&(CurFontPointer->f_ex_file), -1, 2);
  while ((c=NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 1)) == 223)
    FExSeek (&(CurFontPointer->f_ex_file), -2, FSEEK_REL);
  FExSeek (&(CurFontPointer->f_ex_file), -6, FSEEK_REL);
  if (NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 1) != GF_POST_POST)
    Fatal ("ReadGfFileInfo(): could not find GF_POST_POST.");
  post_start = NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4);
  if (NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 1) != GF_FILE_ID)
    Fatal ("ReadGfFileInfo(): illegal gf id in postamble.");
  FExSeek (&(CurFontPointer->f_ex_file), post_start, FSEEK_ABS);
  if (NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 1) != GF_POST)
    Fatal ("ReadGfFileInfo(): did not find GF_POST.");
  NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4); /* p */
  NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4); /* ds */

  /* Check sum business. */
  check_sum = NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 4);
  switch (CurFontPointer->f_class) {
    case FOCLASS_AS_REQUESTED:
      HandleCheckSum (check_sum);
      break;
    case FOCLASS_REPLACEMENT_FONT:
      /* Note that when a replacement font is used the checksum as found in
	 the dvi file has no relevancy. */
      CurFontPointer->f_c = check_sum;
      break;
    default:
      Fatal ("ReadGfFileInfo(): FOCLASS_ illegal.");
    }
  
  NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4); /* hppp */
  NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4); /* vppp */
  NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4); /* min_m */
  NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4); /* max_m */
  NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4); /* min_n */
  NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4); /* max_n */

  /* No characters downloaded, initialize. */
  for (i=0; i<256; i++)
    CurFontPointer->f_ch[i].c_dl = FALSE;

  /* Read in the font directory. */
  /* In a loop read the font directory of the .gf file. */
  while (((c=NoSignExtend(CurFontPointer->f_ex_file.ef_filep, 1)) == GF_CHAR_LOC0) ||
          (c==GF_CHAR_LOC)) {
    switch (c) {
      case GF_CHAR_LOC:
        cin = NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 1);
	ce = &(CurFontPointer->f_ch[cin]);
	if (ce->c_dl)
	  Fatal ("ReadGfFileInfo(): GF_CHAR_LOC: Double definition");
#ifdef DEBUG
	fprintf (stderr, "%% GF_CHAR_LOC: %d\n", cin);
#endif
	ce->c_rw = (DVIU) (CurFontPointer->f_s *
	  FIXES_TO_FLOAT(NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4)));/* dx*/
	NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4); /* dy */
	/* Read tfm width from .gf file. */
	tfm = NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4); /* w */
	switch (CurFontPointer->f_class) {
	  case FOCLASS_AS_REQUESTED:
	    ce->c_w_tfm = (DVIU) (CurFontPointer->f_s * FIXES_TO_FLOAT(tfm));
	    WarningTfmVersusPxlWidth(cin, ce);
	    break;
	  case FOCLASS_REPLACEMENT_FONT:
	    /* In case of a replacement font the tfm width to be used is already
	       loaded (from the font which was supposed to be used originally.)
	       Now we convert from tfm units to DVIUs. */
	    ce->c_w_tfm = (DVIU) (CurFontPointer->f_s * FIXES_TO_FLOAT(ce->c_w_tfm));
	    break;
	  }
	/* Get the character pattern's offset. */
	ce->c_offset = NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4); /* p */
#ifdef DEBUG_GF
	fprintf (stderr, "%% GF_CHAR_LOC: '%o, offset = %d\n",
		 cin, ce->c_offset);
#endif
        break;

      case GF_CHAR_LOC0:
	cin = NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 1);
	ce = &(CurFontPointer->f_ch[cin]);
	if (ce->c_dl)
	  Fatal ("ReadGfFileInfo(): GF_CHAR_LOC0: Double definition");
	ce->c_rw = HConv*NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 1);/* dm */
	ce->c_w_tfm = (DVIU) (CurFontPointer->f_s *
	  FIXES_TO_FLOAT(NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4)));/* w */
	WarningTfmVersusPxlWidth(cin, ce);
	ce->c_offset = NoSignExtend (CurFontPointer->f_ex_file.ef_filep, 4); /* p */
#ifdef DEBUG_GF
	fprintf (stderr, "%% GF_CHAR_LOC0: '%o, offset = %d\n",
		 cin, ce->c_offset);
#endif
	break;
      } /* switch */
  } /* while */
  if (c != GF_POST_POST)
    Fatal ("ReadGfFileInfo(): No GF_POST_POST after charlocs");
#ifdef DEBUG
  fprintf (stderr, "%% GF Info: %s\n", buffer);
#endif
}
