
/*
 * Copyright 1996 Juhana Kouhia (kouhia@nic.funet.fi)
 *
 * text2tex -- text-to-TeX formatter
 * version 1.0
 *
 * Usages:
 *   cat in.txt | text2tex > out.tex
 *   text2tex in.txt > out.tex
 *   text2tex in.txt out.tex
 * Hint:
 *   Use pstops of psutils for further formatting
 */

#include <stdio.h>
#include <math.h>

main(ac,av)
int ac;
char **av;
{
  FILE *in,*out;
  int c,f;

  if (ac == 1) {
    in = stdin;
    out = stdout;
  } else if (ac == 2) {
    if ((in = fopen(av[1],"r")) == NULL) {
      fprintf(stderr,"Could not open file %s for reading\n",av[1]);
      exit(-1);
    }
    out = stdout;
  } else if (ac == 3) {
    if ((in = fopen(av[1],"r")) == NULL) {
      fprintf(stderr,"Could not open file %s for reading\n",av[1]);
      exit(-1);
    }
    if ((out = fopen(av[2],"w")) == NULL) {
      fprintf(stderr,"Could not open file %s for writing\n",av[2]);
      exit(-1);
    }
  }

  fprintf(out,"\\parindent=0pt\n");
  fprintf(out,"\\tt\n\n");
  while((c = getc(in)) != EOF) {
    if (c == '\n') {
      fprintf(out,"\n\n");
      c = getc(in);
      if (c == '\n') fprintf(out,"\\hbox{ }\n\n");
      ungetc(c,in);
    } else if (c == '\\') {
      fprintf(out,"\\char'134");
    } else if (c == '{') {
      fprintf(out,"\\char'173");
    } else if (c == '}') {
      fprintf(out,"\\char'175");
    } else if (c == '_') {
      fprintf(out,"\\_");
    } else if (c == '^') {
      fprintf(out,"\\^{}");
    } else if (c == '$') {
      fprintf(out,"\\$");
    } else if (c == '%') {
      fprintf(out,"\\%%");
    } else if (c == '~') {
      fprintf(out,"\\~{}");
    } else if (c == '#') {
      fprintf(out,"\\#{}");
    } else if (c == '&') {
      fprintf(out,"\\&{}");
    } else if (c == ' ') {
      fprintf(out,"\\ ");
/*      c = getc(in);
      if (c == '\n') fprintf(out,"%%");
      ungetc(c,in);
*/    } else {
      fprintf(out,"%c",c);
    }
  }
  fprintf(out,"\n\\bye\n");
}
