.TH PKTYPE 1 8/8/90
.SH NAME
pktype - translate a packed font file for humans to read
.SH SYNTAX
.B pktype
pk_file_name [output_file_name]
.SH DESCRIPTION
The
.I pktype
program translates a packed font file (PK) (output by, for example,
.BR gftopk (1)
to a file that humans can read. It also serves as a PK
file-validating program (i.e., if
.I pktype
can read it, it's correct) and as an example of a PK-reading
program for other software that wants to read PK files.
.PP
The
.I pk_file_name
on the command line must be complete. Because
the resolution is part of the extension, it would not make
sense to add on a default extension as is done with TeX or
DVI-reading software. If no
.I output_file_name
is specified, the
output goes to the 
.IR stdout .
.PP
The output file gives a compact encoding of the packed encoding, using
conventions described in the source code. Run lengths of black pixels
alternate with parenthesized run lengths of white pixels, and brackets
are used to indicate when a row should be repeated.
.SH "ENVIRONMENT VARIABLES"
.I pktype
uses the environment variable PKFONTS to search for the PK file.  If
PKFONTS is not set, it uses the variable TEXFONTS.  If TEXFONTS is not
set, it uses the system default: 
.BR @TEXFONTS@ .
See
.BR tex (1)
for the details of the searching.
.SH "SEE ALSO"
dvitype(1), gftopk(1), gftype(1)
.br
Donald Knuth et al.,
.I METAFONTware
.SH AUTHORS
Tomas Rokicki wrote the program, and Donald Knuth originally ported it
to Unix. It was published as part of the
.I METAFONTware
techical report, available from the TeX Users Group.

