.TH PKTOGF 1 8/8/90
.SH NAME
pktogf - convert packed font files to generic font files
.SH SYNOPSIS
.B pktogf
[-v] pk_file_name [gf_file_name]
.SH DESCRIPTION
The 
.I pktogf
program converts a packed font file (PK) to a
generic font file (GF). Packed
font files are much smaller than the corresponding GF files,
but some DVI readers only understand GF files.
.PP
The 
.I pk_file_name
on the command line must be complete. Because
the resolution is part of the extension, it would not make
sense to add on a default extension as is done with TeX or
DVI-reading software. The
.I gf_file_name
defaults to the same (stripped) name as
.I pk_file_name ,
and it is placed in the current
working directory with the `gf' suffix replacing `pk'. For
example, the input file
.I io.300pk
would become
.IR io.300gf .
.SH OPTIONS
Unless the
.I -v
switch is given,
.I pktogf
operates silently.  With 
.IR -v ,
the version number of the program and statistics about the
unpacking are output to
.IR stdout .
.SH "ENVIRONMENT VARIABLES"
.I pktogf
uses the environment variable PKFONTS to search for the PK file.  If PKFONTS
is not set, it uses the variable TEXFONTS.  If TEXFONTS is not
set, it uses the system default: 
.BR @TEXFONTS@ .
See
.BR tex (1)
for the details of the searching.
.SH "SEE ALSO"
gftopk(1), gftype(1), pktype(1)
.br
Donald Knuth et al.,
.I METAFONTware
.SH AUTHORS
Tomas Rokicki wrote the program.  It was published as part of the
.I METAFONTware
technical report, available from the TeX Users Group.
Pierre MacKay originally adapted it for compilation under web2c.
