.TH GFTODVI 1 1/19/91
.SH NAME
gftodvi - make proofsheets from generic font files
.SH SYNOPSIS
.B gftodvi
[-verbose] [-overflow-label-offset=real] [gf_file_name]
.SH DESCRIPTION
The 
.IR gftodvi
program converts a generic font (GF) file output by, for example,
.BR mf (1),
to a device independent (DVI) file (that can then be typeset using same
software that has already been written for TeX). The characters in the
GF file will appear one per page, with labels, titles, and annotations
as specified in Appendix H (Hardcopy Proofs) of
.I The
.IR METAFONTbook .
.PP
.I GFtoDVI
uses other fonts in addition to the main GF file.
A `gray' font is used to typeset the
pixels that actually make up the character. (We wouldn't
want all the pixels to be simply black, since then labels,
key points, and other information would be lost.) A `title' font
is used for the information at the top of the page. A `label' font
is used for the labels on key points of the figure. A `slant'
font is used to typeset diagonal lines, which
otherwise have to be simulated using horizontal and vertical rules.
The default gray, title, and label fonts are 
.IR gray ,
.IR cmr8 ,
and 
.IR cmtt10 ,
respectively; there is no default slant font.
.PP
To change the default fonts, you can give 
.BR special
commands in your
Metafont source file, or you can change the fonts online. An online dialog
ensues if you end the
.I gf_file_name
with a `/'. For example,
.br
.ti +2
gftodvi io.300gf/
.br
.ti +2
Special font substitution: grayfont black
.br
.ti +2
OK; any more? grayfontarea /home/art/don/
.br
.ti +2
OK; any more? slantfont /home/fonts/slantimagen6
.br
.ti +2
OK; any more? <RET>
.br
will use
.B /home/art/don/black
as the `gray' font and
.B /home/fonts/slantimagen6
as the `slant' font (this name indicates
a font for lines with slope 1/6 at the resolution of an Imagen printer).
.PP
The
.I gf_file_name
on the command line must be complete. (The program prompts
you for it if you don't give it.) Because
the resolution is part of the extension, it would not make
sense to add on a default extension as is done with TeX or
DVI-reading software. The output file name defaults to the same
root as the gf file, with the `dvi' extension added. For
example, the input file
.I io.2602gf
would become
.IR io.dvi .
.SH OPTIONS
Without the
.I -verbose
option,
.I gftodvi
operates silently.  With it, a banner and progress report are printed on
.IR stdout .
.PP
The argument to the
.I -overflow-label-offset
option specifies the distance from the right edge of the character
bounding box at which the overflow equations (if any) are typeset.
The value is given in TeX points.  The default is a little over two
inches.
.PP
See
.BR tex (1)
for the details of specifying options.
.SH "ENVIRONMENT VARIABLES"
.I gftodvi
uses the environment variable GFFONTS to search for the GF file.  If
GFFONTS is not set, it uses the variable TEXFONTS.  If TEXFONTS is not
set, it uses the system default:
.BR @TEXFONTS@ .
.PP
The TEXFONTS environment variable is used to find the TFM
files that the program needs. If TEXFONTS is not set, the system
default above is used.
See
.BR tex (1)
for the details of the searching.
.SH FILES
.TP 40
@TEXFONTDIR@/{gray.tfm,...}
the default fonts
.TP
@MFINPUTDIR@/{gray.mf,...}
the Metafont sources (perhaps)
.SH "SEE ALSO"
tex(1), mf(1)
.br
Donald Knuth,
.I The METAFONTbook
.br
Donald Knuth et al.,
.I METAFONTware
.SH AUTHORS
Donald Knuth wrote the program. It was published as part of the
.I METAFONTware
technical report, available from the TeX Users Group.
Paul Richards originally ported it to Unix.
