.TH BIBTEX 1 9/18/90
.SH NAME
bibtex \- make a bibliography for TeX
.SH SYNOPSIS
.B bibtex
[aux_file_name]
.SH DESCRIPTION
BibTeX reads the top-level auxiliary
.I (.aux)
file that was output during a running of
.BR tex (1)
and creates a bibliography
.I (.bbl)
file that will be incorporated into the document on subsequent runs.
The
.I aux_file_name
on the command line must be given without the
.I .aux
extension.  If you don't give the
.IR aux_file_name ,
the program prompts you for it.
.PP
BibTeX looks up, in bibliography database
.I (.bib)
files,
the entries specified by the (for example) \\cite and \\nocite commands
in the source file.
It formats the information from those entries
according to instructions in a style
.I (.bst)
file,
and it outputs the results to the
.I .bbl
file.
.PP
The LaTeX manual (a.k.a.
.I LaTeX \- A Document Preparation System,
by Leslie Lamport, published by Addison-Wesley)
explains what a LaTeX source file must contain to work with BibTeX.
Appendix B of the LaTeX manual describes the format of the
.I .bib
files. The `BibTeXing' document by Oren Patashnik describes extensions
and details of this format, and it gives other useful hints for using
BibTeX.
.PP
BibTeX can be used with formats other than LaTeX; in particular, the
.I eplain 
macros support BibTeX.
.SH "ENVIRONMENT VARIABLES"
.I bibtex
searches the directories in the 
path defined by the TEXINPUTS environment variable for
.I .bst
files.  If TEXINPUTS is not set, it uses the system default:
.BR @TEXINPUTS@ .
For
.I .bib
files, it uses the BIBINPUTS environment variable in a similar way.  The
default path there is: 
.BR @BIBINPUTS@ .
See
.BR tex (1)
for the details of the searching.
If the environment variable
\s-2TEXMFOUTPUT\s0 is set, BibTeX attempts to put its output
files in it, if they cannot be put in the current directory.  Again, see
.BR tex (1).
No special searching is done for the
.I .aux
file.
.SH FILES
.TP 25
@TEXINPUTDIR@/*.bst
standard style files
.TP
btxdoc.tex
`BibTeXing' \- LaTeXable documentation for general BibTeX users
.TP
btxhak.tex
`Designing BibTeX Styles' \- LaTeXable documentation for style designers
.TP
btxdoc.bib
database file for those two documents
.TP
xampl.bib
database file with examples of all standard entry types
.TP
btxbst.doc
template file and documentation for the standard styles
.PP
All these files should be available somewhere on your system.
.SH "SEE ALSO"
latex(1), tex(1)
.SH AUTHOR
Oren Patashnik, Stanford University.
