%   Change file for the DVIcopy processor, for use on POSIX systems with
%   the PtC Pascal-to-C translator.
%   Based on the change file for DVItype.
%   This file was created by Tor Lillqvist, tml@tik.vtt.fi.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% WEAVE: print changes only.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
\pageno=\contentspagenumber \advance\pageno by 1
@y
\pageno=\contentspagenumber \advance\pageno by 1
\let\maybe=\iffalse
\def\title{DVI$\,$\lowercase{type} changes for {\mc POSIX}}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% External declarations.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
var @<Globals in the outer block@>@/
@y
var @<Globals in the outer block@>@/
procedure set_paths;
    external;

function test_access(accessmode:integer; filepath:integer): boolean;
    external;
@z

@x
  begin print_ln(banner);@/
@y
  begin
  set_paths; {read environment, to find TEXFONTS, if there}
  print_ln(banner);@/
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Use default case statement feature of PtC.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
@d othercases == others: {default for cases not listed explicitly}
@y
@d othercases == otherwise {default for cases not listed explicitly}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Increase name_length.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
@!name_length=50; {a file name shouldn't be longer than this}
@y
@!name_length=1024; {a file name shouldn't be longer than this}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fix bug in comp_signed.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
      else  begin x:=@"7FFFFF-xx; #((x div @"1000000) + 128); @+ end;
@y
      else  begin x:=@"7FFFFFFF-xx; #((x div @"1000000) + 128); @+ end;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Declare real_name_of_file.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
@ Before a font file can be opened for input we must build a string
with its external name.
 
@<Glob...@>=
@!cur_name:packed array[1..name_length] of char; {external name,
  with no lower case letters}
@y
@ Before a font file can be opened for input we must build a string
with its external name.
 
We rename |cur_name| to match {\TeX}'s use and the C library routines
expectations.

@d cur_name==name_of_file

@<Glob...@>=
@!cur_name,@!real_name_of_file:packed array[1..name_length] of char;
	 {external name}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% File name stuff.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
length of the default area which must be copied to |cur_name| before
|make_name| is called.
@^system dependencies@>
@y
length of the default area which must be copied to |cur_name| before
|make_name| is called.
@^system dependencies@>

On {\mc POSIX} systems, there is no default area, we use external routines
that search directory paths.
@z

@x
  if (b>="a")and(b<="z") then b:=b-@'40; {convert to upper case}
@y
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Lowercase file name extension.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
id4(".")("T")("F")("M")(tfm_ext); {file name extension for \.{TFM} files}
@y
id4(".")("t")("f")("m")(tfm_ext); {file name extension for \.{TFM} files}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Open tfm file.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
@<TFM: Open |tfm_file|@>=
reset(tfm_file,cur_name);
@^system dependencies@>
if eof(tfm_file) then
  abort('---not loaded, TFM file can''t be opened!');
@.TFM file can\'t be opened@>
@y
@d read_access_mode=4  {``read'' mode for |test_access|}
@d write_access_mode=2 {``write'' mode for |test_access|}

@d no_file_path=0    {no path searching should be done}
@d font_file_path=3  {path specifier for \.{TFM} files}
@d vf_file_path=9    {pacth specifier for \.{VF} files}

@<TFM: Open |tfm_file|@>=
@^system dependencies@>
if test_access(read_access_mode,font_file_path) then
    reset(tfm_file,real_name_of_file)
else
  abort('---not loaded, TFM file can''t be opened!');
@.TFM file can\'t be opened@>
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Remove TeXfonts: stuff.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
@d TFM_default_area_name=='TeXfonts:' {change this to the correct name}
@d TFM_default_area_name_length=9 {change this to the correct length}
 
@<Glob...@>=
@!TFM_default_area:packed array[1..TFM_default_area_name_length] of char;
@y

In \.{POSIX} none of this necessary.  We use search paths.
@z 

@x
@ @<Set init...@>=
TFM_default_area:=TFM_default_area_name;
@y
@ 
(nothing)
@z

@x
  for k:=1 to TFM_default_area_name_length do
    cur_name[k]:=TFM_default_area[k];
  make_name(font_name(f),tfm_ext,TFM_default_area_name_length);
@y
  make_name(font_name(f),tfm_ext,0);
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Open input file.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
reset(dvi_file); {prepares to read packed bytes from |dvi_file|}
@y
argv(1, cur_name);
if test_access(read_access_mode,no_file_path) then
    reset(dvi_file,real_name_of_file)
else 
    abort('Input DVI file not found');
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Redefine dvi_length and dvi_move.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
@p function dvi_length:int_32;
begin set_pos(dvi_file,-1); dvi_length:=cur_pos(dvi_file);
end;
@#
procedure dvi_move(n:int_32);
begin set_pos(dvi_file,n); dvi_loc:=n;
end;
@y
@p function dvi_length:int_32;
begin seek(dvi_file,0,2); dvi_length:=tell(dvi_file);
end;
@#
procedure dvi_move(n:int_32);
begin seek(dvi_file,n,0); dvi_loc:=n;
end;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Lowercase.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
id3(".")("V")("F")(vf_ext); {file name extension for \.{VF} files}
@y
id3(".")("v")("f")(vf_ext); {file name extension for \.{VF} files}
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Open VF file.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
reset(vf_file,cur_name);
@^system dependencies@>
if eof(vf_file) then
  goto not_found;
@y
@^system dependencies@>
if test_access(read_access_mode,vf_file_path) then
    reset(vf_file,real_name_of_file)
else 
    goto not_found;
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% No TeXvfonts:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
@d VF_default_area_name=='TeXvfonts:' {change this to the correct name}
@d VF_default_area_name_length=10 {change this to the correct length}
 
@<Glob...@>=
@!VF_default_area:packed array[1..VF_default_area_name_length] of char;
 
@ @<Set init...@>=
VF_default_area:=VF_default_area_name;
@y
 
@ 
(nothing) 
@z

@x
for k:=1 to VF_default_area_name_length do
  cur_name[k]:=VF_default_area[k];
make_name(font_name(cur_vf),vf_ext,VF_default_area_name_length);@/
@y
make_name(font_name(cur_vf),vf_ext,0);@/
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Open output file.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
rewrite(out_file); {prepares to write packed bytes to |out_file|}
@y
argv(2,cur_name);
if test_access(write_access_mode,no_file_path) then
    begin rewrite(out_file,real_name_of_file);
    end
else
    abort('Cannot open output DVI file');
@z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Check usage; also print newline at end of program.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@x
@p begin initialize; {get all variables initialized}
@y
@p begin 
if argc <> 3 then
  begin write_ln('Usage: dvicopy input output'); goto final_end;
  end;
initialize; {get all variables initialized}
@z

@x
final_end:end.
@y
final_end: print_ln(' '); end.
@z
