% Change file for BibTeX for PtC-TeX

@x terminal
@d term_out == tty
@d term_in == tty
@y
@d term_out == output
@d term_in == input
@z

@x
@d othercases == others:        {default for cases not listed explicitly}
@y
@d othercases == otherwise      {default for cases not listed explicitly}
@z

@x program header
program BibTEX;                 {all files are opened dynamically}
label   close_up_shop,@!exit_program @<Labels in the outer block@>;
const   @<Constants in the outer block@>
type    @<Types in the outer block@>
var     @<Globals in the outer block@>@;
@y
program BibTEX(input,output);
label   close_up_shop,@!exit_program @<Labels in the outer block@>;
const   @<Constants in the outer block@>
type    @<Types in the outer block@>
var     @<Globals in the outer block@>
interrupt:integer; {dummy to satisfy linker}
{declarations for external C procedures}
procedure set_paths;
  external;

function test_access(accessmode:integer; filepath:integer): boolean;
  external;
@z

@x compiler directives
@{@&$C-,A+,D-@}  {no range check, catch arithmetic overflow, no debug overhead}
@!debug @{@&$C+,D+@}@+ gubed            {but turn everything on when debugging}
@y
@z

@x increase buf_size
@!buf_size=1000; {maximum number of characters in an input line (or string)}
@y
@!buf_size=3000; {maximum number of characters in an input line (or string)}
@z

@x increase pool_size
@!pool_size=65000; {maximum number of characters in strings}
@y
@!pool_size=200000; {maximum number of characters in strings}
@z

@x increase file_name_size
@d file_name_size=40    {file names shouldn't be longer than this}
@y
@d file_name_size=1024  {file names shouldn't be longer than this}
@z

@x alpha_file type
@!alpha_file=packed file of text_char;  {files that contain textual data}
@y
@!alpha_file=text;      {files that contain textual data}
@z

@x declare real_name_of_file
|name_of_file|. \BibTeX\ does no case conversion for file names.

@<Globals in the outer block@>=
@!name_of_file:packed array[1..file_name_size] of char;
                         {on some systems this is a \&{record} variable}
@y
|name_of_file|. \BibTeX\ does no case conversion for file names.

The \mc{POSIX} version uses search paths to look for files to open.
We use |real_name_of_file| to hold the |name_of_file| with a directory name
from the path in front of it.

@d read_access_mode=4  {``read'' mode for |test_access|}
@d write_access_mode=2 {``write'' mode for |test_access|}

@d no_file_path=0       {no path searching should be done}
@d input_file_path=1    {path specifier for \.{\\input} files}

@<Globals in the outer block@>=
@!name_of_file,@!real_name_of_file:packed array[1..file_name_size] of char;
@z

@x opening files
The \ph\ compiler with which the present version of \TeX\ was prepared has
extended the rules of \PASCAL\ in a very convenient way. To open file~|f|,
we can write
$$\vbox{\halign{#\hfil\qquad&#\hfil\cr
|reset(f,@t\\{name}@>,'/O')|&for input;\cr
|rewrite(f,@t\\{name}@>,'/O')|&for output.\cr}}$$
The `\\{name}' parameter, which is of type `\ignorespaces|packed
array[@t\<\\{any}>@>] of text_char|', stands for the name of
the external file that is being opened for input or output.
Blank spaces that might appear in \\{name} are ignored.

The `\.{/O}' parameter tells the operating system not to issue its own
error messages if something goes wrong. If a file of the specified name
cannot be found, or if such a file cannot be opened for some other reason
(e.g., someone may already be trying to write the same file), we will have
|@!erstat(f)<>0| after an unsuccessful |reset| or |rewrite|.  This allows
\TeX\ to undertake appropriate corrective action.

\TeX's file-opening procedures return |false| if no file identified by
|name_of_file| could be opened.

@d reset_OK(#)==erstat(#)=0
@d rewrite_OK(#)==erstat(#)=0

@<Procedures and functions for file-system interacting@>=
function erstat(var f:file):integer; extern;    {in the runtime library}
@#@t\2@>
function a_open_in(var f:alpha_file):boolean;   {open a text file for input}
begin reset(f,name_of_file,'/O'); a_open_in:=reset_OK(f);
end;
@#
function a_open_out(var f:alpha_file):boolean;  {open a text file for output}
begin rewrite(f,name_of_file,'/O'); a_open_out:=rewrite_OK(f);
end;
@y
On \mc{POSIX}, we implement path searching: If |name_of_file|
doesn't start with |'/'| then |test_access| tries prepending pathnames
from the appropriate path list until success or the end of path list
is reached.

Path searching is not done for output files.

@<Procedures and functions for file-system interacting@>=
function a_open_in(var f:alpha_file;path_specifier:integer):boolean;
{open a text file for input}
begin if test_access(read_access_mode,path_specifier) then
  begin reset(f,real_name_of_file); a_open_in:=true@+end
else
  a_open_in:=false
end;
@#
function a_open_out(var f:alpha_file):boolean;  {open a text file for output}
begin if test_access(write_access_mode,no_file_path) then
  begin rewrite(f,real_name_of_file); a_open_out:=true@+end
else
  a_open_out:=false
end;
@z

@x
@!s_bst_area : str_number;      {\.{texinputs:}}
@!s_bib_area : str_number;      {\.{texbib:}}
@y
@z

@x
pre_define('texinputs:  ',10,file_area_ilk);
s_bst_area := hash_text[pre_def_loc];
pre_define('texbib:     ',7,file_area_ilk);
s_bib_area := hash_text[pre_def_loc];
@y
@z

@x getting top-level name: it comes from command line
@d sam_you_made_the_file_name_too_long == begin
                                          sam_too_long_file_name_print;
                                          goto aux_not_found;
                                          end
@y
@d sam_you_made_the_file_name_too_long == begin
                                          sam_too_long_file_name_print;
                                          goto exit_program;
                                          end
@z

@x
@d sam_you_made_the_file_name_wrong == begin
                                       sam_wrong_file_name_print;
                                       goto aux_not_found;
                                       end

@y
@d sam_you_made_the_file_name_wrong == begin
                                       sam_wrong_file_name_print;
                                       goto exit_program;
                                       end

@z

@x call set_paths; read the command line
check_cmnd_line := false;                       {many systems will change this}
@y
set_paths;
check_cmnd_line := argc > 1;
@z

@x
@<Variables for possible command-line processing@>=
@!check_cmnd_line : boolean;    {|true| if we're to check the command line}
@y
@<Variables for possible command-line processing@>=
@!check_cmnd_line : boolean;    {|true| if we're to check the command line}
@!i : integer;
@z

@x
@<Process a possible command line@>=
begin
do_nothing;             {the ``default system'' doesn't use the command line}
end
@y
@<Process a possible command line@>=
begin argv(1, name_of_file);
i:=file_name_size; while(name_of_file[i]=' ') do decr(i);
aux_name_length:=i;
end
@z

@x
if (not a_open_in(cur_aux_file)) then
@y
if (not a_open_in(cur_aux_file,no_file_path)) then
@z

@x
if (not a_open_in(cur_bib_file)) then
    begin
    add_area (s_bib_area);
    if (not a_open_in(cur_bib_file)) then
        open_bibdata_aux_err ('I couldn''t open database file ');
    end;
@y
if (not a_open_in(cur_bib_file,input_file_path)) then
    open_bibdata_aux_err ('I couldn''t open database file ');
@z

@x
if (not a_open_in(bst_file)) then
    begin
    add_area (s_bst_area);
    if (not a_open_in(bst_file)) then
        begin
        print ('I couldn''t open style file ');
        print_bst_name;@/
        bst_str := 0;                           {mark as unused again}
        aux_err_return;
        end;
    end;
@y
if (not a_open_in(bst_file,input_file_path)) then
    begin
    print ('I couldn''t open style file ');
    print_bst_name;@/
    bst_str := 0;                               {mark as unused again}
    aux_err_return;
    end;
@z

@x
if (not a_open_in(cur_aux_file)) then
@y
if (not a_open_in(cur_aux_file,no_file_path)) then
@z
