#include <stdio.h>
#include <sys/signal.h>
#include <sys/time.h>
#include <ptc.h>
#include "ext.h"

static packrealnameoffile();

#define filenamesize 1024   /* should agree with *.ch */
extern char nameoffile[], realnameoffile[];

/* fixed arrays are used to hold the paths, to avoid any possible problems
   involving interaction of malloc and undump		*/

char texinputpath[MAXPATHCHARS] = defaulttexinputpath;
char fontpath[MAXPATHCHARS] = defaultfontpath;
char formatpath[MAXPATHCHARS] = defaultformatpath;
char texpoolpath[MAXPATHCHARS] = defaulttexpoolpath;
char mfinputpath[MAXPATHCHARS] = defaultmfinputpath;
char basepath[MAXPATHCHARS] = defaultbasepath;
char mfpoolpath[MAXPATHCHARS] = defaultmfpoolpath;
char vfpath[MAXPATHCHARS] = defaultvfpath;

char *getenv();
static copypath();

/*
 * setpaths is called to set up the arrays inputpath, fontpath, formatpath
 * and poolpath as follows:  if the user's environment has a value for the
 * appropriate value, then use it;  otherwise, leave the current value of
 * the array (which may be the default path, or it may be the result of
 * a call to setpaths on a previous run that was made the subject of
 * an undump: this will give the maker of a preloaded TeX the option of
 * providing a new set of "default" paths.
 *
 * Note that we have to copy the string from the environment area, since
 * that will change on the next run (which matters if this is for a
 * preloaded TeX or METAFONT).
 */
setpaths()
{
	register char *envpath;
	
	if ((envpath = getenv("TEXINPUTS")) != NULL)
	    copypath(texinputpath,envpath,MAXPATHCHARS);
	if ((envpath = getenv("TEXFONTS")) != NULL)
	    copypath(fontpath,envpath,MAXPATHCHARS);
	if ((envpath = getenv("TEXFORMATS")) != NULL)
	    copypath(formatpath,envpath,MAXPATHCHARS);
	if ((envpath = getenv("TEXPOOL")) != NULL)
	    copypath(texpoolpath,envpath,MAXPATHCHARS);
	if ((envpath = getenv("MFINPUTS")) != NULL)
	    copypath(mfinputpath,envpath,MAXPATHCHARS);
	if ((envpath = getenv("MFBASES")) != NULL)
	    copypath(basepath,envpath,MAXPATHCHARS);
	if ((envpath = getenv("MFPOOL")) != NULL)
	    copypath(mfpoolpath,envpath,MAXPATHCHARS);
	if ((envpath = getenv("TEXVFONTS")) != NULL)
	    copypath(vfpath,envpath,MAXPATHCHARS);
}

/*
 * copypath(s1,s2,n) copies at most n characters (including the null)
 * from string s2 to string s1, giving an error message for paths
 * that are too long.
 */
static
copypath(s1,s2,n)
    register char *s1,*s2;
    register int n;
{
	while ((*s1++ = *s2++) != '\0')
	    if (--n == 0) {
		fprintf(stderr, "! Environment search path is too big\n");
		*--s1 = '\0';
		return; /* let user continue with truncated path */
		}
}

/*
 *	testaccess(amode,filepath)
 *
 *  Test whether or not the file whose name is in the global nameoffile
 *  can be opened for reading (if mode=READACCESS)
 *  or writing (if mode=WRITEACCESS).
 *
 *  The filepath argument is one of the ...FILEPATH constants defined below.
 *  If the filename given in nameoffile does not begin with '/', we try 
 *  prepending all the ':'-separated areanames in the appropriate path to the
 *  filename until access can be made, if it ever can.
 *
 *  The realnameoffile global array will contain the name that yielded an
 *  access success.
 */

char
testaccess(amode,filepath)
    int amode,filepath;
{
    register char ok;
    register char *p;
    char *curpathplace;
    int f;
    
    switch(filepath) {
	case NOFILEPATH: curpathplace = NULL; break;
	case TEXINPUTFILEPATH: case TEXREADFILEPATH:
			curpathplace = texinputpath; break;
	case TFMFILEPATH: curpathplace = fontpath; break;
	case FORMATFILEPATH: curpathplace = formatpath; break;
	case TEXPOOLFILEPATH: curpathplace = texpoolpath; break;
	case MFINPUTFILEPATH: curpathplace = mfinputpath; break;
	case BASEFILEPATH: curpathplace = basepath; break;
	case MFPOOLFILEPATH: curpathplace = mfpoolpath; break;
	case VFFILEPATH: curpathplace = vfpath; break;
	}
    if (nameoffile[0]=='/')	/* file name has absolute path */
	curpathplace = NULL;
    do {
	packrealnameoffile(&curpathplace);
	if (amode==READACCESS)
	    /* use system call "access" to see if we could read it */
	    if (access(realnameoffile,READACCESS)==0) ok = TRUE;
	    else ok = FALSE;
	else {
	    /* WRITEACCESS: use creat to see if we could create it, but close
	    the file again if we're OK, to let pc open it for real */
	    f = creat(realnameoffile,0666);
	    if (f>=0) ok = TRUE;
	    else ok = FALSE;
	    if (ok)
		close(f);
	    }
    } while (!ok && curpathplace != NULL);
    if (ok) {  /* pad realnameoffile with blanks, as Pascal wants */
	for (p = realnameoffile; *p != '\0'; p++)
	    /* nothing: find end of string */ ;
	while (p < &(realnameoffile[filenamesize]))
	    *p++ = ' ';
	}
    return (ok);
}

/*
 * packrealnameoffile(cpp) makes realnameoffile contain the directory at *cpp,
 * followed by '/', followed by the characters in nameoffile up until the
 * first blank there, and finally a '\0'.  The cpp pointer is left pointing
 * at the next directory in the path.
 * But: if *cpp == NULL, then we are supposed to use nameoffile as is.
 */
static
packrealnameoffile(cpp)
    char **cpp;
{
    register char *p,*realname;
    
    realname = realnameoffile;
    if ((p = *cpp)!=NULL) {
	while (*p && *p != ':') {
	    *realname++ = *p++;
	    if (realname == &(realnameoffile[filenamesize-1]))
		break;
	    }
	if (*p == '\0') *cpp = NULL; /* at end of path now */
	else *cpp = p+1; /* else get past ':' */
	*realname++ = '/';  /* separate the area from the name to follow */
	}
    /* now append nameoffile to realname... */
    p = nameoffile;
    while (*p && *p != ' ') {
	if (realname >= &(realnameoffile[filenamesize-1])) {
	    fprintf(stderr,"! Full file name is too long\n");
	    break;
	    }
	*realname++ = *p++;
	}
    *realname = '\0';
}

