#include <time.h>
#include <signal.h>

extern int interrupt;

/*
**	catchint()
**
**  Gets called when the user hits his interrupt key.  Sets the global
**  "interrupt" nonzero, then sets it up so that the next interrupt will
**  also be caught here.
**
*/

catchint()
{
	signal(SIGINT,catchint);
	interrupt = 1;
}

/*
**      dateandtime(time, day, month, year)
**
**  Stores minutes since midnight, current day, month and year into
**  *time, *day, *month and *year, respectively.
**
**  Also, set things up so that catchint() will get control on interrupts.
**
*/

dateandtime(minutes, day, month, year)
int     *minutes, *day, *month, *year;
{
        long        clock;
	struct tm   *tmptr, *localtime();
	
	clock = time(0);
	tmptr = localtime(&clock);
	
	*minutes = tmptr->tm_hour * 60 + tmptr->tm_min;
	*day = tmptr->tm_mday;
	*month = tmptr->tm_mon + 1;
	*year = tmptr->tm_year + 1900;
	signal(SIGINT,catchint);
}
