/* $Id: ptc.h,v 1.15 90/03/27 01:19:19 tml Exp Locker: tml $
 *
 * Header file included by programs translated with the ptc
 * Pascal-to-C translator (as enhanced by tml@tik.vtt.fi).
 */

# define MAXFILENAME 1024
# define NIL 0

# define PTC_E_FILENOTOPEN 1
# define PTC_E_SCAN 2
# define PTC_E_CASE 3
# define PTC_E_CANTOPEN 4
# define PTC_E_TOOLONGFILENAME 5

# define Rmode "r"
# define Wmode "w"

typedef struct {
  FILE *fp;
  int bufvalid, eoln, eof, writable;
  unsigned char buf;
  int auxbuf;
} text;

/* Lazy I/O: defer actual getting until we refer the buffer varaible */

# define Buf(f) \
  ((f).bufvalid ? 0 : Get(f), \
   (f).buf)

# define Bufx(f) \
  (((f).bufvalid ? 0 : RealGetx(f)), \
   (f).buf)

# define Fread(x, f) fread((char *)&x, sizeof(x), 1, f)

# define Get(f) \
  ((f).eof = (Fread((f).buf, (f).fp) == 0), \
   (f).bufvalid = 1)

# define RealGetx(f) \
  ((f).auxbuf = getc((f).fp), \
   (f).eof = ((f).auxbuf == EOF), \
   (f).eoln = ((f).eof || ((f).auxbuf == '\n')), \
   ((f).buf = ((f).eoln ? ' ' : (f).auxbuf)), \
   (f).bufvalid = 1)

# define Getx(f) (Bufx(f), (f).bufvalid = 0)

# define Getchr(f) (Getx(f), (f).buf)

# define Fscan(f) \
  ((f).bufvalid ? ((f).bufvalid = 0, ungetc((f).buf, (f).fp)) : 0, \
   Tmpfil = (f).fp)

# define Scan(f, p) Scanck(fscanf(Tmpfil, f, p))

# define Eoln(f) \
  (Openck(f), \
   Bufx(f), \
   (f).eoln)

# define Eof(f) \
  (Openck(f), \
   Buf(f), \
   (f).eof)

# define Eofx(f) \
   (Openck(f), \
    Bufx(f), \
    (f).eof)

# define Fwrite(x, f) fwrite((char *)&x, sizeof(x), 1, f)

# define Put(f) Fwrite((f).buf, (f).fp)

# define Putx(f) \
  ((f).eoln = ((f).buf == '\n'), \
   putc((f).buf, (f).fp))

# define Putchr(c, f) ((f).buf = (c), Putx(f))

# define Putl(f, v) ((f).eoln = v)

# define Flush(f) \
  (Openck(f), \
   fflush((f).fp))

# define Finish(f) \
  ((((f).writable && !(f).eoln) ? Putchr('\n', f) : 0), \
   rewind((f).fp), \
   0)

# define Seek(f, p, w) \
  ((f).bufvalid = 0, \
   fseek((f).fp, (p) * sizeof((f).buf), (w)))

# define Tell(f) \
   ((ftell((f).fp) - (f).bufvalid * sizeof((f).buf)) / sizeof((f).buf))

# define Close(f) \
  (Openck(f), \
   fclose((f).fp), \
   (f).fp = 0)

# define Closex(f) (Finish(f), fclose((f).fp), (f).fp = 0)

# define Reset(f, n, l) \
  ((f).fp && n == 0 ? (rewind((f).fp), 0) \
   : (((f).fp ? fclose((f).fp) : 0), \
      (int) ((f).fp = Fopen(n, l, Rmode, __LINE__))), \
   (f).bufvalid = (f).eof = (f).writable = 0)

# define Resetx(f, n, l) \
  ((f).fp ? Finish(f) : (int) ((f).fp = Fopen(n, l, Rmode, __LINE__)), \
   (f).bufvalid = (f).eof = (f).writable = 0)

# define Rewrite(f, n, l) \
  ((f).fp ? (rewind((f).fp), 0) : (int) ((f).fp = Fopen(n, l, Wmode, __LINE__)), \
   (f).writable = (f).eof = 1)

# define Rewritex(f, n, l) \
  ((f).fp ? Finish(f) : (int) ((f).fp = Fopen(n, l, Wmode, __LINE__)), \
   (f).writable = (f).eof = (f).eoln = 1)

# define Cmpstr(x, y) strncmp((x), (y), sizeof(x))

# define Openck(f) \
    ((f).fp ? 0 : PTCerror(PTC_E_FILENOTOPEN, __LINE__, 0, 0))

# define Scanck(n) \
    (n == 1 ? 0 : PTCerror(PTC_E_SCAN, __LINE__, 0, 0))

# define Trunc(f) (int)(f)
# define Round(f) (int) floor((double)(0.5+f))

extern void exit();
extern void abort();
extern char *malloc();
extern void free();

extern PTCerror();
extern Getl();
extern FILE *Fopen();
extern void Argvgt();

extern int argc;
extern unsigned char **argv;
