// SPDX-License-Identifier: BSD-3-Clause
package org.islandoftex.albatross

import java.nio.file.Path

data class FontEntry(
    val path: Path,
    val name: String,
    val styles: List<String>,
    val description: String
) {
    override fun toString(): String {
        return "($path, $name, $styles, $description)"
    }
}
