/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.generic;

import com.dickimawbooks.texparserlib.CaseChangeable;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.FontEncoding;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class EncodingSymbol
extends ControlSequence
implements Expandable,
CaseChangeable {
    private String value;
    private int code;

    public EncodingSymbol(String string, int n, FontEncoding fontEncoding) {
        super(string);
        this.value = fontEncoding == null ? new String(Character.toChars(n)) : fontEncoding.getCharString(n);
        this.code = n;
    }

    public EncodingSymbol(String string, int n, String string2) {
        super(string);
        this.value = string2;
        this.code = n;
    }

    @Override
    public Object clone() {
        return new EncodingSymbol(this.getName(), this.code, this.value);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof EncodingSymbol)) {
            return false;
        }
        return this.code == ((EncodingSymbol)object).code;
    }

    @Override
    public TeXObject toLowerCase(TeXParser teXParser) {
        return teXParser.getListener().createString(this.value.toLowerCase());
    }

    @Override
    public TeXObject toUpperCase(TeXParser teXParser) {
        return teXParser.getListener().createString(this.value.toUpperCase());
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return teXParser.getListener().createString(this.value);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.getListener().getWriteable().write(this.value);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }
}

