/* ea.h -- this file is part of the SYMLINK Library.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef _EA_H
#define _EA_H


#include <symlink/cdefs.h>


#define EA_OPEN_READ	0
#define EA_OPEN_WRITE	1
#define EA_OPEN_CREATE	2
#define EA_OPEN_NEW	3

__BEGIN_DECLS

int symlink_ea_open __PROTO ((const char *name, int mode));
int symlink_ea_close __PROTO ((int handle));
int symlink_ea_set __PROTO ((int handle, const char *name, const char *value, size_t size));
int symlink_ea_get __PROTO ((int handle, const char *name, char *buffer, size_t size));

__END_DECLS

#define ea_open		symlink_ea_open
#define ea_close	symlink_ea_close
#define ea_set		symlink_ea_set
#define ea_get		symlink_ea_get

#ifdef __OPTIMIZE__

int close __PROTO ((int handle));

#ifdef ea_close
#undef ea_close
#endif

#define ea_close(h)	close(h)

#endif /* __OPTIMIZE__ */


#endif /* not _EA_H */
