/***************************************************************************/
/*                                                                         */
/*  DelBlanks.cmd                                                          */
/*                                                            */
/*                                                                         */
/*  Beispielmakro, da das Potential der Rexx-Schnittstelle erkennen       */
/*  lt.                                                                  */
/*                                                                         */
/*  Es sucht Leerzeichen zwischen '\begin' bzw. '\end' und '{' und be-     */
/*  seitigt diese. (Anscheinend hat eine der frheren TeX-Versionen        */
/*  diese Art der Eingabe geschuckt)                                       */
/*                                                                         */
/*  (Dieses Makro entstand auf Anregung von Joachim Eichhorn)              */
/*                                                                         */
/***************************************************************************/

Text = VRGet( 'MLE_1', 'Value')
pos  = Pos( '\begin {', Text)
do while pos > 0
    Text = DelStr( Text, pos, 8)
    Text = Insert( '\begin{', Text, pos - 1)
    pos  = Pos( '\begin {', Text, pos)
end

pos  = Pos( '\end {', Text)
do while pos > 0
    Text = DelStr( Text, pos, 6)
    Text = Insert( '\end{', Text, pos - 1)
    pos  = Pos( '\end {', Text, pos)
end

call VRSet 'MLE_1', 'Value', Text
