#!/bin/sh
# $Id: dvihp,v 1.3 1996/12/03 19:53:56 karl Exp karl $
# Run dvicopy, then dvilj[k].  kb@mail.tug.org, 1994.  Public domain.
# Try to accept arguments a la dvips, from Thomas Esser.

: ${DVILJ=dvilj4}       # the dvilj variant to run
: ${SPOOL=lpr}          # used to print an LJ file
: ${TMPDIR=/tmp}        # for the dvicopy output

rcs_revision='$Revision: 1.3 $'
version=`set - $rcs_revision; echo $2`

usage="Usage: `basename $0` [OPTIONS] [DVIFILE[.dvi]].
  Translate the given DVIFILE to Hewlett-Packard PCL by calling dvicopy
  and then \$DVILJ (dvilj4 by default).
  In the absence of other options, pipe the PCL to \$SPOOL (lpr by default).
  
  Options are recognized from dvips where possible:
-A    print odd pages
-B    print even pages
-d #  set debug bits to # (see documentation)
-D #  set resolution to #
-f    run as filter
-l #  don't print pages after #
-m    manual feed
-n #  print # pages
-O #,#  set/change paper offset to #,# mm
-o s  output to s instead of spooling
-p #  don't print pages before #
-Ps   pass directly to lpr
-v    verbose operation
-x #  set magnification to #

Other options are passed to the dvilj program.

Email bug reports to tex-k@mail.tug.org."


if test $# -eq 0; then
  echo "`basename $0`: Missing argument(s)." >&2
  echo "Try \``basename $0` --help' for more information." >&2
  exit 0
fi

unset infile opt output
output_opt=-e
verbose=false

while test $# -gt 0; do
  case "$1" in
    -help|--help) echo "$usage"; exit 0;;
    -version|--version) 
      echo "`basename $0` (Dviljk 2.6) $version"
      echo "There is NO warranty.  This script is public domain."
      exit 0;;
    -A)  opt="$opt -D1";;                       # -A => -D1 (odd pages)
    -B)  opt="$opt -D2";;                       # -B -> -D2 (even pages)
    -d)  shift; opt="$opt --D$1";;              # -d => --D (debug)
    -d*) opt="$opt `echo $1 | sed s/d/-D/`";;
    -D)  shift; opt="$opt -R$1";;               # -D => -R (resolution)
    -f)  infile=; output=-;;                    # -f (run as filter)
    -l)  shift; opt="$opt -t$1";;               # -l => -t (ending page)
    -l*) opt="$opt `echo $1 | sed s/l/t/`";;
    -m)  opt="$opt -A";;                        # -m => -A (manual feed)
    -n)  shift; opt="$opt -p$1";;               # -n => -p (page count)
    -n*) opt="$opt `echo $1 | sed s/^-n/-p/`";;
    -o)  if test $# -eq 1; then                 # -o (output file)
           # No remaining args, output to foo.lj.
           output=`basename $infile .dvi`.lj
         else shift; output="$1"; fi;;
    -o*) output="`echo $1 | sed 's/^-o//'`";;
    -O)  shift; x=`echo $1 | sed 's/,.*//'`     # -O => -x, -y (page offsets)
         y=`echo $1 | sed 's/.*,//'`;  opt="$opt -x$x -y$y";;
    -O*) temp="`echo $1 | sed 's/^-O//'`"
         x=`echo $temp | sed 's/,.*//'`
         y=`echo $temp | sed 's/.*,//'`;
         opt="$opt -x$x -y$y";;
    -p)  shift; opt="$opt -f$1";;               # -p => -f (starting page)
    -p*) opt="$opt `echo $1 | sed s/p/f/`";;
    -P)  shift; output=; spool_opt="-P$1";;     # -Pprinter
    -P*) output=; spool_opt="$1";;
    -v)  verbose=true; opt="$opt -v";;
    -x)  shift; opt="$opt -m$1";;               # -x => -m (magnification)
    -x*) opt="$opt `echo $1 | sed s/x/m/`";;
    --)  shift; infile="$1"; break;;            # -- => end of options
    -*)  opt="$opt $1";;                        # pass other options through
    *)   infile="$1";;
  esac
  shift
done

# Make sure the filenames are unique on MS-DOS
vfless_dvi=$TMPDIR/dvi$$.-vf
dvicopy_log=$TMPDIR/dvi$$.copy
dvilj_log=$TMPDIR/dvi$$.lj

# Expand VF references.
# If $infile is null, this will read standard input.
# dvilj can't read from a pipe, so always write to a file.
$verbose && echo "Running dvicopy $infile >$vfless_dvi" >&2
if dvicopy $infile >$vfless_dvi; then :; else
  echo "$0: dvicopy $infile failed." >&2
  exit 1
fi
$verbose && ls -l $vfless_dvi >&2

if test -z "$output"; then
  output=- # output to stdout
  # Doing this pipe means the true exit status might get lost, but it
  # seems worth it to avoid the temporary file. (Bad enough to have one.)
  maybe_spool_cmd="| $SPOOL $spool_opt"
else
  maybe_spool_cmd=
fi

# Translate DVI to LJ.
cmd="$DVILJ $opt $output_opt$output $vfless_dvi $maybe_spool_cmd"
$verbose && echo "Running $cmd" >&2
if eval $cmd; then :; else
  echo "$0: $DVILJ failed." >&2
  exit 2
fi

rm -f $TMPDIR/dvi$$.*
